/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.datasource.BaseVirtualColumn;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.beans.JCDataConverter;
import com.klg.jclass.datasource.beans.JCDataEvent;
import com.klg.jclass.datasource.beans.NodeProperties;
import com.klg.jclass.datasource.customizer.DataModelPage;
import com.klg.jclass.datasource.customizer.DescriptionDialog;
import com.klg.jclass.datasource.customizer.DesignTimeMetaData;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.swing.JCAlignLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeModel;

public class VirtualColumnPage
extends DataModelPage
implements ItemListener,
ActionListener {
    DefaultListModel virtualModel = new DefaultListModel();
    DefaultListModel baseModel = new DefaultListModel();
    JList virtualColumns;
    JList basedColumns;
    JTextField name;
    JComboBox type;
    JComboBox operation;
    JComboBox basedColumnChoices;
    JButton btnAddBasedColumn;
    JButton btnDeleteBasedColumn;
    JButton btnAdd;
    JButton btnDelete;
    JButton btnClear;
    JButton btnSet;
    DesignTimeMetaData meta;
    TreeModel tree;
    MetaDataModel mdata;
    private int currentColumnIndex;
    private static int counter = 0;
    private static final boolean TRACE = false;

    public VirtualColumnPage(DesignTimeMetaData designTimeMetaData) {
        super(LocaleBundle.string("Virtual Columns"));
        this.meta = designTimeMetaData;
        this.currentColumnIndex = -1;
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.virtualColumns = new JList(this.virtualModel);
        JLabel jLabel = new JLabel(LocaleBundle.string("Column Name"));
        JLabel jLabel2 = new JLabel(LocaleBundle.string("Column Type"));
        JLabel jLabel3 = new JLabel(LocaleBundle.string("Operation"));
        this.name = new JTextField("", 30);
        this.type = new JComboBox();
        this.operation = new JComboBox();
        this.btnAdd = new JButton(LocaleBundle.string("Add"));
        this.btnDelete = new JButton(LocaleBundle.string("Delete"));
        this.btnClear = new JButton(LocaleBundle.string("Clear"));
        this.btnSet = new JButton(LocaleBundle.string("Set/Modify"));
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.basedColumns = new JList(this.baseModel);
        this.basedColumnChoices = new JComboBox();
        this.btnAddBasedColumn = new JButton(LocaleBundle.string("Add"));
        this.btnDeleteBasedColumn = new JButton(LocaleBundle.string("Delete"));
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel();
        JPanel jPanel7 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        jPanel2.add((Component)this.btnAdd, gridBagConstraints);
        jPanel2.add((Component)this.btnDelete, gridBagConstraints);
        gridBagConstraints.weightx = 5.0;
        jPanel2.add((Component)this.btnClear, gridBagConstraints);
        jPanel.add((Component)new JScrollPane(this.virtualColumns), "Center");
        JPanel jPanel8 = new JPanel();
        jPanel8.setBorder(new TitledBorder(LocaleBundle.string("Based Columns")));
        jPanel8.setLayout(new BorderLayout());
        jPanel3.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        gridBagConstraints.anchor = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 1;
        jPanel3.add((Component)this.btnAddBasedColumn, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weighty = 5.0;
        jPanel3.add((Component)this.btnDeleteBasedColumn, gridBagConstraints);
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)new JScrollPane(this.basedColumns), "Center");
        jPanel4.add((Component)this.basedColumnChoices, "South");
        jPanel8.add((Component)jPanel4, "Center");
        jPanel8.add((Component)jPanel3, "East");
        int n = 0;
        while (n < JCDataConverter.virtualColumnOperationStrings.length) {
            this.operation.addItem(JCDataConverter.virtualColumnOperationStrings[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < JCDataConverter.javaDataTypeStrings.length) {
            this.type.addItem(JCDataConverter.javaDataTypeStrings[n2]);
            ++n2;
        }
        JCAlignLayout jCAlignLayout = new JCAlignLayout();
        jPanel6.setLayout(jCAlignLayout);
        jPanel6.add(jLabel);
        jPanel6.add(this.name);
        jCAlignLayout.setResizeWidth(this.name, true);
        jPanel6.add(jLabel2);
        jPanel6.add(this.type);
        jCAlignLayout.setResizeWidth(this.type, true);
        jPanel6.add(jLabel3);
        jPanel6.add(this.operation);
        jCAlignLayout.setResizeWidth(this.operation, true);
        jPanel5.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 5.0;
        jPanel5.add((Component)this.btnSet, gridBagConstraints);
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)jPanel6, "North");
        jPanel7.add((Component)jPanel8, "Center");
        jPanel7.add((Component)jPanel5, "South");
        this.add((Component)jPanel7, "Center");
        this.add((Component)jPanel, "West");
        this.add((Component)jPanel2, "South");
        this.btnAdd.addActionListener(this);
        this.btnDelete.addActionListener(this);
        this.btnClear.addActionListener(this);
        this.name.addActionListener(this);
        this.type.addItemListener(this);
        this.operation.addItemListener(this);
        this.basedColumnChoices.addItemListener(this);
        this.btnAddBasedColumn.addActionListener(this);
        this.btnDeleteBasedColumn.addActionListener(this);
        this.btnSet.addActionListener(this);
        this.virtualColumns.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (VirtualColumnPage.this.isInitializing()) {
                    return;
                }
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                VirtualColumnPage.this.showSelectedVirtualColumn();
                VirtualColumnPage.this.updateAccess();
            }
        });
        this.basedColumns.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (VirtualColumnPage.this.isInitializing()) {
                    return;
                }
                VirtualColumnPage.this.updateAccess();
            }
        });
    }

    public void setNodeProperties(NodeProperties nodeProperties) {
        this.loadVirtualColumns();
        this.tree = null;
        this.mdata = null;
        this.tree = this.meta.getMetaDataTree();
        if (this.tree != null) {
            this.mdata = this.meta.getMetaData(nodeProperties, this.meta.getModelTreeRoot(), (DataSourceTreeNode)this.tree.getRoot());
        }
        this.loadBasedColumnChoices();
        this.updateAccess();
        this.showSelectedVirtualColumn();
    }

    private void updateAccess() {
        String string = (String)this.virtualColumns.getSelectedValue();
        String string2 = (String)this.basedColumns.getSelectedValue();
        int n = this.virtualModel.getSize();
        this.name.setEnabled(string != null);
        this.type.setEnabled(string != null);
        this.operation.setEnabled(string != null);
        this.basedColumns.setEnabled(string != null);
        this.basedColumnChoices.setEnabled(string != null);
        this.btnAddBasedColumn.setEnabled(string != null);
        this.btnDeleteBasedColumn.setEnabled(string != null && string2 != null);
        this.btnDelete.setEnabled(n > 0);
        this.btnClear.setEnabled(n > 0);
    }

    private void loadVirtualColumns() {
        this.virtualModel.removeAllElements();
        Enumeration enumeration = this.getNodeProperties().getVirtualColumns().elements();
        while (enumeration.hasMoreElements()) {
            BaseVirtualColumn baseVirtualColumn = (BaseVirtualColumn)enumeration.nextElement();
            this.virtualModel.addElement(baseVirtualColumn.getColumnName());
        }
        if (this.virtualModel.getSize() > 0) {
            this.virtualColumns.setSelectedIndex(Math.max(0, this.currentColumnIndex));
        }
    }

    private void loadBasedColumnChoices() {
        if (this.basedColumnChoices.getItemCount() > 0) {
            this.basedColumnChoices.removeAllItems();
        }
        if (this.mdata != null) {
            String string = (String)this.virtualColumns.getSelectedValue();
            int n = 0;
            try {
                n = this.mdata.getColumnCount();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            int n2 = 0;
            while (n2 < n) {
                try {
                    if (string != null && !this.mdata.getColumnIdentifier(n2).equals(string)) {
                        this.basedColumnChoices.addItem(this.mdata.getColumnIdentifier(n2));
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                ++n2;
            }
        }
    }

    private void showSelectedVirtualColumn() {
        this.name.setText("");
        this.baseModel.removeAllElements();
        String string = (String)this.virtualColumns.getSelectedValue();
        int n = this.virtualModel.getSize();
        this.currentColumnIndex = this.virtualColumns.getSelectedIndex();
        if (string == null) {
            return;
        }
        BaseVirtualColumn baseVirtualColumn = this.getNodeProperties().getVirtualColumn(string);
        if (baseVirtualColumn == null) {
            return;
        }
        this.name.setText(baseVirtualColumn.getColumnName());
        JCTypeConverter jCTypeConverter = new JCTypeConverter();
        int n2 = -1;
        int n3 = -1;
        int n4 = 0;
        while (n4 < JCDataConverter.javaDataTypeValues.length) {
            if (JCDataConverter.javaDataTypeValues[n4] == 1003) {
                n3 = n4;
            }
            if (baseVirtualColumn.getColumnType() == JCDataConverter.javaDataTypeValues[n4]) {
                n2 = n4;
                break;
            }
            ++n4;
        }
        this.type.setSelectedIndex(n2 == -1 ? n3 : n2);
        n2 = -1;
        n3 = -1;
        int n5 = 0;
        while (n5 < JCDataConverter.virtualColumnOperationValues.length) {
            if (JCDataConverter.virtualColumnOperationValues[n5] == 3) {
                n3 = n5;
            }
            if (baseVirtualColumn.getOperation() == JCDataConverter.virtualColumnOperationValues[n5]) {
                n2 = n5;
                break;
            }
            ++n5;
        }
        this.operation.setSelectedIndex(n2 == -1 ? n3 : n2);
        this.baseModel.removeAllElements();
        int n6 = 0;
        while (n6 < baseVirtualColumn.getColumns().length) {
            this.baseModel.addElement(baseVirtualColumn.getColumns()[n6]);
            ++n6;
        }
        this.loadBasedColumnChoices();
    }

    int getNextCounter() {
        Enumeration enumeration = this.getNodeProperties().getVirtualColumns().elements();
        while (enumeration.hasMoreElements()) {
            BaseVirtualColumn baseVirtualColumn = (BaseVirtualColumn)enumeration.nextElement();
            if (!baseVirtualColumn.getColumnName().startsWith("col")) continue;
            String string = baseVirtualColumn.getColumnName().substring(new String("col").length());
            int n = 0;
            try {
                n = new Integer(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
            counter = Math.max(counter, n);
        }
        return ++counter;
    }

    void addColumn() {
        String string = "col" + this.getNextCounter();
        DescriptionDialog descriptionDialog = new DescriptionDialog((Frame)new JFrame(), LocaleBundle.string("Column Name"));
        descriptionDialog.setDescription(string);
        descriptionDialog.pack();
        descriptionDialog.setVisible(true);
        String string2 = descriptionDialog.getDescription() == null || descriptionDialog.getDescription().length() == 0 ? string : descriptionDialog.getDescription();
        BaseVirtualColumn baseVirtualColumn = new BaseVirtualColumn(string2, 1003, 3, new String[0]);
        this.getNodeProperties().addVirtualColumn(baseVirtualColumn);
        this.currentColumnIndex = this.getNodeProperties().getVirtualColumns().size() - 1;
    }

    void deleteColumn() {
        String string = (String)this.virtualColumns.getSelectedValue();
        if (string == null) {
            return;
        }
        BaseVirtualColumn baseVirtualColumn = this.getNodeProperties().getVirtualColumn(string);
        this.getNodeProperties().removeVirtualColumn(baseVirtualColumn);
        this.currentColumnIndex = this.getNodeProperties().getVirtualColumns().size() - 1;
    }

    void deleteAllColumns() {
        this.getNodeProperties().removeAllVirtualColumns();
    }

    void addBasedColumn() {
        String string = (String)this.basedColumnChoices.getSelectedItem();
        if (string != null && string.length() > 0) {
            this.baseModel.addElement(string);
            this.currentVirtualColumnChanged();
        }
    }

    void deleteBasedColumn() {
        String string = (String)this.basedColumns.getSelectedValue();
        if (string != null && string.length() > 0) {
            this.baseModel.removeElement(string);
            this.currentVirtualColumnChanged();
        }
    }

    private void currentVirtualColumnChanged() {
        String string = this.name.getText();
        int n = JCDataConverter.virtualColumnOperationValues[this.operation.getSelectedIndex()];
        int n2 = JCDataConverter.javaDataTypeValues[this.type.getSelectedIndex()];
        Object[] objectArray = new String[this.baseModel.getSize()];
        this.baseModel.copyInto(objectArray);
        String string2 = (String)this.virtualColumns.getSelectedValue();
        BaseVirtualColumn baseVirtualColumn = new BaseVirtualColumn(string, n2, n, (String[])objectArray);
        BaseVirtualColumn baseVirtualColumn2 = this.getNodeProperties().getVirtualColumn(string2);
        Vector vector = (Vector)this.getNodeProperties().getVirtualColumns().clone();
        this.getNodeProperties().removeAllVirtualColumns();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            BaseVirtualColumn baseVirtualColumn3 = (BaseVirtualColumn)enumeration.nextElement();
            this.getNodeProperties().addVirtualColumn(baseVirtualColumn3.equals(baseVirtualColumn2) ? baseVirtualColumn : baseVirtualColumn3);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        JTextField jTextField;
        if (this.isInitializing()) {
            return;
        }
        if (this.getNodeProperties() == null) {
            return;
        }
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.btnAdd)) {
                this.addColumn();
                this.getNodeProperties().fireJCDataEvent(new JCDataEvent((Object)this.getNodeProperties()));
            } else if (jButton.equals(this.btnDelete)) {
                this.deleteColumn();
                this.getNodeProperties().fireJCDataEvent(new JCDataEvent((Object)this.getNodeProperties()));
            } else if (jButton.equals(this.btnClear)) {
                this.deleteAllColumns();
                this.getNodeProperties().fireJCDataEvent(new JCDataEvent((Object)this.getNodeProperties()));
            } else if (jButton.equals(this.btnAddBasedColumn)) {
                this.addBasedColumn();
            } else if (jButton.equals(this.btnDeleteBasedColumn)) {
                this.deleteBasedColumn();
            } else if (jButton.equals(this.btnSet)) {
                this.currentVirtualColumnChanged();
                this.getNodeProperties().fireJCDataEvent(new JCDataEvent((Object)this.getNodeProperties()));
            }
        } else if (!(actionEvent.getSource() instanceof JTextField) || (jTextField = (JTextField)actionEvent.getSource()).equals(this.name)) {
            // empty if block
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (this.getNodeProperties() == null) {
            return;
        }
    }
}

