/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.datasource.LocaleBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TipsDialog
extends JDialog
implements ActionListener {
    JButton btnOk;
    JCheckBox showTipsAtStart;
    JPanel messagePanel;

    public TipsDialog(Frame frame, String string) {
        super(frame);
        this.setTitle(string);
        this.init();
    }

    public void init() {
        this.getContentPane().setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel();
        this.messagePanel = new JPanel();
        this.showTipsAtStart = new JCheckBox(LocaleBundle.string("Show Tips At Start"));
        this.btnOk = new JButton(LocaleBundle.string("OK"));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.messagePanel, gridBagConstraints);
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        jPanel.add((Component)this.showTipsAtStart, gridBagConstraints);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.btnOk, gridBagConstraints);
        this.getContentPane().add(jPanel);
        this.btnOk.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TipsDialog.this.setVisible(false);
            }
        });
    }

    public void setShowTipsAtStart(boolean bl) {
        this.showTipsAtStart.setSelected(bl);
    }

    public boolean getShowTipsAtStart() {
        return this.showTipsAtStart.isSelected();
    }

    public void setMessage(String string) {
        this.messagePanel.removeAll();
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator"));
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            ++n;
            this.messagePanel.add(new JLabel(stringTokenizer.nextToken()));
        }
        this.messagePanel.setLayout(new GridLayout(n, 1));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.centerDialog();
        }
        super.setVisible(bl);
    }

    void centerDialog() {
        int n = 0;
        int n2 = 0;
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        n = (dimension.width - this.getSize().width) / 2;
        n2 = (dimension.height - this.getSize().height) / 2;
        this.setLocation(n, n2);
    }
}

