/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.FileError;
import com.agentpp.smiparser.Token;

public class SemanticError
implements FileError {
    private int line = -1;
    private int column = -1;
    private int endPosition = 0;
    private int endLine = -1;
    private int endColumn = -1;
    private String found;
    private String foundTokenImage;
    private String[] expected = new String[0];
    private Token token;
    private int errorType;

    public SemanticError(int errorType, int line, int column, int endPosition, Token token, String found, String foundTokenImage, String[] expected) {
        this.line = line;
        this.column = column;
        this.endPosition = endPosition;
        this.endColumn = token != null ? token.endColumn : column;
        this.endLine = token != null ? token.endLine : line;
        this.token = token;
        this.errorType = errorType;
        this.found = found;
        this.foundTokenImage = foundTokenImage;
        this.expected = expected;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getLastEndPosition() {
        return this.endPosition;
    }

    public int getEndPosition() {
        return this.endPosition;
    }

    public String getFound() {
        return this.found;
    }

    public String getFoundTokenImage() {
        return this.foundTokenImage;
    }

    public String[] getExpected() {
        return this.expected;
    }

    public String[] getExpectedImages() {
        return this.expected;
    }

    public String[] getLastExpectedImages() {
        return this.expected;
    }

    public Token getToken() {
        return this.token;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FileError) {
            FileError pex = (FileError)obj;
            return pex.getErrorType() == this.getErrorType() && pex.getEndPosition() == this.getEndPosition() && pex.getToken() == pex.getToken();
        }
        return false;
    }

    public void freeUnusedTokens() {
        this.token.next = null;
        this.token.specialToken = null;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }
}

