/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IObject;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smiparser.CreateOidsVisitor;
import com.agentpp.smiparser.ParseScope;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParseExceptionHandler;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.StringToken;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class SMIRepository
extends SimpleNode {
    private ImportModuleListener importer = null;
    protected Map modules = new HashMap();
    protected ParseScope scope = null;

    public SMIRepository() {
        super(0);
    }

    public SMIRepository(int id) {
        super(id);
    }

    public void reinit() {
        this.modules = new HashMap();
    }

    public void setImporter(ImportModuleListener importer) {
        this.importer = importer;
        if (this.scope != null) {
            this.scope.setImporter(importer);
        }
        Iterator it = this.modules.values().iterator();
        while (it.hasNext()) {
            ((ParseScope)it.next()).setImporter(importer);
        }
    }

    public void addScope(String moduleName) {
        this.scope = new ParseScope(moduleName, this.importer);
        this.modules.put(moduleName, this.scope);
    }

    public void setScope(String moduleName, SMIParseExceptionHandler errorHandler) {
        this.scope = (ParseScope)this.modules.get(moduleName);
        this.scope.setErrorHandler(errorHandler);
    }

    protected ParseScope getScope(String moduleName) {
        return (ParseScope)this.modules.get(moduleName);
    }

    public boolean importModule(String moduleName, MIBRepository localCache, boolean addAllToKnownObjects) {
        if (this.scope == null) {
            return false;
        }
        return this.scope.importModule(moduleName, localCache, addAllToKnownObjects);
    }

    public String hasCircularImport(String imp, String moduleName) {
        if (this.importer == null) {
            return null;
        }
        return this.getCyclicImport(imp, moduleName);
    }

    private String getCyclicImport(String moduleName, String match) {
        ImportModuleEvent e = new ImportModuleEvent(this, moduleName);
        this.importer.importModule(e);
        if (e.getObjects() == null) {
            return null;
        }
        IObject[] obj = e.getObjects();
        for (int i = 0; i < obj.length; ++i) {
            if (!(obj[i] instanceof MIBModule)) continue;
            MIBModule m = (MIBModule)obj[i];
            if (m.importsFrom(moduleName) || m.importsFrom(match)) {
                return moduleName;
            }
            if (!m.hasImports()) continue;
            String[] imports = m.getImportSources();
            for (int j = 0; j < imports.length; ++j) {
                String s = this.hasCircularImport(imports[j], match);
                if (s == null) continue;
                return s;
            }
        }
        return null;
    }

    public MIBObject getObject(String moduleName, String objectName) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getObject(moduleName, objectName);
    }

    public boolean setErrorHandler(SMIParseExceptionHandler errorHandler) {
        if (this.scope != null) {
            this.scope.setErrorHandler(errorHandler);
            return true;
        }
        return false;
    }

    public ObjectID getObjectID(String objectName) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getObjectID(objectName);
    }

    public ObjectID getObjectID(String moduleName, String objectName) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getObjectID(moduleName, objectName);
    }

    public boolean isModuleAlreadyImported(String moduleName) {
        if (this.scope == null) {
            return false;
        }
        return this.scope.isModuleAlreadyImported(moduleName);
    }

    public boolean isObjectKnown(String objectName) {
        if (this.scope == null) {
            return false;
        }
        return this.scope.isObjectKnown(objectName);
    }

    public MIBObject getKnownObject(String objectName) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getKnownObject(objectName);
    }

    public String getModuleName(Object moduleID) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getModuleName(moduleID);
    }

    public void createOids() {
        try {
            this.jjtAccept(new CreateOidsVisitor(this), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void createOids(String scope) {
        try {
            this.jjtAccept(new CreateOidsVisitor(this, scope), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addObject(MIBObject o) {
        if (this.scope != null) {
            this.scope.addObject(o);
        }
    }

    public void addKnownObject(MIBObject o) throws SMIParseException {
        if (this.scope != null) {
            this.scope.addKnownObject(o);
        }
    }

    public void replaceKnownObject(String name, MIBObject o) {
        if (this.scope != null) {
            this.scope.replaceKnownObject(name, o);
        }
    }

    public void addUnresolvedName(StringToken[] oid, StringToken name) {
        if (this.scope != null) {
            this.scope.addUnresolvedName(oid, name);
        }
    }

    public void checkUnresolved(StringToken name, StringToken[] oid) {
        if (this.scope != null) {
            this.scope.checkUnresolved(name, oid);
        }
    }

    public void resolveNames() {
        if (this.scope != null) {
            this.scope.resolveNames();
        }
    }

    public boolean existsUnresolvedNames() {
        if (this.scope == null) {
            return false;
        }
        return this.scope.existsUnresolvedNames();
    }

    public Iterator getUnresolvedNames() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getUnresolvedNames();
    }

    public StringToken getUnresolvedSyntax(String syntax) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getUnresolvedSyntax(syntax);
    }

    public void checkUnresolvedSyntax(StringToken syntax) {
        if (this.scope != null) {
            this.scope.checkUnresolvedSyntax(syntax);
        }
    }

    public void checkUnresolvedObject(StringToken objectName, Class type) {
        if (this.scope != null) {
            this.scope.checkUnresolvedObject(objectName, type);
        }
    }

    public boolean existsUnresolvedSyntaxes() {
        if (this.scope == null) {
            return false;
        }
        return this.scope.existsUnresolvedSyntaxes();
    }

    public boolean existsWrongTypes() {
        if (this.scope == null) {
            return false;
        }
        return this.scope.existsWrongTypes();
    }

    public void resolveSyntaxes() {
        if (this.scope != null) {
            this.scope.resolveSyntaxes();
        }
    }

    public Iterator getWrongTypes() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getWrongTypes();
    }

    public Iterator getUnresolvedSyntaxes() {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getUnresolvedSyntaxes();
    }

    public void addSequence(String sequenceIdentifier) {
        if (this.scope != null) {
            this.scope.addSequence(sequenceIdentifier);
        }
    }

    public Vector getSequence(String sequenceIdentifier) {
        if (this.scope == null) {
            return null;
        }
        return this.scope.getSequence(sequenceIdentifier);
    }

    public ImportModuleListener getModuleImporter() {
        return this.importer;
    }
}

