/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBImport;
import com.agentpp.smiparser.SMIImportList;
import com.agentpp.smiparser.SimpleNode;
import com.agentpp.smiparser.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMIMib
extends SimpleNode {
    private String name;
    private Token token;
    public String asn1Comment;
    public String asn1EndComment;
    public static final int ID = -4;
    public int version = 1;
    private Map<String, String> imports = new LinkedHashMap<String, String>();
    private List<SMIImportList> importList = new ArrayList<SMIImportList>();

    public SMIMib(String n, Token t) {
        super(-4);
        this.name = n;
        this.token = t;
    }

    public void addImport(String objectName, String moduleSource) {
        this.imports.put(objectName, moduleSource);
    }

    public String getImport(String macro) {
        return this.imports.get(macro);
    }

    public Collection<String> getImportSources() {
        return this.imports.values();
    }

    public Collection<MIBImport> getImports() {
        LinkedHashMap<String, MIBImport> imports = new LinkedHashMap<String, MIBImport>();
        for (SMIImportList entry : this.importList) {
            MIBImport i = (MIBImport)imports.get(entry.getSource());
            if (i == null) {
                i = new MIBImport(entry.getSource());
                imports.put(entry.getSource(), i);
            }
            for (String ref : entry.getImports()) {
                i.addImport(ref);
            }
            i.setUserObject(new Token[]{entry.startToken, entry.getToken()});
        }
        return imports.values();
    }

    public String getName() {
        return this.name;
    }

    @Override
    public Token getToken() {
        return this.token;
    }

    public List getImportList() {
        return this.importList;
    }

    @Override
    public String toString() {
        return this.name;
    }
}

