/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IObject;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIObjectIdentifier;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParseExceptionHandler;
import com.agentpp.smiparser.SemanticError;
import com.agentpp.smiparser.StringToken;
import com.agentpp.smiparser.Token;
import com.objectspace.jgl.Pair;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;

public class ParseScope {
    protected MIBRepository rep = new MIBRepository();
    protected Map unresolved = new HashMap(10);
    protected Map unresolvedSyntaxes = new HashMap(10);
    protected Map knownObjects = new HashMap(100);
    protected Map registeredObjects = new HashMap(100);
    protected Map sequences = new HashMap(100);
    protected Vector wrongTypes = new Vector(10);
    protected String scope = null;
    protected ImportModuleListener importer = null;
    protected SMIParseExceptionHandler errorHandler;

    public ParseScope(String moduleName, ImportModuleListener importer) {
        this.scope = moduleName;
        this.importer = importer;
        this.init();
    }

    public String getScope() {
        return this.scope;
    }

    public SMIParseExceptionHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setImporter(ImportModuleListener importer) {
        this.importer = importer;
    }

    public void setErrorHandler(SMIParseExceptionHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void init() {
        this.rep = new MIBRepository(true);
        this.unresolved = new Hashtable(10);
        this.unresolvedSyntaxes = new Hashtable(10);
        this.knownObjects = new Hashtable(100, 10.0f);
        this.registeredObjects = new Hashtable(100);
        this.sequences = new Hashtable(100);
        Enumeration<? extends MIBObject> en = this.rep.objects();
        while (en.hasMoreElements()) {
            MIBObject o = en.nextElement();
            try {
                this.addKnownObject(o);
            }
            catch (SMIParseException sMIParseException) {}
        }
    }

    public boolean importModule(String moduleName, MIBRepository localCache, boolean addAllToKnownObjects) {
        IObject[] objs = null;
        MIBModule m = localCache.getModule(moduleName);
        if (m != null) {
            objs = m.getObjects();
        } else {
            if (this.importer == null) {
                return false;
            }
            ImportModuleEvent e = new ImportModuleEvent(this, moduleName);
            this.importer.importModule(e);
            objs = e.getObjects();
        }
        if (objs == null) {
            return false;
        }
        for (int i = 0; i < objs.length; ++i) {
            if (!(objs[i] instanceof MIBObject)) continue;
            this.rep.addObject((MIBObject)objs[i]);
            if (!addAllToKnownObjects) continue;
            this.knownObjects.put(objs[i].getName(), objs[i]);
        }
        return true;
    }

    public MIBObject getObject(String moduleName, String objectName) {
        return this.rep.getObject(moduleName, objectName);
    }

    public ObjectID getObjectID(String objectName) {
        MIBObject o = (MIBObject)this.knownObjects.get(objectName);
        if (o == null) {
            return null;
        }
        return o.getOid();
    }

    public ObjectID getObjectID(String moduleName, String objectName) {
        return this.rep.getObjectID(moduleName, objectName);
    }

    public boolean isModuleAlreadyImported(String moduleName) {
        return this.rep.getModule(moduleName) != null;
    }

    public boolean isObjectKnown(String objectName) {
        return this.knownObjects.get(objectName) != null;
    }

    public MIBObject getKnownObject(String objectName) {
        return (MIBObject)this.knownObjects.get(objectName);
    }

    public String getModuleName(Object moduleID) {
        MIBModule m = this.rep.getModule(moduleID);
        if (m == null) {
            return null;
        }
        return m.getModuleName();
    }

    public void addObject(MIBObject o) {
        this.rep.addObject(o);
    }

    public void addKnownObject(MIBObject o) throws SMIParseException {
        switch (o.getType()) {
            case 4: 
            case 10: {
                break;
            }
            default: {
                MIBObject other = (MIBObject)this.registeredObjects.get(o.getOid());
                if (other != null) {
                    Vector<String> v = new Vector<String>();
                    v.addElement(o.getName());
                    v.addElement(other.getName());
                    v.addElement(o.getPrintableOid());
                    if (this.errorHandler != null) {
                        if (o.userObject instanceof Token) {
                            Token t = (Token)o.userObject;
                            this.errorHandler.error(new SMIParseException(new SemanticError(2000, t.beginLine, t.beginColumn, t.endPos, t, o.getName(), o.getName(), new String[0]), 2000, v));
                        } else {
                            this.errorHandler.error(new SMIParseException("Duplicate OID registration", 2000, v));
                        }
                    }
                }
                this.registeredObjects.put(o.getOid(), o);
                break;
            }
        }
        MIBObject obj = (MIBObject)this.knownObjects.get(o.getName());
        if (obj == null || obj.getModuleID() < 0) {
            this.knownObjects.put(o.getName(), o);
        }
    }

    public final void replaceKnownObject(String name, MIBObject o) {
        this.knownObjects.remove(name);
        try {
            this.addKnownObject(o);
        }
        catch (SMIParseException sMIParseException) {
            // empty catch block
        }
    }

    public final void addUnresolvedName(StringToken[] oid, StringToken name) {
        Pair pair = new Pair(oid, name);
        LinkedList unres = ParseScope.getUnresolvedSubIDs(oid);
        for (String subID : unres) {
            StringToken st = new StringToken(subID, null);
            LinkedList<Pair> references = (LinkedList<Pair>)this.unresolved.get(st);
            if (references == null) {
                references = new LinkedList<Pair>();
                this.unresolved.put(st, references);
            }
            references.add(pair);
        }
    }

    private static LinkedList getUnresolvedSubIDs(StringToken[] oid) {
        LinkedList<String> unresolvedSubIDs = new LinkedList<String>();
        for (int i = 0; i < oid.length; ++i) {
            String subID = oid[i].string;
            if (subID.length() <= 0 || Character.isDigit(subID.charAt(0))) continue;
            unresolvedSubIDs.add(subID);
        }
        return unresolvedSubIDs;
    }

    public final void checkUnresolved(StringToken name, StringToken[] oid) {
        LinkedList unres = (LinkedList)this.unresolved.get(name);
        if (unres != null) {
            ListIterator it = unres.listIterator();
            while (it.hasNext()) {
                Pair pair = (Pair)it.next();
                Object[] unresOid = (StringToken[])pair.first;
                StringToken unresName = (StringToken)pair.second;
                int pos = Arrays.binarySearch(unresOid, name);
                if (pos < 0 || pos >= unresOid.length - 1) continue;
                StringToken[] newOid = ParseScope.createResolvedOID(oid, (StringToken[])unresOid, pos);
                ObjectID objid = SMIObjectIdentifier.buildObjectID(newOid);
                if (objid.isValid()) {
                    it.remove();
                    try {
                        this.addKnownObject(new MIBObject(objid, unresName.string));
                    }
                    catch (SMIParseException pex) {}
                    continue;
                }
                pair.first = newOid;
            }
        }
    }

    private static StringToken[] createResolvedOID(StringToken[] oid, StringToken[] unresOid, int pos) {
        StringToken[] newOid = new StringToken[unresOid.length - 1 + oid.length];
        if (pos > 0) {
            System.arraycopy(unresOid, 0, newOid, 0, pos);
        }
        if (oid.length > 0) {
            System.arraycopy(oid, 0, newOid, pos, oid.length);
        }
        System.arraycopy(unresOid, pos + 1, newOid, pos + oid.length, unresOid.length - pos - 1);
        return newOid;
    }

    private static boolean isNumber(String s) {
        try {
            Long.parseLong(s);
            return true;
        }
        catch (NumberFormatException nfex) {
            return false;
        }
    }

    public void resolveNames() {
        Iterator en = this.unresolved.values().iterator();
        while (en.hasNext()) {
            LinkedList unres = (LinkedList)en.next();
            ListIterator it = unres.listIterator();
            while (it.hasNext()) {
                Pair pair = (Pair)it.next();
                StringToken[] unresOid = (StringToken[])pair.first;
                StringToken unresName = (StringToken)pair.second;
                ObjectID roid = null;
                StringToken uname = null;
                int pos = -1;
                for (int i = 0; i < unresOid.length; ++i) {
                    if (ParseScope.isNumber(unresOid[i].string)) continue;
                    uname = unresOid[i];
                    pos = i;
                    break;
                }
                if (Character.isUpperCase(uname.string.charAt(0))) {
                    String oname;
                    String moduleName;
                    int dot = uname.string.indexOf(46);
                    if (dot >= 0 && (roid = this.rep.getObjectID(moduleName = uname.string.substring(0, dot), oname = uname.string.substring(dot + 1))) != null) {
                        uname.string = oname;
                    }
                } else {
                    roid = this.rep.getObjectID(uname.string);
                }
                if (roid == null) continue;
                String[] rsoid = ObjectID.toArray(roid.toString());
                StringToken[] st = new StringToken[rsoid.length];
                for (int i = 0; i < rsoid.length; ++i) {
                    st[i] = new StringToken(rsoid[i], null);
                }
                StringToken[] newOid = ParseScope.createResolvedOID(st, unresOid, pos);
                ObjectID objid = new ObjectID(SMIObjectIdentifier.buildObjectID(newOid));
                if (objid.isValid()) {
                    it.remove();
                    try {
                        MIBObject mo = new MIBObject(objid, unresName.string);
                        mo.userObject = newOid;
                        this.addKnownObject(mo);
                    }
                    catch (SMIParseException pex) {}
                    continue;
                }
                pair.first = newOid;
            }
            if (unres.size() != 0) continue;
            en.remove();
        }
    }

    public boolean existsUnresolvedNames() {
        this.resolveNames();
        return this.unresolved.size() > 0;
    }

    public Iterator getUnresolvedNames() {
        return this.unresolved.values().iterator();
    }

    public void checkUnresolvedSyntax(StringToken syntax) {
        if (this.knownObjects.get(syntax) == null) {
            this.unresolvedSyntaxes.put(syntax, String.class);
        }
    }

    public StringToken getUnresolvedSyntax(String syntax) {
        for (Object token : this.unresolvedSyntaxes.keySet()) {
            if (!(token instanceof StringToken) || !syntax.equals(token)) continue;
            return (StringToken)token;
        }
        return null;
    }

    private boolean isObjectClassNotMatching(Class c1, Class c2) {
        return !c1.equals(c2) && (MIBObject.class.equals(c1.getClass()) || !c1.isAssignableFrom(c2) && !c2.isAssignableFrom(c1));
    }

    public void checkUnresolvedObject(StringToken objectName, Class type) {
        MIBObject o = (MIBObject)this.knownObjects.get(objectName);
        if (o == null || o instanceof MIBTextualConvention || o.getOid().isEmpty() || type != null && this.isObjectClassNotMatching(o.getClass(), type)) {
            if (type == null) {
                this.unresolvedSyntaxes.put(objectName, String.class);
            } else {
                this.unresolvedSyntaxes.put(objectName, type);
            }
        }
    }

    public boolean existsUnresolvedSyntaxes() {
        return this.unresolvedSyntaxes.size() > 0;
    }

    public void resolveSyntaxes() {
        boolean found = true;
        block2: while (found) {
            found = false;
            for (Map.Entry entry : this.unresolvedSyntaxes.entrySet()) {
                StringToken ur = (StringToken)entry.getKey();
                Class type = (Class)entry.getValue();
                Object o = this.knownObjects.get(ur.string);
                if (o == null) continue;
                this.unresolvedSyntaxes.remove(ur);
                if (!type.equals(new String().getClass())) {
                    try {
                        String typeStringExpected = ((MIBObject)type.newInstance()).getTypeString();
                        String typeStringGot = ((MIBObject)o).getTypeString();
                        if (this.isObjectClassNotMatching(o.getClass(), type) && !SMI.ENTRY_TYPES[10].equals(typeStringExpected)) {
                            this.wrongTypes.add(new Object[]{ur, typeStringExpected, typeStringGot});
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                found = true;
                continue block2;
            }
        }
    }

    public boolean existsWrongTypes() {
        return this.wrongTypes.size() > 0;
    }

    public Iterator getWrongTypes() {
        return this.wrongTypes.iterator();
    }

    public Iterator getUnresolvedSyntaxes() {
        return this.unresolvedSyntaxes.entrySet().iterator();
    }

    public void addSequence(String sequenceIdentifier) {
        this.sequences.put(sequenceIdentifier, new Vector());
    }

    public Vector getSequence(String sequenceIdentifier) {
        return (Vector)this.sequences.get(sequenceIdentifier);
    }
}

