/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smiparser;

import com.agentpp.smiparser.ModuleInfo;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ModuleInfoSorter {
    private ModuleInfo[] list = new ModuleInfo[0];
    private Vector sorted = new Vector();
    private Vector source = new Vector();
    private HashSet missing = new HashSet();
    private Hashtable pool = null;
    private HashSet backupPool = null;

    public ModuleInfoSorter(ModuleInfo[] list) {
        this.list = list;
        this.resetPool();
    }

    public static ModuleInfo[] difference(ModuleInfo[] a, ModuleInfo[] b) {
        Vector<ModuleInfo> v = new Vector<ModuleInfo>(a.length);
        for (int i = 0; i < a.length; ++i) {
            boolean match = false;
            for (int j = 0; j < b.length; ++j) {
                if (!a[i].moduleName.equals(b[j].moduleName)) continue;
                match = true;
                break;
            }
            if (match) continue;
            v.add(a[i]);
        }
        Object[] r = new ModuleInfo[v.size()];
        v.copyInto(r);
        return r;
    }

    public void setPool(ModuleInfo[] poolList) {
        this.pool = new Hashtable(this.list.length + poolList.length);
        for (int i = 0; i < poolList.length; ++i) {
            this.pool.put(poolList[i].moduleName, poolList[i]);
        }
    }

    public void resetPool() {
        this.pool = new Hashtable(this.list.length + 1);
    }

    public void setBackupPool(String[] moduleNames) {
        this.backupPool = new HashSet<String>(Arrays.asList(moduleNames));
    }

    public boolean sort() {
        this.source = new Vector(this.list.length);
        for (int i = 0; i < this.list.length; ++i) {
            this.source.add(this.list[i]);
        }
        this.sorted = new Vector(this.list.length);
        this.missing = new HashSet();
        boolean foundAny = true;
        boolean useBackupPool = false;
        while (foundAny && this.source.size() > 0) {
            foundAny = false;
            Iterator en = this.source.iterator();
            while (en.hasNext()) {
                ModuleInfo m = (ModuleInfo)en.next();
                boolean found = true;
                for (int i = 0; i < m.getImports().length; ++i) {
                    if (this.pool.get(m.getImports()[i]) != null || useBackupPool && (!useBackupPool || this.backupPool.contains(m.getImports()[i]))) continue;
                    found = false;
                    break;
                }
                if (!found) continue;
                foundAny = true;
                en.remove();
                this.pool.put(m.moduleName, m);
                this.sorted.add(m);
            }
            if (!foundAny && this.backupPool != null && !useBackupPool) {
                useBackupPool = true;
                foundAny = true;
                continue;
            }
            useBackupPool = false;
        }
        Hashtable<String, ModuleInfo> failed = new Hashtable<String, ModuleInfo>(this.source.size() + 1);
        Enumeration en = this.source.elements();
        while (en.hasMoreElements()) {
            ModuleInfo m = (ModuleInfo)en.nextElement();
            failed.put(m.moduleName, m);
        }
        return this.source.size() == 0;
    }

    public ModuleInfo[] getSortedList() {
        Object[] r = new ModuleInfo[this.sorted.size()];
        this.sorted.copyInto(r);
        return r;
    }

    public ModuleInfo[] getFailedList() {
        Object[] r = new ModuleInfo[this.source.size()];
        this.source.copyInto(r);
        return r;
    }

    public String[] getMissingModules() {
        Object[] o = this.missing.toArray();
        String[] s = new String[o.length];
        for (int i = 0; i < o.length; ++i) {
            s[i] = o[i].toString();
        }
        return s;
    }
}

