/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.repository;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smi.IModule;
import com.agentpp.smi.event.ImportModuleListener;
import com.agentpp.smi.event.RepositoryEvent;
import com.agentpp.smiparser.LenientSMI2Java;
import com.agentpp.smiparser.ParseException;
import com.agentpp.smiparser.SMI2Java;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.smiparser.SMIParser;
import com.agentpp.smiparser.SMIRepository;
import com.agentpp.smiparser.TokenMgrError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class TextFileRepositoryManager
extends DefaultRepositoryManager {
    private boolean lenientParseMode = false;
    private int maxCacheEntries = 50;
    private Map repCache = new LinkedHashMap(){

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() >= TextFileRepositoryManager.this.maxCacheEntries;
        }
    };

    protected MIBModule loadModuleFromFile(String moduleName, boolean moduleOnly) throws IOException, ClassNotFoundException {
        MIBModule m;
        RepositoryEvent event = new RepositoryEvent(this, moduleName);
        this.fireReadModule(event);
        InputStream file = null;
        String fname = moduleName;
        boolean cachable = true;
        if (event.getInputStream() == null) {
            if (event.isUseDefaults()) {
                File f = new File(this.path.getPath(), moduleName);
                if (f.exists()) {
                    file = new FileInputStream(f);
                } else {
                    f = this.getModuleFile(moduleName);
                    file = new FileInputStream(f);
                }
                if (file != null) {
                    fname = f.getPath();
                }
                if ((m = this.getModuleFromCache(moduleName, f.lastModified())) != null) {
                    return m;
                }
            }
            if (file == null) {
                cachable = false;
                String resourceName = "modules/" + moduleName + ".cmib";
                file = IModule.class.getResourceAsStream(resourceName);
                if (file == null) {
                    throw new FileNotFoundException(moduleName);
                }
            }
        } else {
            file = event.getInputStream();
        }
        try {
            MIBRepository rep = this.parse(file, fname, this, this.lenientParseMode);
            m = rep.getModule(moduleName);
            this.fireAfterReadModule(event);
            if (cachable) {
                this.repCache.put(m.getModuleName(), new RepositoryCacheEntry(null, m));
            }
            return m;
        }
        catch (SMIParseException pex) {
            throw new IOException(pex.getMessage());
        }
    }

    private MIBModule getModuleFromCache(String moduleName, long lastModifiedOnDisk) {
        RepositoryCacheEntry e = (RepositoryCacheEntry)this.repCache.get(moduleName);
        if (e != null) {
            if (e.lastUpdate > lastModifiedOnDisk) {
                return (MIBModule)e.module.getClone();
            }
            if (this.verbose) {
                System.out.println("MIB module '" + moduleName + "' changed on disk");
            }
            this.repCache.remove(moduleName);
        }
        return null;
    }

    private synchronized Integer getModuleID(String moduleName, boolean createIfMissing) throws IOException {
        Properties index = this.getModuleIndex();
        String id = index.getProperty(moduleName + ".id");
        if (id != null) {
            return new Integer(id);
        }
        if (createIfMissing) {
            Integer i = this.createModuleID(moduleName);
            index.setProperty(moduleName + ".id", "" + i);
            this.setModuleIndex(index);
        }
        return null;
    }

    private MIBRepository parse(InputStream fi, String path, ImportModuleListener importer, boolean lenient) throws SMIParseException {
        MIBRepository rep = null;
        if (this.verbose) {
            System.out.print("Loading MIB file [" + path + "]...");
        }
        SMIParser parser = new SMIParser(fi);
        if (lenient) {
            parser.setLenient(1);
        }
        parser.setMaxErrors(this.maxErrors);
        SMIRepository tree = null;
        try {
            tree = parser.Input(path);
            tree.setImporter(importer);
            tree.createOids();
        }
        catch (ParseException ex) {
            block25: {
                if (this.verbose) {
                    System.out.println(ex.getMessage());
                    ex.printStackTrace();
                }
                try {
                    fi.close();
                }
                catch (IOException ioex) {
                    if (!this.verbose) break block25;
                    ioex.printStackTrace();
                }
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException nex = new SMIParseException(ex.getMessage(), ex.getShortMessage(), ex.errorType, ex);
            nex.setErrorList(parser.getErrors());
            throw nex;
        }
        catch (Throwable t) {
            if (this.verbose) {
                System.out.println(t.getMessage());
                t.printStackTrace();
            }
            try {
                fi.close();
            }
            catch (IOException ioex) {
                // empty catch block
            }
            if (t instanceof TokenMgrError) {
                if (this.verbose) {
                    System.out.println("failed.");
                }
                throw new SMIParseException(t.getMessage(), null, 50, (TokenMgrError)t);
            }
            if (this.verbose) {
                System.out.println("failed.");
            }
            t.printStackTrace();
            throw new SMIParseException(t.getMessage(), 1000);
        }
        if (parser.getErrors().size() >= this.maxErrors) {
            if (this.verbose) {
                System.out.println("failed.");
            }
            SMIParseException pex = (SMIParseException)parser.getErrors().get(0);
            pex.setErrorList(parser.getErrors());
            throw pex;
        }
        if (this.verbose) {
            System.out.print("parsed");
        }
        try {
            rep = this.getRepository(tree, parser.getErrors(), lenient);
        }
        catch (SMIParseException pex) {
            if (this.verbose) {
                System.out.println(pex.getMessage());
                pex.printStackTrace();
                System.out.println(", failed.");
            }
            throw pex;
        }
        catch (Throwable th) {
            th.printStackTrace();
            throw new SMIParseException(th.getMessage(), 0);
        }
        if (this.verbose) {
            System.out.println(", done.");
        }
        try {
            fi.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
        return rep;
    }

    protected MIBRepository getRepository(SMIRepository rep, List parseErrors, boolean lenient) throws SMIParseException {
        SMI2Java visitor = lenient ? new LenientSMI2Java(rep, this.options) : new SMI2Java(rep, this.options);
        visitor.setErrors(parseErrors);
        visitor.setMaxErrors(this.maxErrors);
        Vector v = new Vector();
        try {
            rep.jjtAccept(visitor, v);
        }
        catch (Exception ex) {
            if (visitor.getErrors().size() > 0) {
                SMIParseException pex = (SMIParseException)visitor.getErrors().get(0);
                pex.setErrorList(visitor.getErrors());
                throw pex;
            }
            ex.printStackTrace();
            throw new SMIParseException(ex.getMessage(), 0);
        }
        if (visitor.getErrors().size() > 0) {
            SMIParseException pex = (SMIParseException)visitor.getErrors().get(0);
            pex.setErrorList(visitor.getErrors());
            throw pex;
        }
        MIBRepository r = visitor.getRepository();
        r.structureChanged();
        if (lenient) {
            Iterator<MIBModule> it = r.modulesIterator();
            while (it.hasNext()) {
                MIBModule m = it.next();
                m.setParseMode(1);
            }
        }
        return r;
    }

    protected File getModuleFile(String moduleName) throws IOException {
        Properties prop = this.getModuleIndex();
        String fname = prop.getProperty(moduleName + ".path", moduleName);
        return new File(fname);
    }

    private Properties getModuleIndex() throws IOException {
        Properties prop = new Properties();
        try {
            FileInputStream is = new FileInputStream(new File(this.path, "module-index.properties"));
            prop.load(is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        return prop;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized boolean saveModulesFromRepository(MIBRepository rep) throws IOException {
        boolean added = true;
        Properties index = this.getModuleIndex();
        Iterator<MIBModule> modules = rep.modulesIterator();
        while (modules.hasNext()) {
            MIBModule m = modules.next();
            RepositoryEvent event = new RepositoryEvent(this, m.getModuleName(), m);
            this.fireWriteModule(event);
            OutputStream output = event.getOutputStream();
            File f = new File(this.path.getPath() + File.separatorChar + m.getModuleName());
            if (output == null) {
                if (!event.isUseDefaults()) return false;
                String p = m.getFileName();
                if (p != null) {
                    f = new File(this.path.getPath(), new File(p).getName());
                }
                if (f.exists()) {
                    added = false;
                }
                this.repCache.put(m.getModuleName(), new RepositoryCacheEntry(f, m));
                FileOutputStream file = new FileOutputStream(f);
                output = file;
            } else {
                this.repCache.put(m.getModuleName(), new RepositoryCacheEntry(f, m));
            }
            output.write(m.toSMI(1, rep, MIBObject.getLineSeparator()).getBytes());
            output.flush();
            output.close();
            index.setProperty(m.getModuleName() + ".file", f.getPath());
            index.setProperty(m.getModuleName() + ".id", "" + m.getModuleID());
        }
        this.setModuleIndex(index);
        return added;
    }

    private void setModuleIndex(Properties index) throws IOException {
        FileOutputStream os = new FileOutputStream(new File(this.path, "module-index.properties"));
        index.store(os, "Text MIB Repository - Last Update: " + new Date());
        os.flush();
        ((OutputStream)os).close();
    }

    public String[] getModuleNames() throws IOException {
        String[] files = super.getModuleNames();
        HashSet<String> f = new HashSet<String>(Arrays.asList(files));
        Properties index = this.getModuleIndex();
        for (Map.Entry<Object, Object> e : index.entrySet()) {
            String key = (String)e.getKey();
            if (!key.endsWith(".file")) continue;
            String name = key.substring(0, key.length() - 5);
            File file = new File((String)e.getValue());
            if (!file.exists() || !file.isFile()) continue;
            f.add(name);
        }
        return f.toArray(new String[f.size()]);
    }

    public boolean isModuleAvailable(String moduleName) {
        boolean isAvailable = super.isModuleAvailable(moduleName);
        if (!isAvailable) {
            try {
                Properties index = this.getModuleIndex();
                String fname = index.getProperty(moduleName + ".file");
                if (fname != null) {
                    File f = new File(fname);
                    return f.exists() && f.isFile();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    public void setLenientParseMode(boolean lenientParseMode) {
        this.lenientParseMode = lenientParseMode;
    }

    public boolean isLenientParseMode() {
        return this.lenientParseMode;
    }

    class RepositoryCacheEntry {
        private long lastUpdate;
        private MIBModule module;

        public RepositoryCacheEntry(File file, MIBModule module) {
            this.module = module;
            this.lastUpdate = System.currentTimeMillis();
        }
    }
}

