/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.xsd;

import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.smiparser.SMI;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.QName;
import org.dom4j.dom.DOMAttribute;
import org.dom4j.dom.DOMComment;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class MIBModule2XSD {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private MIBRepository _$3923;
    private MIBModule _$12726;
    private Vector _$12727 = new Vector();
    private static SimpleDateFormat _$3924 = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private String _$12728 = "http://www.mibexplorer.com/xsd/mibs/";

    public MIBModule2XSD(MIBRepository rep) {
        this._$3923 = rep;
    }

    public void setURLPrefix(String urlPrefix) {
        this._$12728 = urlPrefix;
    }

    public synchronized Document createXML(MIBModule m, String header, String schemaURL) {
        this._$12726 = m;
        this._$12727 = new Vector();
        DOMElement root = new DOMElement("xsd:schema");
        root.addAttribute("xmlns", this._$12728 + m.getModuleName());
        root.addAttribute("xmlns:xsd", "http://www.w3.org/2001/XMLSchema");
        root.addAttribute("xmlns:smi", this._$12728 + "smi");
        DOMDocument doc = new DOMDocument(root);
        String[] dependecies = m.getImportSources();
        for (int i = 0; i < dependecies.length; ++i) {
            DOMAttribute nspace = new DOMAttribute(new QName("xmlns:" + dependecies[i]), this._$12728 + dependecies[i]);
            root.add(nspace);
        }
        root.addAttribute("xml:lang", "en");
        root.addAttribute("elementFormDefault", "qualified");
        root.addAttribute("attributeFormDefault", "unqualified");
        root.addAttribute("targetNamespace", this._$12728 + m.getModuleName());
        doc.add(new DOMComment(header));
        try {
            Vector v = this._$3934(m);
            for (int i = 0; i < v.size(); ++i) {
                root.add((DOMElement)v.get(i));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < this._$12727.size(); ++i) {
            root.add((DOMElement)this._$12727.get(i));
        }
        Vector<MIBTextualConvention> simpleTypes = this._$12726.getTextualConventions();
        for (int i = 0; i < simpleTypes.size(); ++i) {
            root.add(this._$3952(simpleTypes.get(i)));
        }
        this._$12726 = null;
        this._$12727 = null;
        return doc;
    }

    public void output(OutputStream os, Document doc, int indent) {
        try {
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setIndent(true);
            outputFormat.setIndentSize(indent);
            outputFormat.setNewlines(true);
            XMLWriter xmlWriter = new XMLWriter(os, outputFormat);
            xmlWriter.write(doc);
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DOMElement _$3936(String descr) {
        DOMElement description = new DOMElement("xsd:documentation");
        description.setText(MIBObject.getUnquotedString(descr));
        return description;
    }

    private DOMElement _$12737(MIBObjectType o) {
        DOMElement annotation = new DOMElement("xsd:annotation");
        DOMElement appinfo = new DOMElement("xsd:appinfo");
        annotation.add(appinfo);
        DOMElement maxAccess = new DOMElement("maxAccess");
        maxAccess.setText(this._$4019(o.getAccess()));
        appinfo.add(maxAccess);
        DOMElement status = new DOMElement("status");
        status.setText(o.getStatus());
        appinfo.add(status);
        DOMElement oid = new DOMElement("oid");
        oid.setText(o.getOid().toString());
        appinfo.add(oid);
        if (o.hasUnits()) {
            DOMElement units = new DOMElement("units");
            units.setText(o.getUnits());
            appinfo.add(units);
        }
        appinfo.add(this._$3936(o.getDescription()));
        return annotation;
    }

    private DOMElement _$12740(Vector enums) {
        DOMElement r = new DOMElement("xsd:restriction");
        r.addAttribute("base", "xsd:NMTOKEN");
        for (int i = 0; i < enums.size(); ++i) {
            MIBEnum en = (MIBEnum)enums.get(i);
            DOMElement e = new DOMElement("xsd:enumeration");
            e.addAttribute("value", en.getLabel());
            DOMElement annotation = new DOMElement("xsd:annotation");
            DOMElement appinfo = new DOMElement("xsd:appinfo");
            annotation.add(appinfo);
            e.add(annotation);
            DOMElement intVal = new DOMElement("intValue");
            intVal.setText("" + en.getLongValue());
            appinfo.add(intVal);
            if (en.hasComment()) {
                appinfo.add(this._$3936(en.getComment()));
            }
            r.add(e);
        }
        return r;
    }

    private Vector _$12742(String displayHint) {
        if (displayHint == null) {
            return null;
        }
        Vector<DisplayHint> v = new Vector<DisplayHint>();
        int pos = 0;
        while (pos < displayHint.length()) {
            DisplayHint dh = new DisplayHint();
            while (pos < displayHint.length() && Character.isDigit(displayHint.charAt(pos))) {
                ++pos;
            }
            try {
                dh.number = Integer.parseInt(displayHint.substring(0, pos));
            }
            catch (NumberFormatException nfe) {
                return null;
            }
            displayHint = displayHint.substring(pos);
            pos = 0;
            dh.format = displayHint.charAt(pos++);
            if (!Character.isDigit(displayHint.charAt(pos))) {
                dh.sep = new Character(displayHint.charAt(pos++));
                if (!Character.isDigit(displayHint.charAt(pos))) {
                    dh.repeater = new Character(displayHint.charAt(pos++));
                }
            }
            displayHint = displayHint.substring(pos);
            pos = 0;
            v.add(dh);
        }
        return v;
    }

    private static int _$12747(long n) {
        int i = 1;
        while (n / 10L > 0L) {
            n /= 10L;
            ++i;
        }
        return i;
    }

    private DOMElement _$12749(String format, Vector ranges) {
        if (format == null || format.indexOf(42) >= 0) {
            return null;
        }
        DOMElement pattern = new DOMElement("xsd:pattern");
        Vector v = this._$12742(format);
        if (v == null || ranges == null || ranges.size() == 0) {
            return null;
        }
        StringBuffer buf = new StringBuffer(((MIBRange)ranges.get(0)).getLowerValue() != 0L ? "(" : "((");
        Iterator rit = ranges.iterator();
        block7: do {
            MIBRange range = (MIBRange)rit.next();
            int bytesUsed = 0;
            for (int i = 0; i < v.size(); ++i) {
                DisplayHint dh = (DisplayHint)v.get(i);
                String regex = "";
                switch (dh.format) {
                    case 'a': 
                    case 't': {
                        regex = "(#x00-#x7f)";
                        break;
                    }
                    case 'b': {
                        regex = "((0|1){8})";
                        break;
                    }
                    case 'd': {
                        regex = "([0-9]{3})";
                        break;
                    }
                    case 'o': {
                        regex = "([0-7]{3})";
                        break;
                    }
                    case 'x': {
                        regex = "([0-9A-Fa-f]{2})";
                    }
                }
                if ((long)bytesUsed < range.getLowerValue()) {
                    if (dh.format == 'd') {
                        buf.append("(0|[1-9](([0-9]){0,");
                        buf.append(MIBModule2XSD._$12747(0xFF ^ dh.number) - 1);
                        buf.append("}))");
                        if ((long)(bytesUsed += dh.number) >= range.getUpperValue()) continue block7;
                        if (dh.sep != null) {
                            buf.append(dh.sep);
                        }
                    } else if (rit.hasNext()) {
                        buf.append("(" + regex + "{");
                        buf.append(dh.number);
                        buf.append("})");
                        if (dh.sep != null) {
                            buf.append(dh.sep);
                        }
                        if ((long)(bytesUsed += dh.number) >= range.getUpperValue()) {
                            continue block7;
                        }
                    } else {
                        buf.append("(" + regex);
                        if (dh.sep != null) {
                            buf.append(dh.sep);
                        }
                        buf.append(dh.number);
                        buf.append("{");
                        buf.append(range.getLowerValue() - 1L);
                        buf.append(",");
                        buf.append(range.getUpperValue() - 1L);
                        buf.append("})");
                        buf.append(regex);
                        if ((long)(bytesUsed += dh.number) >= range.getUpperValue()) {
                            continue block7;
                        }
                    }
                } else if (dh.format == 'd') {
                    if ((long)dh.number < range.getUpperValue()) {
                        buf.append("(0|[1-9](([0-9]){0,");
                        buf.append(MIBModule2XSD._$12747(0xFF ^ dh.number) - 1);
                        buf.append("}))");
                        bytesUsed = (int)((long)bytesUsed + range.getLowerValue());
                        if ((long)bytesUsed >= range.getUpperValue()) continue block7;
                        if (dh.sep != null) {
                            buf.append(dh.sep);
                        }
                    } else {
                        buf.append("(0|[1-9](([0-9]){0,");
                        buf.append(MIBModule2XSD._$12747(0xFFL ^ range.getUpperValue()) - 1);
                        buf.append("}))");
                        bytesUsed = (int)((long)bytesUsed + range.getUpperValue());
                    }
                } else {
                    buf.append("(" + regex);
                    if (rit.hasNext()) {
                        if (dh.sep != null) {
                            buf.append(dh.sep);
                        }
                        if (range.getLowerValue() == 0L && range.getUpperValue() >= 65535L) {
                            buf.append(")*");
                        } else {
                            buf.append("){");
                            buf.append(range.getLowerValue());
                            buf.append(",");
                            buf.append(Math.min(range.getUpperValue(), (long)dh.number) - 1L);
                            buf.append("}");
                        }
                        bytesUsed = (int)((long)bytesUsed + range.getLowerValue());
                        if ((long)bytesUsed >= range.getUpperValue()) {
                            continue block7;
                        }
                    } else {
                        bytesUsed = (int)((long)bytesUsed + range.getLowerValue());
                        if (dh.sep != null && (long)bytesUsed < range.getUpperValue()) {
                            if (range.getLowerValue() == 0L && range.getUpperValue() >= 65535L) {
                                buf.append(dh.sep);
                                buf.append(")*");
                            } else {
                                buf.append("){");
                                buf.append(range.getLowerValue());
                                buf.append(",");
                                buf.append(range.getUpperValue() - 1L);
                                buf.append("}");
                            }
                            buf.append(regex);
                        } else {
                            if (range.getLowerValue() == 0L && range.getUpperValue() >= 65535L) {
                                buf.append(")*");
                            } else {
                                buf.append("){");
                                buf.append(range.getLowerValue());
                                buf.append(",");
                                buf.append(range.getUpperValue() - 1L);
                                buf.append("}");
                            }
                            buf.append(dh.sep);
                        }
                    }
                }
                if ((long)bytesUsed >= range.getUpperValue()) continue block7;
            }
        } while (rit.hasNext());
        pattern.setText(buf.toString());
        return pattern;
    }

    private DOMElement _$12753(long maxValue, int fraction) {
        DOMElement max = new DOMElement("xsd:maxInclusive");
        if (fraction > 0) {
            max.addAttribute("value", "" + maxValue / (long)(0xA ^ fraction) + "." + maxValue % (long)Math.abs(0xA ^ fraction));
        } else {
            max.addAttribute("value", "" + maxValue);
        }
        return max;
    }

    private Vector _$12757(Vector ranges, String baseType) {
        Vector<DOMElement> v = new Vector<DOMElement>(ranges.size() + 1);
        for (int i = 0; i < ranges.size(); ++i) {
            DOMElement simpleType = new DOMElement("xsd:simpleType");
            DOMElement restriction = new DOMElement("xsd:restriction");
            simpleType.add(restriction);
            restriction.addAttribute("base", baseType);
            MIBRange r = (MIBRange)ranges.get(i);
            restriction.add(this._$12761(r.getLowerValue(), 0));
            restriction.add(this._$12753(r.getUpperValue(), 0));
            v.add(simpleType);
        }
        return v;
    }

    private DOMElement _$12761(long minValue, int fraction) {
        DOMElement min = new DOMElement("xsd:minInclusive");
        if (fraction > 0) {
            min.addAttribute("value", "" + minValue / (long)(0xA ^ fraction) + "." + minValue % (long)Math.abs(0xA ^ fraction));
        } else {
            min.addAttribute("value", "" + minValue);
        }
        return min;
    }

    private DOMElement _$12763(MIBTextualConvention base) {
        if (base.getSyntax().hasEnums()) {
            return this._$12740(base.getSyntax().getEnumsVector());
        }
        String baseSyntax = base.getSyntax().getSyntax();
        DOMElement e = new DOMElement("xsd:restriction");
        int fraction = -1;
        if (base.hasDisplayHint()) {
            if (SMI.isString(baseSyntax)) {
                e.addAttribute("base", "xsd:string");
            } else if (base.getDisplayHint().indexOf(45) > 0) {
                e.addAttribute("base", "xsd:decimal");
                Vector v = this._$12742(base.getDisplayHint());
                if (v != null && v.size() > 0) {
                    DisplayHint dh = (DisplayHint)v.get(0);
                    DOMElement d = new DOMElement("xsd:fractionDigits");
                    d.setText("" + dh.number);
                    e.add(d);
                    fraction = dh.number;
                }
            } else {
                e.addAttribute("base", "xsd:integer");
            }
        } else {
            String impSource;
            String bs = baseSyntax;
            bs = bs.equals(SMI.SMI_SYNTAX[1]) ? "smi:OctetString" : (bs.equals(SMI.SMI_SYNTAX[2]) ? "smi:ObjectIdentifier" : (this._$12726.getImportSource(baseSyntax) != null ? ((impSource = this._$12726.getImportSource(baseSyntax)).equals("SNMPv2-SMI") || impSource.equals("RFC1155-SMI") ? "smi:" + baseSyntax : impSource + ":" + baseSyntax) : "smi:" + baseSyntax));
            e.addAttribute("base", bs);
        }
        if (SMI.isUnsignedNumeric(baseSyntax)) {
            long m = 0xFFFFFFFFL;
            if (SMI.basicSyntax(baseSyntax) == 7) {
                m = Long.MAX_VALUE;
            }
            long minValue = Math.max(base.getSyntax().getMinOfRanges(), 0L);
            long maxValue = Math.min(base.getSyntax().getMaxOfRanges(), m);
            e.add(this._$12761(minValue, fraction));
            e.add(this._$12753(maxValue, fraction));
        } else if (base.getSyntax().hasEnums()) {
            e.add(this._$12740(base.getSyntax().getEnumsVector()));
        } else if (SMI.isNumeric(baseSyntax)) {
            long m = Integer.MAX_VALUE;
            DOMElement min = new DOMElement("xsd:minInclusive");
            long minValue = Math.max(base.getSyntax().getMinOfRanges(), Integer.MIN_VALUE);
            long maxValue = Math.min(base.getSyntax().getMaxOfRanges(), m);
            e.add(this._$12761(minValue, fraction));
            e.add(this._$12753(maxValue, fraction));
        } else if (SMI.isString(baseSyntax) && !base.hasDisplayHint()) {
            int minLength = 0;
            int maxLength = 65535;
            long minValue = Math.max(base.getSyntax().getMinOfRanges(), (long)minLength);
            long maxValue = Math.min(base.getSyntax().getMaxOfRanges(), (long)maxLength);
            e.add(this._$12761(minValue, fraction));
            e.add(this._$12753(maxValue, fraction));
        } else if (SMI.isString(baseSyntax) && base.hasDisplayHint()) {
            DOMElement pattern;
            Vector<MIBRange> ranges = base.getSyntax().getRangesVector();
            if (base.getSyntax().hasRanges()) {
                ranges = new Vector(1);
                ranges.add(new MIBRange(0L, 65535L));
            }
            if ((pattern = this._$12749(base.getDisplayHint(), ranges)) != null) {
                e.add(pattern);
            } else {
                e.addComment("Repeat in DISPLAY-HINT is not supported");
            }
        } else if (SMI.smiSyntax(baseSyntax) == 3) {
            // empty if block
        }
        return e;
    }

    private DOMElement _$3952(MIBTextualConvention tc) {
        DOMElement typedef = new DOMElement("xsd:simpleType");
        String m = this._$3923.getModuleName(tc.getModuleID());
        MIBTextualConvention baseSyntax = this._$3923.getEffectiveSyntax(tc.getSyntax());
        String base = baseSyntax.getSyntax().getSyntax();
        if (tc.getName() != null) {
            typedef.addAttribute("name", tc.getName());
        }
        if (tc.hasDescription() || tc.hasDisplayHint()) {
            DOMElement annotation = new DOMElement("xsd:annotation");
            if (tc.hasDescription()) {
                annotation.add(this._$3936(tc.getDescription()));
            }
            if (tc.hasDisplayHint()) {
                DOMElement appinfo = new DOMElement("xsd:appinfo");
                appinfo.add(this._$12769(MIBObject.getUnquotedString(tc.getDisplayHint())));
                annotation.add(appinfo);
            }
            typedef.add(annotation);
        }
        if (baseSyntax.getSyntax().hasRanges() && SMI.isNumeric(base)) {
            DOMElement union = new DOMElement("xsd:union");
            String type = "xsd:int";
            if (SMI.isUnsignedNumeric(base)) {
                type = "xsd:unsignedInt";
            }
            Vector ranges = this._$12757(baseSyntax.getSyntax().getRangesVector(), type);
            for (int i = 0; i < ranges.size(); ++i) {
                union.add((DOMElement)ranges.get(i));
            }
            typedef.add(union);
        } else {
            typedef.add(this._$12763(baseSyntax));
        }
        return typedef;
    }

    private Vector _$3996(Vector tcs) {
        tcs = new Vector<DOMElement>(tcs);
        for (int i = 0; i < tcs.size(); ++i) {
            tcs.setElementAt(this._$3952((MIBTextualConvention)tcs.elementAt(i)), i);
        }
        return tcs;
    }

    private Vector _$4002(Vector i) {
        Vector<DOMElement> v = new Vector<DOMElement>();
        DOMElement schema = new DOMElement("xsd:import");
        schema.addAttribute("namespace", "http://www.w3.org/2001/XMLSchema");
        schema.addAttribute("schemaLocation", "http://www.w3.org/2001/XMLSchema.xsd");
        v.add(schema);
        DOMElement smi = new DOMElement("xsd:import");
        smi.addAttribute("namespace", this._$12728 + "smi");
        smi.addAttribute("schemaLocation", this._$12728 + "smi.xsd");
        v.add(smi);
        if (i != null) {
            Enumeration en = i.elements();
            while (en.hasMoreElements()) {
                MIBImport ii = (MIBImport)en.nextElement();
                DOMElement imp = new DOMElement("xsd:import");
                imp.addAttribute("namespace", this._$12728 + ii.getSource());
                imp.addAttribute("schemaLocation", this._$12728 + ii.getSource() + ".xsd");
                v.addElement(imp);
            }
        }
        return v;
    }

    private DOMElement _$12771(MIBIndexPart index) {
        DOMElement attr = new DOMElement("xsd:attribute");
        return attr;
    }

    private String _$12773(MIBObjectType ot) {
        String s = ot.getSyntax().getSyntax();
        if (ot.getSyntax().getType() == 3) {
            String m = this._$12726.getImportSource(s);
            if (m != null) {
                return m + ":" + s;
            }
            return s;
        }
        if (s.equals(SMI.SMI_SYNTAX[1])) {
            return "smi:OctetString";
        }
        if (s.equals(SMI.SMI_SYNTAX[12])) {
            return "smi:Bits";
        }
        if (s.equals(SMI.SMI_SYNTAX[2])) {
            return "smi:ObjectIdentifier";
        }
        return "smi:" + s;
    }

    private Vector _$12774(MIBObjectType ot) {
        Vector<? extends MIBObjectType> indexCols = this._$3923.getColumnarObjectsOfTable(ot, true, false);
        if (indexCols == null) {
            return new Vector();
        }
        Vector<DOMElement> v = new Vector<DOMElement>(indexCols.size() + 1);
        for (int i = 0; i < indexCols.size(); ++i) {
            DOMElement appinfo;
            DOMElement annotation;
            MIBObjectType ip = indexCols.get(i);
            DOMElement attr = new DOMElement("xsd:attribute");
            attr.addAttribute("name", ip.getName());
            attr.addAttribute("type", this._$12773(ip));
            if (ot.getIndexPart().isAugment()) {
                annotation = new DOMElement("xsd:annotation");
                appinfo = new DOMElement("xsd:appinfo");
                annotation.add(appinfo);
                DOMElement augments = new DOMElement("augments");
                appinfo.add(augments);
                String m = this._$12726.getImportSource(ot.getIndexPart().getIndexPart()[0]);
                m = m != null ? m + ":" + ot.getIndexPart().getIndexPart()[0] : ot.getIndexPart().getIndexPart()[0];
                augments.setText(m);
                attr.add(annotation);
            } else if (ot.getIndexPart().isImplied() && i + 1 == indexCols.size()) {
                annotation = new DOMElement("xsd:annotation");
                appinfo = new DOMElement("xsd:appinfo");
                annotation.add(appinfo);
                DOMElement implied = new DOMElement("impliedLength");
                appinfo.add(implied);
                attr.add(annotation);
            }
            v.add(attr);
        }
        return v;
    }

    private DOMElement _$12777(MIBObjectType table, Vector cols) {
        int i;
        DOMElement complexEntry = new DOMElement("xsd:complexType");
        complexEntry.addAttribute("name", table.getName() + "Type");
        if (cols.size() > 0) {
            DOMElement sequence = new DOMElement("xsd:sequence");
            for (i = 0; i < cols.size(); ++i) {
                DOMElement e = this._$12780((MIBObjectType)cols.get(i));
                if (e == null) continue;
                sequence.add(e);
            }
            complexEntry.add(sequence);
        }
        Vector index = this._$12774(table);
        for (i = 0; i < index.size(); ++i) {
            complexEntry.add((DOMElement)index.get(i));
        }
        return complexEntry;
    }

    /*
     * Unable to fully structure code
     */
    private DOMElement _$12780(MIBObject object) {
        switch (object.getType()) {
            case 1: {
                element = new DOMElement("xsd:element");
                element.addAttribute("name", object.getName());
                ot = (MIBObjectType)object;
                if (!SMI.isAccessible(ot.getAccess())) ** GOTO lbl29
                v0 = scalar = this._$3923.hasDescendants(ot) == false;
                if (ot.isColumnarObject() || scalar) {
                    if (ot.getSyntax().getType() == 4) {
                        element.addAttribute("type", this._$12773(ot));
                        element.addAttribute("minOccurs", "0");
                        element.add(this._$12737(ot));
                    } else {
                        element.addAttribute("minOccurs", "0");
                        base = this._$3923.getEffectiveSyntax(ot.getSyntax());
                        if (base.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                            element.addAttribute("type", ot.getName() + "Type");
                            element.add(this._$12737(ot));
                        } else {
                            element.add(this._$12737(ot));
                            element.add(this._$3952(base));
                        }
                    }
                    return element;
                }
                ** GOTO lbl41
lbl29:
                // 1 sources

                if (ot.isTable()) {
                    element.addAttribute("type", ot.getName() + "Type");
                    element.addAttribute("minOccurs", "0");
                    element.addAttribute("maxOccurs", "unbounded");
                    element.add(this._$12737(ot));
                    columns = this._$3923.getColumnarObjectsOfTable(ot, false, true);
                    this._$12727.add(this._$12777(ot, columns));
                    return element;
                }
            }
lbl41:
            // 4 sources

            case 0: 
            case 5: 
            case 10: {
                element = new DOMElement("xsd:element");
                element.addAttribute("name", object.getName());
                element.addAttribute("minOccurs", "0");
                complexType = new DOMElement("xsd:complexType");
                sequence = new DOMElement("xsd:sequence");
                complexType.add(sequence);
                element.add(complexType);
                children = this._$3923.getChildren(object);
                hasInstances = false;
                for (i = 0; i < children.size(); ++i) {
                    o = children.get(i);
                    if (!(o instanceof MIBObjectType)) continue;
                    ot = (MIBObjectType)o;
                    v1 = scalar = this._$3923.hasDescendants(ot) == false;
                    if (!ot.isColumnarObject() && !scalar) continue;
                    hasInstances = true;
                    e = this._$12780(ot);
                    if (e == null) continue;
                    sequence.add(e);
                }
                if (!hasInstances) break;
                return element;
            }
        }
        return null;
    }

    private String _$3984(String objectName) {
        String module = "";
        try {
            String m;
            MIBObject obj = this._$3923.getObject(objectName);
            if (obj != null && (m = this._$3923.getModuleName(obj.getModuleID())) != null) {
                module = m;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return module;
    }

    private Vector _$4046() {
        Vector<DOMElement> v = new Vector<DOMElement>();
        Enumeration it = this._$12726.objectsByOid().elements();
        while (it.hasMoreElements()) {
            DOMElement e;
            MIBObject o = (MIBObject)it.nextElement();
            if ((!(o instanceof MIBObjectType) || ((MIBObjectType)o).isColumnarObject()) && o.getType() != 0 && o.getType() != 10 && !(o instanceof MIBModule) || (e = this._$12780(o)) == null) continue;
            v.add(e);
        }
        return v;
    }

    private Vector _$3934(MIBModule m) {
        Vector<DOMElement> v = new Vector<DOMElement>();
        if (m.hasDescription()) {
            DOMElement annotation = new DOMElement("xsd:annotation");
            DOMElement appinfo = new DOMElement("xsd:appinfo");
            annotation.add(appinfo);
            appinfo.add(this._$3936(m.getDescription()));
            v.add(annotation);
        }
        Vector imports = this._$4002(m.getImportsVector());
        for (int i = 0; i < imports.size(); ++i) {
            v.add((DOMElement)imports.get(i));
        }
        DOMElement module = new DOMElement("xsd:element");
        module.addAttribute("name", "snmp-data");
        DOMElement complexType0 = new DOMElement("xsd:complexType");
        DOMElement sequence0 = new DOMElement("xsd:sequence");
        complexType0.add(sequence0);
        DOMElement element = new DOMElement("xsd:element");
        sequence0.add(element);
        element.addAttribute("name", "context");
        element.addAttribute("minOccurs", "0");
        element.addAttribute("maxOccurs", "unbounded");
        DOMElement complexType = new DOMElement("xsd:complexType");
        DOMElement sequence = new DOMElement("xsd:sequence");
        complexType.add(sequence);
        element.add(complexType);
        Vector nodes = this._$4046();
        for (int i = 0; i < nodes.size(); ++i) {
            DOMElement e = (DOMElement)nodes.get(i);
            if (e == null) continue;
            sequence.add(e);
        }
        DOMElement a1 = new DOMElement("xsd:attribute");
        a1.addAttribute("name", "agent");
        a1.addAttribute("type", "xsd:NMTOKEN");
        a1.addAttribute("use", "required");
        DOMElement a2 = new DOMElement("xsd:attribute");
        a2.addAttribute("name", "port");
        a2.addAttribute("type", "xsd:integer");
        a2.addAttribute("use", "required");
        complexType.add(a1);
        complexType.add(a2);
        module.add(complexType0);
        v.add(module);
        return v;
    }

    private DOMElement _$12769(String displayHint) {
        DOMElement e = new DOMElement("displayHint");
        e.setText(displayHint);
        return e;
    }

    private String _$4019(String access) {
        switch (SMI.accessType(access)) {
            case 5: {
                return "notify";
            }
            case 0: {
                return "not-accessible";
            }
            case 6: {
                return "not-implemented";
            }
            case 2: 
            case 3: {
                return "read-write";
            }
            case 1: {
                return "read-only";
            }
            case 4: {
                return "write-only";
            }
        }
        return "unknown";
    }

    class DisplayHint {
        public int number = 0;
        public char format = (char)100;
        public Character sep = null;
        public Character repeater = null;

        DisplayHint() {
        }
    }
}

