/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.xml;

import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.smiparser.SMI;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.dom.DOMCDATA;
import org.dom4j.dom.DOMComment;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentType;
import org.dom4j.dom.DOMElement;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class MIBModule2XML {
    public static final String ISO_DATE_FORMAT = "yyyy-MM-dd HH:mm";
    private MIBRepository _$3923;
    private static SimpleDateFormat _$3924 = new SimpleDateFormat("yyyy-MM-dd HH:mm");

    public MIBModule2XML(MIBRepository rep) {
        this._$3923 = rep;
    }

    public DOMDocument createXML(MIBModule m, String header, String dtdURL) {
        DOMElement root = new DOMElement("smi");
        DOMDocument doc = new DOMDocument(root);
        DOMDocumentType docType = new DOMDocumentType("smi", dtdURL);
        doc.setDocType(docType);
        doc.add(new DOMComment(header));
        try {
            List l = this._$3934(m);
            Iterator it = l.iterator();
            while (it.hasNext()) {
                root.add((DOMElement)it.next());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return doc;
    }

    private DOMElement _$3936(String descr) {
        DOMElement description = new DOMElement("description");
        description.add(new DOMCDATA(MIBObject.getUnquotedString(descr)));
        return description;
    }

    private DOMElement _$3940(String ref) {
        DOMElement reference = new DOMElement("reference");
        reference.add(new DOMCDATA(MIBObject.getUnquotedString(ref)));
        return reference;
    }

    private DOMElement _$3943(MIBRevision r) {
        DOMElement revision = new DOMElement("revision");
        Date d = MIBModule.getDateFromUTC(MIBObject.getUnquotedString(r.getRevision()));
        revision.addAttribute("date", _$3924.format(d));
        revision.add(this._$3936(r.getDescription()));
        return revision;
    }

    private DOMElement _$3952(MIBTextualConvention tc) {
        Enumeration<Serializable> en;
        DOMElement typedef = new DOMElement("typedef");
        String m = this._$3923.getModuleName(tc.getModuleID());
        if (m != null) {
            typedef.addAttribute("parent", m);
        }
        if (tc.getName() != null) {
            typedef.addAttribute("name", tc.getName());
        }
        typedef.addAttribute("basetype", tc.getSyntax().getSyntax());
        if (tc.hasStatus()) {
            typedef.addAttribute("status", tc.getStatus());
        }
        if (tc.getSyntax().hasRanges()) {
            en = tc.getSyntax().getRangesVector().elements();
            while (en.hasMoreElements()) {
                MIBRange r = en.nextElement();
                DOMElement range = new DOMElement("range");
                range.addAttribute("min", r.getLower().toString());
                range.addAttribute("max", r.getUpper().toString());
                typedef.add(range);
            }
        }
        if (tc.getSyntax().hasEnums()) {
            en = tc.getSyntax().getEnumsVector().elements();
            while (en.hasMoreElements()) {
                MIBEnum e = (MIBEnum)en.nextElement();
                DOMElement enumeration = new DOMElement("namednumber");
                enumeration.addAttribute("name", e.getLabel());
                enumeration.addAttribute("number", e.getValue());
                typedef.add(enumeration);
            }
        }
        if (tc.hasDisplayHint()) {
            DOMElement format = new DOMElement("format");
            format.setText(MIBObject.getUnquotedString(tc.getDisplayHint()));
            typedef.add(format);
        }
        if (tc.hasDescription()) {
            typedef.add(this._$3936(tc.getDescription()));
        }
        if (tc.hasReference()) {
            typedef.add(this._$3940(tc.getReference()));
        }
        return typedef;
    }

    private DOMElement _$3980(MIBSyntax s) {
        DOMElement syntax = new DOMElement("syntax");
        if (!s.hasEnums() && !s.hasRanges()) {
            DOMElement type = new DOMElement("type");
            type.addAttribute("name", s.getSyntax());
            type.addAttribute("module", this._$3984(s.getSyntax()));
            syntax.add(type);
        } else {
            Enumeration<Serializable> en;
            DOMElement typedef = new DOMElement("typedef");
            typedef.addAttribute("basetype", s.getSyntax());
            if (s.hasRanges()) {
                en = s.getRangesVector().elements();
                while (en.hasMoreElements()) {
                    MIBRange r = (MIBRange)en.nextElement();
                    DOMElement range = new DOMElement("range");
                    range.addAttribute("min", r.getLower().toString());
                    range.addAttribute("max", r.getUpper().toString());
                    typedef.add(range);
                }
            }
            if (s.hasEnums()) {
                en = s.getEnumsVector().elements();
                while (en.hasMoreElements()) {
                    MIBEnum e = (MIBEnum)en.nextElement();
                    DOMElement enumeration = new DOMElement("namednumber");
                    enumeration.addAttribute("name", e.getLabel());
                    enumeration.addAttribute("number", e.getValue());
                    typedef.add(enumeration);
                }
            }
            syntax.add(typedef);
        }
        return syntax;
    }

    public void output(OutputStream os, Document doc, int indent) {
        try {
            OutputFormat outputFormat = new OutputFormat();
            outputFormat.setIndent(true);
            outputFormat.setIndentSize(indent);
            outputFormat.setNewlines(true);
            XMLWriter xmlWriter = new XMLWriter(os, outputFormat);
            xmlWriter.write(doc);
            xmlWriter.flush();
            xmlWriter.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private DOMElement _$3996(Vector tcs) {
        DOMElement typedefs = new DOMElement("typedefs");
        tcs = new Vector(tcs);
        for (int i = 0; i < tcs.size(); ++i) {
            typedefs.add(this._$3952((MIBTextualConvention)tcs.elementAt(i)));
        }
        return typedefs;
    }

    private DOMElement _$4002(Vector i) {
        DOMElement imports = new DOMElement("imports");
        Enumeration en = i.elements();
        while (en.hasMoreElements()) {
            MIBImport ii = (MIBImport)en.nextElement();
            for (int j = 0; j < ii.getImports().length; ++j) {
                DOMElement imp = new DOMElement("import");
                imp.addAttribute("module", ii.getSource());
                imp.addAttribute("name", (String)ii.getImportsVector().elementAt(j));
                imports.add(imp);
            }
        }
        return imports;
    }

    private DOMElement _$4010(MIBObjectType ot, String t) {
        DOMElement scalar = new DOMElement(t);
        scalar.addAttribute("name", ot.getName());
        scalar.addAttribute("oid", ot.getPrintableOid());
        scalar.addAttribute("status", ot.getStatus());
        MIBTextualConvention tc = null;
        if (ot.getSyntax().getType() == 3 || ot.getSyntax().hasEnums() || ot.getSyntax().hasRanges()) {
            tc = this._$3923.getEffectiveSyntax(ot.getSyntax());
        }
        scalar.add(this._$3980(ot.getSyntax()));
        DOMElement access = new DOMElement("access");
        access.setText(this._$4019(ot.getAccess()));
        scalar.add(access);
        if (ot.hasDefaultValue()) {
            DOMElement defaultValue = new DOMElement("default");
            defaultValue.add(new DOMCDATA(ot.getDefaultValue()));
            scalar.add(defaultValue);
        }
        if (tc != null && tc.hasDisplayHint()) {
            DOMElement format = new DOMElement("format");
            format.add(new DOMCDATA(MIBObject.getUnquotedString(tc.getDisplayHint())));
            scalar.add(format);
        }
        if (ot.hasUnits()) {
            DOMElement units = new DOMElement("units");
            units.add(new DOMCDATA(MIBObject.getUnquotedString(ot.getUnits())));
            scalar.add(units);
        }
        scalar.add(this._$3936(ot.getDescription()));
        if (ot.hasReference()) {
            scalar.add(this._$3940(ot.getReference()));
        }
        return scalar;
    }

    private DOMElement _$4027(MIBIndexPart index, MIBObjectType ot) {
        DOMElement linkage = new DOMElement("linkage");
        linkage.addAttribute("implied", "" + index.isImplied());
        if (index.isAugment()) {
            DOMElement augments = new DOMElement("augments");
            MIBObject o = this._$3923.getObject(index.getIndexPart()[0]);
            if (o != null) {
                String m = this._$3923.getModuleName(o.getModuleID());
                if (m != null) {
                    augments.addAttribute("module", m);
                } else {
                    augments.addAttribute("module", "");
                }
            } else {
                augments.addAttribute("module", "");
            }
            augments.addAttribute("name", index.getIndexPart()[0]);
            linkage.add(augments);
        } else {
            Vector<? extends MIBObjectType> v = this._$3923.getColumnarObjectsOfTable(ot, true, false);
            for (int i = 0; i < v.size(); ++i) {
                DOMElement ind = new DOMElement("index");
                MIBObjectType o = v.elementAt(i);
                String m = this._$3923.getModuleName(o.getModuleID());
                if (m != null) {
                    ind.addAttribute("module", m);
                } else {
                    ind.addAttribute("module", "");
                }
                ind.addAttribute("name", o.getName());
                linkage.add(ind);
            }
        }
        return linkage;
    }

    private DOMElement _$4039(MIBObjectType ot) {
        DOMElement row = new DOMElement("row");
        row.addAttribute("name", ot.getName());
        row.addAttribute("oid", ot.getPrintableOid());
        row.addAttribute("status", ot.getStatus());
        row.add(this._$4027(ot.getIndexPart(), ot));
        row.add(this._$3936(ot.getDescription()));
        if (ot.hasReference()) {
            row.add(this._$3940(ot.getReference()));
        }
        Vector<? extends MIBObjectType> cols = this._$3923.getColumnarObjectsOfTable(ot, false, true);
        boolean rowCreation = false;
        Enumeration<? extends MIBObjectType> en = cols.elements();
        while (en.hasMoreElements()) {
            MIBObjectType c = en.nextElement();
            row.add(this._$4010(c, "column"));
            if (SMI.accessType(c.getAccess()) != 3) continue;
            rowCreation = true;
        }
        if (rowCreation) {
            row.addAttribute("create", "true");
        } else {
            row.addAttribute("create", "false");
        }
        return row;
    }

    private DOMElement _$4046(Enumeration en) {
        DOMElement nodes = new DOMElement("nodes");
        while (en.hasMoreElements()) {
            MIBObject o = (MIBObject)en.nextElement();
            if (!o.getClass().equals(MIBObject.class) && !(o instanceof MIBObjectType) && !(o instanceof MIBModule)) continue;
            if (o instanceof MIBObjectType) {
                MIBObjectType ot = (MIBObjectType)o;
                MIBObjectType row = this._$3923.getTableEntry(o);
                if (row != null) {
                    DOMElement table = new DOMElement("table");
                    table.addAttribute("name", ot.getName());
                    table.addAttribute("oid", ot.getPrintableOid());
                    table.addAttribute("status", ot.getStatus());
                    table.add(this._$3936(ot.getDescription()));
                    if (ot.hasReference()) {
                        table.add(this._$3940(ot.getReference()));
                    }
                    table.add(this._$4039(row));
                    nodes.add(table);
                    continue;
                }
                if (ot.isTable() || ot.isColumnarObject()) continue;
                nodes.add(this._$4010(ot, "scalar"));
                continue;
            }
            DOMElement node = new DOMElement("node");
            node.addAttribute("name", o.getName());
            node.addAttribute("oid", o.getPrintableOid());
            if (o.hasDescription()) {
                node.add(this._$3936(o.getDescription()));
            }
            if (o.hasReference()) {
                node.add(this._$3940(o.getReference()));
            }
            if (o.hasStatus()) {
                node.addAttribute("status", o.getStatus());
            }
            nodes.add(node);
        }
        return nodes;
    }

    private String _$3984(String objectName) {
        String module = "";
        try {
            String m;
            MIBObject obj = this._$3923.getObject(objectName);
            if (obj != null && (m = this._$3923.getModuleName(obj.getModuleID())) != null) {
                module = m;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return module;
    }

    private DOMElement _$4056(Enumeration en) {
        DOMElement groups = new DOMElement("groups");
        while (en.hasMoreElements()) {
            MIBObject o = (MIBObject)en.nextElement();
            if (!(o instanceof MIBGroup)) continue;
            MIBGroup g = (MIBGroup)o;
            DOMElement group = new DOMElement("group");
            group.addAttribute("name", o.getName());
            group.addAttribute("oid", o.getPrintableOid());
            group.addAttribute("status", o.getStatus());
            DOMElement members = new DOMElement("members");
            Enumeration gen = g.getObjectsVector().elements();
            while (gen.hasMoreElements()) {
                String name = (String)gen.nextElement();
                DOMElement member = new DOMElement("member");
                member.addAttribute("module", this._$3984(name));
                member.addAttribute("name", name);
                members.add(member);
            }
            group.add(members);
            group.add(this._$3936(o.getDescription()));
            if (o.hasReference()) {
                group.add(this._$3940(o.getReference()));
            }
            groups.add(group);
        }
        return groups;
    }

    private DOMElement _$4064(MIBException variation) {
        DOMElement refinement = new DOMElement("refinement");
        refinement.addAttribute("module", this._$3984(variation.getVariation()));
        refinement.addAttribute("name", variation.getVariation());
        if (variation.hasSyntax()) {
            refinement.add(this._$3980(variation.getSyntax()));
        }
        if (variation.hasAccess()) {
            DOMElement access = new DOMElement("access");
            access.setText(this._$4019(variation.getAccess()));
            refinement.add(access);
        }
        refinement.add(this._$3936(variation.getDescription()));
        return refinement;
    }

    private DOMElement _$4070(Enumeration en) {
        DOMElement compliances = new DOMElement("compliances");
        while (en.hasMoreElements()) {
            MIBObject o = (MIBObject)en.nextElement();
            if (!(o instanceof MIBCompliance)) continue;
            MIBCompliance c = (MIBCompliance)o;
            DOMElement comp = new DOMElement("compliance");
            comp.addAttribute("name", o.getName());
            comp.addAttribute("oid", o.getPrintableOid());
            if (o.hasStatus()) {
                comp.addAttribute("status", o.getStatus());
            }
            comp.add(this._$3936(o.getDescription()));
            DOMElement requires = new DOMElement("requires");
            DOMElement refinements = new DOMElement("refinements");
            boolean refined = false;
            Enumeration<MIBComplianceModule> gen = c.getModules().elements();
            while (gen.hasMoreElements()) {
                MIBComplianceModule cm = gen.nextElement();
                if (cm.hasMandatory()) {
                    String[] mand = cm.getMandatory();
                    for (int i = 0; i < mand.length; ++i) {
                        DOMElement mandatory = new DOMElement("mandatory");
                        if (cm.getModuleName() == null || cm.getModuleName().trim().length() == 0) {
                            mandatory.addAttribute("module", this._$3984(mand[i]));
                        } else {
                            mandatory.addAttribute("module", cm.getModuleName());
                        }
                        mandatory.addAttribute("name", mand[i]);
                        requires.add(mandatory);
                    }
                }
                if (!cm.hasVariations()) continue;
                Enumeration ven = cm.getVariationsVector().elements();
                while (ven.hasMoreElements()) {
                    MIBVariation vv = (MIBVariation)ven.nextElement();
                    if (vv instanceof MIBException) {
                        refinements.add(this._$4064((MIBException)vv));
                        refined = true;
                        continue;
                    }
                    if (!(vv instanceof MIBCondGroup)) continue;
                    MIBCondGroup cg = (MIBCondGroup)vv;
                    DOMElement cond = new DOMElement("option");
                    if (cm.getModuleName() == null || cm.getModuleName().trim().length() == 0) {
                        cond.addAttribute("module", this._$3984(cg.getVariation()));
                    } else {
                        cond.addAttribute("module", cm.getModuleName());
                    }
                    cond.addAttribute("name", cg.getVariation());
                    cond.add(this._$3936(cg.getDescription()));
                    requires.add(cond);
                }
            }
            comp.add(requires);
            if (refined) {
                comp.add(refinements);
            }
            if (o.hasReference()) {
                comp.add(this._$3940(o.getReference()));
            }
            compliances.add(comp);
        }
        return compliances;
    }

    private List _$3934(MIBModule m) {
        Vector<MIBTextualConvention> tcs;
        Vector<DOMElement> v = new Vector<DOMElement>(1);
        DOMElement module = new DOMElement("module");
        module.addAttribute("name", m.getModuleName());
        module.addAttribute("language", "SMIv" + m.getSMIVersion());
        if (m.getSMIVersion() > 1) {
            DOMElement organization = new DOMElement("organization");
            organization.add(new DOMCDATA(MIBObject.getUnquotedString(m.getOrganization())));
            module.add(organization);
            DOMElement contact = new DOMElement("contact");
            contact.add(new DOMCDATA(MIBObject.getUnquotedString(m.getContactInfo())));
            module.add(contact);
            module.add(this._$3936(m.getDescription()));
            if (m.hasReference()) {
                module.add(this._$3940(m.getReference()));
            }
            if (m.hasRevisions()) {
                Enumeration en = m.getRevisionsVector().elements();
                while (en.hasMoreElements()) {
                    module.add(this._$3943((MIBRevision)en.nextElement()));
                }
            }
            DOMElement identity = new DOMElement("identity");
            identity.addAttribute("node", m.getName());
            module.add(identity);
        }
        v.add(module);
        if (m.hasImports()) {
            v.add(this._$4002(m.getImportsVector()));
        }
        if ((tcs = m.getTextualConventions()).size() > 0) {
            v.add(this._$3996(tcs));
        }
        v.add(this._$4046(m.objectsByOid().elements()));
        v.add(this._$4056(m.objectsByOid().elements()));
        v.add(this._$4070(m.objectsByOid().elements()));
        return v;
    }

    private String _$4019(String access) {
        switch (SMI.accessType(access)) {
            case 5: {
                return "notifyonly";
            }
            case 0: {
                return "noaccess";
            }
            case 6: {
                return "notimplemented";
            }
            case 2: 
            case 3: {
                return "readwrite";
            }
            case 1: {
                return "readonly";
            }
            case 4: {
                return "writeonly";
            }
        }
        return "unknown";
    }
}

