/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pib;

import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.ObjectID;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PIBObjectType
extends MIBObjectType {
    public static final long serialVersionUID = 1000L;
    private String pibReferences;
    private String tag;
    private List<String> uniqueObjects;
    private List<MIBEnum> installErrors;
    private MIBIndexPart mibIndexPart;

    public PIBObjectType() {
    }

    public PIBObjectType(ObjectID oid, String name, Integer moduleID) {
        super(oid, name, moduleID);
    }

    public PIBObjectType(PIBObjectType pibObjectType) {
        super(pibObjectType);
        this.pibReferences = pibObjectType.pibReferences;
        this.tag = pibObjectType.tag;
        this.uniqueObjects = pibObjectType.uniqueObjects == null ? null : new ArrayList<String>(pibObjectType.uniqueObjects);
        this.installErrors = pibObjectType.installErrors == null ? null : new ArrayList<MIBEnum>(pibObjectType.installErrors);
        this.mibIndexPart = pibObjectType.mibIndexPart == null ? null : new MIBIndexPart(pibObjectType.mibIndexPart);
    }

    public List<String> getUniqueObjects() {
        return this.uniqueObjects;
    }

    @Override
    public MIBObject getClone() {
        return new PIBObjectType(this);
    }

    public String getTag() {
        return this.tag;
    }

    public String getPibReferences() {
        return this.pibReferences;
    }

    public void setInstallErrors(List<MIBEnum> installErrors) {
        this.installErrors = installErrors;
    }

    public void setUniqueObjects(List<String> uniqueObjects) {
        this.uniqueObjects = uniqueObjects;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setPibReferences(String pibReferences) {
        this.pibReferences = pibReferences;
    }

    public void setMibIndexPart(MIBIndexPart mibIndex) {
        this.mibIndexPart = mibIndex;
    }

    public List<MIBEnum> getInstallErrors() {
        return this.installErrors;
    }

    public MIBIndexPart getMibIndexPart() {
        return this.mibIndexPart;
    }

    @Override
    protected void toSMIIndexPart(int mode, String lineSeparator, MIBObjectType c, StringBuffer buf) {
        super.toSMIIndexPart(mode, lineSeparator, c, buf);
        if (this.mibIndexPart != null && this.mibIndexPart.getIndexPartVector() != null && this.mibIndexPart.getIndexPartVector().size() > 0) {
            buf.append('\t');
            String cs = null;
            if (c instanceof PIBObjectType) {
                PIBObjectType co = (PIBObjectType)c;
                cs = c.hasIndexPart() ? co.mibIndexPart.toSMI(mode, lineSeparator) : "";
            }
            MIBObject.addString(mode, buf, this.mibIndexPart.toSMI(mode, lineSeparator), cs);
        }
        if (this.uniqueObjects != null) {
            buf.append('\t');
            MIBObject.addKeyWord(mode, buf, "UNIQUENESS ");
            buf.append("{");
            if (this.uniqueObjects.size() > 0) {
                buf.append(lineSeparator);
                buf.append(MIBObject.formatObjectRefs(mode, "\t\t", this.uniqueObjects.iterator(), lineSeparator));
            }
            buf.append(" }");
            buf.append(lineSeparator);
        }
    }

    @Override
    protected void toSmiAccess(int mode, int smiversion, String lineSeparator, MIBObjectType oc, StringBuffer buf) {
        if (smiversion >= 1) {
            super.toSmiAccess(mode, smiversion, lineSeparator, oc, buf);
        } else {
            PIBObjectType c = (PIBObjectType)oc;
            if (this.access != null) {
                buf.append('\t');
                PIBObjectType.addKeyWord(mode, buf, "PIB-ACCESS ");
                PIBObjectType.addString(mode, buf, this.access, c == null ? null : c.getAccess());
                buf.append(lineSeparator);
            }
            if (this.getPibReferences() != null) {
                buf.append('\t');
                PIBObjectType.addKeyWord(mode, buf, "PIB-REFERENCES ");
                buf.append("{ ");
                PIBObjectType.addString(mode, buf, this.getPibReferences(), c == null ? null : c.getPibReferences());
                buf.append(" }" + lineSeparator);
            }
            if (this.getTag() != null) {
                buf.append('\t');
                PIBObjectType.addKeyWord(mode, buf, "PIB-TAG ");
                buf.append("{ ");
                PIBObjectType.addString(mode, buf, this.getTag(), c == null ? null : c.getTag());
                buf.append(" }" + lineSeparator);
            }
        }
    }

    @Override
    protected String getSMIBeforeReference(int mode, String lineSeparator, MIBObject c) {
        PIBObjectType co = null;
        if (c instanceof PIBObjectType) {
            co = (PIBObjectType)c;
        }
        StringBuffer buf = new StringBuffer();
        if (this.installErrors != null && this.installErrors.size() > 0) {
            buf.append('\t');
            PIBObjectType.addKeyWord(mode, buf, "INSTALL-ERRORS { ");
            Iterator<MIBEnum> cit = Collections.emptyList().iterator();
            if (co != null && co.getInstallErrors() != null) {
                cit = co.getInstallErrors().iterator();
            }
            MIBSyntax.toSMIEnums(mode, lineSeparator, buf, cit, this.getInstallErrors());
            buf.append("}" + lineSeparator);
        }
        return buf.toString();
    }
}

