/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib.pdf;

import com.agentpp.common.font.FontStyle;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBIndexPart;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectOrderComparator;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBRevision;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.MIBVariation;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.mib.pib.PIBComplianceObject;
import com.agentpp.mib.pib.PIBIndexPart;
import com.agentpp.mib.pib.PIBModule;
import com.agentpp.mib.pib.PIBObjectType;
import com.agentpp.smi.IEnum;
import com.agentpp.smiparser.SMI;
import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfPageEventHelper;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBModule2PDF {
    private static final String _$27939 = "Comments";
    private static final String _$27940 = "Keywords";
    private static final String _$27941 = "Identifier";
    private static final String _$27942 = "Values";
    private static final String _$27943 = "Types";
    private static final String _$27944 = "Clauses";
    private static final String _$27945 = "Text";
    private static final int _$27946 = 160;
    private static final int _$27947 = 160;
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    private static final SimpleDateFormat _$27949 = new SimpleDateFormat("yyyy-MM-dd");
    private MIBRepository _$12421;
    private Vector _$19148;
    private int _$15049 = 8;
    private int _$27950 = 2;
    private int _$6737 = 160;
    private float _$27951 = 11.0f;
    private float _$27952 = 10.0f;
    private String _$15473 = "";
    private Rectangle _$24908;
    private Date _$27953;
    private Font _$25023 = FontFactory.getFont("Courier", this._$27952, 0);
    private Hashtable _$27956 = new Hashtable();
    private boolean _$27957;
    private boolean _$27958;
    private boolean _$27959 = true;
    private boolean _$27960 = true;
    private Vector _$27961 = new Vector();
    private int _$27962 = 0;
    private boolean _$27963;

    public MIBModule2PDF(MIBRepository rep, Vector fontStyles, int tabSize) {
        this._$12421 = rep;
        this._$19148 = fontStyles;
        this._$15049 = tabSize;
        this._$27964(fontStyles);
    }

    public void setFontSize(float fontSize) {
        this._$25023.setSize(fontSize);
    }

    private void _$27964(Vector fontStyles) {
        for (int i = 0; i < fontStyles.size(); ++i) {
            FontStyle style = (FontStyle)fontStyles.elementAt(i);
            int s = 0;
            if (style.isBold() && style.isItalic()) {
                s = 3;
            } else if (style.isBold()) {
                s = 1;
            } else if (style.isItalic()) {
                s = 2;
            }
            Font f = FontFactory.getFont(this._$25023.getFamilyname(), this._$25023.getSize(), s, style.getColor());
            this._$27956.put(style.getName(), f);
        }
    }

    private String _$26478(int num) {
        StringBuffer buf = new StringBuffer(num);
        for (int i = 0; i < num * this._$15049; ++i) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public void writePDF(MIBModule m, OutputStream os, String creator, Rectangle pageSize) throws DocumentException {
        if (pageSize == null) {
            pageSize = PageSize.A4;
        }
        this._$27953 = new Date();
        this._$27950 = m.getSMIVersion();
        this._$15473 = m.getModuleName();
        this._$24908 = pageSize;
        Document doc = new Document(pageSize);
        PdfWriter writer = PdfWriter.getInstance(doc, os);
        doc.addAuthor(System.getProperty("user.name"));
        doc.addKeywords(m.getModuleName() + ", " + (m.getSMIVersion() == 1 ? "SMIv1" : "SMIv2") + ", " + "MIB specification");
        doc.addTitle(m.getModuleName());
        doc.addCreator(creator);
        this._$27976(m);
        MyPageEvents events = new MyPageEvents();
        writer.setPageEvent(events);
        doc.open();
        if (m.hasCopyrightComment()) {
            this._$27961.add(null);
            doc.add(new Paragraph(this._$27951, m.getCopyrightComment(), (Font)this._$27956.get(_$27939)));
        }
        doc.add(this._$27981("\n"));
        this._$27982(doc, m);
        if (m.hasCopyrightCommentEnd()) {
            this._$27961.add(null);
            doc.add(new Paragraph(this._$27951, m.getCopyrightCommentEnd(), (Font)this._$27956.get(_$27939)));
        }
        try {
            doc.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    private void _$27976(MIBModule m) {
        this._$27961 = new Vector(m.size() + 1);
        this._$27962 = 0;
    }

    private Chunk _$27983(String keyword) {
        return new Chunk(keyword, (Font)this._$27956.get(_$27940));
    }

    private Chunk _$27981(String text) {
        return new Chunk(text, this._$25023);
    }

    private Chunk _$15663(String text) {
        return new Chunk(text, (Font)this._$27956.get(_$27939));
    }

    private Chunk _$317(String text) {
        return new Chunk(text, (Font)this._$27956.get(_$27945));
    }

    private Phrase _$317(int ident, String lines) {
        String prefix = this._$26478(ident);
        if (lines == null) {
            return new Phrase(prefix + "\"\"", (Font)this._$27956.get(_$27945));
        }
        StringTokenizer st = new StringTokenizer(lines, "\n\r", true);
        Phrase p = new Phrase();
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.equals("\n")) {
                p.add(this._$317(s));
                continue;
            }
            if (s.equals("\r")) continue;
            p.add(this._$317(prefix + s));
        }
        return p;
    }

    private Chunk _$27988(String text) {
        return new Chunk(text, (Font)this._$27956.get(_$27944));
    }

    private Chunk _$8984(String text) {
        return new Chunk(text, (Font)this._$27956.get(_$27943));
    }

    private Chunk _$63(String value) {
        return new Chunk(value, (Font)this._$27956.get(_$27942));
    }

    private Chunk _$20051(String value) {
        return new Chunk(value, (Font)this._$27956.get(_$27941));
    }

    private Chunk _$27989(String objectName) {
        Chunk chunk = new Chunk(objectName, (Font)this._$27956.get(_$27941));
        chunk.setLocalGoto(objectName);
        return chunk;
    }

    private void _$27992(Paragraph doc, MIBRange range) {
        if (range.getLower().equals(range.getUpper())) {
            doc.add(this._$63(range.getUpper().toString()));
        } else {
            doc.add(this._$63(range.getLower().toString()));
            doc.add(this._$27981(".."));
            doc.add(this._$63(range.getUpper().toString()));
        }
    }

    private void _$27993(Paragraph doc, IEnum enumeration) {
        doc.add(this._$20051(enumeration.getLabel()));
        doc.add(this._$27981("("));
        doc.add(this._$63(enumeration.getValue()));
        doc.add(this._$27981(")"));
    }

    private void _$24699(Paragraph doc, MIBSyntax syn) {
        switch (syn.getType()) {
            case 2: {
                doc.add(this._$27983("SEQUENCE OF "));
                doc.add(this._$63(syn.getSyntax()));
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                if (this._$12421.getObject(syn.getSyntax()) != null) {
                    doc.add(this._$27989(syn.getSyntax()));
                } else {
                    doc.add(this._$8984(syn.getSyntax()));
                }
                if (!syn.hasRanges()) break;
                MIBTextualConvention effective = this._$12421.getEffectiveSyntax(syn);
                MIBSyntax base = effective.getSyntax();
                if (base.getSyntax().equals(SMI.SMI_SYNTAX[1]) || base.getSyntax().equals(SMI.SMI_SYNTAX[10]) || base.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    doc.add(this._$27981(" ("));
                    doc.add(this._$27983("SIZE"));
                }
                doc.add(this._$27981(" ("));
                Enumeration<MIBRange> en = syn.getRangesVector().elements();
                while (en.hasMoreElements()) {
                    this._$27992(doc, en.nextElement());
                    if (!en.hasMoreElements()) continue;
                    doc.add(this._$27981(" | "));
                }
                doc.add(this._$27981(")"));
                if (!base.getSyntax().equals(SMI.SMI_SYNTAX[1]) && !base.getSyntax().equals(SMI.SMI_SYNTAX[12])) break;
                doc.add(this._$27981(")"));
            }
        }
        if (syn.hasEnums()) {
            this._$27996(doc, syn.getEnumsVector());
        }
    }

    private void _$27996(Paragraph doc, List<MIBEnum> enums) {
        doc.add(this._$27981(" {\n" + this._$26478(3)));
        int max = MIBObject.getMaxLength(enums.iterator());
        Iterator<MIBEnum> en = enums.iterator();
        while (en.hasNext()) {
            MIBEnum enumeration = en.next();
            this._$27993(doc, enumeration);
            if (enumeration.hasComment()) {
                if (en.hasNext()) {
                    doc.add(this._$27981(","));
                } else {
                    doc.add(this._$27981(" "));
                }
                String space = MIBObject.space(max - enumeration.toString().length() + 1);
                doc.add(this._$27981(space));
                String lines = enumeration.getComment();
                String first = enumeration.getComment();
                int suffix = lines.indexOf(10);
                if (suffix < 0) {
                    lines = null;
                } else {
                    first = lines.substring(0, suffix);
                    lines = lines.substring(suffix);
                }
                doc.add(this._$15663(this._$26478(1) + first));
                if (lines != null) {
                    StringTokenizer st = new StringTokenizer(lines, "\n");
                    while (st.hasMoreTokens()) {
                        doc.add(this._$27981("\n" + this._$26478(4) + MIBObject.space(max)));
                        doc.add(this._$15663(st.nextToken()));
                    }
                }
                doc.add(this._$27981("\n" + this._$26478(3)));
                continue;
            }
            if (en.hasNext()) {
                doc.add(this._$27981(",\n" + this._$26478(3)));
                continue;
            }
            doc.add(this._$27981(" "));
        }
        doc.add(this._$27981("}"));
    }

    private void _$27998(Paragraph doc, MIBObject o) {
        doc.add(this._$27981(this._$26478(1)));
        doc.add(this._$27988("STATUS      "));
        if (!o.hasStatus()) {
            doc.add(this._$27981("current"));
        } else {
            doc.add(this._$27981(o.getStatus()));
        }
        doc.add(this._$27981("\n" + this._$26478(1)));
        doc.add(this._$27988("DESCRIPTION"));
        if (!o.hasDescription()) {
            doc.add(this._$317(" \"\"\n"));
        } else {
            doc.add(this._$27981("\n"));
            doc.add(this._$317(2, o.getDescription()));
            doc.add(this._$27981("\n"));
        }
        if (o instanceof PIBObjectType) {
            doc.add(this._$27981(this._$26478(1)));
            doc.add(this._$27988("INSTALL-ERRORS"));
            this._$27996(doc, ((PIBObjectType)o).getInstallErrors());
            doc.add(this._$27981("\n"));
        }
        if (o.hasReference()) {
            doc.add(this._$27981(this._$26478(1)));
            doc.add(this._$27988("REFERENCE"));
            doc.add(this._$317(2, o.getReference()));
            doc.add(this._$27981("\n"));
        }
    }

    private void _$28000(Paragraph doc, ObjectID oid, MIBObject parent, String qualified) {
        try {
            int diff = oid.size();
            doc.add(this._$27981("{ "));
            if (parent != null) {
                diff = oid.size() - parent.getOid().size();
                if (qualified != null) {
                    doc.add(this._$27989(qualified + "." + parent.getName()));
                } else {
                    doc.add(this._$27989(parent.getName()));
                }
            }
            doc.add(this._$27981(" "));
            for (int i = oid.size() - diff; i < oid.size(); ++i) {
                String oname = null;
                if (i + 1 < oid.size()) {
                    this._$12421.getObjectName(oid.getPrefix(i + 1));
                }
                if (oname != null) {
                    doc.add(this._$20051(oname));
                    doc.add(this._$27981("("));
                    doc.add(this._$63(oid.getSubID(i)));
                    doc.add(this._$27981(")"));
                } else {
                    doc.add(this._$63(oid.getSubID(i)));
                }
                doc.add(this._$27981(" "));
            }
            doc.add(this._$27981("}"));
        }
        catch (ObjectIDFormatException ex) {
            doc.add(this._$27981("{ " + oid.toString() + " }"));
        }
    }

    private void _$28004(Paragraph doc, MIBObject o, MIBObject parent) {
        MIBObject[] parents = this._$12421.getObjectsByName(parent.getName());
        if (parents == null || parents.length <= 1) {
            this._$28000(doc, o.getOid(), parent, null);
        } else {
            String m = this._$12421.getModuleName(parent.getModuleID());
            if (m == null) {
                this._$28000(doc, o.getOid(), parent, null);
            } else {
                this._$28000(doc, o.getOid(), parent, m);
            }
        }
    }

    private void _$28006(Paragraph doc, MIBObject o) {
        if ((this._$6737 & 0x20) > 0) {
            if ((this._$6737 & 0x400) > 0) {
                doc.add(this._$15663(" -- " + o.getPrintableOid() + " --  "));
            } else {
                doc.add(this._$27981(this._$26478(1)));
                doc.add(this._$15663("-- " + o.getPrintableOid()));
                doc.add(this._$27981("\n"));
                doc.add(this._$27981(this._$26478(1)));
            }
        } else {
            doc.add(this._$27981(this._$26478(1)));
        }
        doc.add(this._$27983("::= "));
        MIBObject parent = this._$12421.getParent(o);
        if (parent == null) {
            doc.add(this._$27981(o.getOid().toSMI()));
        } else if (o instanceof MIBModule && parent.getModuleID() == o.getModuleID()) {
            while (parent != null && parent.getModuleID() == o.getModuleID()) {
                parent = this._$12421.getParent(parent);
            }
            if (parent == null) {
                this._$28000(doc, o.getOid(), parent, null);
            } else {
                this._$28004(doc, o, parent);
            }
        } else {
            this._$28004(doc, o, parent);
        }
    }

    private void _$28007(Paragraph doc, MIBIndexPart index) {
        if (index.getType() == 1) {
            if (index instanceof PIBIndexPart) {
                doc.add(this._$27988("PIB-INDEX "));
            } else {
                doc.add(this._$27988("INDEX "));
            }
        } else if (index.getType() == 3) {
            doc.add(this._$27988("EXTENDS "));
        } else {
            doc.add(this._$27988("AUGMENTS "));
        }
        doc.add(this._$27981("{\n"));
        Vector v = index.getIndexPartVector();
        Enumeration en = v.elements();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this._$27981(this._$26478(2)));
            if (index.isImplied() && !en.hasMoreElements()) {
                doc.add(this._$27983("IMPLIED "));
            }
            doc.add(this._$27989(element));
            if (en.hasMoreElements()) {
                doc.add(this._$27981(",\n"));
                continue;
            }
            doc.add(this._$27981("\n"));
        }
        doc.add(this._$27981(this._$26478(1) + "}\n"));
    }

    private void _$28009(Document doc, MIBObject o) throws DocumentException {
        Paragraph para = this._$28011(doc, o);
        if (o.getType() == 0 && o.hasStatus()) {
            para.add(this._$27983(" OBJECT-IDENTITY\n"));
            this._$27998(para, o);
        } else {
            para.add(this._$27983(" OBJECT IDENTIFIER"));
        }
        para.add(this._$27981("\n"));
        this._$28006(para, o);
        doc.add(para);
    }

    private void _$28012(Document doc, MIBObjectType ot) throws DocumentException {
        Paragraph p = this._$28011(doc, ot);
        p.add(this._$27983(" OBJECT-TYPE"));
        p.add(this._$27981("\n" + this._$26478(1)));
        p.add(this._$27988("SYNTAX      "));
        this._$24699(p, ot.getSyntax());
        p.add(this._$27981("\n"));
        if (ot.hasUnits()) {
            p.add(this._$27981(this._$26478(1)));
            p.add(this._$27988("UNITS       "));
            if (ot.getUnits().indexOf(10) > 0) {
                p.add(this._$27981("\n"));
                p.add(this._$317(2, ot.getUnits()));
            } else {
                p.add(this._$317(ot.getUnits()));
            }
            p.add(this._$27981("\n"));
        }
        p.add(this._$27981(this._$26478(1)));
        if (ot.getAccess() != null) {
            if (this._$27950 == 1) {
                p.add(this._$27988("ACCESS      "));
            } else {
                p.add(this._$27988("MAX-ACCESS  "));
            }
            p.add(this._$27981(ot.getAccess()));
            p.add(this._$27981("\n"));
        }
        this._$27998(p, ot);
        if (ot.hasIndexPart()) {
            p.add(this._$27981(this._$26478(1)));
            this._$28007(p, ot.getIndexPart());
        }
        if (ot instanceof PIBObjectType) {
            p.add(this._$27981(this._$26478(1)));
            this._$28007(p, ((PIBObjectType)ot).getMibIndexPart());
            if (((PIBObjectType)ot).getUniqueObjects() != null) {
                p.add(this._$27981(this._$26478(1)));
                p.add(this._$27988("UNIQUENESS  "));
                p.add("{\n");
                Iterator<String> it = ((PIBObjectType)ot).getUniqueObjects().iterator();
                while (it.hasNext()) {
                    String element = it.next();
                    doc.add(this._$27981(this._$26478(2)));
                    doc.add(this._$27989(element));
                    if (it.hasNext()) {
                        doc.add(this._$27981(",\n"));
                        continue;
                    }
                    doc.add(this._$27981("\n"));
                }
                doc.add(this._$27981(this._$26478(1) + "}\n"));
            }
        }
        if (ot.hasDefaultValue()) {
            p.add(this._$27981(this._$26478(1)));
            p.add(this._$27988("DEFVAL      "));
            p.add(this._$27981("{ "));
            p.add(this._$63(ot.getDefaultValue()));
            p.add(this._$27981(" }\n"));
        }
        this._$28006(p, ot);
        if (this._$12421 != null && ot.isTable()) {
            p.add(this._$27981("\n\n"));
            p.add(this._$20051(ot.getSyntax().getSyntax()));
            p.add(this._$27981(" ::= "));
            p.add(this._$27983("SEQUENCE"));
            p.add(this._$27981(" {\n"));
            int max = MIBObject.getMaxLength(ot.getTableEntriesVector().iterator());
            if (ot.getTableEntriesVector().size() == 0) {
                p.add(this._$27981(this._$26478(1) + "}\n"));
            }
            Enumeration en = ot.getTableEntriesVector().elements();
            while (en.hasMoreElements()) {
                String s = (String)en.nextElement();
                p.add(this._$27981(this._$26478(2)));
                p.add(this._$27989(s));
                p.add(this._$27981(MIBObject.space(max - s.length() + 1)));
                MIBObjectType o = (MIBObjectType)this._$12421.getObject(s);
                if (o == null) continue;
                p.add(this._$20051(o.getSyntax().getSyntax()));
                if (en.hasMoreElements()) {
                    p.add(this._$27981(",\n"));
                    continue;
                }
                p.add(this._$27981("\n" + this._$26478(1) + "}\n"));
            }
            p.add(this._$27981("\n"));
        }
        doc.add(p);
    }

    private Paragraph _$28011(Document doc, MIBObject o) throws DocumentException {
        if (o.hasComment()) {
            this._$27961.add(null);
            doc.add(new Paragraph(this._$27951, this._$15663(o.getComment())));
        }
        Chunk chunk = new Chunk(o.getName(), (Font)this._$27956.get(_$27941));
        chunk.setLocalDestination(o.getName());
        this._$27961.add(o);
        Paragraph para = new Paragraph(this._$27951, "\n");
        para.add(chunk);
        para.setKeepTogether(this._$27957);
        return para;
    }

    private Phrase _$28017(int indent, Enumeration en, boolean link) {
        Phrase doc = new Phrase();
        while (en.hasMoreElements()) {
            String element = (String)en.nextElement();
            doc.add(this._$27981(this._$26478(indent)));
            if (link) {
                doc.add(this._$27989(element));
            } else {
                doc.add(this._$20051(element));
            }
            if (en.hasMoreElements()) {
                doc.add(this._$27981(",\n"));
                continue;
            }
            doc.add(this._$27981("\n"));
        }
        return doc;
    }

    private void _$28019(Document doc, MIBNotifyType o) throws DocumentException {
        Paragraph p = this._$28011(doc, o);
        if (o.isV1Trap()) {
            p.add(this._$27983(" TRAP-TYPE"));
            p.add(this._$27981("\n" + this._$26478(1)));
            p.add(this._$27988("ENTERPRISE "));
            p.add(this._$27981(o.getEnterprise() + "\n"));
            if (o.hasVariables()) {
                p.add(this._$27981(this._$26478(1)));
                p.add(this._$27988("VARIABLES"));
                p.add(this._$27981(" {\n"));
                p.add(this._$28017(2, o.getVariablesVector().elements(), true));
                p.add(this._$27981(this._$26478(1) + "}\n"));
            }
            if (o.hasDescription()) {
                p.add(this._$27981("\n" + this._$26478(1)));
                p.add(this._$27988("DESCRIPTION "));
                p.add(this._$27981("\n"));
                if (!o.hasDescription()) {
                    p.add(this._$317(" \"\"\n"));
                } else {
                    p.add(this._$27981("\n"));
                    p.add(this._$317(2, o.getDescription()));
                    p.add(this._$27981("\n"));
                }
            }
        } else {
            p.add(this._$27988(" NOTIFICATION-TYPE"));
            p.add(this._$27981("\n"));
            if (o.hasVariables()) {
                p.add(this._$27981(this._$26478(1)));
                p.add(this._$27988("OBJECTS"));
                p.add(this._$27981(" {\n"));
                p.add(this._$28017(2, o.getVariablesVector().elements(), true));
                p.add(this._$27981(this._$26478(1) + "}\n"));
            }
            this._$27998(p, o);
        }
        if (o.isV1Trap()) {
            try {
                p.add(this._$27981(" ::= "));
                p.add(this._$63("" + o.getOid().getLastSubID()));
                p.add(this._$27981("\n"));
            }
            catch (ObjectIDFormatException oex) {}
        } else {
            this._$28006(p, o);
        }
        doc.add(p);
    }

    private void _$28025(Document doc, MIBGroup o) throws DocumentException {
        Paragraph p = this._$28011(doc, o);
        p.add(this._$27983(" " + SMI.ENTRY_TYPES[o.getType()]));
        p.add(this._$27981("\n"));
        if (o.getType() == 7) {
            p.add(this._$27981(this._$26478(1)));
            p.add(this._$27988("NOTIFICATIONS"));
            p.add(this._$27981(" {\n"));
        } else {
            p.add(this._$27981(this._$26478(1)));
            p.add(this._$27988("OBJECTS"));
            p.add(this._$27981(" {\n"));
        }
        p.add(this._$28017(2, o.getObjectsVector().elements(), true));
        p.add(this._$27981(this._$26478(1) + "}\n"));
        this._$27998(p, o);
        this._$28006(p, o);
        doc.add(p);
    }

    private void _$28026(Paragraph p, MIBVariation o) {
        p.add(this._$27981(this._$26478(1)));
        if (o instanceof MIBException) {
            p.add(this._$27988("OBJECT         "));
        } else {
            p.add(this._$27988("VARIATION      "));
        }
        p.add(this._$27981(o.getVariation()));
        if (o.hasSyntax()) {
            p.add(this._$27981("\n" + this._$26478(1) + "  "));
            p.add(this._$27988("SYNTAX       "));
            this._$24699(p, o.getSyntax());
        }
        if (o.hasWriteSyntax()) {
            p.add(this._$27981("\n" + this._$26478(1) + "  "));
            p.add(this._$27988("WRITE-SYNTAX "));
            this._$24699(p, o.getWriteSyntax());
        }
        if (o.hasAccess()) {
            p.add(this._$27981("\n" + this._$26478(1) + "  "));
            if (o instanceof MIBException) {
                if (o instanceof PIBComplianceObject) {
                    p.add(this._$27988("PIB-MIN-ACCESS "));
                } else {
                    p.add(this._$27988("MIN-ACCESS   "));
                }
            } else {
                p.add(this._$27988("ACCESS       "));
            }
            p.add(this._$27981(o.getAccess()));
        }
        if (o.hasCreationRequires()) {
            p.add(this._$27981("\n" + this._$26478(1) + "  "));
            p.add(this._$27988("CREATION-REQUIRES"));
            p.add(this._$27981(" {\n"));
            p.add(this._$28017(3, o.getCreationRequiresVector().elements(), false));
            p.add(this._$27981(" }"));
        }
        if (o.hasDefaultValue()) {
            p.add(this._$27981("\n" + this._$26478(1) + "  "));
            p.add(this._$27988("DEFVAL       "));
            p.add(this._$27981(" { "));
            p.add(this._$27981(o.getDefval()));
            p.add(this._$27981(" }"));
        }
        p.add(this._$27981("\n" + this._$26478(1) + "  "));
        p.add(this._$27988("DESCRIPTION "));
        if (o.getDescription() != null) {
            p.add(this._$27981("\n"));
            p.add(this._$317(2, o.getDescription()));
        } else {
            p.add(this._$317("\"\""));
        }
        p.add(this._$27981("\n"));
    }

    private void _$28027(Paragraph p, MIBComplianceModule o) {
        p.add(this._$27981(this._$26478(1)));
        p.add(this._$27988("MODULE "));
        if (o.hasModuleName()) {
            p.add(this._$20051(o.getModuleName()));
        }
        p.add(this._$27981("\n"));
        if (o.hasMandatory()) {
            p.add(this._$27981(this._$26478(1)));
            p.add(this._$27988("MANDATORY-GROUPS"));
            p.add(this._$27981(" {\n"));
            p.add(this._$28017(3, o.getMandatoryVector().elements(), false));
            p.add(this._$27981(this._$26478(1) + "}\n"));
        }
        if (o.hasVariations()) {
            Enumeration en = o.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this._$28026(p, v);
            }
        }
    }

    private void _$28028(Document doc, MIBCompliance o) throws DocumentException {
        if (this._$27950 > 1) {
            Paragraph p = this._$28011(doc, o);
            p.add(this._$27983(" MODULE-COMPLIANCE"));
            p.add(this._$27981("\n"));
            this._$27998(p, o);
            Enumeration<MIBComplianceModule> en = o.getModules().elements();
            while (en.hasMoreElements()) {
                this._$28027(p, en.nextElement());
            }
            this._$28006(p, o);
            doc.add(p);
        }
    }

    private void _$28029(Paragraph p, MIBSupportedModule o) {
        p.add(this._$27981("\n\n" + this._$26478(1)));
        p.add(this._$27988("SUPPORTS "));
        p.add(this._$27981(o.getSupports()));
        p.add(this._$27981("\n" + this._$26478(1)));
        p.add(this._$27988("INCLUDES"));
        p.add(this._$27981(" {\n"));
        p.add(this._$28017(2, o.getIncludes().elements(), false));
        p.add(this._$27981(this._$26478(1) + "}\n"));
        if (o.hasVariations()) {
            Enumeration en = o.getVariationsVector().elements();
            while (en.hasMoreElements()) {
                MIBVariation v = (MIBVariation)en.nextElement();
                this._$28026(p, v);
            }
        }
    }

    private void _$28030(Document doc, MIBAgentCaps o) throws DocumentException {
        if (this._$27950 > 1) {
            Paragraph p = this._$28011(doc, o);
            p.setKeepTogether(false);
            p.add(this._$27983(" AGENT-CAPABILITIES"));
            p.add(this._$27981("\n\n" + this._$26478(1)));
            p.add(this._$27988("PRODUCT-RELEASE"));
            p.add(this._$27981("\n"));
            p.add(this._$317(2, o.getProductRelease()));
            p.add(this._$27981("\n"));
            this._$27998(p, o);
            Enumeration en = o.getModules().elements();
            while (en.hasMoreElements()) {
                this._$28029(p, (MIBSupportedModule)en.nextElement());
            }
            this._$28006(p, o);
            doc.add(p);
        }
    }

    private void _$28031(Document doc, MIBTextualConvention o) throws DocumentException {
        Paragraph p = this._$28011(doc, o);
        if (!o.hasStatus() || SMI.statusType(o.getStatus()) == 0) {
            p.add(this._$27981(" ::= "));
            this._$24699(p, o.getSyntax());
        } else {
            p.add(this._$27981(" ::= "));
            p.add(this._$27983("TEXTUAL-CONVENTION"));
            p.add(this._$27981("\n"));
            if (o.hasDisplayHint()) {
                p.add(this._$27981(this._$26478(1)));
                p.add(this._$27988("DISPLAY-HINT "));
                p.add(this._$317(o.getDisplayHint()));
                p.add(this._$27981("\n"));
            }
            this._$27998(p, o);
            p.add(this._$27981(this._$26478(1)));
            p.add(this._$27988("SYNTAX      "));
            this._$24699(p, o.getSyntax());
        }
        doc.add(p);
    }

    private void writeObject(Document doc, MIBObject o) throws DocumentException {
        if (o instanceof MIBObjectType) {
            this._$28012(doc, (MIBObjectType)o);
        } else if (o instanceof MIBTextualConvention) {
            this._$28031(doc, (MIBTextualConvention)o);
        } else if (o instanceof MIBNotifyType) {
            this._$28019(doc, (MIBNotifyType)o);
        } else if (o instanceof MIBGroup) {
            this._$28025(doc, (MIBGroup)o);
        } else if (o instanceof MIBCompliance) {
            this._$28028(doc, (MIBCompliance)o);
        } else if (o instanceof MIBAgentCaps) {
            this._$28030(doc, (MIBAgentCaps)o);
        } else {
            this._$28009(doc, o);
        }
    }

    private void _$18246(Document doc, MIBModule m) throws DocumentException {
        TreeMap<MIBObject, MIBObject> orderedObjects = new TreeMap<MIBObject, MIBObject>(new MIBObjectOrderComparator(this._$6737));
        Enumeration en = m.objects();
        while (en.hasMoreElements()) {
            MIBObject obj = (MIBObject)en.nextElement();
            orderedObjects.put(obj, obj);
        }
        for (MIBObject o : orderedObjects.values()) {
            if (!(o instanceof MIBModule)) {
                this.writeObject(doc, o);
                continue;
            }
            if (!(o instanceof MIBModule) || m.getSMIVersion() != 1 || !o.getOid().isValid()) continue;
            this.writeObject(doc, o);
        }
    }

    private Chunk _$28033(String moduleName, String objectName) {
        Chunk anchor;
        if (moduleName != null) {
            anchor = new Chunk(moduleName + "." + objectName, (Font)this._$27956.get(_$27941));
            anchor.setLocalDestination(moduleName + "." + objectName);
        } else {
            anchor = new Chunk(objectName, (Font)this._$27956.get(_$27941));
            anchor.setLocalDestination(objectName);
        }
        return anchor;
    }

    private void _$28034(Paragraph doc, MIBImport imports) {
        Enumeration en = imports.getImportsVector().elements();
        while (en.hasMoreElements()) {
            doc.add(this._$27981(this._$26478(1)));
            String name = en.nextElement().toString();
            MIBObject[] o = this._$12421.getObjectsByName(name);
            if (o != null && o.length > 1) {
                doc.add(this._$28033(imports.getSource(), name));
            } else {
                doc.add(this._$28033(null, name));
            }
            if (!en.hasMoreElements()) continue;
            doc.add(this._$27981(",\n"));
        }
        doc.add(this._$27981("\n" + this._$26478(2)));
        doc.add(this._$27983("FROM "));
        doc.add(this._$20051(imports.getSource()));
        if (imports.hasComment()) {
            doc.add(this._$27981(this._$26478(2)));
            doc.add(this._$15663(imports.getComment()));
        }
    }

    private void _$28035(Document doc, MIBModule o) throws DocumentException {
        if (this._$27950 > 1 && o.getOid().size() > 0) {
            String d;
            Paragraph p = this._$28011(doc, o);
            p.add(this._$27983(" MODULE-IDENTITY"));
            if (o instanceof PIBModule) {
                p.add(this._$27981("\n" + this._$26478(1)));
                p.add(this._$27988("SUBJECT-CATEGORIES {"));
                p.add(this._$27981("\n"));
                Iterator<? extends IEnum> it = ((PIBModule)o).getCategories().iterator();
                while (it.hasNext()) {
                    IEnum element = it.next();
                    p.add(this._$27981(this._$26478(2)));
                    this._$27993(p, element);
                    if (it.hasNext()) {
                        p.add(this._$27981(",\n"));
                        continue;
                    }
                    p.add(this._$27981("\n"));
                }
                p.add(this._$27981(this._$26478(1) + "}\n"));
            }
            p.add(this._$27981("\n" + this._$26478(1)));
            p.add(this._$27988("LAST-UPDATED "));
            p.add(this._$317(o.getLastUpdated()));
            if ((this._$6737 & 0x20) > 0 && (d = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(o.getLastUpdated()))) != null) {
                p.add(this._$27981(this._$26478(1)));
                p.add(this._$15663("-- " + d));
            }
            p.add(this._$27981("\n" + this._$26478(1)));
            p.add(this._$27988("ORGANIZATION "));
            p.add(this._$317(o.getOrganization()));
            p.add(this._$27981("\n" + this._$26478(1)));
            p.add(this._$27988("CONTACT-INFO"));
            p.add(this._$27981("\n"));
            p.add(this._$317(2, o.getContactInfo()));
            p.add(this._$27981("\n" + this._$26478(1)));
            p.add(this._$27988("DESCRIPTION"));
            p.add(this._$27981("\n"));
            p.add(this._$317(2, o.getDescription()));
            p.add(this._$27981("\n"));
            if (o.hasRevisions()) {
                Enumeration en = o.getRevisionsVector().elements();
                while (en.hasMoreElements()) {
                    String d2;
                    MIBRevision r = (MIBRevision)en.nextElement();
                    p.add(this._$27981("\n" + this._$26478(1)));
                    p.add(this._$27988("REVISION "));
                    p.add(this._$317(r.getRevision()));
                    if ((this._$6737 & 0x20) > 0 && (d2 = MIBModule.getTimeFromUTC(MIBObject.getUnquotedString(r.getRevision()))) != null) {
                        p.add(this._$27981(this._$26478(1)));
                        p.add(this._$15663("-- " + d2));
                    }
                    p.add(this._$27981("\n" + this._$26478(1)));
                    p.add(this._$27988("DESCRIPTION"));
                    p.add(this._$27981("\n"));
                    p.add(this._$317(2, r.getDescription()));
                    p.add(this._$27981("\n"));
                }
            }
            this._$28006(p, o);
            doc.add(p);
        }
    }

    private void _$27982(Document doc, MIBModule m) throws DocumentException {
        this._$27961.add(m.getModuleName());
        Paragraph top = new Paragraph(this._$27951, this._$27981(m.getModuleName()));
        if (m instanceof PIBModule) {
            top.add(this._$27983(" PIB-DEFINITIONS ::= BEGIN"));
        } else {
            top.add(this._$27983(" DEFINITIONS ::= BEGIN"));
        }
        top.add(this._$27981("\n\n"));
        doc.add(top);
        if (m.hasImports()) {
            this._$27961.add("IMPORTS");
            Paragraph p = new Paragraph(this._$27951, "IMPORTS\n", (Font)this._$27956.get(_$27940));
            Enumeration<MIBImport> en = m.getImportsVector().elements();
            while (en.hasMoreElements()) {
                MIBImport mi = en.nextElement();
                this._$28034(p, mi);
                if (en.hasMoreElements() || !mi.hasComment()) continue;
                p.add(this._$27981("\n"));
            }
            p.add(this._$27981(";"));
            doc.add(p);
        }
        this._$28035(doc, m);
        this._$18246(doc, m);
        doc.add(this._$27981("\n"));
        this._$27961.add("END");
        doc.add(new Paragraph("END", (Font)this._$27956.get(_$27940)));
    }

    public void setDefaultFont(Font defaultFont) {
        this._$25023 = defaultFont;
    }

    public Font getDefaultFont() {
        return this._$25023;
    }

    public void setLeading(float leading) {
        this._$27951 = leading;
    }

    public void setKeepTogether(boolean keepTogether) {
        this._$27957 = keepTogether;
    }

    public boolean isKeepTogether() {
        return this._$27957;
    }

    public void setDisplayPageNumbers(boolean displayPageNumbers) {
        this._$27958 = displayPageNumbers;
    }

    public boolean isDisplayPageNumbers() {
        return this._$27958;
    }

    public void setOutlineAsTree(boolean outlineTree) {
        this._$27959 = outlineTree;
        if (outlineTree) {
            this._$6737 = 160;
        }
    }

    public boolean isOutlineAsTree() {
        return this._$27959;
    }

    public void setShowBookmarks(boolean showBookmarks) {
        this._$27960 = showBookmarks;
    }

    public boolean isShowBookmarks() {
        return this._$27960;
    }

    public void setDisplayCurrentDate(boolean displayCurrentDate) {
        this._$27963 = displayCurrentDate;
    }

    public void setMode(int mode) {
        this._$6737 = mode;
    }

    public boolean isDisplayCurrentDate() {
        return this._$27963;
    }

    public int getMode() {
        return this._$6737;
    }

    class MyPageEvents
    extends PdfPageEventHelper {
        PdfContentByte cb;
        PdfTemplate template;
        BaseFont bf = null;

        MyPageEvents() {
        }

        public void onParagraph(PdfWriter writer, Document document, float position) {
            try {
                PdfContentByte cb = writer.getDirectContent();
                PdfOutline root = null;
                String title = null;
                if (MIBModule2PDF.this._$27961.elementAt(MIBModule2PDF.this._$27962) == null) {
                    MIBModule2PDF.this._$27962++;
                    return;
                }
                MIBObject o = null;
                if (MIBModule2PDF.this._$27961.elementAt(MIBModule2PDF.this._$27962) instanceof MIBObject) {
                    o = (MIBObject)MIBModule2PDF.this._$27961.elementAt(MIBModule2PDF.this._$27962);
                    title = o.getName();
                    MIBObject parent = MIBModule2PDF.this._$12421.getParent(o);
                    if (parent != null) {
                        root = (PdfOutline)parent.userObject;
                    }
                } else {
                    title = MIBModule2PDF.this._$27961.elementAt(MIBModule2PDF.this._$27962).toString();
                }
                if (!MIBModule2PDF.this._$27959 || root == null) {
                    root = cb.getRootOutline().getKids().size() > 0 ? (PdfOutline)cb.getRootOutline().getKids().get(0) : cb.getRootOutline();
                }
                PdfDestination destination = new PdfDestination(2, position);
                PdfOutline outline = new PdfOutline(root, destination, title);
                if (o != null) {
                    o.userObject = outline;
                }
                MIBModule2PDF.this._$27962++;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }

        public void onOpenDocument(PdfWriter writer, Document document) {
            try {
                this.bf = BaseFont.createFont("Courier", "Cp1252", false);
                this.cb = writer.getDirectContent();
                this.template = this.cb.createTemplate(50.0f, 50.0f);
            }
            catch (DocumentException de) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void onEndPage(PdfWriter writer, Document document) {
            if (!MIBModule2PDF.this._$27958) {
                return;
            }
            int pageN = writer.getPageNumber();
            String text = "Page " + pageN + " of     ";
            float lenNum = this.bf.getWidthPoint("8888", 8.0f);
            float len = this.bf.getWidthPoint(text, 8.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(MIBModule2PDF.this._$24908.getWidth() - 30.0f - len, 30.0f);
            this.cb.showText(text);
            this.cb.endText();
            this.cb.addTemplate(this.template, MIBModule2PDF.this._$24908.getWidth() - 30.0f - lenNum, 30.0f);
            this.cb.beginText();
            this.cb.setFontAndSize(this.bf, 8.0f);
            this.cb.setTextMatrix(30.0f, 30.0f);
            this.cb.showText(MIBModule2PDF.this._$15473);
            this.cb.endText();
            if (MIBModule2PDF.this._$27963) {
                this.cb.beginText();
                this.cb.setFontAndSize(this.bf, 8.0f);
                String date = _$27949.format(MIBModule2PDF.this._$27953);
                len = this.bf.getWidthPoint(date, 8.0f);
                this.cb.setTextMatrix(MIBModule2PDF.this._$24908.getWidth() / 2.0f - len / 2.0f, 30.0f);
                this.cb.showText(date);
                this.cb.endText();
            }
        }

        public void onCloseDocument(PdfWriter writer, Document document) {
            this.template.beginText();
            this.template.setFontAndSize(this.bf, 8.0f);
            this.template.showText(String.valueOf(writer.getPageNumber() - 1));
            this.template.endText();
        }
    }
}

