/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.smi.IEnum;
import com.agentpp.smi.IRange;
import com.agentpp.smi.ISyntax;
import com.agentpp.smi.ext.SMIEnum;
import com.agentpp.smi.ext.SMISyntax;
import com.agentpp.smiparser.SMI;
import com.agentpp.smiparser.SMIRange;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIBSyntax
implements Serializable,
SMISyntax {
    public static final long serialVersionUID = 1000L;
    protected String syntax;
    protected int type;
    protected Vector<MIBRange> ranges = null;
    protected Vector<MIBEnum> enums = null;
    public transient Object userObject;

    public MIBSyntax() {
        this.syntax = null;
        this.type = 0;
    }

    public MIBSyntax(String syntax, int type) {
        this.syntax = syntax;
        this.type = type;
    }

    public MIBSyntax(ISyntax other) {
        this.syntax = other.getSyntax();
        this.type = other.getType();
        if (other.hasEnums()) {
            this.setEnums((MIBEnum[])other.getEnums());
        }
        if (other.hasRanges()) {
            this.setRanges((MIBRange[])other.getRanges());
        }
    }

    @Override
    public final String getSyntax() {
        return this.syntax;
    }

    @Override
    public final void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    @Override
    public final int getType() {
        return this.type;
    }

    @Override
    public final void setType(int t) {
        this.type = t;
    }

    @Override
    public final boolean hasRanges() {
        return this.ranges != null && this.ranges.size() > 0;
    }

    public final void addRange(MIBRange range) {
        if (this.ranges == null) {
            this.ranges = new Vector(5);
        }
        this.ranges.addElement(range);
    }

    @Override
    public IRange[] getRanges() {
        if (this.ranges == null) {
            return null;
        }
        Object[] r = new MIBRange[this.ranges.size()];
        this.ranges.copyInto(r);
        return r;
    }

    public void setRanges(MIBRange[] ranges) {
        this.ranges = MIBRepository.buildVector(ranges);
    }

    public void setRanges(SMIRange[] ranges) {
        this.ranges = MIBRepository.buildVector(ranges);
    }

    public final void setRangesVector(Vector<MIBRange> v) {
        this.ranges = v;
    }

    public final Vector<MIBRange> getRangesVector() {
        return this.ranges;
    }

    public final boolean containsRange(MIBRange range) {
        if (!this.hasRanges()) {
            return false;
        }
        return this.ranges.contains(range);
    }

    public final boolean isRestrictiveRange(MIBRange range) {
        if (!this.hasRanges()) {
            return true;
        }
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        Enumeration<MIBRange> en = this.ranges.elements();
        while (en.hasMoreElements()) {
            MIBRange r = en.nextElement();
            if (r.getLowerValue() <= range.getLowerValue() && r.getUpperValue() >= range.getUpperValue()) {
                return true;
            }
            if (r.getLowerValue() < min) {
                min = r.getLowerValue();
            }
            if (r.getUpperValue() <= max) continue;
            max = r.getUpperValue();
        }
        return range.getLowerValue() > min || range.getUpperValue() < max;
    }

    public final boolean isRestrictiveOrSubset(Vector restrictions) {
        if (!this.hasRanges()) {
            return true;
        }
        if (restrictions == null) {
            return false;
        }
        Vector ranges = (Vector)this.ranges.clone();
        Vector normRanges = new Vector(ranges.size() + 1);
        Vector normRestrict = new Vector(restrictions.size() + 1);
        MIBRange.normalizeRanges(ranges, normRanges);
        MIBRange.normalizeRanges(restrictions, normRestrict);
        return MIBRange.compareRanges(normRanges, normRestrict) >= 0;
    }

    public final long getMinOfEnums() {
        if (!this.hasEnums()) {
            return Long.MIN_VALUE;
        }
        long min = Long.MAX_VALUE;
        Enumeration<MIBEnum> en = this.enums.elements();
        while (en.hasMoreElements()) {
            MIBEnum r = en.nextElement();
            if (r.getLongValue() >= min) continue;
            min = r.getLongValue();
        }
        return min;
    }

    public final long getMaxOfEnums() {
        if (!this.hasEnums()) {
            return Long.MIN_VALUE;
        }
        long max = Long.MIN_VALUE;
        Enumeration<MIBEnum> en = this.enums.elements();
        while (en.hasMoreElements()) {
            MIBEnum r = en.nextElement();
            if (r.getLongValue() <= max) continue;
            max = r.getLongValue();
        }
        return max;
    }

    public final long getMinOfRanges() {
        if (!this.hasRanges()) {
            return Long.MIN_VALUE;
        }
        long min = Long.MAX_VALUE;
        Enumeration<MIBRange> en = this.ranges.elements();
        while (en.hasMoreElements()) {
            MIBRange r = en.nextElement();
            if (r.getLowerValue() >= min) continue;
            min = r.getLowerValue();
        }
        return min;
    }

    public final long getMaxOfRanges() {
        if (!this.hasRanges()) {
            return Long.MAX_VALUE;
        }
        long max = Long.MIN_VALUE;
        Enumeration<MIBRange> en = this.ranges.elements();
        while (en.hasMoreElements()) {
            MIBRange r = en.nextElement();
            if (r.getLowerValue() <= max) continue;
            max = r.getUpperValue();
        }
        return max;
    }

    public boolean isIncludedInRanges(long value) {
        if (this.hasRanges()) {
            for (int i = 0; i < this.ranges.size(); ++i) {
                MIBRange r = this.ranges.get(i);
                if (value < r.getLowerValue() || value > r.getUpperValue()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public final boolean hasEnums() {
        return this.enums != null && this.enums.size() > 0;
    }

    public final void addEnum(MIBEnum e) {
        if (this.enums == null) {
            this.enums = new Vector(5);
        }
        this.enums.addElement(e);
    }

    public int getMaxEnumLabelLength() {
        int max = 0;
        for (MIBEnum e : this.enums) {
            if (e.getLabel() == null || e.getLabel().length() <= max) continue;
            max = e.getLabel().length();
        }
        return max;
    }

    public int getMinEnumLabelLength() {
        int min = Integer.MAX_VALUE;
        for (MIBEnum e : this.enums) {
            if (e.getLabel() == null || e.getLabel().length() >= min) continue;
            min = e.getLabel().length();
        }
        return min;
    }

    @Override
    public IEnum[] getEnums() {
        if (this.enums == null) {
            return null;
        }
        Object[] e = new MIBEnum[this.enums.size()];
        this.enums.copyInto(e);
        return e;
    }

    public final void setEnums(MIBEnum[] enumerations) {
        this.enums = MIBRepository.buildVector(enumerations);
    }

    public final void setEnums(SMIEnum[] enumerations) {
        this.enums = MIBRepository.buildVector(enumerations);
    }

    public final void setEnumsVector(Vector<MIBEnum> v) {
        this.enums = v;
    }

    public final Vector<MIBEnum> getEnumsVector() {
        return this.enums;
    }

    public byte[] getBitsEnum(String labelList) {
        StringTokenizer st = new StringTokenizer(labelList, "{}, ");
        long max = this.getMaxOfEnums();
        byte[] bits = new byte[max >= 0L ? (int)(max / 8L) + 1 : 0];
        while (st.hasMoreTokens()) {
            String bit = st.nextToken();
            boolean found = false;
            Enumeration<MIBEnum> en = this.enums.elements();
            while (en.hasMoreElements()) {
                MIBEnum e = en.nextElement();
                if (!e.getLabel().equals(bit)) continue;
                found = true;
                try {
                    int b = (int)Long.parseLong(e.getValue());
                    if (b / 8 >= bits.length) {
                        byte[] old = bits;
                        bits = new byte[b / 8 + 1];
                        System.arraycopy(old, 0, bits, 0, old.length);
                    }
                    int n = b / 8;
                    bits[n] = (byte)(bits[n] | 1 << 7 - b % 8);
                }
                catch (NumberFormatException nfe) {}
                break;
            }
            if (found) continue;
            return null;
        }
        return bits;
    }

    public String getBitsEnum(byte[] bits) {
        StringBuffer buf = new StringBuffer(50);
        buf.append('{');
        boolean first = true;
        for (int i = 0; i < bits.length * 8; ++i) {
            if ((bits[i / 8] & 1 << 7 - i % 8) <= 0) continue;
            String label = this.getLabel(i);
            if (!first) {
                buf.append(',');
            }
            first = false;
            if (label != null) {
                buf.append(label);
                continue;
            }
            buf.append("" + i);
        }
        buf.append('}');
        return buf.toString();
    }

    public final int getEnumValue(String label) {
        Enumeration<MIBEnum> en = this.enums.elements();
        while (en.hasMoreElements()) {
            MIBEnum e = en.nextElement();
            if (!e.getLabel().equals(label) && !e.toString().equals(label)) continue;
            return Integer.parseInt(e.getValue());
        }
        return Integer.MIN_VALUE;
    }

    public String getEnum(String label) {
        if (this.syntax.equals(SMI.SMI_SYNTAX[12])) {
            byte[] bits = this.getBitsEnum(label);
            if (bits == null) {
                return null;
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < bits.length; ++i) {
                String hex = Integer.toHexString(bits[i] & 0xFF);
                for (int f = 0; f < 2 - hex.length(); ++f) {
                    hex = "0" + hex;
                }
                buf.append("\\x" + hex);
            }
            return buf.toString();
        }
        Enumeration<MIBEnum> en = this.enums.elements();
        while (en.hasMoreElements()) {
            MIBEnum e = en.nextElement();
            if (!e.getLabel().equals(label)) continue;
            return e.getValue();
        }
        return null;
    }

    public final String getLabel(long num) {
        MIBEnum e = this.getEnum(num);
        if (e == null) {
            return null;
        }
        return e.getLabel();
    }

    public final MIBEnum getEnum(long num) {
        Enumeration<MIBEnum> en = this.enums.elements();
        while (en.hasMoreElements()) {
            MIBEnum e = en.nextElement();
            if (e.getLongValue() != num) continue;
            return e;
        }
        return null;
    }

    protected final String getSMIv2Syntax() {
        if (this.syntax.equals(SMI.SMI_SYNTAX[0]) && !this.hasEnums()) {
            return SMI.SMI_SYNTAX[8];
        }
        if (this.syntax.equals(SMI.SMI_SYNTAX[3])) {
            return SMI.SMI_SYNTAX[5];
        }
        if (this.syntax.equals(SMI.SMI_SYNTAX[4])) {
            return SMI.SMI_SYNTAX[7];
        }
        return this.syntax;
    }

    public String toSMI(int mode, MIBRepository rep, MIBSyntax c, String lineSeparator) {
        StringBuffer buf = new StringBuffer();
        switch (this.type) {
            case 2: {
                MIBObject.addKeyWord(mode, buf, "SEQUENCE OF ");
                MIBObject.addString(mode, buf, this.syntax, c == null ? null : c.syntax);
                break;
            }
            case 0: 
            case 1: 
            case 3: {
                if (mode == 8) {
                    buf.append(this.getSMIv2Syntax());
                } else if (rep != null) {
                    if (rep.getObject(this.syntax) != null) {
                        MIBObject.addObjectLink(mode, buf, this.syntax, c == null ? null : c.syntax);
                    } else {
                        MIBObject.addString(mode, buf, this.syntax, c == null ? null : c.syntax);
                    }
                } else {
                    MIBObject.addString(mode, buf, this.syntax, c == null ? null : c.syntax);
                }
                if ((mode & 1) <= 0 && (mode & 2) <= 0 || !this.hasRanges()) break;
                boolean isSize = false;
                MIBSyntax base = null;
                if (rep != null) {
                    base = rep.resolveTC(this.syntax);
                }
                if (base == null) {
                    base = this;
                }
                if (base.getSyntax().equals(SMI.SMI_SYNTAX[1]) || base.getSyntax().equals(SMI.SMI_SYNTAX[10]) || base.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                    isSize = true;
                    buf.append(" (");
                    MIBObject.addKeyWord(mode, buf, "SIZE");
                }
                buf.append(" (");
                Enumeration<MIBRange> cen = null;
                if (c != null) {
                    cen = c.hasRanges() ? c.ranges.elements() : new Vector().elements();
                }
                Enumeration<MIBRange> en = this.ranges.elements();
                while (en.hasMoreElements()) {
                    MIBRange cr = null;
                    if (cen != null) {
                        cr = cen.hasMoreElements() ? cen.nextElement() : new MIBRange(0L, -1L);
                    }
                    MIBObject.addString(mode, buf, en.nextElement().toSMI(mode), cr == null ? null : cr.toSMI(mode));
                    if (!en.hasMoreElements()) continue;
                    buf.append(" | ");
                }
                buf.append(")");
                if (!isSize) break;
                buf.append(")");
            }
        }
        if (this.hasEnums()) {
            buf.append(" {");
            buf.append(lineSeparator);
            buf.append("\t\t\t");
            Iterator<MIBEnum> cen = null;
            if (c != null) {
                cen = c.hasEnums() ? c.enums.iterator() : new Vector().iterator();
            }
            MIBSyntax.toSMIEnums(mode, lineSeparator, buf, cen, this.enums);
            buf.append("}");
        }
        buf.append(lineSeparator);
        return buf.toString();
    }

    public static void toSMIEnums(int mode, String lineSeparator, StringBuffer buf, Iterator<MIBEnum> cen, List<MIBEnum> enums) {
        int max = MIBObject.getMaxLength(enums.iterator());
        Iterator<MIBEnum> en = enums.iterator();
        while (en.hasNext()) {
            MIBEnum ce = null;
            if (cen != null) {
                ce = cen.hasNext() ? cen.next() : new MIBEnum("", "0");
            }
            MIBEnum e = en.next();
            MIBObject.addString(mode, buf, e.toSMI(mode), ce == null ? null : ce.toSMI(mode));
            if (e.hasComment()) {
                if (en.hasNext()) {
                    buf.append(",");
                }
                String space = MIBObject.space(max - e.toString().length() + 1);
                buf.append(space);
                String lines = e.getComment();
                String first = e.getComment();
                int suffix = lines.indexOf("\n");
                if (suffix < 0) {
                    lines = null;
                } else {
                    first = lines.substring(0, suffix);
                    lines = lines.substring(suffix);
                }
                MIBObject.addComment(mode, buf, "\t" + first, lineSeparator);
                if (lines != null) {
                    StringTokenizer st = new StringTokenizer(lines, "\n", true);
                    while (st.hasMoreTokens()) {
                        String token = st.nextToken();
                        int index = "\n".indexOf(token);
                        if (index >= 0) continue;
                        if ((mode & 2) > 0) {
                            buf.append("\n");
                        } else {
                            buf.append(lineSeparator);
                        }
                        buf.append("\t\t\t\t" + MIBObject.space(max));
                        MIBObject.addComment(mode, buf, token, lineSeparator);
                    }
                }
                buf.append(lineSeparator);
                buf.append("\t\t\t");
                continue;
            }
            if (en.hasNext()) {
                buf.append(",");
                buf.append(lineSeparator);
                buf.append("\t\t\t");
                continue;
            }
            buf.append(' ');
        }
    }

    public boolean isRestrictiveSyntax(MIBRepository rep) {
        if (this.getType() != 3) {
            return true;
        }
        MIBObject base = rep.getObject(this.getSyntax());
        if (!(base instanceof MIBTextualConvention)) {
            return false;
        }
        MIBTextualConvention mySyntax = (MIBTextualConvention)base;
        if (this.hasRanges() && !mySyntax.getSyntax().isRestrictiveOrSubset(this.getRangesVector())) {
            return false;
        }
        if (this.hasEnums() && mySyntax.getSyntax().hasEnums()) {
            if (this.getEnumsVector().size() > mySyntax.getSyntax().getEnumsVector().size()) {
                return false;
            }
            for (MIBEnum e : this.getEnumsVector()) {
                MIBEnum defined = mySyntax.getSyntax().getEnum(e.getLongValue());
                if (defined != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isRestrictiveSyntax(MIBRepository rep, MIBSyntax refinement) {
        block6: {
            MIBTextualConvention mySyntax;
            block5: {
                mySyntax = rep.getEffectiveSyntax(this);
                MIBTextualConvention restrictiveSyntax = rep.getEffectiveSyntax(refinement);
                if (!restrictiveSyntax.getSyntax().getSyntax().equals(mySyntax.getSyntax().getSyntax()) || restrictiveSyntax.getSyntax().hasEnums() != mySyntax.getSyntax().hasEnums() && mySyntax.getSyntax().hasEnums() || restrictiveSyntax.getSyntax().hasRanges() != mySyntax.getSyntax().hasRanges() && mySyntax.getSyntax().hasRanges()) {
                    return false;
                }
                if (!refinement.hasRanges()) break block5;
                for (int i = 0; i < refinement.getRangesVector().size(); ++i) {
                    MIBRange r = refinement.getRangesVector().get(i);
                    if (mySyntax.getSyntax().isRestrictiveRange(r)) continue;
                    return false;
                }
                break block6;
            }
            if (!refinement.hasEnums()) break block6;
            if (!mySyntax.getSyntax().hasEnums()) {
                return false;
            }
            if (refinement.getEnumsVector().size() > mySyntax.getSyntax().getEnumsVector().size()) {
                return false;
            }
            for (MIBEnum e : refinement.getEnumsVector()) {
                MIBEnum defined = mySyntax.getSyntax().getEnum(e.getLongValue());
                if (defined != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof MIBSyntax) {
            MIBSyntax other = (MIBSyntax)o;
            return MIBObject.saveCompare(this.syntax, other.syntax) && this.type == other.type && MIBObject.saveCompare(this.enums, other.enums) && MIBObject.saveCompare(this.ranges, other.ranges);
        }
        return false;
    }

    public int hashCode() {
        return this.syntax.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.syntax = SMI.getCommonIdentifier(this.syntax);
    }
}

