/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.smi.ext.SMIImport;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class MIBImport
implements Serializable,
SMIImport {
    public static final long serialVersionUID = 1000L;
    protected Vector imports = null;
    protected String source = null;
    protected String comment = null;
    protected transient Object userObject;

    public MIBImport() {
    }

    public MIBImport(String source) {
        this.source = source;
    }

    public MIBImport(String source, Vector imports) {
        this.source = source;
        this.imports = imports;
    }

    public MIBImport(String source, Vector imports, String comment) {
        this(source, imports);
        this.comment = comment;
    }

    public MIBImport(MIBImport other) {
        this.source = other.source;
        this.comment = other.comment;
        Enumeration en = other.imports.elements();
        while (en.hasMoreElements()) {
            this.addImport((String)en.nextElement());
        }
    }

    public void setSource(String source) {
        this.source = source;
    }

    public boolean hasComment() {
        return this.comment != null;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getSource() {
        return this.source;
    }

    public String getComment() {
        return this.comment;
    }

    public Object getUserObject() {
        return this.userObject;
    }

    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    public void setImports(String[] imports) {
        this.imports = MIBRepository.buildVector(imports);
    }

    public String[] getImports() {
        if (this.imports == null) {
            return null;
        }
        Object[] s = new String[this.imports.size()];
        this.imports.copyInto(s);
        return s;
    }

    public void addImport(String imp) {
        if (this.imports == null) {
            this.imports = new Vector(5);
        }
        this.imports.addElement(imp);
    }

    public void setImportsVector(Vector v) {
        this.imports = v;
    }

    public Vector getImportsVector() {
        return this.imports;
    }

    public boolean imports(String objectName) {
        return this.imports.contains(objectName);
    }

    public String toSMI(MIBRepository rep, int mode, String lineSeparator) {
        StringBuffer buf = new StringBuffer();
        Enumeration en = this.imports.elements();
        while (en.hasMoreElements()) {
            buf.append("\t");
            String name = en.nextElement().toString();
            MIBObject[] o = rep.getObjectsByName(name);
            if (o != null && o.length > 1) {
                MIBObject.addObjectRef(this.source, mode, buf, name);
            } else {
                MIBObject.addObjectRef(null, mode, buf, name);
            }
            if (!en.hasMoreElements()) continue;
            buf.append(",");
            buf.append(lineSeparator);
        }
        buf.append(lineSeparator);
        buf.append("\t\t");
        MIBObject.addKeyWord(mode, buf, "FROM ");
        buf.append(this.source);
        if (this.hasComment()) {
            buf.append("\t\t");
            MIBObject.addComment(mode, buf, this.getComment(), lineSeparator);
        }
        return buf.toString();
    }

    public String toString() {
        return this.source;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MIBImport) {
            MIBImport other = (MIBImport)obj;
            return (this.source == null ? other.getSource() == null : this.source.equals(other.getSource())) && (this.getImportsVector() == null ? other.getImportsVector() == null : this.getImportsVector().equals(other.getImportsVector())) && (!this.hasComment() ? !other.hasComment() : this.getComment().equals(other.getComment()));
        }
        return false;
    }

    public int hashCode() {
        if (this.source != null) {
            return this.source.hashCode();
        }
        return super.hashCode();
    }
}

