/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.ext.SMIGroup;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class MIBGroup
extends MIBObject
implements Serializable,
SMIGroup {
    public static final long serialVersionUID = 1000L;
    protected Vector objects = new Vector();
    public static final int ID = 6;
    protected int groupType = 6;

    public MIBGroup() {
        this.groupType = 6;
    }

    public MIBGroup(int type) {
        this.groupType = type == 6 ? 6 : 7;
    }

    public MIBGroup(ObjectID oid, String name, Integer moduleID, int type) {
        super(oid, name, moduleID);
        this.groupType = type == 6 ? 6 : 7;
    }

    public MIBGroup(MIBGroup other) {
        super(other);
        this.groupType = other.groupType;
        if (other.objects != null) {
            Enumeration en = other.objects.elements();
            while (en.hasMoreElements()) {
                this.objects.addElement(en.nextElement());
            }
        }
    }

    public MIBObject getClone() {
        return new MIBGroup(this);
    }

    public final String getTypeString() {
        return SMI.ENTRY_TYPES[this.groupType];
    }

    public final boolean isObjectGroup() {
        return this.groupType == 6;
    }

    public final boolean isNotificationGroup() {
        return this.groupType != 6;
    }

    public final boolean contains(String name) {
        return this.objects.contains(name);
    }

    public final int getType() {
        return this.groupType;
    }

    public final void setType(int type) {
        this.groupType = type;
    }

    public final void setObjects(String[] objects) {
        this.objects = MIBRepository.buildVector(objects);
    }

    public void addObject(String object) {
        if (this.objects == null) {
            this.objects = new Vector(5);
        }
        this.objects.addElement(object);
    }

    public String[] getObjects() {
        if (this.objects == null) {
            return null;
        }
        Object[] s = new String[this.objects.size()];
        this.objects.copyInto(s);
        return s;
    }

    public Vector getObjectsVector() {
        return this.objects;
    }

    public void setObjectsVector(Vector v) {
        this.objects = v;
    }

    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBGroup c = (MIBGroup)this.comparable(mode);
        StringBuffer buf = new StringBuffer();
        MIBGroup.addNavigationLinks(this, mode, buf, rep, lineSeparator);
        if (this.hasComment()) {
            MIBGroup.addComment(mode, buf, this.asn1Comment, lineSeparator);
            buf.append(lineSeparator);
        }
        MIBGroup.addObjectRef(null, mode, buf, this.name);
        buf.append(' ');
        MIBGroup.addKeyWord(mode, buf, SMI.ENTRY_TYPES[this.groupType]);
        buf.append(lineSeparator);
        if (this.groupType == 7) {
            buf.append('\t');
            MIBGroup.addKeyWord(mode, buf, "NOTIFICATIONS");
            buf.append(" {");
            buf.append(lineSeparator);
        } else {
            buf.append('\t');
            MIBGroup.addKeyWord(mode, buf, "OBJECTS");
            buf.append(" {");
            buf.append(lineSeparator);
        }
        MIBObject.addString(mode, buf, MIBObject.formatObjectRefs(mode, "\t\t", this.objects.iterator(), lineSeparator), c == null ? null : MIBObject.formatObjectRefs(mode, "\t\t", c.objects.iterator(), lineSeparator));
        if (this.objects.size() == 0) {
            buf.append("\t}");
        } else {
            buf.append(" }");
        }
        buf.append(lineSeparator);
        buf.append(this.getSMIDefBegin(mode, lineSeparator));
        buf.append(this.getSMIDefEnd(mode, rep, this.asn1CommentInline, lineSeparator));
        return buf.toString();
    }

    public boolean equals(Object o) {
        if (o instanceof MIBGroup && super.equals(o)) {
            MIBGroup other = (MIBGroup)o;
            return this.groupType == other.groupType && MIBGroup.saveCompare(this.objects, other.objects);
        }
        return false;
    }
}

