/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.mib;

import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.ObjectID;
import com.agentpp.smi.IImplementationSpec;
import com.agentpp.smi.ext.SMIAgentCapabilities;
import com.agentpp.smi.ext.SMIImplementationSpec;
import com.agentpp.smiparser.SMI;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Vector;

public class MIBAgentCaps
extends MIBObject
implements Serializable,
SMIAgentCapabilities {
    public static final long serialVersionUID = 1000L;
    protected String productRelease = null;
    protected Vector modules = new Vector();

    public MIBAgentCaps() {
    }

    public MIBAgentCaps(ObjectID oid, String name, Integer moduleID) {
        super(oid, name, moduleID);
    }

    public MIBAgentCaps(MIBAgentCaps other) {
        super(other);
        this.productRelease = other.productRelease;
        Enumeration en = other.modules.elements();
        while (en.hasMoreElements()) {
            this.modules.addElement(new MIBSupportedModule((MIBSupportedModule)en.nextElement()));
        }
    }

    public MIBObject getClone() {
        return new MIBAgentCaps(this);
    }

    public final String getTypeString() {
        return SMI.ENTRY_TYPES[9];
    }

    public final int getType() {
        return 9;
    }

    public final void setProductRelease(String newProductRelease) {
        this.productRelease = newProductRelease;
    }

    public final String getProductRelease() {
        return this.productRelease;
    }

    public final void setModules(SMIImplementationSpec[] supportedModules) {
        this.modules = new Vector<SMIImplementationSpec>(Arrays.asList(supportedModules));
    }

    public final void setModules(Vector newModules) {
        this.modules = newModules;
    }

    public final Vector getModules() {
        return this.modules;
    }

    public final IImplementationSpec[] getImplementationSpecs() {
        Object[] m = new MIBSupportedModule[this.modules.size()];
        this.modules.copyInto(m);
        return m;
    }

    public String toSMI(int mode, int smiversion, MIBRepository rep, String lineSeparator) {
        MIBAgentCaps c = (MIBAgentCaps)this.comparable(mode);
        if (smiversion > 1) {
            StringBuffer buf = new StringBuffer(lineSeparator);
            MIBAgentCaps.addNavigationLinks(this, mode, buf, rep, lineSeparator);
            if (this.hasComment()) {
                MIBAgentCaps.addComment(mode, buf, this.asn1Comment, lineSeparator);
                buf.append(lineSeparator);
            }
            MIBAgentCaps.addObjectRef(null, mode, buf, this.name, c == null ? null : c.name);
            MIBAgentCaps.addKeyWord(mode, buf, " AGENT-CAPABILITIES");
            buf.append(lineSeparator);
            buf.append(lineSeparator);
            buf.append("\t");
            MIBAgentCaps.addKeyWord(mode, buf, "PRODUCT-RELEASE");
            buf.append(lineSeparator);
            MIBAgentCaps.addText(lineSeparator, mode, buf, MIBAgentCaps.formatLines("\t\t", this.productRelease), c == null ? null : MIBAgentCaps.formatLines("\t\t", c.productRelease));
            buf.append(lineSeparator);
            buf.append(this.getSMIDefBegin(mode, lineSeparator));
            Enumeration cen = null;
            if (c != null && c.modules != null) {
                cen = c.modules.elements();
            }
            Enumeration en = this.modules.elements();
            while (en.hasMoreElements()) {
                MIBSupportedModule cs = null;
                if (cen != null) {
                    cs = cen.hasMoreElements() ? (MIBSupportedModule)cen.nextElement() : new MIBSupportedModule();
                }
                buf.append(((MIBSupportedModule)en.nextElement()).toSMI(mode, rep, cs, lineSeparator));
            }
            buf.append(lineSeparator);
            buf.append(this.getSMIDefEnd(mode, rep, this.asn1CommentInline, lineSeparator));
            return buf.toString();
        }
        return "";
    }

    public boolean equals(Object o) {
        if (o instanceof MIBAgentCaps && super.equals(o)) {
            MIBAgentCaps other = (MIBAgentCaps)o;
            return MIBAgentCaps.saveCompare(this.productRelease, other.productRelease) && MIBAgentCaps.saveCompare(this.modules, other.modules);
        }
        return false;
    }

    public void freeUserObjects() {
        super.freeUserObjects();
        for (MIBSupportedModule m : this.modules) {
            m.freeUserObjects();
        }
    }
}

