/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.wizard;

import com.agentpp.common.MIBCompiler;
import com.agentpp.common.StatusBar;
import com.agentpp.common.WizardEvent;
import com.agentpp.common.WizardListener;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.event.MIBModuleEvent;
import com.agentpp.mib.event.MIBModuleListener;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.util.FileUtilities;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCLongValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class BasicImportPanel
extends JPanel
implements MIBModuleListener,
StatusBar {
    private GridBagLayout _$4482 = new GridBagLayout();
    private JTextArea _$10072 = new JTextArea();
    private JCheckBox _$20951 = new JCheckBox();
    private JLabel _$20952 = new JLabel();
    private JButton _$20953 = new JButton();
    private JLabel _$20954 = new JLabel();
    private JLabel _$20955 = new JLabel();
    private JComboBox _$20956 = new JComboBox();
    private JLabel _$20957 = new JLabel();
    private JComboBox _$20958 = new JComboBox();
    private RepositoryManager _$294;
    private JFrame _$296;
    private UserConfigFile _$290;
    private transient Vector _$10250;
    private JCSpinField _$20959 = new JCSpinField();
    static /* synthetic */ Class class$com$agentpp$mib$MIBObject;

    public BasicImportPanel(UserConfigFile userConfigFile, RepositoryManager repositoryManager, JFrame jFrame) {
        this._$294 = repositoryManager;
        this._$296 = jFrame;
        this._$290 = userConfigFile;
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.initModules();
    }

    public void initModules() {
        this._$20956.removeAllItems();
        try {
            HashSet<String> hashSet = new HashSet<String>();
            Object[] objectArray = this._$294.getModuleNames();
            hashSet.addAll(Arrays.asList(objectArray));
            objectArray = this._$294.getBuiltinModuleNames();
            hashSet.addAll(Arrays.asList(objectArray));
            objectArray = hashSet.toArray(new String[hashSet.size()]);
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                this._$20956.addItem(objectArray[i]);
            }
        }
        catch (Exception exception) {
            this.setMessage(exception.getMessage());
        }
    }

    void jbInit() throws Exception {
        this._$10072.setBackground(UIManager.getColor("Label.background"));
        this._$10072.setEnabled(false);
        this._$10072.setFont(new Font("Dialog", 0, 12));
        this._$10072.setDisabledTextColor(Color.black);
        this._$10072.setEditable(false);
        this._$10072.setText("In order to be able to define a new MIB module, you need to define a root object identifier (OID). There is typically only a single root OID for a MIB module, but that's not a requirement. You will be able to add additional root objects by using the Edit/Imports... menu.\nA possible root OID for an enterprise specific MIB module is the enterprises ID assigned by IANA (http://www.iana.org) or any OID defined in a subtree of that OID by an enterprise specific registration MIB.\nIf you are creating such a registration MIB module, then you should import the \"enterprises\" OID and assign your IANA ID in the spin field left of the respective check box.\nOtherwise, you need to import an OID from another registration MIB module, which can be imported from an external MIB file.");
        this._$10072.setColumns(40);
        this._$10072.setLineWrap(true);
        this._$10072.setRows(9);
        this._$10072.setWrapStyleWord(true);
        this.setLayout(this._$4482);
        this._$20951.setToolTipText("Check this option to import SNMPv2-SMI.enterprises into your MIB module");
        this._$20951.setHorizontalTextPosition(10);
        this._$20951.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BasicImportPanel.this.importEnterprises_itemStateChanged(itemEvent);
            }
        });
        this._$20952.setText("Import external registration MIB module:");
        this._$20953.setText("Import MIB File...");
        this._$20953.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BasicImportPanel.this.importFromFile_actionPerformed(actionEvent);
            }
        });
        this._$20954.setText("Import \"enterprises\" from SNMPv2-SMI");
        this._$20955.setText("Select MIB to import root OID from: ");
        this._$20957.setText("Select root object identifier:");
        this._$20956.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                BasicImportPanel.this.rootModule_itemStateChanged(itemEvent);
            }
        });
        this._$20956.setMaximumSize(new Dimension(150, 21));
        this._$20959.setEnabled(false);
        this._$20959.setMinimumSize(new Dimension(100, 1));
        this._$20959.setToolTipText("Enter your IANA enterprise ID here");
        this._$20959.setDataProperties(new DataProperties(new JCLongValidator(null, new Long("0"), new Long("4294967295"), null, false, null, new Long("1"), "#,##0.###;-#,##0.###", false, false, false, null, new Long("1")), new MutableValueModel(Long.class, new Long("1")), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
        this.add((Component)this._$10072, new GridBagConstraints(0, 0, 4, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._$20952, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.add((Component)this._$20953, new GridBagConstraints(2, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._$20951, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 13, 2, new Insets(11, 10, 9, 0), 0, 0));
        this.add((Component)this._$20954, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._$20955, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._$20956, new GridBagConstraints(2, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._$20957, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._$20958, new GridBagConstraints(2, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this._$20959, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 17, 3, new Insets(10, 10, 10, 10), 0, 0));
    }

    public boolean isRegistrationModule() {
        return this._$20951.isSelected();
    }

    public long getEnterpriseNumber() {
        this._$20959.commitEdit();
        return ((Number)this._$20959.getValue()).longValue();
    }

    void importFromFile_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray = new File[]{};
        JFileChooser jFileChooser = new JFileChooser();
        File file = new File(this._$290.get("MIBListPath", ""));
        jFileChooser.setSelectedFile(file);
        jFileChooser.setFileSelectionMode(2);
        if (jFileChooser.showOpenDialog(this._$296) == 0) {
            this._$290.put("MIBListPath", jFileChooser.getSelectedFile().getPath());
            if (jFileChooser.getSelectedFile().isDirectory()) {
                Vector vector = FileUtilities.getSubtree(jFileChooser.getSelectedFile());
                objectArray = new File[vector.size()];
                vector.copyInto(objectArray);
            } else {
                objectArray = new File[]{jFileChooser.getSelectedFile()};
            }
            if (objectArray.length == 0) {
                this.setMessage("No files found in given list!");
            } else {
                MIBCompiler.compileMIBs(this._$290, this, this._$296, this._$294, (File[])objectArray, this, true, MIBCompiler.UpdateMode.updateAlways, false, true);
                this.initModules();
            }
        }
    }

    public void setMessage(String string) {
        if (string.startsWith("Successfully")) {
            JOptionPane.showMessageDialog(this, string, "Import Success", 1);
        } else {
            JOptionPane.showMessageDialog(this, string, "Import Error", 0);
        }
    }

    public String getMessage() {
        return "";
    }

    public void moduleEvent(MIBModuleEvent mIBModuleEvent) {
        switch (mIBModuleEvent.getAction()) {
            case 1: {
                Vector vector = mIBModuleEvent.getModules();
                for (int i = 0; i < vector.size(); ++i) {
                    this._$20956.addItem(vector.get(i));
                }
                break;
            }
        }
    }

    void importEnterprises_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this._$20956.setEnabled(false);
            this._$20958.setEnabled(false);
            this._$20953.setEnabled(false);
            this._$20956.setSelectedItem("SNMPv2-SMI");
            this._$20958.setSelectedItem("enterprises");
            this._$20959.setEnabled(true);
        } else {
            this._$20953.setEnabled(true);
            this._$20959.setEnabled(false);
            this._$20959.setValue(new Long(1L));
            this._$20956.setEnabled(true);
            this._$20958.setEnabled(true);
            this.initModules();
        }
        this.fireUpdateWizardState(new WizardEvent(this, this.isReady(), this.isReady()));
    }

    public String getModuleName() {
        return (String)this._$20956.getSelectedItem();
    }

    public String getRootOID() {
        return (String)this._$20958.getSelectedItem();
    }

    private void _$20964(String string) {
        this._$20958.removeAllItems();
        try {
            MIBObject[] mIBObjectArray = this._$294.getObjects(string);
            for (int i = 0; i < mIBObjectArray.length; ++i) {
                if (!mIBObjectArray[i].getClass().equals(class$com$agentpp$mib$MIBObject == null ? BasicImportPanel.class$("com.agentpp.mib.MIBObject") : class$com$agentpp$mib$MIBObject) && (!(mIBObjectArray[i] instanceof MIBModule) || ((MIBModule)mIBObjectArray[i]).getSMIVersion() <= 1)) continue;
                this._$20958.addItem(mIBObjectArray[i].getName());
            }
        }
        catch (Exception exception) {
            this.setMessage(exception.getMessage());
        }
    }

    void rootModule_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this._$20964((String)itemEvent.getItem());
        }
        this.fireUpdateWizardState(new WizardEvent(this, this.isReady(), this.isReady()));
    }

    public boolean isReady() {
        return this._$20956.getSelectedItem() != null && this._$20958.getSelectedItem() != null || this._$20951.isSelected();
    }

    public synchronized void removeWizardListener(WizardListener wizardListener) {
        if (this._$10250 != null && this._$10250.contains(wizardListener)) {
            Vector vector = (Vector)this._$10250.clone();
            vector.removeElement(wizardListener);
            this._$10250 = vector;
        }
    }

    public synchronized void addWizardListener(WizardListener wizardListener) {
        Vector vector;
        Vector vector2 = vector = this._$10250 == null ? new Vector(2) : (Vector)this._$10250.clone();
        if (!vector.contains(wizardListener)) {
            vector.addElement(wizardListener);
            this._$10250 = vector;
        }
    }

    protected void fireUpdateWizardState(WizardEvent wizardEvent) {
        if (this._$10250 != null) {
            Vector vector = this._$10250;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((WizardListener)vector.elementAt(i)).updateWizardState(wizardEvent);
            }
        }
    }

    protected void firePack() {
        if (this._$10250 != null) {
            Vector vector = this._$10250;
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                ((WizardListener)vector.elementAt(i)).pack();
            }
        }
    }
}

