/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.spelling;

import com.wintertree.ssce.EditableLexicon;
import com.wintertree.ssce.FileTextLexicon;
import com.wintertree.ssce.SpellingSession;
import com.wintertree.util.MessageBox;
import com.wintertree.util.Sort;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JUserDictionaryDlg
extends JDialog {
    boolean frameSizeAdjusted = false;
    JLabel JLabel1 = new JLabel();
    JLabel JLabel2 = new JLabel();
    JTextField otherWordTextFld = new JTextField();
    JPanel JPanel1 = new JPanel();
    JLabel JLabel3 = new JLabel();
    JRadioButton ignoreRb = new JRadioButton();
    JRadioButton autoChangeCheckWordRb = new JRadioButton();
    JRadioButton autoChangeOtherWordRb = new JRadioButton();
    JRadioButton condChangeCheckWordRb = new JRadioButton();
    JRadioButton condChangeOtherWordRb = new JRadioButton();
    JRadioButton excludeRb = new JRadioButton();
    JButton addWordBtn = new JButton();
    JButton deleteWordBtn = new JButton();
    JButton doneBtn = new JButton();
    JTextField wordTextFld = new JTextField();
    JScrollPane JScrollPane1 = new JScrollPane();
    JList wordList = new JList();
    DefaultListModel wordListModel;
    protected EditableLexicon lexicon;
    public boolean debug = false;

    public JUserDictionaryDlg(Frame frame, FileTextLexicon fileTextLexicon) {
        super(frame, true);
        this.setTitle("Edit user dictionary");
        this.getContentPane().setLayout(null);
        this.setSize(486, 312);
        this.setVisible(false);
        this.JLabel1.setText("Words:");
        this.getContentPane().add(this.JLabel1);
        this.JLabel1.setBounds(8, 8, 232, 16);
        this.JLabel2.setText("Other word:");
        this.getContentPane().add(this.JLabel2);
        this.JLabel2.setBounds(248, 8, 217, 19);
        this.getContentPane().add(this.otherWordTextFld);
        this.otherWordTextFld.setBounds(248, 24, 224, 24);
        this.JPanel1.setLayout(null);
        this.getContentPane().add(this.JPanel1);
        this.JPanel1.setBounds(8, 120, 464, 137);
        this.JLabel3.setText("Action");
        this.JPanel1.add(this.JLabel3);
        this.JLabel3.setBounds(8, 8, 36, 15);
        this.ignoreRb.setText("Ignore (skip)");
        this.ignoreRb.setActionCommand("Ignore (skip)");
        this.JPanel1.add(this.ignoreRb);
        this.ignoreRb.setFont(new Font("Dialog", 0, 12));
        this.ignoreRb.setBounds(8, 24, 440, 24);
        this.autoChangeCheckWordRb.setText("Auto change, using case of checked word");
        this.autoChangeCheckWordRb.setActionCommand("Auto change, using case of checked word");
        this.JPanel1.add(this.autoChangeCheckWordRb);
        this.autoChangeCheckWordRb.setFont(new Font("Dialog", 0, 12));
        this.autoChangeCheckWordRb.setBounds(8, 41, 440, 24);
        this.autoChangeOtherWordRb.setText("Auto change, using case of other word");
        this.autoChangeOtherWordRb.setActionCommand("Auto change, using case of other word");
        this.JPanel1.add(this.autoChangeOtherWordRb);
        this.autoChangeOtherWordRb.setFont(new Font("Dialog", 0, 12));
        this.autoChangeOtherWordRb.setBounds(8, 58, 440, 24);
        this.condChangeCheckWordRb.setText("Conditionally change, using case of checked word");
        this.condChangeCheckWordRb.setActionCommand("Conditionally change, using case of checked word");
        this.JPanel1.add(this.condChangeCheckWordRb);
        this.condChangeCheckWordRb.setFont(new Font("Dialog", 0, 12));
        this.condChangeCheckWordRb.setBounds(8, 75, 440, 24);
        this.condChangeOtherWordRb.setText("Conditionally change, using case of other word");
        this.condChangeOtherWordRb.setActionCommand("Conditionally change, using case of other word");
        this.JPanel1.add(this.condChangeOtherWordRb);
        this.condChangeOtherWordRb.setFont(new Font("Dialog", 0, 12));
        this.condChangeOtherWordRb.setBounds(8, 92, 440, 24);
        this.excludeRb.setText("Exclude (treat as misspelled)");
        this.excludeRb.setActionCommand("Exclude (treat as misspelled)");
        this.JPanel1.add(this.excludeRb);
        this.excludeRb.setFont(new Font("Dialog", 0, 12));
        this.excludeRb.setBounds(8, 109, 440, 24);
        this.addWordBtn.setText("Add word");
        this.addWordBtn.setActionCommand("Add word");
        this.getContentPane().add(this.addWordBtn);
        this.addWordBtn.setFont(new Font("Dialog", 0, 12));
        this.addWordBtn.setBounds(248, 56, 104, 32);
        this.deleteWordBtn.setText("Delete word");
        this.deleteWordBtn.setActionCommand("Delete word");
        this.getContentPane().add(this.deleteWordBtn);
        this.deleteWordBtn.setFont(new Font("Dialog", 0, 12));
        this.deleteWordBtn.setBounds(368, 56, 104, 32);
        this.doneBtn.setText("Done");
        this.doneBtn.setActionCommand("Done");
        this.getContentPane().add(this.doneBtn);
        this.doneBtn.setFont(new Font("Dialog", 0, 12));
        this.doneBtn.setBounds(197, 272, 91, 29);
        this.getContentPane().add(this.wordTextFld);
        this.wordTextFld.setBounds(8, 24, 228, 24);
        this.JScrollPane1.setOpaque(true);
        this.getContentPane().add(this.JScrollPane1);
        this.JScrollPane1.setBounds(8, 48, 228, 64);
        this.JScrollPane1.getViewport().add(this.wordList);
        this.wordList.setBounds(0, 0, 225, 61);
        SymAction symAction = new SymAction();
        this.addWordBtn.addActionListener(symAction);
        this.deleteWordBtn.addActionListener(symAction);
        this.doneBtn.addActionListener(symAction);
        SymListSelection symListSelection = new SymListSelection();
        this.wordList.addListSelectionListener(symListSelection);
        this.wordListModel = new DefaultListModel();
        this.wordList.setModel(this.wordListModel);
        this.lexicon = fileTextLexicon;
        this.lexiconChanged();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.ignoreRb);
        buttonGroup.add(this.autoChangeCheckWordRb);
        buttonGroup.add(this.autoChangeOtherWordRb);
        buttonGroup.add(this.condChangeCheckWordRb);
        buttonGroup.add(this.condChangeOtherWordRb);
        buttonGroup.add(this.excludeRb);
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
        }
        super.setVisible(bl);
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    void addWordBtn_actionPerformed(ActionEvent actionEvent) {
        int n = this.autoChangeCheckWordRb.isSelected() ? 65 : (this.autoChangeOtherWordRb.isSelected() ? 97 : (this.condChangeCheckWordRb.isSelected() ? 67 : (this.condChangeOtherWordRb.isSelected() ? 99 : (this.excludeRb.isSelected() ? 101 : 105))));
        try {
            this.lexicon.addWord(SpellingSession.stripPossessives(this.wordTextFld.getText()), n, SpellingSession.stripPossessives(this.otherWordTextFld.getText()));
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println(exception);
            }
            MessageBox.createMessageBox("Edit dictionary", "Error adding word: " + exception);
            return;
        }
        this.lexiconChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteWordBtn_actionPerformed(ActionEvent actionEvent) {
        try {
            this.lexicon.deleteWord(this.wordTextFld.getText());
        }
        catch (Exception exception) {
            if (this.debug) {
                System.out.println(exception);
            }
            MessageBox.createMessageBox("Edit dictionary", "Error deleting word: " + exception);
            return;
        }
        finally {
            this.lexiconChanged();
        }
    }

    void doneBtn_actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    void wordList_valueChanged(ListSelectionEvent listSelectionEvent) {
        this.wordListSelectionChanged();
    }

    protected void lexiconChanged() {
        int n = this.wordList.getSelectedIndex();
        this.wordListModel.clear();
        String[] stringArray = new String[this.lexicon.size()];
        int n2 = 0;
        Enumeration enumeration = this.lexicon.words();
        while (enumeration.hasMoreElements()) {
            stringArray[n2++] = (String)enumeration.nextElement();
        }
        Sort.ascending(stringArray);
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            this.wordListModel.addElement(stringArray[n2]);
        }
        if (n < 0) {
            n = 0;
        }
        if (n >= this.wordListModel.size()) {
            n = this.wordListModel.size() - 1;
        }
        if (n >= 0) {
            this.wordList.setSelectedIndex(n);
            this.wordListSelectionChanged();
        }
    }

    protected void wordListSelectionChanged() {
        String string = (String)this.wordList.getSelectedValue();
        if (string != null) {
            this.wordTextFld.setText(string);
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.lexicon.findWord(string, true, stringBuffer);
            switch (n) {
                case 65: {
                    this.autoChangeCheckWordRb.setSelected(true);
                    break;
                }
                case 97: {
                    this.autoChangeOtherWordRb.setSelected(true);
                    break;
                }
                case 67: {
                    this.condChangeCheckWordRb.setSelected(true);
                    break;
                }
                case 99: {
                    this.condChangeOtherWordRb.setSelected(true);
                    break;
                }
                case 101: {
                    this.excludeRb.setSelected(true);
                    break;
                }
                default: {
                    this.ignoreRb.setSelected(true);
                }
            }
            this.otherWordTextFld.setText(stringBuffer.toString());
        } else {
            this.wordTextFld.setText("");
            this.otherWordTextFld.setText("");
        }
    }

    class SymListSelection
    implements ListSelectionListener {
        SymListSelection() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object = listSelectionEvent.getSource();
            if (object == JUserDictionaryDlg.this.wordList) {
                JUserDictionaryDlg.this.wordList_valueChanged(listSelectionEvent);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JUserDictionaryDlg.this.addWordBtn) {
                JUserDictionaryDlg.this.addWordBtn_actionPerformed(actionEvent);
            } else if (object == JUserDictionaryDlg.this.deleteWordBtn) {
                JUserDictionaryDlg.this.deleteWordBtn_actionPerformed(actionEvent);
            } else if (object == JUserDictionaryDlg.this.doneBtn) {
                JUserDictionaryDlg.this.doneBtn_actionPerformed(actionEvent);
            }
        }
    }
}

