/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.spelling;

import com.agentpp.designer.spelling.JTextAreaWordParser;
import com.agentpp.designer.spelling.UndoRecord;
import com.wintertree.ssce.FileTextLexicon;
import com.wintertree.ssce.Lexicon;
import com.wintertree.ssce.MemTextLexicon;
import com.wintertree.ssce.SpellingSession;
import com.wintertree.ssce.SuggestionSet;
import com.wintertree.ssce.TypographicalComparator;
import com.wintertree.ssce.WordComparator;
import com.wintertree.ssce.WordParser;
import com.wintertree.util.MessageBox;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Stack;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JSpellCheckDlg
extends JDialog {
    public int minSuggestDepth;
    protected boolean canceled;
    protected WordComparator comparator;
    protected boolean firstTime = true;
    protected WordParser parser;
    protected SpellingSession speller;
    private boolean _$24291;
    private int _$24292;
    DefaultListModel suggestionListModel;
    private String _$24308;
    private Timer _$24287;
    private Stack _$24295;
    Vector userLexVec;
    public boolean debug = false;
    boolean frameSizeAdjusted = false;
    JLabel problemLabel = new JLabel();
    JTextField problemTextFld = new JTextField();
    JLabel JLabel2 = new JLabel();
    JLabel JLabel3 = new JLabel();
    JButton undoButton = new JButton();
    JButton ignoreButton = new JButton();
    JButton ignoreAllButton = new JButton();
    JButton changeButton = new JButton();
    JButton changeAllButton = new JButton();
    JButton suggestButton = new JButton();
    JButton addButton = new JButton();
    JButton cancelButton = new JButton();
    JLabel JLabel1 = new JLabel();
    JTextField changeToTextFld = new JTextField();
    JScrollPane JScrollPane1 = new JScrollPane();
    JList suggestionList = new JList();
    JScrollPane JScrollPane2 = new JScrollPane();
    JTextArea contextTextArea = new JTextArea();
    JScrollPane JScrollPane3 = new JScrollPane();
    JList userDictList = new JList();

    protected JSpellCheckDlg(Frame frame) {
        super(frame, true);
        this.setTitle("Check Spelling");
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.setSize(497, 337);
        this.setVisible(false);
        this.problemLabel.setText("Not in dictionary:");
        this.getContentPane().add(this.problemLabel);
        this.problemLabel.setFont(new Font("Dialog", 0, 12));
        this.problemLabel.setBounds(8, 8, 288, 12);
        this.problemTextFld.setToolTipText("The misspelled word");
        this.getContentPane().add(this.problemTextFld);
        this.problemTextFld.setBounds(8, 24, 372, 24);
        this.JLabel2.setText("Suggestions:");
        this.getContentPane().add(this.JLabel2);
        this.JLabel2.setFont(new Font("Dialog", 0, 12));
        this.JLabel2.setBounds(8, 96, 372, 16);
        this.JLabel3.setText("Add words to:");
        this.getContentPane().add(this.JLabel3);
        this.JLabel3.setFont(new Font("Dialog", 0, 12));
        this.JLabel3.setBounds(8, 176, 372, 24);
        this.undoButton.setText("Undo");
        this.undoButton.setActionCommand("Undo");
        this.undoButton.setToolTipText("Undo the last change");
        this.getContentPane().add(this.undoButton);
        this.undoButton.setFont(new Font("Dialog", 0, 12));
        this.undoButton.setBounds(392, 200, 96, 24);
        this.ignoreButton.setText("Ignore");
        this.ignoreButton.setActionCommand("Ignore");
        this.ignoreButton.setToolTipText("Ignore this occurrence of the word.");
        this.getContentPane().add(this.ignoreButton);
        this.ignoreButton.setFont(new Font("Dialog", 0, 12));
        this.ignoreButton.setBounds(392, 8, 96, 24);
        this.ignoreAllButton.setText("Ignore All");
        this.ignoreAllButton.setActionCommand("Ignore All");
        this.ignoreAllButton.setToolTipText("Ignore this and all further occurrences of the word.");
        this.getContentPane().add(this.ignoreAllButton);
        this.ignoreAllButton.setFont(new Font("Dialog", 0, 12));
        this.ignoreAllButton.setBounds(392, 40, 96, 24);
        this.changeButton.setText("Change");
        this.changeButton.setActionCommand("Change");
        this.changeButton.setToolTipText("Change this occurrence of the word.");
        this.getContentPane().add(this.changeButton);
        this.changeButton.setFont(new Font("Dialog", 0, 12));
        this.changeButton.setBounds(392, 72, 96, 24);
        this.changeAllButton.setText("Change All");
        this.changeAllButton.setActionCommand("Change All");
        this.changeAllButton.setToolTipText("Change this and all further occurrences of the word.");
        this.getContentPane().add(this.changeAllButton);
        this.changeAllButton.setFont(new Font("Dialog", 0, 12));
        this.changeAllButton.setBounds(392, 104, 96, 24);
        this.suggestButton.setText("Suggest");
        this.suggestButton.setActionCommand("Suggest");
        this.suggestButton.setToolTipText("Look for better suggestions.");
        this.getContentPane().add(this.suggestButton);
        this.suggestButton.setFont(new Font("Dialog", 0, 12));
        this.suggestButton.setBounds(392, 136, 96, 24);
        this.addButton.setText("Add");
        this.addButton.setActionCommand("Add");
        this.addButton.setToolTipText("Add this word to the selected user dictionary.");
        this.getContentPane().add(this.addButton);
        this.addButton.setFont(new Font("Dialog", 0, 12));
        this.addButton.setBounds(392, 168, 96, 24);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand("Cancel");
        this.cancelButton.setToolTipText("Stop the spelling check.");
        this.getContentPane().add(this.cancelButton);
        this.cancelButton.setFont(new Font("Dialog", 0, 12));
        this.cancelButton.setBounds(392, 232, 96, 24);
        this.JLabel1.setText("Change to:");
        this.getContentPane().add(this.JLabel1);
        this.JLabel1.setFont(new Font("Dialog", 0, 12));
        this.JLabel1.setBounds(8, 48, 368, 24);
        this.changeToTextFld.setToolTipText("The word to replace the misspelled word.");
        this.getContentPane().add(this.changeToTextFld);
        this.changeToTextFld.setBounds(8, 72, 369, 25);
        this.JScrollPane1.setHorizontalScrollBarPolicy(31);
        this.JScrollPane1.setOpaque(true);
        this.getContentPane().add(this.JScrollPane1);
        this.JScrollPane1.setBounds(8, 112, 370, 70);
        this.suggestionList.setSelectionMode(0);
        this.suggestionList.setToolTipText("Suggested replacements for the misspelled word");
        this.JScrollPane1.getViewport().add(this.suggestionList);
        this.suggestionList.setBounds(0, 0, 367, 67);
        this.JScrollPane2.setOpaque(true);
        this.getContentPane().add(this.JScrollPane2);
        this.JScrollPane2.setBounds(8, 264, 483, 63);
        this.contextTextArea.setLineWrap(true);
        this.contextTextArea.setAutoscrolls(false);
        this.contextTextArea.setWrapStyleWord(true);
        this.contextTextArea.setEditable(false);
        this.JScrollPane2.getViewport().add(this.contextTextArea);
        this.contextTextArea.setBounds(0, 0, 480, 60);
        this.JScrollPane3.setOpaque(true);
        this.getContentPane().add(this.JScrollPane3);
        this.JScrollPane3.setBounds(8, 200, 372, 49);
        this.userDictList.setSelectionMode(0);
        this.userDictList.setToolTipText("Select the user dictionary words will be added to when the Add button is pressed.");
        this.userDictList.setVisibleRowCount(1);
        this.JScrollPane3.getViewport().add(this.userDictList);
        this.userDictList.setBounds(0, 0, 369, 46);
        SymAction symAction = new SymAction();
        this.ignoreButton.addActionListener(symAction);
        this.ignoreAllButton.addActionListener(symAction);
        this.changeButton.addActionListener(symAction);
        this.changeAllButton.addActionListener(symAction);
        this.suggestButton.addActionListener(symAction);
        this.addButton.addActionListener(symAction);
        this.cancelButton.addActionListener(symAction);
        this.undoButton.addActionListener(symAction);
        SymListSelection symListSelection = new SymListSelection();
        this.suggestionList.addListSelectionListener(symListSelection);
        this.suggestionListModel = new DefaultListModel();
        this.suggestionList.setModel(this.suggestionListModel);
        this._$24287 = new Timer(250, symAction);
        this._$24287.setRepeats(false);
    }

    public JSpellCheckDlg(Frame frame, SpellingSession spellingSession, WordParser wordParser, WordComparator wordComparator, FileTextLexicon[] fileTextLexiconArray) {
        this(frame);
        this.canceled = false;
        this.speller = spellingSession;
        this.parser = wordParser;
        if (wordComparator == null) {
            wordComparator = new TypographicalComparator();
        }
        this.comparator = wordComparator;
        this._$24291 = false;
        this.minSuggestDepth = 10;
        this._$24292 = 0;
        this.userLexVec = new Vector();
        if (fileTextLexiconArray != null) {
            for (int i = 0; i < fileTextLexiconArray.length; ++i) {
                if (fileTextLexiconArray[i] == null) continue;
                this.userLexVec.addElement(fileTextLexiconArray[i].getFileName());
            }
        }
        this.userDictList.setListData(this.userLexVec);
        if (fileTextLexiconArray != null && fileTextLexiconArray.length > 0) {
            this.userDictList.setSelectedIndex(0);
        }
        this._$24295 = new Stack();
        this.contextTextArea.setEnabled(false);
    }

    public JSpellCheckDlg(Frame frame, SpellingSession spellingSession, String string, WordComparator wordComparator, FileTextLexicon[] fileTextLexiconArray) {
        this(frame);
        this.canceled = false;
        this.speller = spellingSession;
        this.contextTextArea.setText(string);
        this.parser = new JTextAreaWordParser(this.contextTextArea, spellingSession.getOption(4096), false);
        if (wordComparator == null) {
            wordComparator = new TypographicalComparator();
        }
        this.comparator = wordComparator;
        this._$24291 = false;
        this.minSuggestDepth = 10;
        this._$24292 = 0;
        this.userLexVec = new Vector();
        for (int i = 0; i < fileTextLexiconArray.length; ++i) {
            this.userLexVec.addElement(fileTextLexiconArray[i].getFileName());
        }
        this.userDictList.setListData(this.userLexVec);
        this._$24295 = new Stack();
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setLocation(50, 50);
            this._$24287.start();
        }
        super.setVisible(bl);
    }

    public String getText() {
        if (this.contextTextArea != null) {
            return this.contextTextArea.getText();
        }
        return null;
    }

    public boolean userCanceled() {
        return this.canceled;
    }

    public void addNotify() {
        Dimension dimension = this.getSize();
        super.addNotify();
        if (this.frameSizeAdjusted) {
            return;
        }
        this.frameSizeAdjusted = true;
        Insets insets = this.getInsets();
        this.setSize(insets.left + insets.right + dimension.width, insets.top + insets.bottom + dimension.height);
    }

    protected void busy(boolean bl) {
        if (bl) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    protected void changeWord() {
        if (this.debug) {
            System.out.println("replacing " + this.parser.getWord() + " with " + this.changeToTextFld.getText());
        }
        this.contextTextArea.setEditable(true);
        this.parser.replaceWord(this.changeToTextFld.getText());
        this.contextTextArea.setEditable(false);
        UndoRecord undoRecord = new UndoRecord();
        undoRecord.offset = this.parser.getCursor();
        undoRecord.origText = this.problemTextFld.getText();
        undoRecord.newText = this.changeToTextFld.getText();
        this._$24295.push(undoRecord);
    }

    protected void deleteWord() {
        if (this.debug) {
            System.out.println("deleting " + this.parser.getWord());
        }
        StringBuffer stringBuffer = new StringBuffer();
        this.contextTextArea.setEditable(true);
        int n = this.parser.deleteWord(stringBuffer);
        this.contextTextArea.setEditable(false);
        UndoRecord undoRecord = new UndoRecord();
        undoRecord.offset = n;
        undoRecord.origText = stringBuffer.toString();
        undoRecord.newText = "";
        this._$24295.push(undoRecord);
    }

    protected FileTextLexicon findLex(String string) {
        Lexicon[] lexiconArray = this.speller.getLexicons();
        if (lexiconArray == null) {
            return null;
        }
        for (int i = 0; i < lexiconArray.length; ++i) {
            FileTextLexicon fileTextLexicon;
            if (!(lexiconArray[i] instanceof FileTextLexicon) || !(fileTextLexicon = (FileTextLexicon)lexiconArray[i]).getFileName().equals(string)) continue;
            return fileTextLexicon;
        }
        return null;
    }

    protected int getSuggestions() {
        int n;
        SuggestionSet suggestionSet = new SuggestionSet(16);
        this.busy(true);
        this.speller.suggest(this.problemTextFld.getText(), this._$24292, this.comparator, suggestionSet);
        this.suggestionListModel.clear();
        for (n = 0; n < suggestionSet.size(); ++n) {
            this.suggestionListModel.addElement(suggestionSet.wordAt(n));
        }
        this.busy(false);
        return n;
    }

    protected MemTextLexicon getTempLex() {
        Lexicon[] lexiconArray = this.speller.getLexicons();
        if (lexiconArray == null) {
            return null;
        }
        for (int i = 0; i < lexiconArray.length; ++i) {
            if (!(lexiconArray[i] instanceof MemTextLexicon)) continue;
            return (MemTextLexicon)lexiconArray[i];
        }
        return null;
    }

    protected boolean runChecker() {
        int n;
        Vector vector = new Vector();
        this.problemTextFld.setText("");
        this.changeToTextFld.setText("");
        this.changeButton.setText("Change");
        this._$24291 = false;
        this._$24308 = "";
        this.updateUI();
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 5;
        int n4 = -1;
        int n5 = 0;
        do {
            this.busy(true);
            n = this.speller.check(this.parser, stringBuffer);
            this.busy(false);
            if (this.debug) {
                System.out.println("runChecker: check result: " + n + " word: " + (this.parser.hasMoreElements() ? this.parser.getWord() : "(none)") + " replWord: " + stringBuffer.toString());
            }
            if ((n & 1) != 0) {
                int n6 = this.parser.getCursor();
                n2 = n6 >= n4 && n6 < n4 + n5 ? ++n2 : 0;
                if (n2 >= n3) {
                    this.parser.nextWord();
                } else {
                    this.problemTextFld.setText(this.parser.getWord());
                    this.changeToTextFld.setText(stringBuffer.toString());
                    this.changeWord();
                    n4 = n6;
                    n5 = stringBuffer.length();
                }
            }
        } while ((n & 1) != 0);
        if ((n & 8) != 0) {
            this.setVisible(false);
            this.dispose();
            return false;
        }
        this.parser.highlightWord();
        if ((n & 2) != 0) {
            this.problemLabel.setText("Consider changing:");
            this.problemTextFld.setText(this.parser.getWord());
            this.changeToTextFld.setText(stringBuffer.toString());
            this._$24292 = this.minSuggestDepth;
            this.getSuggestions();
            this.updateUI();
        } else if ((n & 0x80) != 0) {
            this.problemLabel.setText("Capitalization:");
            this.problemTextFld.setText(this.parser.getWord());
            this.changeToTextFld.setText(stringBuffer.toString());
            this.updateUI();
        } else if ((n & 4) != 0) {
            this.problemLabel.setText("Doubled word:");
            this.problemTextFld.setText(this.parser.getWord());
            this.changeToTextFld.setText("");
            this._$24291 = true;
            this.updateUI();
        } else if ((n & 0x20) != 0) {
            this.problemLabel.setText("Mixed case:");
            this.problemTextFld.setText(this.parser.getWord());
            this.changeToTextFld.setText(stringBuffer.toString());
            this.updateUI();
        } else if ((n & 0x40) != 0) {
            this.problemLabel.setText("Contains digits:");
            this.problemTextFld.setText(this.parser.getWord());
            this.changeToTextFld.setText(stringBuffer.toString());
            this.updateUI();
        } else if ((n & 0x10) != 0) {
            this.problemLabel.setText("Not in dictionary:");
            this.problemTextFld.setText(this.parser.getWord());
            this.changeToTextFld.setText(stringBuffer.toString());
            this._$24292 = this.minSuggestDepth;
            if (this.getSuggestions() > 0) {
                this.changeToTextFld.setText((String)this.suggestionListModel.getElementAt(0));
            }
            this.updateUI();
        }
        return true;
    }

    public void undo() {
        StringBuffer stringBuffer;
        MemTextLexicon memTextLexicon;
        UndoRecord undoRecord = (UndoRecord)this._$24295.pop();
        this.parser.setCursor(undoRecord.offset);
        if (undoRecord.newText.length() > 0) {
            this.contextTextArea.setEditable(true);
            this.parser.deleteText(undoRecord.newText.length());
            this.contextTextArea.setEditable(false);
        }
        if (undoRecord.origText.length() > 0) {
            this.contextTextArea.setEditable(true);
            this.parser.insertText(undoRecord.offset, undoRecord.origText);
            this.contextTextArea.setEditable(false);
        }
        if ((memTextLexicon = this.getTempLex()) != null && memTextLexicon.findWord(undoRecord.origText, true, stringBuffer = new StringBuffer()) == 65) {
            try {
                memTextLexicon.deleteWord(undoRecord.origText);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void updateUI() {
        if (!this.problemTextFld.getText().equals(this._$24308)) {
            this._$24292 = this.minSuggestDepth;
        }
        this.changeToTextFld.setEnabled(this._$24291 == false);
        this.ignoreButton.setEnabled(true);
        this.ignoreAllButton.setEnabled(this._$24291 == false && this.getTempLex() != null);
        if (this._$24291) {
            this.changeButton.setText("Delete");
        } else {
            this.changeButton.setText("Change");
        }
        this.changeButton.setEnabled(true);
        this.changeAllButton.setEnabled(this._$24291 == false && this.getTempLex() != null);
        var1_1 = this.userDictList.getModel();
        this.addButton.setEnabled(this._$24291 == false && var1_1.getSize() > 0);
        if (this._$24291) ** GOTO lbl-1000
        if (this._$24292 < 100 && this.problemTextFld.getText().length() > 0) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.suggestButton.setEnabled(v0);
        this.cancelButton.setEnabled(true);
        this.undoButton.setEnabled(this._$24295.empty() == false);
    }

    void ignoreButton_actionPerformed(ActionEvent actionEvent) {
        this.parser.nextWord();
        this.runChecker();
    }

    void ignoreAllButton_actionPerformed(ActionEvent actionEvent) {
        MemTextLexicon memTextLexicon = this.getTempLex();
        String string = this.problemTextFld.getText();
        if (this.speller.getOption(16384)) {
            string = SpellingSession.stripPossessives(string);
        }
        try {
            memTextLexicon.addWord(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.runChecker();
    }

    void changeButton_actionPerformed(ActionEvent actionEvent) {
        if (this._$24291) {
            this.deleteWord();
        } else {
            this.changeWord();
        }
        this.runChecker();
    }

    void changeAllButton_actionPerformed(ActionEvent actionEvent) {
        if (!this.problemTextFld.getText().equals(this.changeToTextFld.getText())) {
            MemTextLexicon memTextLexicon = this.getTempLex();
            String string = this.problemTextFld.getText();
            String string2 = this.changeToTextFld.getText();
            if (this.speller.getOption(16384)) {
                string = SpellingSession.stripPossessives(string);
                string2 = SpellingSession.stripPossessives(string2);
            }
            if (memTextLexicon != null) {
                try {
                    memTextLexicon.addWord(string, 65, string2);
                }
                catch (Exception exception) {
                    MessageBox.createMessageBox(this.getTitle(), "Error saving word: " + exception);
                }
            }
        }
        this.runChecker();
    }

    void suggestButton_actionPerformed(ActionEvent actionEvent) {
        this._$24308 = this.problemTextFld.getText();
        if (this.getSuggestions() > 0) {
            this.changeToTextFld.setText((String)this.suggestionListModel.getElementAt(0));
        }
        this._$24292 += 10;
        this.updateUI();
    }

    void addButton_actionPerformed(ActionEvent actionEvent) {
        FileTextLexicon fileTextLexicon;
        int n;
        if (this.userDictList.getModel().getSize() == 0) {
            // empty if block
        }
        if ((n = this.userDictList.getSelectedIndex()) < 0) {
            n = 0;
        }
        if ((fileTextLexicon = this.findLex((String)this.userDictList.getModel().getElementAt(n))) != null) {
            String string = this.problemTextFld.getText();
            if (this.speller.getOption(16384)) {
                string = SpellingSession.stripPossessives(string);
            }
            try {
                fileTextLexicon.addWord(string);
            }
            catch (Exception exception) {
                MessageBox.createMessageBox(this.getTitle(), "Error adding word to dictionary: " + exception);
            }
        }
        this.parser.nextWord();
        this.runChecker();
    }

    void cancelButton_actionPerformed(ActionEvent actionEvent) {
        this.canceled = true;
        this.setVisible(false);
        this.dispose();
    }

    void undoButton_actionPerformed(ActionEvent actionEvent) {
        this.undo();
        this.runChecker();
    }

    void checkStartDelayTimer_actionPerformed(ActionEvent actionEvent) {
        this.runChecker();
    }

    void suggestionList_valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.suggestionList.getSelectedIndex();
        if (n >= 0) {
            this.changeToTextFld.setText((String)this.suggestionListModel.getElementAt(n));
        }
    }

    class SymListSelection
    implements ListSelectionListener {
        SymListSelection() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            Object object = listSelectionEvent.getSource();
            if (object == JSpellCheckDlg.this.suggestionList) {
                JSpellCheckDlg.this.suggestionList_valueChanged(listSelectionEvent);
            }
        }
    }

    class SymAction
    implements ActionListener {
        SymAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == JSpellCheckDlg.this.ignoreButton) {
                JSpellCheckDlg.this.ignoreButton_actionPerformed(actionEvent);
            } else if (object == JSpellCheckDlg.this.ignoreAllButton) {
                JSpellCheckDlg.this.ignoreAllButton_actionPerformed(actionEvent);
            } else if (object == JSpellCheckDlg.this.changeButton) {
                JSpellCheckDlg.this.changeButton_actionPerformed(actionEvent);
            } else if (object == JSpellCheckDlg.this.changeAllButton) {
                JSpellCheckDlg.this.changeAllButton_actionPerformed(actionEvent);
            } else if (object == JSpellCheckDlg.this.suggestButton) {
                JSpellCheckDlg.this.suggestButton_actionPerformed(actionEvent);
            } else if (object == JSpellCheckDlg.this.addButton) {
                JSpellCheckDlg.this.addButton_actionPerformed(actionEvent);
            } else if (object == JSpellCheckDlg.this.cancelButton) {
                JSpellCheckDlg.this.cancelButton_actionPerformed(actionEvent);
            } else if (object == JSpellCheckDlg.this.undoButton) {
                JSpellCheckDlg.this.undoButton_actionPerformed(actionEvent);
            }
            if (object == JSpellCheckDlg.this._$24287) {
                JSpellCheckDlg.this.checkStartDelayTimer_actionPerformed(actionEvent);
            }
        }
    }
}

