/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.spelling;

import com.wintertree.ssce.EditableLexicon;
import com.wintertree.ssce.FileTextLexicon;
import com.wintertree.ssce.PropSpellingSession;
import com.wintertree.ssce.StringWordParser;
import com.wintertree.ssce.SuggestionSet;
import com.wintertree.util.UniCharacter;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.StyledDocument;

public class BackgroundChecker
implements DocumentListener,
CaretListener {
    protected boolean busy;
    protected JTextComponent component;
    protected int caretPos;
    protected Vector misspelledWords = new Vector();
    public boolean debug = false;
    protected Highlighter.HighlightPainter highlightPainter;
    protected PropSpellingSession sentry;
    protected EditableLexicon userDictionary;

    public BackgroundChecker(JTextComponent jTextComponent, PropSpellingSession propSpellingSession, Highlighter.HighlightPainter highlightPainter) {
        this.component = jTextComponent;
        this.sentry = propSpellingSession;
        this.highlightPainter = highlightPainter != null ? highlightPainter : new ZigZagHighlightPainter(Color.red);
        FileTextLexicon[] fileTextLexiconArray = propSpellingSession.getUserLexicons();
        this.userDictionary = fileTextLexiconArray != null ? fileTextLexiconArray[0] : null;
        this.caretPos = jTextComponent.getCaret().getDot();
        this.resume();
    }

    public BackgroundChecker(JTextComponent jTextComponent, PropSpellingSession propSpellingSession) {
        this(jTextComponent, propSpellingSession, null);
    }

    public void addMisspelledWord(String string, int n) throws BadLocationException {
        Object object = this.misspelledWords.elements();
        while (object.hasMoreElements()) {
            MisspelledWord misspelledWord = (MisspelledWord)object.nextElement();
            int n2 = misspelledWord.getOffset();
            int n3 = misspelledWord.getLen();
            if (n < misspelledWord.getOffset() || n >= misspelledWord.getOffset() + misspelledWord.getLen()) continue;
            misspelledWord.setLen(string.length());
            if (this.debug) {
                this._$7539("add.1");
            }
            return;
        }
        object = new MisspelledWord(string, n);
        this.misspelledWords.addElement(object);
        if (this.debug) {
            this._$7539("add.2");
        }
    }

    public void caretUpdate(CaretEvent caretEvent) {
        if (this.busy) {
            return;
        }
        this.busy = true;
        int n = caretEvent.getDot();
        if (n == this.caretPos) {
            this.busy = false;
            return;
        }
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.getWordAt(this.caretPos, stringBuffer);
        if (n2 >= 0 && (n < n2 || n > n2 + stringBuffer.length())) {
            bl = true;
        }
        if (n == this.caretPos + 1) {
            String string = null;
            try {
                string = this.component.getDocument().getText(this.caretPos - 1, 2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            if (string != null && this.isWordChar(string.charAt(0)) && !this.isWordChar(string.charAt(1))) {
                n2 = this.getWordAt(this.caretPos - 1, stringBuffer);
                bl = true;
            }
        }
        if (bl) {
            this.checkWord(stringBuffer.toString(), n2);
        }
        this.caretPos = n;
        this.busy = false;
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkWord(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = this.sentry.check(string, stringBuffer);
        if ((n2 & 1) != 0) {
            n2 &= ~1;
            n2 |= 2;
        }
        if ((n2 & 0x10) == 0) {
            if ((n2 & 2) == 0) {
                if (n2 != 0) return false;
                if (!this.isInMisspelledWord(n, n + string.length())) return false;
                this.removeMisspelledWord(n);
                return false;
            }
        }
        try {
            this.addMisspelledWord(string, n);
            return false;
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Can't happen!" + badLocationException);
            return false;
        }
    }

    public JPopupMenu createPopupMenu(int n, int n2, int n3, String string, String string2, String string3) {
        if (!this.isInWord(n, n2)) {
            return null;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        this.fillPopupMenu(jPopupMenu, n, n2, n3, string, string2, string3);
        return jPopupMenu;
    }

    public boolean fillPopupMenu(JPopupMenu jPopupMenu, int n, int n2, int n3, String string, String string2, String string3) {
        StringBuffer stringBuffer;
        Point point;
        TextUI textUI = this.component.getUI();
        int n4 = textUI.viewToModel(this.component, point = new Point(n, n2));
        int n5 = this.getWordAt(n4, stringBuffer = new StringBuffer());
        if (n5 < 0) {
            return false;
        }
        SuggestionSet suggestionSet = new SuggestionSet(n3);
        this.sentry.suggest(stringBuffer.toString(), this.sentry.getMinSuggestDepth(), this.sentry.getComparator(), suggestionSet);
        if (suggestionSet.size() > 0) {
            for (int i = 0; i < suggestionSet.size(); ++i) {
                jPopupMenu.add(new ReplaceWordAction(suggestionSet.wordAt(i), n5, stringBuffer.length()));
            }
            jPopupMenu.addSeparator();
        } else if (string3 != null) {
            JMenuItem jMenuItem = new JMenuItem(string3);
            jMenuItem.setEnabled(false);
            jPopupMenu.add(jMenuItem);
            jPopupMenu.addSeparator();
        }
        if (string != null) {
            jPopupMenu.add(new IgnoreAllAction(string, stringBuffer.toString()));
        }
        if (string2 != null && this.userDictionary != null) {
            jPopupMenu.add(new AddWordAction(string2, stringBuffer.toString()));
        }
        return true;
    }

    public Color getZigZagColor() {
        if (this.highlightPainter instanceof ZigZagHighlightPainter) {
            return ((ZigZagHighlightPainter)this.highlightPainter).getColor();
        }
        return Color.black;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        if (this.busy) {
            return;
        }
        this.busy = true;
        int n = documentEvent.getLength();
        int n2 = documentEvent.getOffset();
        if (n == 1) {
            int n3 = n2 - n;
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = -1;
            char c = '\u0000';
            char c2 = '\u0000';
            try {
                c = this.component.getText(n3, 1).charAt(0);
                c2 = this.component.getText(n2, 1).charAt(0);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            boolean bl = this.isWordChar(c);
            boolean bl2 = this.isWordChar(c2);
            boolean bl3 = false;
            int n5 = n2;
            if (bl2) {
                MisspelledWord misspelledWord;
                if (this.isInMisspelledWord(n3, n2)) {
                    bl3 = true;
                } else if (!this.isInMisspelledWord(n2) && (misspelledWord = this.findMisspelledWord(n2 + 1)) != null) {
                    bl3 = true;
                    try {
                        misspelledWord.setOffset(n2);
                    }
                    catch (BadLocationException badLocationException) {
                        System.err.println("Can't happen!: " + badLocationException);
                    }
                }
            } else if (bl) {
                n5 = n3;
                bl3 = true;
                char c3 = '\u0000';
                try {
                    c3 = this.component.getText(n2 + 1, 1).charAt(0);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                if (this.isWordChar(c3)) {
                    n4 = this.getWordAt(n2 + 1, stringBuffer);
                    this.checkWord(stringBuffer.toString(), n4);
                }
            }
            if (bl3) {
                n4 = this.getWordAt(n5, stringBuffer);
                this.checkWord(stringBuffer.toString(), n4);
            }
        } else {
            this.onInsertText(n2, n);
        }
        this.busy = false;
    }

    public boolean isInMisspelledWord(Point point) {
        TextUI textUI = this.component.getUI();
        int n = textUI.viewToModel(this.component, point);
        return this.isInMisspelledWord(n);
    }

    public void recheckAll() {
        String string = null;
        try {
            string = this.component.getDocument().getText(0, this.component.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Can't happen: " + badLocationException);
            return;
        }
        StringWordParser stringWordParser = new StringWordParser(string, !this.sentry.getOption(4096));
        while (stringWordParser.hasMoreElements()) {
            this.checkWord(stringWordParser.getWord(), stringWordParser.getCursor());
            stringWordParser.nextWord();
        }
    }

    public void removeMisspelledWord(int n) {
        boolean bl = false;
        Enumeration enumeration = this.misspelledWords.elements();
        while (enumeration.hasMoreElements()) {
            MisspelledWord misspelledWord = (MisspelledWord)enumeration.nextElement();
            int n2 = misspelledWord.getOffset();
            int n3 = misspelledWord.getLen();
            if (n < n2 || n >= n2 + n3) continue;
            misspelledWord.hide();
            this.misspelledWords.removeElement(misspelledWord);
            bl = true;
            break;
        }
        if (this.debug && !bl) {
            System.out.println("removeMisspelledWords: word at " + n + " not found");
        }
        if (this.debug) {
            this._$7539("remove");
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        if (this.busy) {
            return;
        }
        this.busy = true;
        int n = documentEvent.getLength();
        int n2 = documentEvent.getOffset();
        boolean bl = false;
        int n3 = n2;
        if (this.isInMisspelledWord(n2)) {
            bl = true;
        }
        if (n2 > 0 && this.isInMisspelledWord(n2 - 1)) {
            n3 = n2 - 1;
            bl = true;
        }
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer();
            int n4 = this.getWordAt(n3, stringBuffer);
            this.checkWord(stringBuffer.toString(), n4);
        }
        this.busy = false;
    }

    public void resume() {
        this.component.getDocument().addDocumentListener(this);
        this.component.addCaretListener(this);
    }

    public void setUserDictionary(EditableLexicon editableLexicon) {
        this.userDictionary = editableLexicon;
    }

    public void setZigZagColor(Color color) {
        if (this.highlightPainter instanceof ZigZagHighlightPainter) {
            ((ZigZagHighlightPainter)this.highlightPainter).setColor(color);
        }
    }

    public void stop() {
        this.component.getDocument().removeDocumentListener(this);
        this.component.removeCaretListener(this);
    }

    protected MisspelledWord findMisspelledWord(int n, int n2) {
        Enumeration enumeration = this.misspelledWords.elements();
        while (enumeration.hasMoreElements()) {
            MisspelledWord misspelledWord = (MisspelledWord)enumeration.nextElement();
            int n3 = misspelledWord.getOffset();
            int n4 = misspelledWord.getLen();
            if (!(n >= n3 && n < n3 + n4 || n2 >= n3 && n2 < n3 + n4 || n3 >= n && n3 <= n2) && (n3 + n4 - 1 < n || n3 + n4 - 1 > n2)) continue;
            return misspelledWord;
        }
        return null;
    }

    protected MisspelledWord findMisspelledWord(int n) {
        return this.findMisspelledWord(n, n);
    }

    protected int getWordAt(int n, StringBuffer stringBuffer) {
        char c;
        int n2;
        int n3;
        int n4;
        if (n < 0 || n >= this.component.getDocument().getLength()) {
            return -1;
        }
        int n5 = Math.max(0, n - 100);
        int n6 = Math.min(this.component.getDocument().getLength() - n5, 200);
        String string = "";
        try {
            string = this.component.getText(n5, n6);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Can't happen: " + badLocationException);
            return -1;
        }
        stringBuffer.setLength(0);
        int n7 = n - n5;
        if (!this.isWordChar(string.charAt(n7))) {
            return -1;
        }
        for (n4 = n7; n4 >= 0 && this.isWordChar(string.charAt(n4)); --n4) {
        }
        if (n4 < 0) {
            n4 = 0;
        }
        while (n4 < string.length() && !UniCharacter.isLetterOrDigit(string.charAt(n4))) {
            ++n4;
        }
        boolean bl = false;
        for (n3 = n4; n3 < string.length() && this.isWordChar(string.charAt(n3)); ++n3) {
            n2 = string.charAt(n3);
            stringBuffer.append((char)n2);
            if (n2 != 46 || n3 <= 0 || !UniCharacter.isLetterOrDigit(string.charAt(n3 - 1)) || n3 >= string.length() - 1 || !UniCharacter.isLetterOrDigit(string.charAt(n3 + 1))) continue;
            bl = true;
        }
        n3 = 0;
        if (bl) {
            n2 = 0;
            n3 = 1;
            for (c = '\u0000'; c < stringBuffer.length(); ++c) {
                if (UniCharacter.isLetterOrDigit(stringBuffer.charAt(c))) {
                    if (++n2 <= 2) continue;
                    n3 = 0;
                    break;
                }
                n2 = 0;
            }
        }
        n2 = 1;
        while (n2 != 0 && stringBuffer.length() > 0) {
            c = stringBuffer.charAt(stringBuffer.length() - 1);
            n2 = 0;
            if (UniCharacter.isApostrophe(c) && stringBuffer.length() > 1 && Character.toLowerCase(stringBuffer.charAt(stringBuffer.length() - 2)) != 's') {
                stringBuffer.setLength(stringBuffer.length() - 1);
                n2 = 1;
            }
            if (c != '.' || n3 != 0) continue;
            stringBuffer.setLength(stringBuffer.length() - 1);
            n2 = 1;
        }
        return n4 + n5;
    }

    protected boolean isInMisspelledWord(int n, int n2) {
        return this.findMisspelledWord(n, n2) != null;
    }

    protected boolean isInMisspelledWord(int n) {
        return this.isInMisspelledWord(n, n);
    }

    protected boolean isInWord(int n, int n2) {
        TextUI textUI = this.component.getUI();
        Point point = new Point(n, n2);
        int n3 = textUI.viewToModel(this.component, point);
        String string = null;
        try {
            string = this.component.getText(n3, 1);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return string != null && string.length() != 0 && this.isWordChar(string.charAt(0));
    }

    protected boolean isWordChar(char c) {
        return UniCharacter.isLetterOrDigit(c) || UniCharacter.isApostrophe(c) || c == '.';
    }

    protected void onInsertText(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        int n3 = this.getWordAt(n, stringBuffer);
        int n4 = this.getWordAt(n + n2 - 1, stringBuffer2);
        int n5 = n;
        int n6 = n + n2;
        if (n3 >= 0) {
            n5 = n3;
        }
        if (n4 >= 0) {
            n6 = n4 + stringBuffer2.length();
        }
        if (n3 >= 0 && n4 >= 0 && n3 == n4) {
            this.checkWord(stringBuffer.toString(), n3);
            return;
        }
        String string = null;
        try {
            string = this.component.getText(n5, n6 - n5);
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Can't happen! " + badLocationException);
            return;
        }
        StringWordParser stringWordParser = new StringWordParser(string, !this.sentry.getOption(4096));
        StringBuffer stringBuffer3 = new StringBuffer();
        while (true) {
            int n7 = this.sentry.check(stringWordParser, stringBuffer3);
            if (n7 == 8) break;
            this.checkWord(stringWordParser.getWord(), n + stringWordParser.getCursor());
            stringWordParser.nextWord();
        }
    }

    protected void recheckAll(String string) {
        String string2 = null;
        try {
            string2 = this.component.getDocument().getText(0, this.component.getDocument().getLength());
        }
        catch (BadLocationException badLocationException) {
            System.err.println("Can't happen: " + badLocationException);
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = string2.indexOf(string);
        while (n >= 0) {
            int n2 = this.getWordAt(n, stringBuffer);
            this.checkWord(stringBuffer.toString(), n2);
            n = string2.indexOf(string, n + string.length());
        }
    }

    private void _$7539(String string) {
        System.out.print(string + "(" + this.misspelledWords.size() + "): ");
        Enumeration enumeration = this.misspelledWords.elements();
        while (enumeration.hasMoreElements()) {
            MisspelledWord misspelledWord = (MisspelledWord)enumeration.nextElement();
            System.out.print("[" + misspelledWord.getOffset() + "," + misspelledWord.getLen() + "] ");
        }
        System.out.println();
    }

    class ReplaceWordAction
    extends AbstractAction {
        private int _$7535;
        private int _$3404;

        public ReplaceWordAction(String string, int n, int n2) {
            super(string);
            this._$3404 = n;
            this._$7535 = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BackgroundChecker.this.removeMisspelledWord(this._$3404);
            AttributeSet attributeSet = null;
            if (BackgroundChecker.this.component.getDocument() instanceof StyledDocument) {
                Element element = ((StyledDocument)BackgroundChecker.this.component.getDocument()).getCharacterElement(this._$3404);
                attributeSet = element.getAttributes();
            }
            try {
                BackgroundChecker.this.component.getDocument().remove(this._$3404, this._$7535);
                BackgroundChecker.this.component.getDocument().insertString(this._$3404, actionEvent.getActionCommand(), attributeSet);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class IgnoreAllAction
    extends AbstractAction {
        private String _$7530;

        public IgnoreAllAction(String string, String string2) {
            super(string);
            this._$7530 = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                BackgroundChecker.this.sentry.getTempLexicon().addWord(this._$7530);
            }
            catch (Exception exception) {
                System.err.println("Can't add " + this._$7530 + ": " + exception);
            }
            BackgroundChecker.this.recheckAll(this._$7530);
        }
    }

    class AddWordAction
    extends AbstractAction {
        private String _$7530;

        public AddWordAction(String string, String string2) {
            super(string);
            this._$7530 = string2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BackgroundChecker.this.userDictionary == null) {
                return;
            }
            try {
                EditableLexicon cfr_ignored_0 = BackgroundChecker.this.userDictionary;
                BackgroundChecker.this.userDictionary.addWord(this._$7530, 105, null);
            }
            catch (Exception exception) {
                System.err.println("Can't add " + this._$7530 + ": " + exception);
            }
            BackgroundChecker.this.recheckAll(this._$7530);
        }
    }

    protected class ZigZagHighlightPainter
    implements Highlighter.HighlightPainter {
        private static final int _$12725 = 3;
        protected Color color;

        public ZigZagHighlightPainter(Color color) {
            this.color = color;
        }

        public ZigZagHighlightPainter() {
            this(Color.red);
        }

        public Color getColor() {
            return this.color;
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            TextUI textUI = jTextComponent.getUI();
            try {
                Rectangle rectangle = textUI.modelToView(jTextComponent, n);
                Rectangle rectangle2 = textUI.modelToView(jTextComponent, n2);
                Rectangle rectangle3 = shape.getBounds();
                int n3 = rectangle.x;
                int n4 = rectangle2.x;
                int n5 = rectangle.y;
                int n6 = rectangle2.y;
                int n7 = n5 + rectangle.height - 3;
                int n8 = n6 + rectangle2.height - 3;
                graphics.setColor(this.color);
                if (n5 == n6) {
                    this.zigzag(graphics, n3, n4, n7);
                } else {
                    this.zigzag(graphics, n3, rectangle3.x + rectangle3.width - n3, n7);
                    for (int i = n7 + 1 + rectangle.height; i < n6; i += rectangle.height) {
                        this.zigzag(graphics, rectangle3.x, rectangle3.x + rectangle3.width, i - 1);
                    }
                    this.zigzag(graphics, rectangle3.x, n4, n8);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }

        public void setColor(Color color) {
            this.color = color;
        }

        protected void zigzag(Graphics graphics, int n, int n2, int n3) {
            for (int i = n; i < n2; i += 2) {
                graphics.drawLine(i, n3, Math.min(i + 3 - 1, n2), n3 + 3 - 1);
                graphics.drawLine(i += 2, n3 + 3 - 1, Math.min(i + 3 - 1, n2), n3);
            }
        }
    }

    class MisspelledWord {
        protected int len;
        protected Position pos;
        protected Object tag;

        public MisspelledWord(String string, int n) throws BadLocationException {
            this.pos = BackgroundChecker.this.component.getDocument().createPosition(n);
            this.tag = BackgroundChecker.this.component.getHighlighter().addHighlight(n, n + string.length(), BackgroundChecker.this.highlightPainter);
            this.len = string.length();
        }

        public int getLen() {
            return this.len;
        }

        public int getOffset() {
            return this.pos.getOffset();
        }

        public String getWord() {
            String string = "";
            try {
                string = BackgroundChecker.this.component.getText(this.pos.getOffset(), this.len);
            }
            catch (BadLocationException badLocationException) {
                System.err.println(badLocationException);
            }
            return string;
        }

        public void hide() {
            BackgroundChecker.this.component.getHighlighter().removeHighlight(this.tag);
            this.len = 0;
        }

        public void setLen(int n) throws BadLocationException {
            this.len = n;
            int n2 = this.getOffset();
            BackgroundChecker.this.component.getHighlighter().changeHighlight(this.tag, n2, n2 + n);
        }

        public void setOffset(int n) throws BadLocationException {
            this.pos = BackgroundChecker.this.component.getDocument().createPosition(n);
        }
    }
}

