/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.editor;

import com.agentpp.common.ShuffleDialog;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.TablePanel;
import com.agentpp.common.table.TableUtils;
import com.agentpp.designer.MIBDesignerFrame;
import com.agentpp.designer.editor.EditedObjectFactory;
import com.agentpp.designer.editor.JCObjectCellEditor;
import com.agentpp.event.OkButtonListener;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBRepository;
import com.klg.jclass.table.CellStyleModel;
import com.klg.jclass.table.DataViewModel;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.JCTableDataListener;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class ObjectsEditor
extends JPanel
implements OkButtonListener,
JCTableDataListener {
    BorderLayout borderLayout1 = new BorderLayout();
    Border border4;
    BorderLayout borderLayout3 = new BorderLayout();
    Border border6;
    public static final String[][] header = new String[][]{{"Columns"}, {"Tables"}, {"Notifications"}, {"Objects"}, {"Modules"}, {"Groups"}, {"Cond. Groups and Exceptions"}, {"Imported Modules"}, {"Variations"}, {"Modules"}, {"Creatable Columns"}};
    protected Vector objects = null;
    protected MIBRepository rep = null;
    protected int type = 3;
    boolean editable = true;
    protected JCEditableVectorDataSource model = new JCEditableVectorDataSource();
    protected JCObjectCellEditor objectsEditor;
    protected TableSorter sorter;
    JFrame myFrame = null;
    TablePanel tablePanelObjects;
    JPanel jPanel1 = new JPanel();
    JButton jButtonAdd = new JButton();
    JButton jButtonRemove = new JButton();
    EtchedBorder eborder;
    TitledBorder tborder;
    JButton jButtonAddAll = new JButton();
    private boolean _$17576 = false;
    private JButton _$14672 = new JButton();
    private FlowLayout _$4745 = new FlowLayout();
    private JCCellStyle _$16598;
    private boolean _$17577 = false;
    private EditedObjectFactory _$17578 = null;

    public ObjectsEditor() {
        this.tablePanelObjects = new TablePanel();
        this._$16598 = new JCCellStyle(this.getJCTable().getDefaultCellStyle());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getJCTable().setRowLabelDisplay(false);
    }

    public ObjectsEditor(int n) {
        this.tablePanelObjects = n > 4 ? new TablePanel(3) : new TablePanel(2);
        this._$16598 = new JCCellStyle(this.getJCTable().getDefaultCellStyle());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getJCTable().setRowLabelDisplay(false);
    }

    public ObjectsEditor(Vector vector, JFrame jFrame, boolean bl, int n) {
        this._$17577 = bl;
        this.tablePanelObjects = n > 4 ? new TablePanel(3) : new TablePanel(2);
        this._$16598 = new JCCellStyle(this.getJCTable().getDefaultCellStyle());
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.getJCTable().setRowLabelDisplay(false);
        this.myFrame = jFrame;
        this.setObjects(vector);
        this.setType(n);
    }

    public void setRepository(MIBRepository mIBRepository) {
        this.rep = mIBRepository;
        if (this.objectsEditor != null) {
            this.objectsEditor.setRepository(mIBRepository);
        }
    }

    public Object getObject(int n) {
        this.updateObjects();
        return this.objects.get(n);
    }

    public int getNumObjects() {
        this.updateObjects();
        return this.objects.size();
    }

    public void setObjects(Vector vector) {
        this.objects = vector != null ? vector : new Vector();
        this.model = new JCEditableVectorDataSource();
        this.model.setNumColumns(0);
        this.model.setNumRows(0);
        this.model.addColumn(0, header[this.type][0], null);
        this.sorter = new TableSorter(this.getJCTable(), this.model);
        this.getJCTable().setDataSource(this.model);
        this.getJCTable().setSelectionPolicy(2);
        this.objectsEditor = new JCObjectCellEditor(this.type, this.rep);
        this.objectsEditor.setEditable(false);
        Object object = this.objects.elements();
        while (object.hasMoreElements()) {
            this.addObject(this.model.getNumRows(), object.nextElement());
        }
        object = new JCCellStyle(this.getJCTable().getDefaultCellStyle());
        if (this._$17577) {
            ((JCCellStyle)object).setCellEditor(this.objectsEditor);
        } else {
            ((JCCellStyle)object).setEditable(this._$17577);
            ((JCCellStyle)object).setCellEditor(null);
        }
        this.getJCTable().setCellStyle(-997, 0, (CellStyleModel)object);
        this.model.addTableDataListener(this);
    }

    public void dataChanged(JCTableDataEvent jCTableDataEvent) {
        Object object;
        if ((jCTableDataEvent.getCommand() == 1 || jCTableDataEvent.getCommand() == 3) && jCTableDataEvent.getRow() >= 0 && (object = this.model.getTableDataItem(jCTableDataEvent.getRow(), 0)) != null) {
            this.objectsEditor.exclude(object);
        }
    }

    public void setTitle(String string) {
        this.tborder.setTitle(string);
    }

    public void setEnabled(boolean bl) {
        this.jButtonAdd.setEnabled(bl);
        this.jButtonAddAll.setEnabled(bl);
        this.jButtonRemove.setEnabled(bl);
        this._$14672.setEnabled(bl);
        this.editable = bl;
        this._$16598.setEditable(bl && this._$17577);
    }

    public void setType(int n) {
        this.type = n;
        this.objectsEditor.setMode(n);
        this.model.setColumnLabels(header[n]);
        this.sorter = new TableSorter(this.getJCTable(), this.model);
        this._$16598 = new JCCellStyle(this.getJCTable().getDefaultCellStyle());
        if (this._$17577) {
            this._$16598.setCellEditor(this.objectsEditor);
        } else {
            this._$16598.setEditable(false);
            this._$16598.setCellEditor(null);
        }
        this.getJCTable().setCellStyle(-997, 0, this._$16598);
    }

    protected void addObject(int n, Object object) {
        Vector<Object> vector = new Vector<Object>(1);
        if (this._$17578 != null && object instanceof String) {
            object = this._$17578.create((String)object);
        }
        vector.add(object);
        if (this.model.getNumRows() == 0 || n >= this.model.getNumRows()) {
            this.model.addRow(Integer.MAX_VALUE, null, vector);
        } else {
            this.model.addRow(n, null, vector);
        }
        if (object != null && object.toString() != null && object.toString().length() > 0) {
            this.objectsEditor.exclude(object);
        }
    }

    void jbInit() throws Exception {
        this.eborder = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.tborder = new TitledBorder(this.eborder, "Objects");
        this.border4 = BorderFactory.createCompoundBorder(this.tborder, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.setLayout(this.borderLayout1);
        this.setBorder(this.border4);
        this.tablePanelObjects.setPreferredSize(new Dimension(350, 250));
        this.jButtonAdd.setText("Add");
        this.jButtonAdd.setIcon(MIBDesignerFrame.imageAdd16);
        this.jButtonAdd.setToolTipText("Add a new item to the list");
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectsEditor.this.addAction(actionEvent);
            }
        });
        this.jButtonRemove.setIcon(MIBDesignerFrame.imageRemove16);
        this.jButtonRemove.setToolTipText("Remove selected items");
        this.jButtonRemove.setText("Remove");
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectsEditor.this.removeAction(actionEvent);
            }
        });
        this.jButtonAddAll.setText("Complete");
        this.jButtonAddAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectsEditor.this.jButtonAddAll_actionPerformed(actionEvent);
            }
        });
        this._$14672.setToolTipText("Open a shuffle panel to choose items from");
        this._$14672.setText("Choose...");
        this._$14672.setIcon(MIBDesignerFrame.imageOpen16);
        this._$14672.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ObjectsEditor.this.jButtonChoose_actionPerformed(actionEvent);
            }
        });
        this.jPanel1.setLayout(this._$4745);
        this.add((Component)this.tablePanelObjects, "Center");
        this.add((Component)this.jPanel1, "South");
        this.addAddButton();
        this.addButtons();
        this.addChooseButton();
        this.addRemoveButton();
    }

    public void setRowsEditable(boolean bl) {
        this._$17577 = bl;
    }

    protected void addAddButton() {
        if (this.isRowsEditable()) {
            this.jPanel1.add((Component)this.jButtonAdd, null);
        }
    }

    protected void addButtons() {
    }

    protected void addChooseButton() {
        this.jPanel1.add((Component)this._$14672, null);
    }

    protected void addRemoveButton() {
        this.jPanel1.add((Component)this.jButtonRemove, null);
    }

    public JPanel getButtonPanel() {
        return this.jPanel1;
    }

    protected void updateObjects() {
        Object object;
        int n;
        this.objectsEditor.stopCellEditing();
        this.objects = new Vector();
        for (n = 0; n < this.getJCTable().getNumRows(); ++n) {
            object = this.getJCTable().getDataView().getTableDataItem(n, 0);
            this.objects.addElement(object);
        }
        for (n = 0; n < this.objects.size(); ++n) {
            object = this.objects.elementAt(n);
            if (object != null && object.toString() != null && object.toString().length() != 0) continue;
            this.objects.removeElementAt(n);
            --n;
        }
    }

    public void okButtonPressed(ActionEvent actionEvent) {
        this.updateObjects();
    }

    public Vector getObjects() {
        return this.objects;
    }

    public JCTable getJCTable() {
        return this.tablePanelObjects.getTable();
    }

    void addAction(ActionEvent actionEvent) {
        this.objectsEditor.stopCellEditing();
        Vector vector = this.objectsEditor.getAvailableObjects("");
        if (vector.size() == 0) {
            this.jButtonAdd.setEnabled(false);
            return;
        }
        Object e = vector.firstElement();
        int n = TableUtils.getFirstSelectedRow(this.getJCTable());
        if (n >= 0) {
            this.addObject(n, e);
        } else {
            this.addObject(this.model.getNumRows(), e);
        }
        vector = this.objectsEditor.getAvailableObjects("");
        if (vector.size() == 0) {
            this.jButtonAdd.setEnabled(false);
        }
        int n2 = n >= 0 ? n : this.model.getNumRows() - 1;
        this.tablePanelObjects.getTable().traverse(n2, 0, true, true);
    }

    void removeAction(ActionEvent actionEvent) {
        int[] nArray = TableUtils.getMarkedRows(this.getJCTable());
        this.getJCTable().commitEdit(true);
        this.removeRows(nArray);
    }

    protected void removeRows(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            Object object = this.model.getTableDataItem(nArray[i], 0);
            if (object == null) continue;
            this.objectsEditor.include(object);
        }
        TableUtils.removeRows(this.model, nArray);
        Vector vector = this.objectsEditor.getAvailableObjects("");
        if (vector.size() > 0) {
            this.jButtonAdd.setEnabled(true);
        }
    }

    public JCEditableVectorDataSource getModel() {
        return this.model;
    }

    void jButtonAddAll_actionPerformed(ActionEvent actionEvent) {
        this.objectsEditor.stopCellEditing();
        this.jButtonAdd.setEnabled(false);
        Vector vector = this.objectsEditor.getAvailableObjects("");
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.addObject(this.model.getNumRows(), enumeration.nextElement());
        }
    }

    public void setAddAllEnabled(boolean bl) {
        this._$17576 = bl;
        if (this._$17576) {
            this.jPanel1.add((Component)this.jButtonAddAll, 1);
        } else {
            this.jButtonAddAll.setEnabled(false);
        }
    }

    public boolean isAddAllEnabled() {
        return this._$17576;
    }

    public boolean isRowsEditable() {
        return this._$17577;
    }

    void jButtonChoose_actionPerformed(ActionEvent actionEvent) {
        Object object;
        Vector vector = this.objectsEditor.getAvailableObjects("");
        this.updateObjects();
        Vector vector2 = this.getObjects();
        Object object2 = vector2.elements();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (object != null && object.toString() != null && object.toString().length() != 0) continue;
            if (vector.firstElement() != null && vector.firstElement().toString() != null && vector.firstElement().toString().length() != 0) break;
            vector.remove(0);
            break;
        }
        object2 = new JCVectorDataSource();
        ((JCVectorDataSource)object2).setNumColumns(0);
        ((JCVectorDataSource)object2).setNumRows(vector.size());
        ((JCVectorDataSource)object2).addColumn(0, "Objects", vector);
        object = new JCVectorDataSource();
        ((JCVectorDataSource)object).setNumColumns(0);
        ((JCVectorDataSource)object).setNumRows(vector2.size());
        ((JCVectorDataSource)object).addColumn(0, "Objects", vector2);
        ShuffleDialog shuffleDialog = new ShuffleDialog(this.myFrame, "Select " + header[this.type][0], true, (JCVectorDataSource)object2, (JCVectorDataSource)object);
        shuffleDialog.setLeftTitle("Available");
        shuffleDialog.setRightTitle("Selected");
        shuffleDialog.setLocationRelativeTo(this.myFrame);
        shuffleDialog.setVisible(true);
        if (shuffleDialog.getResult() == 0) {
            int n;
            DataViewModel dataViewModel = shuffleDialog.getRightTable().getDataView();
            int[] nArray = new int[this.model.getNumRows()];
            for (n = 0; n < nArray.length; ++n) {
                nArray[n] = n;
            }
            this.removeRows(nArray);
            block5: for (n = 0; n < shuffleDialog.getRightTable().getNumRows(); ++n) {
                if (shuffleDialog.getRightTable().isRowHidden(n)) continue;
                Vector vector3 = new Vector(this.model.getNumColumns());
                Object object3 = shuffleDialog.getRightTable().getDataView().getTableDataItem(n, 0);
                switch (this.type) {
                    case 9: {
                        this.addObject(Integer.MAX_VALUE, new MIBComplianceModule(object3.toString()));
                        continue block5;
                    }
                    default: {
                        this.addObject(Integer.MAX_VALUE, object3);
                    }
                }
            }
            this.updateObjects();
            if (this.getNumObjects() > 0) {
                this.getJCTable().setCurrentCell(0, 0);
            }
        }
        this.sorter.sort();
    }

    public EditedObjectFactory getObjectFactory() {
        return this._$17578;
    }

    public void setObjectFactory(EditedObjectFactory editedObjectFactory) {
        this._$17578 = editedObjectFactory;
    }
}

