/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.editor;

import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBVariation;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.SMI;
import java.awt.Component;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class ObjectCellEditor
extends DefaultCellEditor {
    public static final int COLUMNS = 0;
    public static final int TABLES = 1;
    public static final int NOTIFICATIONS = 2;
    public static final int ACCESSIBLE_OBJECTS = 3;
    public static final int MODULES = 4;
    public static final int GROUPS = 5;
    public static final int GROUPS_AND_OBJECTS = 6;
    public static final int IMPORTED_MODULES = 7;
    public static final int OBJECTS = 8;
    public static final int MODULES_ZEROCASE = 9;
    public static final int CREATABLE_COLUMNS = 10;
    protected int mode = 0;
    private MIBRepository _$2384;
    private MIBObjectType _$12203 = new MIBObjectType();
    private DefaultTableModel _$10720 = new DefaultTableModel(0, 0);
    protected RepositoryManager repMan = null;
    protected Object edited = null;
    protected Hashtable negativeList = new Hashtable();

    public ObjectCellEditor(int n, MIBRepository mIBRepository) {
        super(new JComboBox());
        this.mode = n;
        this._$2384 = mIBRepository;
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setTable(MIBObjectType mIBObjectType) {
        this._$12203 = mIBObjectType;
    }

    public void setNegativeList(Vector vector) {
        this.negativeList = new Hashtable(vector.size() + 5);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.negativeList.put(e.toString(), e);
        }
    }

    public void exclude(Object object) {
        if (object != null && object.toString() != null) {
            this.negativeList.put(object.toString(), object);
        }
    }

    public void include(Object object) {
        if (object != null && object.toString() != null) {
            this.negativeList.remove(object.toString());
        }
    }

    public void setColumnsModel(DefaultTableModel defaultTableModel) {
        this._$10720 = defaultTableModel;
    }

    public void setRepository(MIBRepository mIBRepository) {
        this._$2384 = mIBRepository;
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this.repMan = repositoryManager;
    }

    public RepositoryManager getRepositoryManager() {
        return this.repMan;
    }

    public Object getCellEditorValue() {
        if (this.edited == null || this.edited instanceof String) {
            return super.getCellEditorValue();
        }
        Object object = super.getCellEditorValue();
        String string = null;
        if (object != null) {
            string = object.toString();
        }
        if (this.edited instanceof MIBModule) {
            ((MIBModule)this.edited).setModuleName(string);
        } else if (this.edited instanceof MIBObject) {
            ((MIBObject)this.edited).setName(string);
        } else if (this.edited instanceof MIBVariation) {
            ((MIBVariation)this.edited).setVariation(string);
        } else if (this.edited instanceof MIBSupportedModule) {
            MIBSupportedModule mIBSupportedModule = (MIBSupportedModule)this.edited;
            if (mIBSupportedModule == null) {
                return this.edited;
            }
            if (mIBSupportedModule.getSupports() != null && !mIBSupportedModule.getSupports().equals(string)) {
                mIBSupportedModule.setIncludes(new Vector());
                mIBSupportedModule.setVariations(new Vector());
            }
            mIBSupportedModule.setSupports(string);
        } else if (this.edited instanceof MIBComplianceModule) {
            MIBComplianceModule mIBComplianceModule = (MIBComplianceModule)this.edited;
            if (mIBComplianceModule == null) {
                return this.edited;
            }
            if (mIBComplianceModule.getModuleName() != null && !mIBComplianceModule.getModuleName().equals(string)) {
                mIBComplianceModule.setMandatory(new Vector());
                mIBComplianceModule.setVariations(new Vector());
            }
            mIBComplianceModule.setModuleName(string);
        }
        return this.edited;
    }

    public Vector getAvailableObjects(Object object) {
        Vector<String> vector = new Vector<String>();
        switch (this.mode) {
            case 0: {
                MIBObjectType mIBObjectType;
                MIBObject mIBObject;
                Vector<Object> vector2 = new Vector<Object>(this._$10720.getRowCount() + 1);
                for (int i = 0; i < this._$10720.getRowCount(); ++i) {
                    vector2.addElement(this._$10720.getValueAt(i, 1));
                }
                if (vector2 != null) {
                    Enumeration enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        mIBObject = (MIBObject)enumeration.nextElement();
                        if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBObjectType) || SMI.accessType((mIBObjectType = (MIBObjectType)mIBObject).getAccess()) != 0 && SMI.accessType(mIBObjectType.getAccess()) != 1) continue;
                        vector.addElement(mIBObjectType.getName());
                    }
                }
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBObjectType) || !(mIBObjectType = (MIBObjectType)mIBObject).isColumnarObject() || SMI.accessType(mIBObjectType.getAccess()) != 0 && SMI.accessType(mIBObjectType.getAccess()) != 1) continue;
                    if (this._$2384.getObjectsByName(mIBObjectType.getName()).length > 1) {
                        String string = this._$2384.getModuleName(mIBObjectType.getModuleID());
                        if (string != null) {
                            vector.addElement(string + "." + mIBObjectType.getName());
                        } else {
                            vector.addElement(mIBObjectType.getName());
                        }
                    }
                    vector.addElement(mIBObjectType.getName());
                }
                break;
            }
            case 1: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObjectType mIBObjectType;
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBObjectType) || !(mIBObjectType = (MIBObjectType)mIBObject).isTable() || !mIBObjectType.hasIndexPart() || mIBObjectType.getIndexPart().isAugment()) continue;
                    vector.addElement(mIBObjectType.getName());
                }
                break;
            }
            case 2: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBNotifyType)) continue;
                    vector.addElement(mIBObject.getName());
                }
                break;
            }
            case 3: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBObjectType) || SMI.accessType(((MIBObjectType)mIBObject).getAccess()) == 0) continue;
                    vector.addElement(mIBObject.getName());
                }
                break;
            }
            case 4: 
            case 9: {
                if (this.repMan == null) {
                    return vector;
                }
                if (this.mode == 9) {
                    vector.addElement("");
                }
                try {
                    String[] stringArray = this.repMan.getModuleNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        vector.addElement(stringArray[i]);
                    }
                    break;
                }
                catch (IOException iOException) {
                    System.out.println("Error while reading from repository: " + iOException.getMessage());
                    break;
                }
            }
            case 5: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBGroup)) continue;
                    vector.addElement(mIBObject.getName());
                }
                break;
            }
            case 6: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || (!(mIBObject instanceof MIBGroup) || !(object instanceof MIBCondGroup) && !(object instanceof String)) && (!(mIBObject instanceof MIBObjectType) && !(mIBObject instanceof MIBNotifyType) || !(object instanceof MIBException) && !(object instanceof String))) continue;
                    vector.addElement(mIBObject.getName());
                }
                break;
            }
            case 8: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBObjectType) && !(mIBObject instanceof MIBNotifyType)) continue;
                    vector.addElement(mIBObject.getName());
                }
                break;
            }
            case 7: {
                vector.addElement("");
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBModule)) continue;
                    vector.addElement(((MIBModule)mIBObject).getModuleName());
                }
                break;
            }
        }
        return vector;
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.edited = object;
        this.include(object);
        JComboBox jComboBox = (JComboBox)super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        jComboBox.removeAllItems();
        Vector vector = this.getAvailableObjects(object);
        Collections.sort(vector);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            jComboBox.addItem(enumeration.nextElement());
        }
        if (object == null) {
            if (jComboBox.getItemCount() > 0) {
                jComboBox.setSelectedIndex(0);
            }
        } else if (jComboBox.getItemCount() > 0) {
            jComboBox.setSelectedItem(object.toString());
        }
        return jComboBox;
    }
}

