/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.editor;

import com.agentpp.common.TableSorter;
import com.agentpp.common.table.ExtendedTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.designer.MIBDesignerFrame;
import com.agentpp.designer.spelling.SpellCheckedTextEditor;
import com.agentpp.mib.MIBEnum;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRange;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.smiparser.SMI;
import com.agentpp.util.gui.ErrorDialog;
import com.agentpp.util.gui.ErrorTextPanel;
import com.agentpp.util.gui.StringField;
import com.klg.jclass.cell.editors.JCLongCellEditor;
import com.klg.jclass.cell.editors.JCStringCellEditor;
import com.klg.jclass.cell.validate.JCValidateEvent;
import com.klg.jclass.cell.validate.JCValidateListener;
import com.klg.jclass.table.DataViewModel;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.TablePopupMenu;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import com.klg.jclass.table.data.JCVectorDataSource;
import com.wintertree.ssce.PropSpellingSession;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MIBSyntaxEditor
extends JDialog
implements ItemListener {
    public static final String[] enumHeaders = new String[]{"Value", "Label", "Comment"};
    public static final String[] rangeHeaders = new String[]{"Lower", "Upper"};
    private static final int _$12530 = 1;
    private static final int _$12531 = 0;
    private static final int _$12532 = 2;
    BorderLayout borderLayout1 = new BorderLayout();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    BorderLayout borderLayout3 = new BorderLayout();
    Border border5;
    TitledBorder titledBorder3;
    Border border6;
    protected MIBSyntax syntax = null;
    protected MIBRepository rep = null;
    JFrame myFrame = null;
    JPanel jPanelCenter = new JPanel();
    JPanel jPanelSouth = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    JPanel jPanel1 = new JPanel();
    JPanel jPanel2 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton jButtonSave = new JButton();
    JButton jButtonCancel = new JButton();
    BorderLayout borderLayout4 = new BorderLayout();
    JPanel jPanelSyntax = new JPanel();
    JTabbedPane jTabbedPane1 = new JTabbedPane();
    JPanel jPanelEnums = new JPanel();
    JPanel jPanelRanges = new JPanel();
    JLabel jLabelSyntax = new JLabel();
    BorderLayout borderLayout5 = new BorderLayout();
    Border border7;
    JComboBox jComboBoxSyntax = new JComboBox();
    Border border8;
    Border border9;
    ExtendedTable tablePanelEnums = new ExtendedTable();
    ExtendedTable tablePanelRanges = new ExtendedTable();
    BorderLayout borderLayout6 = new BorderLayout();
    JPanel jPanel3 = new JPanel();
    FlowLayout flowLayout2 = new FlowLayout();
    JButton jButtonAddEnum = new JButton();
    JButton jButtonRemoveEnum = new JButton();
    BorderLayout borderLayout7 = new BorderLayout();
    JPanel jPanel4 = new JPanel();
    FlowLayout flowLayout3 = new FlowLayout();
    JButton jButtonAddRange = new JButton();
    JButton jButtonRemoveRange = new JButton();
    SyntaxTableModel enumModel = null;
    SyntaxTableModel rangeModel = null;
    TableSorter enumsSorter;
    TableSorter rangesSorter;
    private PropSpellingSession _$4380;
    JCStringCellEditor labelEditor = new JCStringCellEditor();
    StringField intEditor = new StringField("abcdefhABCDEFH0123456789'", true, 32, false);
    private MIBEnum[] _$12573;
    private MIBRange[] _$12574;
    private boolean _$8737 = false;
    private boolean _$12575 = true;
    JButton jButtonImport = new JButton();

    public MIBSyntaxEditor() {
        this._$2405();
    }

    public MIBSyntaxEditor(MIBSyntax mIBSyntax, JFrame jFrame, PropSpellingSession propSpellingSession) {
        this(mIBSyntax, jFrame, propSpellingSession, true);
    }

    public MIBSyntaxEditor(MIBSyntax mIBSyntax, JFrame jFrame, PropSpellingSession propSpellingSession, boolean bl) {
        super(jFrame);
        this._$4380 = propSpellingSession;
        this._$2405();
        this.setModal(true);
        this.myFrame = jFrame;
        this.setSyntax(mIBSyntax);
        this.jButtonImport.setEnabled(this.myFrame instanceof MIBDesignerFrame && bl);
        this._$12575 = bl;
    }

    private void _$2405() {
        this.tablePanelEnums.setRowLabelDisplay(false);
        this.tablePanelEnums.setSelectionPolicy(2);
        TablePopupMenu tablePopupMenu = this.tablePanelEnums.getPopupMenu();
        tablePopupMenu.addItem("Comment...", new EditComment());
        this.tablePanelEnums.setPopupMenuEnabled(true);
        this.tablePanelRanges.setRowLabelDisplay(false);
        this.tablePanelRanges.setSelectionPolicy(2);
        JCVectorDataSource jCVectorDataSource = new JCVectorDataSource();
        jCVectorDataSource.setNumColumns(enumHeaders.length);
        jCVectorDataSource.setNumRows(8);
        this.tablePanelEnums.setDataSource(jCVectorDataSource);
        JCVectorDataSource jCVectorDataSource2 = new JCVectorDataSource();
        jCVectorDataSource2.setNumColumns(rangeHeaders.length);
        jCVectorDataSource2.setNumRows(8);
        this.tablePanelEnums.setDataSource(jCVectorDataSource2);
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < SMI.SMI_SYNTAX.length - 1; ++i) {
            this.jComboBoxSyntax.addItem(SMI.SMI_SYNTAX[i]);
        }
    }

    protected void processWindowEvent(WindowEvent windowEvent) {
        super.processWindowEvent(windowEvent);
        if (windowEvent.getID() == 201) {
            this.jButtonCancel_actionPerformed(null);
        }
    }

    public void setTypeEditable(boolean bl) {
        this.jComboBoxSyntax.setEditable(bl);
        this.jButtonImport.setEnabled(bl);
    }

    public void setSyntax(MIBSyntax mIBSyntax) {
        int n;
        MIBRange[] mIBRangeArray;
        this.syntax = mIBSyntax;
        this.enumModel = new SyntaxTableModel(enumHeaders, mIBSyntax, 0);
        this.rangeModel = new SyntaxTableModel(rangeHeaders, mIBSyntax, 1);
        this.tablePanelEnums.setDataSource(this.enumModel);
        this.tablePanelRanges.setDataSource(this.rangeModel);
        JCCellStyle jCCellStyle = new JCCellStyle(this.tablePanelEnums.getDefaultCellStyle());
        jCCellStyle.setEditable(true);
        this.labelEditor.addValidateListener(new LabelValidater());
        jCCellStyle.setCellEditor(this.labelEditor);
        this.tablePanelEnums.setCellStyle(-997, 1, jCCellStyle);
        JCCellStyle jCCellStyle2 = new JCCellStyle(this.tablePanelEnums.getDefaultCellStyle());
        jCCellStyle2.setEditable(true);
        this.tablePanelEnums.setCellStyle(-997, 0, jCCellStyle2);
        JCCellStyle jCCellStyle3 = new JCCellStyle(this.tablePanelEnums.getDefaultCellStyle());
        jCCellStyle3.setEditable(true);
        jCCellStyle3.setCellEditor(new JCStringCellEditor());
        this.tablePanelEnums.setCellStyle(-997, 2, jCCellStyle3);
        JCCellStyle jCCellStyle4 = new JCCellStyle(this.tablePanelEnums.getDefaultCellStyle());
        jCCellStyle4.setEditable(true);
        jCCellStyle4.setCellEditor(new JCLongCellEditor());
        jCCellStyle4.setDataType(Long.class);
        this.tablePanelRanges.setCellStyle(-997, -997, jCCellStyle4);
        MIBEnum[] mIBEnumArray = (MIBEnum[])mIBSyntax.getEnums();
        if (mIBEnumArray != null) {
            this._$12573 = new MIBEnum[mIBSyntax.getEnumsVector().size()];
        }
        if ((mIBRangeArray = (MIBRange[])mIBSyntax.getRanges()) != null) {
            this._$12574 = new MIBRange[mIBSyntax.getRangesVector().size()];
        }
        for (n = 0; mIBEnumArray != null && n < this._$12573.length; ++n) {
            this._$12573[n] = new MIBEnum(mIBEnumArray[n].getLabel(), mIBEnumArray[n].getValue());
        }
        for (n = 0; mIBRangeArray != null && n < this._$12574.length; ++n) {
            this._$12574[n] = new MIBRange(mIBRangeArray[n].getLower(), mIBRangeArray[n].getUpper());
        }
        if (!mIBSyntax.getSyntax().equals(SMI.SMI_SYNTAX[0])) {
            this.jTabbedPane1.setEnabledAt(1, false);
        }
        if (mIBSyntax.hasEnums()) {
            this.jTabbedPane1.setSelectedIndex(1);
        } else {
            this.jTabbedPane1.setSelectedIndex(0);
        }
        this.enumsSorter = new TableSorter((JCTable)this.tablePanelEnums, (JCVectorDataSource)this.enumModel, this.enumModel);
        this.rangesSorter = new TableSorter(this.tablePanelRanges, this.rangeModel);
    }

    public void setRepository(MIBRepository mIBRepository) {
        int n;
        this.rep = mIBRepository;
        this.jComboBoxSyntax.removeAllItems();
        for (n = 0; n < SMI.SMI_SYNTAX.length - 1; ++n) {
            this.jComboBoxSyntax.addItem(SMI.SMI_SYNTAX[n]);
            if (!this.syntax.getSyntax().equals(SMI.SMI_SYNTAX[n])) continue;
            this.jComboBoxSyntax.setSelectedIndex(n);
        }
        if (this._$12575) {
            Enumeration<? extends MIBTextualConvention> enumeration = mIBRepository.getTextualConventions().elements();
            while (enumeration.hasMoreElements()) {
                String string = ((MIBObject)enumeration.nextElement()).getName();
                this.jComboBoxSyntax.addItem(string);
                if (this.syntax.getSyntax().equals(string)) {
                    this.jComboBoxSyntax.setSelectedIndex(n);
                }
                ++n;
            }
        }
    }

    void jbInit() throws Exception {
        this.setTitle("SYNTAX Editor");
        this.jComboBoxSyntax.addItemListener(this);
        this.border1 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border1, "Module");
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border3 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder2 = new TitledBorder(this.border3, "Module");
        this.border4 = BorderFactory.createCompoundBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(134, 134, 134)), "OBJECT-TYPE"), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border5 = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        this.titledBorder3 = new TitledBorder(this.border5, "Revisions");
        this.border6 = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "INDEX"), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border7 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border8 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.border9 = BorderFactory.createEmptyBorder(10, 0, 10, 0);
        this.getContentPane().setLayout(this.borderLayout1);
        this.jPanelSouth.setLayout(this.borderLayout2);
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jPanel1.setMinimumSize(new Dimension(0, 0));
        this.jPanel1.setPreferredSize(new Dimension(0, 2));
        this.jPanel2.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setHgap(10);
        this.flowLayout1.setVgap(10);
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSyntaxEditor.this.jButtonSave_actionPerformed(actionEvent);
            }
        });
        this.jButtonCancel.setActionCommand("jButtonCancel");
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSyntaxEditor.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        this.jPanelCenter.setLayout(this.borderLayout4);
        this.jLabelSyntax.setText("Syntax:");
        this.jPanelSyntax.setLayout(this.borderLayout5);
        this.borderLayout5.setHgap(10);
        this.borderLayout5.setVgap(10);
        this.jPanelCenter.setBorder(this.border8);
        this.jPanelSyntax.setBorder(this.border9);
        this.tablePanelEnums.setPreferredSize(new Dimension(360, 150));
        this.jPanelEnums.setLayout(this.borderLayout6);
        this.jPanel3.setLayout(this.flowLayout2);
        this.jButtonAddEnum.setText("Add");
        this.jButtonAddEnum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSyntaxEditor.this.jButtonAddEnum_actionPerformed(actionEvent);
            }
        });
        this.jButtonRemoveEnum.setText("Remove");
        this.jButtonRemoveEnum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSyntaxEditor.this.jButtonRemoveEnum_actionPerformed(actionEvent);
            }
        });
        this.jPanelRanges.setLayout(this.borderLayout7);
        this.jPanel4.setLayout(this.flowLayout3);
        this.jButtonAddRange.setText("Add");
        this.jButtonAddRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSyntaxEditor.this.jButtonAddRange_actionPerformed(actionEvent);
            }
        });
        this.jButtonRemoveRange.setText("Remove");
        this.jButtonRemoveRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSyntaxEditor.this.jButtonRemoveRange_actionPerformed(actionEvent);
            }
        });
        this.jButtonImport.setToolTipText("Import a Textual Convention or type assignment from an another MIB module");
        this.jButtonImport.setActionCommand("import");
        this.jButtonImport.setText("Import...");
        this.jButtonImport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBSyntaxEditor.this.jButtonImport_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.jPanelCenter, "Center");
        this.jPanelCenter.add((Component)this.jPanelSyntax, "North");
        this.jPanelSyntax.add((Component)this.jLabelSyntax, "West");
        this.jPanelSyntax.add((Component)this.jComboBoxSyntax, "South");
        this.jPanelCenter.add((Component)this.jTabbedPane1, "Center");
        this.jPanelEnums.add((Component)this.tablePanelEnums, "Center");
        this.jPanelEnums.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.jButtonAddEnum, null);
        this.jPanel3.add((Component)this.jButtonRemoveEnum, null);
        this.jTabbedPane1.add((Component)this.jPanelRanges, "Ranges");
        this.jTabbedPane1.add((Component)this.jPanelEnums, "Enumerations");
        this.jPanelRanges.add((Component)this.tablePanelRanges, "Center");
        this.jPanelRanges.add((Component)this.jPanel4, "South");
        this.jPanel4.add((Component)this.jButtonAddRange, null);
        this.jPanel4.add((Component)this.jButtonRemoveRange, null);
        this.getContentPane().add((Component)this.jPanelSouth, "South");
        this.jPanelSouth.add((Component)this.jPanel1, "North");
        this.jPanelSouth.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jButtonSave, null);
        this.jPanel2.add((Component)this.jButtonCancel, null);
        this.jPanelSyntax.add((Component)this.jButtonImport, "East");
        this.getRootPane().setDefaultButton(this.jButtonSave);
        this.pack();
    }

    private boolean _$12612() {
        return this.jComboBoxSyntax.getSelectedIndex() < SMI.SMI_SYNTAX.length;
    }

    private int _$12613() {
        return this._$12612() ? 0 : 3;
    }

    void jButtonSave_actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        String[] stringArray;
        this.tablePanelEnums.commitEdit(true);
        this.tablePanelRanges.commitEdit(true);
        this.enumModel.save(this.tablePanelEnums.getDataView());
        this.rangeModel.save(this.tablePanelRanges.getDataView());
        if (this.jTabbedPane1.isEnabledAt(1) && this.syntax.hasEnums() && this.syntax.hasRanges()) {
            stringArray = new String[]{"ENUMERATIONS and RANGES cannot be specified at the same time!", "Please select <OK> the use the ENUMERATIONS or ", "choose <Cancel> to use the RANGES."};
            serializable = new ErrorDialog(this.myFrame, "Inconsistent Sub-Typing", true, true, new ErrorTextPanel(stringArray));
            ((Window)serializable).setLocationRelativeTo(this);
            ((Dialog)serializable).setVisible(true);
            if (((ErrorDialog)serializable).getResult() == 0) {
                this.syntax.setRanges((MIBRange[])null);
            } else {
                this.syntax.setEnums((MIBEnum[])null);
            }
        }
        if (!this.jTabbedPane1.isEnabledAt(0)) {
            this.syntax.setRanges((MIBRange[])null);
        }
        if (!this.jTabbedPane1.isEnabledAt(1)) {
            this.syntax.setEnums((MIBEnum[])null);
        } else if (this.syntax.hasEnums()) {
            stringArray = this.syntax.getEnumsVector().elements();
            while (stringArray.hasMoreElements()) {
                serializable = (MIBEnum)stringArray.nextElement();
                if (!((MIBEnum)serializable).hasValidValue()) {
                    String[] stringArray2 = new String[]{"Value '" + ((MIBEnum)serializable).getValue() + "' for label '" + ((MIBEnum)serializable).getLabel() + "'", "is not a valid numeric value! Please enter a valid", "number or press <Cancel>."};
                    ErrorDialog errorDialog = new ErrorDialog(this.myFrame, "Invalid Value", true, false, new ErrorTextPanel(stringArray2));
                    errorDialog.setLocationRelativeTo(this);
                    errorDialog.setVisible(true);
                    return;
                }
                if (((MIBEnum)serializable).getLabel().length() != 0) continue;
                String[] stringArray3 = new String[]{"The label for value '" + ((MIBEnum)serializable).getValue() + "' is empty!", "Please enter a valid label or press <Cancel>."};
                ErrorDialog errorDialog = new ErrorDialog(this.myFrame, "Invalid Label", true, false, new ErrorTextPanel(stringArray3));
                errorDialog.setLocationRelativeTo(this);
                errorDialog.setVisible(true);
                return;
            }
            this.syntax.setEnumsVector(TableUtils.sortVectorByView(this.tablePanelEnums, this.syntax.getEnumsVector()));
        }
        if (this.syntax.hasRanges()) {
            this.syntax.setRangesVector(TableUtils.sortVectorByView(this.tablePanelRanges, this.syntax.getRangesVector()));
        }
        this.syntax.setType(this._$12613());
        this.syntax.setSyntax(this.jComboBoxSyntax.getSelectedItem().toString());
        this.dispose();
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.syntax.setRanges(this._$12574);
        this.syntax.setEnums(this._$12573);
        this.dispose();
    }

    void jButtonAddEnum_actionPerformed(ActionEvent actionEvent) {
        this.tablePanelEnums.commitEdit(true);
        this.enumModel.addRow();
        this.itemStateChanged(new ItemEvent(this.jComboBoxSyntax, this.jComboBoxSyntax.getSelectedIndex(), this.jComboBoxSyntax.getSelectedItem(), 1));
    }

    void jButtonRemoveEnum_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = TableUtils.getSelectedRows(this.tablePanelEnums);
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.enumModel.deleteRows(nArray[i], 1);
        }
        this.itemStateChanged(new ItemEvent(this.jComboBoxSyntax, this.jComboBoxSyntax.getSelectedIndex(), this.jComboBoxSyntax.getSelectedItem(), 1));
    }

    void jButtonAddRange_actionPerformed(ActionEvent actionEvent) {
        this.tablePanelRanges.commitEdit(true);
        this.rangeModel.addRow();
        this.itemStateChanged(new ItemEvent(this.jComboBoxSyntax, this.jComboBoxSyntax.getSelectedIndex(), this.jComboBoxSyntax.getSelectedItem(), 1));
    }

    void jButtonRemoveRange_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = TableUtils.getSelectedRows(this.tablePanelRanges);
        if (nArray == null || nArray.length == 0) {
            return;
        }
        for (int i = nArray.length - 1; i >= 0; --i) {
            this.rangeModel.deleteRows(nArray[i], 1);
        }
        this.itemStateChanged(new ItemEvent(this.jComboBoxSyntax, this.jComboBoxSyntax.getSelectedIndex(), this.jComboBoxSyntax.getSelectedItem(), 1));
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 2) {
            return;
        }
        String string = itemEvent.getItem().toString();
        if (string.equals(SMI.SMI_SYNTAX[0]) || string.equals(SMI.SMI_SYNTAX[12]) || this.rep != null && this.rep.getBaseSyntax(new MIBSyntax(string, this._$12613())).getSyntax().equals(SMI.SMI_SYNTAX[0]) || this.rep != null && this.rep.getBaseSyntax(new MIBSyntax(string, this._$12613())).getSyntax().equals(SMI.SMI_SYNTAX[12])) {
            this.jTabbedPane1.setEnabledAt(1, true);
        } else {
            this.jTabbedPane1.setEnabledAt(1, false);
        }
        if (this.rep != null && this.rep.getBaseSyntax(new MIBSyntax(string, this._$12613())).hasEnums()) {
            this.jTabbedPane1.setEnabledAt(0, false);
        }
        if (this.rep != null && this.rep.getBaseSyntax(new MIBSyntax(string, this._$12613())).hasRanges()) {
            this.jTabbedPane1.setEnabledAt(0, false);
        }
        if (SMI.isSubTypable(string) || this.rep != null && SMI.isSubTypable(this.rep.getBaseSyntax(new MIBSyntax(string, this._$12613())).getSyntax())) {
            this.jTabbedPane1.setEnabledAt(0, true);
        } else {
            this.jTabbedPane1.setEnabledAt(0, false);
        }
        if (this.rangeModel != null && this.enumModel != null && this.jTabbedPane1.isEnabledAt(0) && this.jTabbedPane1.isEnabledAt(1)) {
            if (this.rangeModel.getNumRows() > 0 && this.enumModel.getNumRows() == 0) {
                this.jTabbedPane1.setEnabledAt(1, false);
            } else if (this.rangeModel.getNumRows() == 0 && this.enumModel.getNumRows() > 0) {
                this.jTabbedPane1.setEnabledAt(0, false);
            }
        }
    }

    public void setReleaseLock(boolean bl) {
        this._$8737 = bl;
        this.jComboBoxSyntax.setEnabled(!bl);
        this.jButtonImport.setEnabled(!bl && this.myFrame instanceof MIBDesignerFrame && this._$12575);
    }

    public boolean isReleaseLock() {
        return this._$8737;
    }

    void editComment(MIBEnum mIBEnum) {
        SpellCheckedTextEditor spellCheckedTextEditor = new SpellCheckedTextEditor(this._$4380, this.myFrame, "ASN.1 Comment - " + mIBEnum.toString(), true);
        if (mIBEnum.hasComment()) {
            spellCheckedTextEditor.setText(mIBEnum.getComment());
        } else {
            spellCheckedTextEditor.setText("");
        }
        spellCheckedTextEditor.setToolTip("Each line must begin with '--' which should not be followed by any additional '--'");
        spellCheckedTextEditor.setLocationRelativeTo(this);
        spellCheckedTextEditor.show();
        if (spellCheckedTextEditor.isApproved()) {
            if (spellCheckedTextEditor.getText().trim().length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(spellCheckedTextEditor.getText(), "\n", true);
                StringBuffer stringBuffer = new StringBuffer();
                while (stringTokenizer.hasMoreTokens()) {
                    String string = stringTokenizer.nextToken();
                    if (!string.equals("\n") && !string.trim().startsWith("--")) {
                        stringBuffer.append("--");
                        stringBuffer.append(string);
                        continue;
                    }
                    stringBuffer.append(string);
                }
                mIBEnum.setComment(stringBuffer.toString());
            } else {
                mIBEnum.setComment(null);
            }
        }
    }

    public void jButtonImport_actionPerformed(ActionEvent actionEvent) {
        if (this.myFrame instanceof MIBDesignerFrame) {
            MIBDesignerFrame mIBDesignerFrame = (MIBDesignerFrame)this.myFrame;
            mIBDesignerFrame.getCurrentPanel().editImports();
            this.setRepository(this.rep);
        }
    }

    class EditComment
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            JCCellPosition jCCellPosition = MIBSyntaxEditor.this.tablePanelEnums.getCurrentCell();
            if (jCCellPosition == null) {
                JOptionPane.showMessageDialog(MIBSyntaxEditor.this, "Please select comment to edit first", "No Rows Selected!", 1);
                return;
            }
            MIBEnum mIBEnum = MIBSyntaxEditor.this.enumModel._$4891.getEnumsVector().elementAt(jCCellPosition.row);
            MIBSyntaxEditor.this.editComment(mIBEnum);
        }
    }

    class LabelValidater
    implements JCValidateListener {
        private static final String _$12633 = "qwertzuiopasdfghjklyxcvbnmQWERTZUIOPASDFGHJKLYXCVBNM0123456789";
        private static final int _$12634 = 64;

        public void valueChangedEnd(JCValidateEvent jCValidateEvent) {
        }

        public void stateIsInvalid(JCValidateEvent jCValidateEvent) {
        }

        public void valueChangedBegin(JCValidateEvent jCValidateEvent) {
            String string = (String)jCValidateEvent.getValue();
            if (string.length() > 64) {
                jCValidateEvent.setBeep(true);
                jCValidateEvent.setValid(false);
                return;
            }
            for (int i = 0; i < string.length(); ++i) {
                if (_$12633.indexOf(string.charAt(i)) >= 0) continue;
                jCValidateEvent.setBeep(true);
                jCValidateEvent.setValid(false);
                return;
            }
            if (string.length() > 0) {
                string = string.substring(0, 1).toLowerCase() + string.substring(1);
            }
            jCValidateEvent.setValue(string);
            jCValidateEvent.setValid(true);
        }
    }

    class SyntaxTableModel
    extends JCEditableVectorDataSource
    implements Comparator {
        private MIBSyntax _$4891;
        private String[] _$12624;
        private int _$10719 = 0;
        public static final int ENUMERATIONS = 0;
        public static final int RANGES = 1;

        public SyntaxTableModel() {
            this(enumHeaders, new MIBSyntax(), 0);
        }

        public SyntaxTableModel(String[] stringArray, MIBSyntax mIBSyntax, int n) {
            this._$12624 = stringArray;
            this._$10719 = n;
            this.setSyntax(mIBSyntax);
        }

        public void setSyntax(MIBSyntax mIBSyntax) {
            this._$4891 = mIBSyntax;
            this.setNumRows(0);
            this.setNumColumns(this._$12624.length);
            this.setColumnLabels(this._$12624);
            switch (this._$10719) {
                case 0: {
                    if (!mIBSyntax.hasEnums()) break;
                    for (int i = 0; i < mIBSyntax.getEnumsVector().size(); ++i) {
                        MIBEnum mIBEnum = mIBSyntax.getEnumsVector().get(i);
                        super.addRow(Integer.MAX_VALUE, null, new Vector<Object>(Arrays.asList(mIBEnum.getValue(), mIBEnum.getLabel(), mIBEnum.getComment())));
                    }
                    break;
                }
                case 1: {
                    if (!mIBSyntax.hasRanges()) break;
                    for (int i = 0; i < mIBSyntax.getRangesVector().size(); ++i) {
                        MIBRange mIBRange = mIBSyntax.getRangesVector().get(i);
                        super.addRow(Integer.MAX_VALUE, null, new Vector<Object>(Arrays.asList(mIBRange.getLower(), mIBRange.getUpper())));
                    }
                    break;
                }
            }
        }

        public void save(DataViewModel dataViewModel) {
            LinkedList<Serializable> linkedList = new LinkedList<Serializable>();
            switch (this._$10719) {
                case 0: {
                    for (int i = 0; i < dataViewModel.getNumRows(); ++i) {
                        linkedList.add(new MIBEnum((String)dataViewModel.getDataSource().getTableDataItem(i, 1), (String)dataViewModel.getDataSource().getTableDataItem(i, 0), (String)dataViewModel.getDataSource().getTableDataItem(i, 2)));
                    }
                    this._$4891.setEnumsVector(new Vector<MIBEnum>(linkedList));
                    break;
                }
                case 1: {
                    for (int i = 0; i < dataViewModel.getNumRows(); ++i) {
                        linkedList.add(new MIBRange((Long)dataViewModel.getDataSource().getTableDataItem(i, 0), (Long)dataViewModel.getDataSource().getTableDataItem(i, 1)));
                    }
                    this._$4891.setRangesVector(new Vector<MIBRange>(linkedList));
                }
            }
        }

        public boolean setTableDataItem(Object object, int n, int n2) {
            if (object == null && n2 < 2) {
                return false;
            }
            if (this._$10719 == 0 && n2 == 2) {
                if (object != null && object.toString().length() > 0) {
                    String string = object.toString();
                    if (!string.trim().startsWith("--")) {
                        string = "-- " + string;
                    }
                    return super.setTableDataItem(string, n, n2);
                }
                return super.setTableDataItem(null, n, n2);
            }
            return super.setTableDataItem(object, n, n2);
        }

        public void addRow() {
            int n = this.getNumRows();
            switch (this._$10719) {
                case 0: {
                    if (super.getNumRows() < 1) {
                        if (this._$4891.getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                            super.addRow(Integer.MAX_VALUE, null, new Vector<Object>(Arrays.asList("0", "", null)));
                            break;
                        }
                        super.addRow(Integer.MAX_VALUE, null, new Vector<Object>(Arrays.asList("1", "", null)));
                        break;
                    }
                    long l = 0L;
                    try {
                        l = SMI.parseLongConstant((String)super.getTableDataItem(super.getNumRows() - 1, 0));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    super.addRow(Integer.MAX_VALUE, null, new Vector<Object>(Arrays.asList("" + (l + 1L), "", null)));
                    break;
                }
                case 1: {
                    super.addRow(Integer.MAX_VALUE, null, new Vector<Object>(Arrays.asList(new Long(0L), new Long(0L))));
                }
            }
        }

        public int compare(Object object, Object object2) {
            try {
                return new Long(SMI.parseLongConstant(object.toString())).compareTo(new Long(SMI.parseLongConstant(object2.toString())));
            }
            catch (Exception exception) {
                if (object == null) {
                    return -1;
                }
                if (object2 == null) {
                    return 1;
                }
                return object.toString().compareTo(object2.toString());
            }
        }

        public boolean equals(Object object) {
            return this == object;
        }
    }
}

