/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.editor;

import com.agentpp.common.StandardDialog;
import com.agentpp.common.tree.MIBTreePanel;
import com.agentpp.designer.editor.DefaultValueEditorBITS;
import com.agentpp.designer.editor.DefaultValueEditorEnum;
import com.agentpp.designer.editor.MIBSyntaxEditor;
import com.agentpp.event.OkButtonListener;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSyntax;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.smiparser.SMI;
import com.wintertree.ssce.PropSpellingSession;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public class MIBObjectTypeEditor
extends JPanel
implements OkButtonListener {
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    JLabel jLabelSyntax = new JLabel();
    JLabel jLabelAccess = new JLabel();
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    BorderLayout borderLayout3 = new BorderLayout();
    Border border5;
    TitledBorder titledBorder3;
    Border border6;
    protected MIBObjectType objectType = null;
    protected MIBSyntax syntax = null;
    protected MIBRepository rep = null;
    private boolean _$4203 = false;
    JFrame myFrame = null;
    JComboBox jComboBox1 = new JComboBox();
    JLabel jLabelDefval = new JLabel();
    JTextField jTextFieldDefval = new JTextField();
    JTextField jTextFieldSyntax = new JTextField();
    JButton jButtonEdit = new JButton();
    JLabel jLabelUnits = new JLabel();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea jTextAreaUnits = new JTextArea();
    private boolean _$4213;
    private PropSpellingSession _$4182;
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JButton jButtonChooseDefVal = new JButton();

    public MIBObjectTypeEditor() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        for (int i = 0; i < SMI.ACCESS.length - 1; ++i) {
            this.jComboBox1.addItem(SMI.ACCESS[i]);
        }
    }

    public MIBObjectTypeEditor(MIBObjectType mIBObjectType, JFrame jFrame, PropSpellingSession propSpellingSession) {
        this();
        this._$4182 = propSpellingSession;
        this.myFrame = jFrame;
        this.setObjectType(mIBObjectType);
    }

    public void setRepository(MIBRepository mIBRepository) {
        this.rep = mIBRepository;
        MIBModule mIBModule = mIBRepository.getModule(this.objectType.getModuleID());
        if (mIBModule != null && mIBModule.getSMIVersion() > 1) {
            this.jComboBox1.removeItemAt(4);
        }
        if (mIBRepository != null) {
            this._$4231();
        }
    }

    public void setObjectType(MIBObjectType mIBObjectType) {
        int n;
        this.objectType = mIBObjectType;
        this.jComboBox1.removeAllItems();
        for (n = 0; n < SMI.ACCESS.length - 1; ++n) {
            this.jComboBox1.addItem(SMI.ACCESS[n]);
        }
        this.syntax = new MIBSyntax(mIBObjectType.getSyntax());
        this.jTextFieldSyntax.setText(this.syntax.getSyntax());
        this._$4235();
        try {
            n = SMI.accessType(mIBObjectType.getAccess());
            this.jComboBox1.setSelectedIndex(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mIBObjectType.hasDefaultValue()) {
            this.jTextFieldDefval.setText(mIBObjectType.getDefaultValue());
        } else {
            this.jTextFieldDefval.setText("");
        }
        if (mIBObjectType.hasUnits()) {
            this.jTextAreaUnits.setText(MIBObject.getUnquotedString(mIBObjectType.getUnits()));
        } else {
            this.jTextAreaUnits.setText("");
        }
        if (this.rep != null) {
            this._$4231();
        }
    }

    private void _$4235() {
        this.jTextFieldSyntax.setToolTipText(MIBObject.getFlatString(this.syntax.toSMI(1, this.rep, null, "\n")));
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border1, "Module");
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border3 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder2 = new TitledBorder(this.border3, "Module");
        this.border4 = BorderFactory.createCompoundBorder(new TitledBorder(new EtchedBorder(0, Color.white, new Color(134, 134, 134)), "OBJECT-TYPE"), BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border5 = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        this.titledBorder3 = new TitledBorder(this.border5, "Revisions");
        this.border6 = BorderFactory.createCompoundBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142)), "INDEX"), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.gridBagLayout1);
        this.jLabelSyntax.setText("Syntax:");
        this.jLabelAccess.setText("Max. Access:");
        this.setBorder(this.border4);
        this.jLabelDefval.setText("Default Value:");
        this.jTextFieldSyntax.setEnabled(false);
        this.jTextFieldSyntax.setColumns(16);
        this.jButtonEdit.setAlignmentY(1.0f);
        this.jButtonEdit.setText("Edit...");
        this.jButtonEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBObjectTypeEditor.this.jButtonEdit_actionPerformed(actionEvent);
            }
        });
        this.jLabelUnits.setText("Units:");
        this.jTextAreaUnits.setPreferredSize(new Dimension(0, 21));
        this.jScrollPane1.setPreferredSize(new Dimension(3, 48));
        this.jButtonChooseDefVal.setToolTipText("Choose the default value from the set of allowed values");
        this.jButtonChooseDefVal.setText("Choose...");
        this.jButtonChooseDefVal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBObjectTypeEditor.this.jButtonChooseDefVal_actionPerformed(actionEvent);
            }
        });
        this.add((Component)this.jLabelSyntax, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jLabelUnits, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jTextFieldSyntax, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jButtonEdit, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jLabelAccess, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jComboBox1, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 16, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jTextFieldDefval, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jLabelDefval, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jScrollPane1, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.jButtonChooseDefVal, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.jTextAreaUnits, null);
    }

    public void okButtonPressed(ActionEvent actionEvent) {
        this.objectType.setAccess(this.jComboBox1.getSelectedItem().toString());
        if (this.jTextFieldDefval.getText().trim().length() > 0) {
            this.objectType.setDefaultValue(this.jTextFieldDefval.getText());
        } else {
            this.objectType.setDefaultValue(null);
        }
        this.objectType.setSyntax(this.syntax);
        if (this.jTextAreaUnits.getText().trim().length() > 0) {
            this.objectType.setUnits(MIBObject.getQuotedString(this.jTextAreaUnits.getText()));
        } else {
            this.objectType.setUnits(null);
        }
    }

    void jButtonEdit_actionPerformed(ActionEvent actionEvent) {
        MIBSyntaxEditor mIBSyntaxEditor = new MIBSyntaxEditor(this.syntax, this.myFrame, this._$4182);
        if (this.rep != null) {
            mIBSyntaxEditor.setRepository(this.rep);
        }
        mIBSyntaxEditor.setReleaseLock(this._$4203);
        mIBSyntaxEditor.setLocationRelativeTo(this);
        mIBSyntaxEditor.setVisible(true);
        this.jTextFieldSyntax.setText(this.syntax.getSyntax());
        this._$4235();
        this._$4231();
    }

    private void _$4231() {
        boolean bl = true;
        boolean bl2 = false;
        MIBTextualConvention mIBTextualConvention = this.rep.getEffectiveSyntax(this.syntax);
        if (mIBTextualConvention.getSyntax().hasEnums()) {
            bl = false;
            bl2 = true;
        } else if (SMI.isCounter(mIBTextualConvention.getSyntax().getSyntax())) {
            bl = false;
            bl2 = false;
        } else if (SMI.isOID(mIBTextualConvention.getSyntax().getSyntax())) {
            bl = false;
            bl2 = true;
        }
        this.jTextFieldDefval.setEnabled(bl && this._$4213);
        this.jButtonChooseDefVal.setEnabled(bl2 && this._$4213);
    }

    public void setAllowDefval(boolean bl) {
        this._$4213 = bl;
        this._$4231();
    }

    public boolean isAllowDefval() {
        return this._$4213;
    }

    public void setReleaseLock(boolean bl) {
        this._$4203 = bl;
        if (bl && this.syntax.getSyntax().equals(SMI.SMI_SYNTAX[0]) && this.syntax.hasEnums()) {
            this.jButtonEdit.setEnabled(true);
        } else {
            this.jButtonEdit.setEnabled(!bl);
        }
        this.jComboBox1.setEnabled(!bl);
    }

    void jButtonChooseDefVal_actionPerformed(ActionEvent actionEvent) {
        MIBTextualConvention mIBTextualConvention = this.rep.getEffectiveSyntax(this.syntax);
        Object[] objectArray = new String[]{"OK", "Clear", "Cancel"};
        if (mIBTextualConvention.getSyntax().hasEnums()) {
            if (!mIBTextualConvention.getSyntax().getSyntax().equals(SMI.SMI_SYNTAX[12])) {
                DefaultValueEditorEnum defaultValueEditorEnum = new DefaultValueEditorEnum(mIBTextualConvention.getSyntax().getEnums());
                defaultValueEditorEnum.setDefaultValue(this.jTextFieldDefval.getText());
                defaultValueEditorEnum.setPreferredSize(new Dimension(500, 320));
                int n = JOptionPane.showOptionDialog(this, defaultValueEditorEnum, "Default Value Editor", 1, -1, null, objectArray, objectArray[0]);
                if (n == 0) {
                    this.jTextFieldDefval.setText(defaultValueEditorEnum.getDefaultValue());
                } else if (n == 1) {
                    this.jTextFieldDefval.setText("");
                }
            } else {
                DefaultValueEditorBITS defaultValueEditorBITS = new DefaultValueEditorBITS(mIBTextualConvention.getSyntax(), this.jTextFieldDefval.getText());
                defaultValueEditorBITS.setPreferredSize(new Dimension(500, 320));
                int n = JOptionPane.showOptionDialog(this, defaultValueEditorBITS, "Default Value Editor", 1, -1, null, objectArray, objectArray[0]);
                if (n == 0) {
                    this.jTextFieldDefval.setText(defaultValueEditorBITS.getDefaultValue());
                } else if (n == 1) {
                    this.jTextFieldDefval.setText("");
                }
            }
        } else if (SMI.isOID(mIBTextualConvention.getSyntax().getSyntax())) {
            StandardDialog standardDialog = new StandardDialog((Frame)this.myFrame, "Select Default Object ID", true, true);
            MIBTreePanel mIBTreePanel = new MIBTreePanel();
            mIBTreePanel.setTree(this.rep, this.rep.getModule(this.objectType.getModuleID()), true);
            standardDialog.setCenterPanel(mIBTreePanel);
            standardDialog.setSize(640, 400);
            standardDialog.setVisible(true);
            if (standardDialog.getResult() == 0) {
                MIBObject mIBObject = mIBTreePanel.getSelectedMIBObject();
                this.jTextFieldDefval.setText(this.rep.getUniqueObjectName(mIBObject));
            }
        }
    }
}

