/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.editor;

import com.agentpp.common.SearchMIBRepository;
import com.agentpp.common.SearchPanel;
import com.agentpp.common.StandardDialog;
import com.agentpp.designer.MIBDesignerFrame;
import com.agentpp.designer.MIBDesignerPanel;
import com.agentpp.designer.editor.MIBObjectChange;
import com.agentpp.designer.editor.MIBObjectChangeFactory;
import com.agentpp.designer.editor.UTCDateTimeChooser;
import com.agentpp.designer.spelling.BackgroundChecker;
import com.agentpp.designer.spelling.JSpellCheckDlg;
import com.agentpp.designer.spelling.JTextAreaWordParser;
import com.agentpp.designer.spelling.SpellCheckedTextEditor;
import com.agentpp.event.OkButtonListener;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.mib.ObjectID;
import com.agentpp.mib.ObjectIDFormatException;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.SMI;
import com.agentpp.util.Regex;
import com.agentpp.util.gui.ErrorDialog;
import com.agentpp.util.gui.ErrorTextPanel;
import com.agentpp.util.gui.ModifierButton;
import com.agentpp.util.gui.StringField;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.wintertree.ssce.PropSpellingSession;
import com.wintertree.ssce.SpellingSession;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;

public class MIBObjectEditor
extends JDialog {
    public static final int APPROVED = 1;
    public static final int CANCELED = 0;
    public static final String NAME_PATTERN = "qwertzuiopasdfghjklyxcvbnmQWERTZUIOPASDFGHJKLYXCVBNM0123456789";
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    protected MIBObject myObject;
    protected MIBRepository rep;
    protected MIBModule myModule;
    protected Vector okListener = new Vector(2);
    protected JFrame myFrame;
    protected int result = 0;
    private boolean _$15885 = false;
    private boolean _$14135;
    JPanel jPanelNorth = new JPanel();
    JPanel jPanelSouth = new JPanel();
    JPanel jPanelCenter = new JPanel();
    JPanel jPanel1 = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton jButtonSave = new JButton();
    JButton jButtonCancel = new JButton();
    JPanel jPanel2 = new JPanel();
    JLabel jLabelName = new JLabel();
    JButton jLabelDescr = new ModifierButton();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    JPanel jPanel3 = new JPanel();
    StringField jTextFieldName = new StringField("qwertzuiopasdfghjklyxcvbnmQWERTZUIOPASDFGHJKLYXCVBNM0123456789", true, 16, false);
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    VerticalFlowLayout verticalFlowLayout2 = new VerticalFlowLayout();
    JPanel jPanel4 = new JPanel();
    JTextField jTextFieldOIDPrefix = new JTextField();
    BorderLayout borderLayout4 = new BorderLayout();
    JTextField jTextFieldOIDSuffix = new StringField("1234567890.", true, 6, false);
    BorderLayout borderLayout5 = new BorderLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea jTextAreaDescr = new JTextArea();
    JButton jLabelReference = new ModifierButton();
    JLabel jLabelStatus = new JLabel();
    JComboBox jComboBoxStatus = new JComboBox();
    JScrollPane jScrollPane2 = new JScrollPane();
    JTextArea jTextFieldReference = new JTextArea();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    BackgroundChecker backgroundCheckerDescr;
    BackgroundChecker backgroundCheckerRef;
    protected PropSpellingSession ssce;
    JButton labelOID = new JButton();
    private RepositoryManager _$294;
    private MIBObjectChangeFactory _$15908;
    private LinkedList _$4171 = new LinkedList();

    public MIBObjectEditor(PropSpellingSession propSpellingSession, RepositoryManager repositoryManager, MIBObject mIBObject, MIBRepository mIBRepository, MIBModule mIBModule, JFrame jFrame, boolean bl, MIBObjectChangeFactory mIBObjectChangeFactory) {
        super(jFrame, mIBObject.getTypeString(), bl);
        int n;
        this.ssce = propSpellingSession;
        this.myFrame = jFrame;
        this.myObject = mIBObject;
        this.myModule = mIBModule;
        this.rep = mIBRepository;
        this._$294 = repositoryManager;
        this._$15908 = mIBObjectChangeFactory;
        if (mIBModule.getSMIVersion() == 1) {
            this.jTextFieldName.setPattern("qwertzuiopasdfghjklyxcvbnmQWERTZUIOPASDFGHJKLYXCVBNM0123456789-");
        } else {
            this.jTextFieldName.setPattern(NAME_PATTERN);
        }
        if (mIBObject instanceof MIBTextualConvention) {
            this.jTextFieldName.setFirstUpperCase(true);
        } else {
            this.jTextFieldName.setFirstLowerCase(true);
        }
        boolean bl2 = false;
        if (mIBModule.getSMIVersion() != 1) {
            for (n = 3; n < SMI.STATUS.length; ++n) {
                this.jComboBoxStatus.addItem(SMI.STATUS[n]);
                if (this.myObject.getStatus() == null || !SMI.STATUS[n].equals(this.myObject.getStatus())) continue;
                this.jComboBoxStatus.setSelectedIndex(n - 3);
                bl2 = true;
            }
            if (!bl2) {
                this.jComboBoxStatus.setSelectedIndex(SMI.STATUS.length - 4);
            }
        } else {
            for (n = 1; n < SMI.STATUS.length - 1; ++n) {
                this.jComboBoxStatus.addItem(SMI.STATUS[n]);
                if (this.myObject.getStatus() == null || !SMI.STATUS[n].equals(this.myObject.getStatus())) continue;
                this.jComboBoxStatus.setSelectedIndex(n - 1);
                bl2 = true;
            }
            if (!bl2) {
                this.jComboBoxStatus.setSelectedIndex(0);
            }
        }
        if (!(this.myObject instanceof MIBModule || this.myObject.getType() != 10 && (this.myObject.getStatus() != null || this.myObject instanceof MIBAgentCaps || this.myObject instanceof MIBCompliance))) {
            this.jComboBoxStatus.setEnabled(false);
            this.jTextAreaDescr.setEnabled(false);
            this.jLabelDescr.setEnabled(false);
            this.jTextAreaDescr.setEditable(false);
            this.jTextFieldReference.setEditable(false);
            this.jLabelReference.setEnabled(false);
        } else if (this.myObject instanceof MIBModule) {
            this.jTextFieldReference.setEnabled(false);
            this.jLabelReference.setEnabled(false);
            this.jComboBoxStatus.setEnabled(false);
        } else if (this.myObject instanceof MIBTextualConvention) {
            this.jTextFieldOIDSuffix.setEnabled(false);
        }
        if (this.myObject.getDescription() != null) {
            this.jTextAreaDescr.setText(MIBObject.getUnquotedString(this.myObject.getDescription()));
        }
        if (this.myObject.getOid() != null) {
            try {
                String string = this.myObject.getPrintableOid();
                MIBObject mIBObject2 = mIBRepository.getParent(this.myObject);
                if (mIBObject2 != null) {
                    string = mIBObject2.getName();
                    int n2 = this.myObject.getOid().size() - mIBObject2.getOid().size();
                    if (n2 > 1) {
                        ObjectID objectID = this.myObject.getOid().getSuffix(n2);
                        objectID = ObjectID.trim(objectID);
                        string = string + "." + objectID.toString();
                    }
                }
                this.jTextFieldOIDPrefix.setText(string);
                this.jTextFieldOIDSuffix.setText(this.myObject.getOid().getSuffix(1).toString());
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                // empty catch block
            }
        }
        this.jTextFieldOIDPrefix.setEnabled(false);
        this.jTextFieldOIDPrefix.setEditable(false);
        this.jTextFieldName.setText(this.myObject.getName());
        if (this.myObject instanceof MIBModule) {
            this.jTextFieldReference.setEnabled(false);
        } else if (this.myObject.hasReference()) {
            this.jTextFieldReference.setText(MIBObject.getUnquotedString(this.myObject.getReference()));
        }
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.backgroundCheckerDescr = MIBObjectEditor.backgroundSpellCheck(propSpellingSession, this.jTextAreaDescr);
        this.backgroundCheckerRef = MIBObjectEditor.backgroundSpellCheck(propSpellingSession, this.jTextFieldReference);
    }

    public void setReleaseLock(boolean bl) {
        this.jTextFieldOIDSuffix.setEnabled(!bl);
        this.jTextFieldName.setEnabled(!bl);
        this._$14135 = bl;
    }

    public MIBObjectEditor() {
        this(null, null, new MIBObject(), new MIBRepository(), new MIBModule(), null, false, null);
    }

    public void setCenterPanel(JPanel jPanel) {
        this.jPanelCenter.add((Component)jPanel, "East");
        this.pack();
    }

    public void addOkButtonListener(OkButtonListener okButtonListener) {
        this.okListener.addElement(okButtonListener);
    }

    void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this.titledBorder1 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(142, 142, 142)), "Object Definition");
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.panel1.setLayout(this.borderLayout1);
        this.jPanelSouth.setLayout(this.borderLayout2);
        this.jPanel1.setLayout(this.flowLayout1);
        this.jButtonSave.setText("Save");
        this.jButtonSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBObjectEditor.this.jButtonSave_actionPerformed(actionEvent);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBObjectEditor.this.jButtonCancel_actionPerformed(actionEvent);
            }
        });
        this.flowLayout1.setAlignment(2);
        this.flowLayout1.setHgap(10);
        this.flowLayout1.setVgap(10);
        this.jPanelNorth.setLayout(this.gridBagLayout1);
        this.jPanel2.setLayout(this.verticalFlowLayout2);
        this.jLabelName.setText("Object Name:");
        this.jLabelDescr.setHorizontalAlignment(2);
        this.jLabelDescr.setHorizontalTextPosition(2);
        this.jLabelDescr.setText("Description:");
        this.jLabelDescr.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBObjectEditor.this.jLabelDescr_actionPerformed(actionEvent);
            }
        });
        this.jPanelNorth.setBorder(this.border2);
        this.jPanel3.setLayout(this.verticalFlowLayout1);
        this.jTextFieldName.setPreferredSize(new Dimension(220, 21));
        this.jTextFieldName.setColumns(20);
        this.jPanel3.setMinimumSize(new Dimension(4, 17));
        this.jPanel4.setLayout(this.borderLayout4);
        this.jTextFieldOIDPrefix.setColumns(18);
        this.jPanelCenter.setLayout(this.borderLayout5);
        this.jTextFieldOIDSuffix.setColumns(5);
        this.jTextAreaDescr.setLineWrap(false);
        this.jTextAreaDescr.setColumns(25);
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setPreferredSize(new Dimension(262, 80));
        this.jLabelReference.setHorizontalAlignment(2);
        this.jLabelReference.setHorizontalTextPosition(2);
        this.jLabelReference.setText("Reference: ");
        this.jLabelReference.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBObjectEditor.this.jLabelReference_actionPerformed(actionEvent);
            }
        });
        this.verticalFlowLayout2.setVgap(9);
        this.jLabelStatus.setText("Status:");
        this.jComboBoxStatus.setPreferredSize(new Dimension(262, 22));
        this.verticalFlowLayout1.setVerticalFill(true);
        this.jScrollPane2.setHorizontalScrollBarPolicy(31);
        this.jTextFieldReference.setRows(1);
        this.labelOID.setToolTipText("Click to verify that this OID is not used by any other MIB module in the current repository");
        this.labelOID.setHorizontalAlignment(2);
        this.labelOID.setHorizontalTextPosition(2);
        this.labelOID.setText("Object ID:");
        this.labelOID.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBObjectEditor.this.labelOID_actionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanelSouth, "South");
        this.jPanelSouth.add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jButtonSave, null);
        this.jPanel1.add((Component)this.jButtonCancel, null);
        this.panel1.add((Component)this.jPanelCenter, "Center");
        this.jPanelCenter.add((Component)this.jPanelNorth, "Center");
        this.jPanelNorth.add((Component)this.jLabelName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelNorth.add((Component)this.jLabelStatus, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelNorth.add((Component)this.jLabelReference, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelNorth.add((Component)this.jLabelDescr, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelNorth.add((Component)this.jTextFieldName, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelNorth.add((Component)this.jTextFieldOIDPrefix, new GridBagConstraints(1, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelNorth.add((Component)this.jTextFieldOIDSuffix, new GridBagConstraints(2, 1, 1, 1, 0.5, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelNorth.add((Component)this.jComboBoxStatus, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelNorth.add((Component)this.jScrollPane2, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelNorth.add((Component)this.jScrollPane1, new GridBagConstraints(1, 4, 2, 4, 1.0, 2.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.jPanelNorth.add((Component)this.labelOID, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.jTextAreaDescr, null);
        this.jScrollPane2.getViewport().add((Component)this.jTextFieldReference, null);
        this.jPanelNorth.add((Component)this.jScrollPane2, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.getRootPane().setDefaultButton(this.jButtonSave);
    }

    protected int myCenterX(Dimension dimension) {
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        return (dimension2.width - dimension.width) / 2 + point.x;
    }

    protected int myCenterY(Dimension dimension) {
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        return (dimension2.height - dimension.height) / 2 + point.y;
    }

    void jButtonSave_actionPerformed(ActionEvent actionEvent) {
        Comparable<StringBuffer> comparable;
        Object object;
        Vector<Object> vector;
        Comparable comparable2;
        if (this.jTextFieldName.isEnabled()) {
            if (!this._$15925(this.jTextFieldName.getText())) {
                return;
            }
            if (this.myModule != null && (comparable2 = this.myModule.getObjectByName(this.jTextFieldName.getText())) != null && !((MIBObject)comparable2).equals(this.myObject)) {
                String[] stringArray = new String[]{"The object name " + this.jTextFieldName.getText(), "is already used within MIB module " + this.myModule.getModuleName(), "Please choose another object name before saving!"};
                ErrorDialog errorDialog = new ErrorDialog(this.myFrame, "Duplicate Object Name", true, false, new ErrorTextPanel(stringArray));
                errorDialog.setLocationRelativeTo(this);
                errorDialog.setVisible(true);
                return;
            }
        }
        comparable2 = null;
        boolean bl = false;
        if (this.jTextFieldOIDSuffix.isEnabled()) {
            try {
                vector = this.myObject.getOid().getPrefix(this.myObject.getOid().size() - 1).toString();
                if (this.jTextFieldOIDSuffix.getText().length() > 0) {
                    vector = (String)((Object)vector) + "." + this.jTextFieldOIDSuffix.getText();
                    object = new ObjectID(this.jTextFieldOIDSuffix.getText());
                    if (!((ObjectID)object).isValid()) {
                        String[] stringArray = new String[]{"The object identifier suffix '" + this.jTextFieldOIDSuffix.getText() + "'", "is invalid!", "Please choose another suffix before saving!"};
                        ErrorDialog errorDialog = new ErrorDialog(this.myFrame, "Invalid OID suffix", true, false, new ErrorTextPanel(stringArray));
                        errorDialog.setLocationRelativeTo(this);
                        errorDialog.setVisible(true);
                        return;
                    }
                    if (((ObjectID)object).size() != 1 && this.myObject instanceof MIBObjectType && ((MIBObjectType)this.myObject).isColumnarObject()) {
                        String[] stringArray = new String[]{"The object identifier suffix '" + this.jTextFieldOIDSuffix.getText() + "'", "must contain exactly one sub-ID for columnar objects!", "Please choose another suffix before saving!"};
                        ErrorDialog errorDialog = new ErrorDialog(this.myFrame, "Invalid OID suffix", true, false, new ErrorTextPanel(stringArray));
                        errorDialog.setLocationRelativeTo(this);
                        errorDialog.setVisible(true);
                        return;
                    }
                } else if (this.jTextFieldOIDSuffix.getText().length() == 0 && this.myObject instanceof MIBObjectType && ((MIBObjectType)this.myObject).isColumnarObject()) {
                    String[] stringArray = new String[]{"The given object identifier suffix must", "contain exactly one sub-ID for columnar objects!", "Please choose another suffix before saving!"};
                    ErrorDialog errorDialog = new ErrorDialog(this.myFrame, "Invalid OID suffix", true, false, new ErrorTextPanel(stringArray));
                    errorDialog.setLocationRelativeTo(this);
                    errorDialog.setVisible(true);
                    return;
                }
                comparable2 = new ObjectID((String)((Object)vector));
                object = this.rep.getObjectsByOid((ObjectID)comparable2);
                int n = -1;
                int n2 = this.myObject.getType() == 10 ? 0 : 1;
                comparable = new StringBuffer();
                if (object != null) {
                    for (int i = 0; i < ((Object)object).length; ++i) {
                        if (this.myObject.equals(object[i])) continue;
                        if (bl) {
                            ((StringBuffer)comparable).append(", ");
                        }
                        ((StringBuffer)comparable).append(((MIBObject)object[i]).getName());
                        bl = true;
                        if (((MIBObject)object[i]).getType() == 10) continue;
                        ++n2;
                        n = i;
                    }
                }
                if (bl) {
                    String string = ((StringBuffer)comparable).toString();
                    if (n2 > 1) {
                        string = ((MIBObject)object[n]).getName();
                        String[] stringArray = new String[]{"The object identifier suffix '" + this.jTextFieldOIDSuffix.getText() + "'", "is already used by MIB object registration " + string, "Please choose another suffix before saving!"};
                        JOptionPane.showMessageDialog(this, stringArray, "Duplicate OID Registration", 0);
                        return;
                    }
                    String[] stringArray = new String[]{"The object identifier suffix '" + this.jTextFieldOIDSuffix.getText() + "'", "is already used by the object name" + (string.indexOf(44) > 0 ? "s " : " ") + string + ".", "For best interoperability it is not recommended", "to assign multiple names to an OID.", "Would you like to save this object anyway?"};
                    if (JOptionPane.showConfirmDialog(this, stringArray, "Multiple OID Names", 0, 2) == 1) {
                        return;
                    }
                }
            }
            catch (ObjectIDFormatException objectIDFormatException) {
                objectIDFormatException.printStackTrace();
            }
        }
        if (!this._$15885 && !this._$14135) {
            object = this.rep.getObjectsByOid(this.myObject.getOid());
            vector = !(this.myObject instanceof MIBObjectType) && !(this.myObject instanceof MIBModule) && object != null && ((MIBObject[])object).length > 1 ? new Vector(1) : this.rep.getDescendants(this.myObject);
            this.rep.removeObject(this.myObject);
            this.myModule.remove(this.myObject);
            if (this.jTextFieldOIDSuffix.isEnabled()) {
                MIBObjectChange mIBObjectChange = null;
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    comparable = (MIBObject)enumeration.nextElement();
                    this.rep.removeObject((MIBObject)comparable);
                    this.myModule.remove((MIBObject)comparable);
                    if (this._$15908 != null) {
                        mIBObjectChange = this._$15908.createUpdateEdit((MIBObject)comparable);
                        this._$4171.add(mIBObjectChange);
                    }
                    ObjectID objectID = new ObjectID((ObjectID)comparable2);
                    comparable = ((MIBObject)comparable).getClone();
                    try {
                        objectID.append(((MIBObject)comparable).getOid().getSuffix(((MIBObject)comparable).getOid().size() - ((ObjectID)comparable2).size()));
                        ((MIBObject)comparable).setOid(objectID);
                        this.rep.addObject((MIBObject)comparable);
                        this.myModule.add((MIBObject)comparable);
                        mIBObjectChange.setNewValue((MIBObject)comparable);
                    }
                    catch (ObjectIDFormatException objectIDFormatException) {
                        objectIDFormatException.printStackTrace();
                    }
                }
                this.myObject.setOid((ObjectID)comparable2);
            }
        }
        if (!this._$15885 && !this.myObject.getName().equals(this.jTextFieldName.getText())) {
            MIBDesignerPanel.changeObjectReferences(this.myModule, this.myObject.getName(), this.jTextFieldName.getText(), this._$4171, this._$15908);
        }
        this.myObject.setName(this.jTextFieldName.getText());
        if (!this._$15885) {
            this.rep.addObject(this.myObject);
            this.myModule.add(this.myObject);
        }
        if (this.jTextAreaDescr.isEnabled()) {
            this.myObject.setDescription(MIBObject.getQuotedString(this.jTextAreaDescr.getText(), false));
        }
        if (this.jTextFieldReference.isEnabled()) {
            if (this.jTextFieldReference.getText().length() > 0) {
                this.myObject.setReference(MIBObject.getQuotedString(this.jTextFieldReference.getText()));
            } else {
                this.myObject.setReference(null);
            }
        }
        if (this.jComboBoxStatus.isEnabled()) {
            this.myObject.setStatus(this.jComboBoxStatus.getSelectedItem().toString());
        }
        this.fireOkButtonEvent();
        this.result = 1;
        this.dispose();
    }

    private boolean _$15925(String string) {
        if (!ObjectID.isIdentifier(string)) {
            String[] stringArray = new String[]{"The given object name '" + string + "' is invalid", "Please choose another object name before saving!"};
            ErrorDialog errorDialog = new ErrorDialog(this.myFrame, "Invalid Object Name", true, false, new ErrorTextPanel(stringArray));
            errorDialog.setLocationRelativeTo(this);
            errorDialog.setVisible(true);
            return false;
        }
        return true;
    }

    void jButtonCancel_actionPerformed(ActionEvent actionEvent) {
        this.result = 0;
        this.dispose();
    }

    public void fireOkButtonEvent() {
        Enumeration enumeration = this.okListener.elements();
        while (enumeration.hasMoreElements()) {
            OkButtonListener okButtonListener = (OkButtonListener)enumeration.nextElement();
            okButtonListener.okButtonPressed(new ActionEvent(this, 1001, "OK"));
        }
    }

    public static String getUTCTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        String string = simpleDateFormat.format(new Date(gregorianCalendar.getTime().getTime() - (long)UTCDateTimeChooser.getTimezoneOffsetGMT()));
        string = string + "Z";
        return string;
    }

    public int getResult() {
        return this.result;
    }

    public void setChangeObjectOnly(boolean bl) {
        this._$15885 = bl;
    }

    public boolean isChangeObjectOnly() {
        return this._$15885;
    }

    void jLabelDescr_actionPerformed(ActionEvent actionEvent) {
        if ((actionEvent.getModifiers() & 2) > 0) {
            MIBObjectEditor.checkTextArea(this.ssce, this.myFrame, this.jTextAreaDescr);
        } else {
            MIBObjectEditor.editTextArea(this.ssce, this.myFrame, this.jTextAreaDescr, "Description of " + this.jTextFieldName.getText());
        }
    }

    public static BackgroundChecker backgroundSpellCheck(PropSpellingSession propSpellingSession, final JTextComponent jTextComponent) {
        final BackgroundChecker backgroundChecker = new BackgroundChecker(jTextComponent, propSpellingSession);
        jTextComponent.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                JPopupMenu jPopupMenu;
                if ((mouseEvent.isPopupTrigger() || mouseEvent.getModifiers() == 4) && (jPopupMenu = backgroundChecker.createPopupMenu(mouseEvent.getX(), mouseEvent.getY(), 10, "Ignore All", "Add", "No Suggestions")) != null) {
                    jPopupMenu.show(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        return backgroundChecker;
    }

    public static void editTextArea(PropSpellingSession propSpellingSession, JFrame jFrame, JTextArea jTextArea, String string) {
        SpellCheckedTextEditor spellCheckedTextEditor = new SpellCheckedTextEditor(propSpellingSession, jFrame, string, true);
        spellCheckedTextEditor.setText(jTextArea.getText());
        spellCheckedTextEditor.setColumns(30);
        spellCheckedTextEditor.setPrefferedSize(new Dimension(350, 300));
        spellCheckedTextEditor.setLocationRelativeTo(jFrame);
        spellCheckedTextEditor.setVisible(true);
        if (spellCheckedTextEditor.isApproved()) {
            jTextArea.setText(spellCheckedTextEditor.getText());
        }
    }

    public static void checkTextArea(PropSpellingSession propSpellingSession, JFrame jFrame, JTextArea jTextArea) {
        JTextAreaWordParser jTextAreaWordParser = new JTextAreaWordParser(jTextArea, propSpellingSession.getOption(4096), false);
        JSpellCheckDlg jSpellCheckDlg = new JSpellCheckDlg((Frame)jFrame, (SpellingSession)propSpellingSession, jTextAreaWordParser, propSpellingSession.comparator, propSpellingSession.userLexicons);
        jSpellCheckDlg.minSuggestDepth = propSpellingSession.minSuggestDepth;
        jSpellCheckDlg.setVisible(true);
    }

    void jLabelReference_actionPerformed(ActionEvent actionEvent) {
        if ((actionEvent.getModifiers() & 2) > 0) {
            MIBObjectEditor.checkTextArea(this.ssce, this.myFrame, this.jTextFieldReference);
        } else {
            MIBObjectEditor.editTextArea(this.ssce, this.myFrame, this.jTextFieldReference, "Reference of " + this.jTextFieldName.getText());
        }
    }

    void labelOID_actionPerformed(ActionEvent actionEvent) {
        if (this.myFrame instanceof MIBDesignerFrame) {
            MIBDesignerFrame mIBDesignerFrame = (MIBDesignerFrame)this.myFrame;
            SearchPanel searchPanel = new SearchPanel();
            searchPanel.setSearchConfig(1);
            searchPanel.setIgnoreCase(false);
            String string = "";
            try {
                string = this.myObject.getOid().getPrefix(this.myObject.getOid().size() - 1).toString();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            Regex regex = new Regex();
            String string2 = searchPanel.getSearchExpression();
            try {
                regex.compile(string + ".*");
            }
            catch (ParseException parseException) {
                parseException.printStackTrace();
                return;
            }
            final SearchMIBRepository searchMIBRepository = new SearchMIBRepository(this.myFrame, this._$294, regex, searchPanel);
            StandardDialog standardDialog = new StandardDialog(this.myFrame, "Search Results for OID " + string, true, true){

                public boolean cancel() {
                    searchMIBRepository.cancel = true;
                    return false;
                }

                public boolean ok() {
                    searchMIBRepository.cancel = true;
                    return true;
                }
            };
            standardDialog.setCenterPanel(searchMIBRepository);
            standardDialog.setLocationRelativeTo(this);
            Thread thread = new Thread(searchMIBRepository);
            thread.start();
            standardDialog.setVisible(true);
        }
    }

    public LinkedList getSubtreeEdits() {
        return this._$4171;
    }
}

