/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.editor;

import com.agentpp.designer.editor.MIBObjectEditor;
import com.agentpp.designer.editor.MIBRevisionEditor;
import com.agentpp.designer.spelling.BackgroundChecker;
import com.agentpp.event.OkButtonListener;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRevision;
import com.agentpp.util.gui.ErrorDialog;
import com.agentpp.util.gui.ErrorTextPanel;
import com.agentpp.util.gui.ModifierButton;
import com.agentpp.util.table.TablePanel;
import com.borland.jbcl.layout.VerticalFlowLayout;
import com.wintertree.ssce.PropSpellingSession;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;

public class MIBModuleEditor
extends JPanel
implements OkButtonListener {
    BorderLayout borderLayout1 = new BorderLayout();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    JPanel jPanel1 = new JPanel();
    VerticalFlowLayout verticalFlowLayout1 = new VerticalFlowLayout();
    JLabel jLabelLastUpdated = new JLabel();
    JLabel jLabelOrganization = new JLabel();
    JButton jLabelContact = new ModifierButton();
    JPanel jPanel2 = new JPanel();
    JTextField jTextFieldLastUpdated = new JTextField();
    VerticalFlowLayout verticalFlowLayout2 = new VerticalFlowLayout();
    JTextField jTextFieldOrganization = new JTextField();
    JPanel jPanel3 = new JPanel();
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    BorderLayout borderLayout2 = new BorderLayout();
    TablePanel jPanelTable = new TablePanel();
    BorderLayout borderLayout3 = new BorderLayout();
    JPanel jPanel5 = new JPanel();
    FlowLayout flowLayout1 = new FlowLayout();
    JButton jButtonAddRow = new JButton();
    JButton jButtonRemoveRow = new JButton();
    Border border5;
    TitledBorder titledBorder3;
    Border border6;
    protected MIBModule module = null;
    protected String[] revTitles = new String[]{"Revision", "Description"};
    protected DefaultTableModel tableModel = new DefaultTableModel(this.revTitles, 0);
    JScrollPane jScrollPane1 = new JScrollPane();
    JTextArea jTextFieldContact = new JTextArea();
    JButton jButtonEditRow = new JButton();
    JFrame myFrame = null;
    JPanel jPanel4 = new JPanel();
    BorderLayout borderLayout4 = new BorderLayout();
    JButton jButtonLastUpdated = new JButton();
    private boolean _$8737 = false;
    private PropSpellingSession _$4380;
    private BackgroundChecker _$15359;
    private BackgroundChecker _$15360;

    public MIBModuleEditor() {
        try {
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.jPanelTable.create();
        this.jPanelTable.getJTable().setAutoResizeMode(4);
        this.jPanelTable.getJTable().setSelectionMode(0);
    }

    public MIBModuleEditor(PropSpellingSession propSpellingSession, MIBModule mIBModule, JFrame jFrame) {
        this();
        this._$4380 = propSpellingSession;
        this.myFrame = jFrame;
        this.setModule(mIBModule);
        this._$15359 = MIBObjectEditor.backgroundSpellCheck(propSpellingSession, this.jTextFieldContact);
        this._$15360 = MIBObjectEditor.backgroundSpellCheck(propSpellingSession, this.jTextFieldOrganization);
    }

    public void setModule(MIBModule mIBModule) {
        this.module = mIBModule;
        this.jTextFieldContact.setText(MIBModule.getUnquotedString(mIBModule.getContactInfo()));
        this.jTextFieldLastUpdated.setText(MIBModule.getUnquotedString(mIBModule.getLastUpdated()));
        this.jTextFieldOrganization.setText(MIBModule.getUnquotedString(mIBModule.getOrganization()));
        if (mIBModule.getRevisionsVector() != null) {
            Enumeration enumeration = mIBModule.getRevisionsVector().elements();
            while (enumeration.hasMoreElements()) {
                MIBRevision mIBRevision = (MIBRevision)enumeration.nextElement();
                Vector<String> vector = new Vector<String>(2);
                vector.addElement(MIBObject.getUnquotedString(mIBRevision.getRevision()));
                vector.addElement(MIBObject.getUnquotedString(mIBRevision.getDescription()));
                this.tableModel.addRow(vector);
            }
        }
        if (this.tableModel.getRowCount() > 0) {
            this.jButtonLastUpdated.setEnabled(false);
        }
    }

    public String getOrganization() {
        return MIBObject.getQuotedString(this.jTextFieldOrganization.getText(), this.module.getSMIVersion() == 1);
    }

    public String getLastUpdated() {
        return MIBObject.getQuotedString(this.jTextFieldLastUpdated.getText(), this.module.getSMIVersion() == 1);
    }

    public String getContact() {
        return MIBObject.getQuotedString(this.jTextFieldContact.getText(), this.module.getSMIVersion() == 1);
    }

    public MIBRevision[] getRevisions() {
        TableModel tableModel = this.jPanelTable.getJTable().getModel();
        MIBRevision[] mIBRevisionArray = new MIBRevision[this.jPanelTable.getJTable().getModel().getRowCount()];
        for (int i = 0; i < mIBRevisionArray.length; ++i) {
            mIBRevisionArray[i] = new MIBRevision(MIBObject.getQuotedString(tableModel.getValueAt(i, 0).toString(), false), MIBObject.getQuotedString(tableModel.getValueAt(i, 1).toString(), false));
        }
        return mIBRevisionArray;
    }

    void jbInit() throws Exception {
        this.tableModel.setColumnIdentifiers(this.revTitles);
        this.jPanelTable.setModel(this.tableModel);
        this.border1 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder1 = new TitledBorder(this.border1, "Module");
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border3 = new EtchedBorder(0, Color.white, new Color(134, 134, 134));
        this.titledBorder2 = new TitledBorder(this.border3, "Module");
        this.border4 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.border5 = BorderFactory.createEtchedBorder(Color.white, new Color(142, 142, 142));
        this.titledBorder3 = new TitledBorder(this.border5, "Revisions");
        this.border6 = BorderFactory.createCompoundBorder(this.titledBorder3, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(this.borderLayout1);
        this.jPanel1.setLayout(this.verticalFlowLayout1);
        this.jLabelLastUpdated.setText("Last-Updated:");
        this.jTextFieldLastUpdated.setEditable(false);
        if (this.tableModel.getRowCount() > 0) {
            this.jButtonLastUpdated.setEnabled(false);
        }
        this.jTextFieldLastUpdated.setToolTipText("Last-updated must be identical to the first revision field if present");
        this.jLabelOrganization.setText("Organization:");
        this.jLabelContact.setText("Contact:");
        this.jLabelContact.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBModuleEditor.this.jLabelContact_actionPerformed(actionEvent);
            }
        });
        this.jPanel2.setLayout(this.verticalFlowLayout2);
        this.verticalFlowLayout1.setVgap(10);
        this.setBorder(this.border4);
        this.jPanel3.setLayout(this.borderLayout2);
        this.jPanel5.setLayout(this.flowLayout1);
        this.jButtonAddRow.setText("Add");
        this.jButtonAddRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBModuleEditor.this.jButtonAddRow_actionPerformed(actionEvent);
            }
        });
        this.jButtonRemoveRow.setText("Remove");
        this.jButtonRemoveRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBModuleEditor.this.jButtonRemoveRow_actionPerformed(actionEvent);
            }
        });
        this.jPanel3.setBorder(this.border6);
        this.jPanelTable.setPreferredSize(new Dimension(200, 80));
        this.jScrollPane1.setVerticalScrollBarPolicy(22);
        this.jScrollPane1.setPreferredSize(new Dimension(257, 80));
        this.jButtonEditRow.setText("Edit");
        this.jButtonEditRow.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBModuleEditor.this.jButtonEditRow_actionPerformed(actionEvent);
            }
        });
        this.jPanel4.setLayout(this.borderLayout4);
        this.jButtonLastUpdated.setPreferredSize(new Dimension(75, 25));
        this.jButtonLastUpdated.setText("Update");
        this.jButtonLastUpdated.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MIBModuleEditor.this.jButtonLastUpdated_actionPerformed(actionEvent);
            }
        });
        this.borderLayout4.setHgap(5);
        this.jTextFieldOrganization.setPreferredSize(new Dimension(269, 25));
        this.add((Component)this.jPanel1, "West");
        this.jPanel1.add((Component)this.jLabelLastUpdated, null);
        this.jPanel1.add((Component)this.jLabelOrganization, null);
        this.jPanel1.add((Component)this.jLabelContact, null);
        this.add((Component)this.jPanel2, "Center");
        this.jPanel2.add((Component)this.jPanel4, null);
        this.jPanel4.add((Component)this.jTextFieldLastUpdated, "Center");
        this.jPanel4.add((Component)this.jButtonLastUpdated, "East");
        this.jPanel2.add((Component)this.jTextFieldOrganization, null);
        this.jPanel2.add((Component)this.jScrollPane1, null);
        this.jTextFieldContact.setColumns(25);
        this.jTextFieldContact.setWrapStyleWord(true);
        this.jScrollPane1.getViewport().add((Component)this.jTextFieldContact, null);
        this.add((Component)this.jPanel3, "South");
        this.jPanel3.add((Component)this.jPanelTable, "Center");
        this.jPanel3.add((Component)this.jPanel5, "South");
        this.jPanel5.add((Component)this.jButtonAddRow, null);
        this.jPanel5.add((Component)this.jButtonEditRow, null);
        this.jPanel5.add((Component)this.jButtonRemoveRow, null);
    }

    public void okButtonPressed(ActionEvent actionEvent) {
        this.module.setLastUpdated(MIBObject.getQuotedString(this.jTextFieldLastUpdated.getText(), this.module.getSMIVersion() == 1));
        this.module.setContactInfo(MIBObject.getQuotedString(this.jTextFieldContact.getText(), this.module.getSMIVersion() == 1));
        this.module.setOrganization(MIBObject.getQuotedString(this.jTextFieldOrganization.getText(), this.module.getSMIVersion() == 1));
        MIBRevision[] mIBRevisionArray = this.getRevisions();
        if (this.module.hasRevisions()) {
            if (this.module.getRevisionsVector().size() < mIBRevisionArray.length) {
                this.module.releaseChangedObjects(mIBRevisionArray.length);
            } else if (this.module.getRevisionsVector().size() > mIBRevisionArray.length) {
                if (mIBRevisionArray.length == 0) {
                    this.module.unreleaseObjects(0);
                } else if (!this.module.getRevisionsVector().firstElement().equals(mIBRevisionArray[0])) {
                    this.module.unreleaseObjects(mIBRevisionArray.length + 1);
                }
            }
        }
        this.module.setRevisions(this.getRevisions());
    }

    void jButtonEditRow_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.jPanelTable.getSelectedRowsInTableModel();
        if (nArray.length == 0) {
            return;
        }
        MIBRevision mIBRevision = new MIBRevision(this.tableModel.getValueAt(nArray[0], 0).toString(), this.tableModel.getValueAt(nArray[0], 1).toString());
        MIBRevisionEditor mIBRevisionEditor = new MIBRevisionEditor(this._$4380, mIBRevision, this.myFrame, "MIB Revision", true);
        mIBRevisionEditor.setLocation(this.myCenterX(mIBRevisionEditor.getPreferredSize()), this.myCenterY(mIBRevisionEditor.getPreferredSize()));
        mIBRevisionEditor.setVisible(true);
        this.tableModel.setValueAt(MIBObject.getUnquotedString(mIBRevisionEditor.getValue().getRevision()), nArray[0], 0);
        this.tableModel.setValueAt(MIBObject.getUnquotedString(mIBRevisionEditor.getValue().getDescription()), nArray[0], 1);
        if (nArray[0] == 0) {
            this.jTextFieldLastUpdated.setText(MIBObject.getUnquotedString(mIBRevisionEditor.getValue().getRevision()));
        }
    }

    void jButtonAddRow_actionPerformed(ActionEvent actionEvent) {
        Object[] objectArray;
        int n;
        if (this._$8737 && (n = JOptionPane.showOptionDialog(this, "This operation will release all changes to the last revision! Continue?", "Release Changes", 0, 3, null, objectArray = new Object[]{"OK", "Cancel"}, objectArray[0])) == 1) {
            return;
        }
        objectArray = new String[]{MIBObjectEditor.getUTCTime(), new String()};
        if (this.tableModel.getRowCount() == 0) {
            this.tableModel.addRow(objectArray);
        } else {
            this.tableModel.insertRow(0, objectArray);
        }
        this.jTextFieldLastUpdated.setText((String)objectArray[0]);
        this.jButtonLastUpdated.setEnabled(false);
    }

    void jButtonRemoveRow_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.jPanelTable.getSelectedRowsInTableModel();
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (this._$8737) {
            Object[] objectArray;
            if (nArray.length > 1 || nArray[0] > 0) {
                objectArray = new String[]{"Caution! This operation will remove a revision statement", "of an already released revision of this module.", "Press 'OK' to remove it anyway!"};
                ErrorDialog errorDialog = new ErrorDialog(this.myFrame, "Removing Released Revision", true, true, new ErrorTextPanel((String[])objectArray));
                errorDialog.setLocationRelativeTo(this);
                errorDialog.setVisible(true);
                if (errorDialog.getResult() == 1) {
                    return;
                }
            } else {
                objectArray = new Object[]{"OK", "Cancel"};
                int n = JOptionPane.showOptionDialog(this, "This will mark all objects added since last revision as unreleased! Continue?", "Undo Revision", 0, 3, null, objectArray, objectArray[0]);
                if (n == 1) {
                    return;
                }
            }
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.tableModel.removeRow(nArray[i]);
            for (int j = i + 1; j < nArray.length; ++j) {
                if (nArray[j] <= nArray[i]) continue;
                int n = j;
                nArray[n] = nArray[n] - 1;
            }
        }
        if (this.tableModel.getRowCount() > 0) {
            this.jTextFieldLastUpdated.setText(this.tableModel.getValueAt(0, 0).toString());
        } else {
            this.jButtonLastUpdated.setEnabled(true);
        }
    }

    protected int myCenterX(Dimension dimension) {
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        return (dimension2.width - dimension.width) / 2 + point.x;
    }

    protected int myCenterY(Dimension dimension) {
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        return (dimension2.height - dimension.height) / 2 + point.y;
    }

    void jButtonLastUpdated_actionPerformed(ActionEvent actionEvent) {
        this.jTextFieldLastUpdated.setText(MIBObjectEditor.getUTCTime());
    }

    public void setReleaseLock(boolean bl) {
        this._$8737 = bl;
    }

    public boolean isReleaseLock() {
        return this._$8737;
    }

    void jLabelContact_actionPerformed(ActionEvent actionEvent) {
        if ((actionEvent.getModifiers() & 2) > 0) {
            MIBObjectEditor.checkTextArea(this._$4380, this.myFrame, this.jTextFieldContact);
        } else {
            MIBObjectEditor.editTextArea(this._$4380, this.myFrame, this.jTextFieldContact, "Contact of " + this.module.getName());
        }
    }
}

