/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.editor;

import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBCondGroup;
import com.agentpp.mib.MIBException;
import com.agentpp.mib.MIBGroup;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBVariation;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.SMI;
import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.field.cell.JCComboFieldCellEditor;
import com.klg.jclass.field.validate.JCStringValidator;
import com.klg.jclass.table.TableDataModel;
import com.klg.jclass.table.data.JCVectorDataSource;
import com.klg.jclass.util.swing.JCListModel;
import com.klg.jclass.util.value.StringValueModel;
import java.awt.AWTEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JTextField;
import javax.swing.ListModel;

public class JCObjectCellEditor
extends JCComboFieldCellEditor {
    public static final int COLUMNS = 0;
    public static final int TABLES = 1;
    public static final int NOTIFICATIONS = 2;
    public static final int ACCESSIBLE_OBJECTS = 3;
    public static final int MODULES = 4;
    public static final int GROUPS = 5;
    public static final int GROUPS_AND_OBJECTS = 6;
    public static final int IMPORTED_MODULES = 7;
    public static final int OBJECTS = 8;
    public static final int MODULES_ZEROCASE = 9;
    public static final int CREATABLE_COLUMNS = 10;
    protected int mode = 0;
    private MIBRepository _$2384;
    private TableDataModel _$10720 = new JCVectorDataSource(0, 0, null, null, null);
    protected RepositoryManager repMan = null;
    protected Object edited = null;
    protected Hashtable negativeList = new Hashtable();
    protected Hashtable values = new Hashtable();
    private boolean _$10723;

    public JCObjectCellEditor(int n, MIBRepository mIBRepository) {
        this.mode = n;
        this._$2384 = mIBRepository;
        this.setAutoComplete(true, true, false, false, null);
        JCStringValidator jCStringValidator = new JCStringValidator();
        jCStringValidator.setMatchPickList(true);
        jCStringValidator.setAllowNull(false);
        jCStringValidator.setPickList(this.getPickList(null));
        this.setValueModel(new StringValueModel());
        this.setValidator(jCStringValidator);
        this.setSelectOnEnter(false);
    }

    public void cancelCellEditing() {
        super.cancelCellEditing();
        if (!this.isEditFinished()) {
            this.exclude(this.getCellEditorValue());
        }
        this.setEditFinished(true);
    }

    public boolean stopCellEditing() {
        boolean bl = super.stopCellEditing();
        if (!this.isEditFinished()) {
            this.exclude(this.getCellEditorValue());
        }
        this.setEditFinished(true);
        return bl;
    }

    public ListModel getPickList(Object object) {
        this.include(object);
        if (this._$2384 == null) {
            return new JCListModel();
        }
        Vector vector = this.getAvailableObjects(object);
        Collections.sort(vector);
        this.values.clear();
        for (int i = 0; i < vector.size(); ++i) {
            this.values.put(vector.get(i).toString(), vector.get(i));
            vector.set(i, vector.get(i).toString());
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return new JCListModel(objectArray);
    }

    public void setMode(int n) {
        this.mode = n;
    }

    public void setNegativeList(Vector vector) {
        this.negativeList = new Hashtable(vector.size() + 5);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.negativeList.put(e.toString(), e);
        }
    }

    public void exclude(Object object) {
        if (object != null && object.toString() != null) {
            this.negativeList.put(object.toString(), object);
        }
    }

    public void include(Object object) {
        if (object != null && object.toString() != null) {
            this.negativeList.remove(object.toString());
        }
    }

    public void setColumnsModel(TableDataModel tableDataModel) {
        this._$10720 = tableDataModel;
    }

    public void setRepository(MIBRepository mIBRepository) {
        this._$2384 = mIBRepository;
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this.repMan = repositoryManager;
    }

    public RepositoryManager getRepositoryManager() {
        return this.repMan;
    }

    public Object getCellEditorValue() {
        if (this.getState() != 1) {
            return this.edited;
        }
        if (this.edited == null) {
            return super.getValue();
        }
        Object object = super.getValue();
        String string = null;
        if (object instanceof String) {
            string = (String)super.getValue();
        }
        if (string != null && this.edited instanceof String && this.values.get(string) == null) {
            return this.edited;
        }
        if (this.edited instanceof MIBModule) {
            ((MIBModule)this.edited).setModuleName(string);
        } else if (this.edited instanceof MIBObject) {
            ((MIBObject)this.edited).setName(string);
        } else if (this.edited instanceof MIBVariation) {
            ((MIBVariation)this.edited).setVariation(string);
        } else if (this.edited instanceof MIBSupportedModule) {
            MIBSupportedModule mIBSupportedModule = (MIBSupportedModule)this.edited;
            if (mIBSupportedModule == null) {
                return this.edited;
            }
            if (mIBSupportedModule.getSupports() != null && !mIBSupportedModule.getSupports().equals(string)) {
                mIBSupportedModule.setIncludes(new Vector());
                mIBSupportedModule.setVariations(new Vector());
            }
            mIBSupportedModule.setSupports(string);
        } else if (this.edited instanceof MIBComplianceModule) {
            MIBComplianceModule mIBComplianceModule = (MIBComplianceModule)this.edited;
            if (mIBComplianceModule == null) {
                return this.edited;
            }
            if (mIBComplianceModule.getModuleName() != null && !mIBComplianceModule.getModuleName().equals(string)) {
                mIBComplianceModule.setMandatory(new Vector());
                mIBComplianceModule.setVariations(new Vector());
            }
            mIBComplianceModule.setModuleName(string);
        } else if (this.edited instanceof String) {
            return string;
        }
        return this.edited;
    }

    public Vector getAvailableObjects(Object object) {
        Vector<String> vector = new Vector<String>();
        switch (this.mode) {
            case 10: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObjectType mIBObjectType;
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBObjectType) || !(mIBObjectType = (MIBObjectType)mIBObject).isColumnarObject() || !mIBObjectType.getAccess().equals(SMI.ACCESS[3])) continue;
                    vector.addElement(mIBObject.getName());
                }
                break;
            }
            case 0: {
                MIBObjectType mIBObjectType;
                MIBObject mIBObject;
                Vector<Object> vector2 = new Vector<Object>(this._$10720.getNumRows() + 1);
                for (int i = 0; i < this._$10720.getNumRows(); ++i) {
                    vector2.addElement(this._$10720.getTableDataItem(i, 1));
                }
                if (vector2 != null) {
                    Enumeration enumeration = vector2.elements();
                    while (enumeration.hasMoreElements()) {
                        mIBObject = (MIBObject)enumeration.nextElement();
                        if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBObjectType) || SMI.accessType((mIBObjectType = (MIBObjectType)mIBObject).getAccess()) != 0 && SMI.accessType(mIBObjectType.getAccess()) != 1) continue;
                        if (this._$2384.getObjectsByName(mIBObjectType.getName()).length > 1) {
                            String string = this._$2384.getModuleName(mIBObjectType.getModuleID());
                            if (string != null) {
                                vector.addElement(string + "." + mIBObjectType.getName());
                            } else {
                                vector.addElement(mIBObjectType.getName());
                            }
                        }
                        vector.addElement(mIBObjectType.getName());
                    }
                }
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBObjectType) || !(mIBObjectType = (MIBObjectType)mIBObject).isColumnarObject() || SMI.accessType(mIBObjectType.getAccess()) != 0 && SMI.accessType(mIBObjectType.getAccess()) != 1) continue;
                    vector.addElement(mIBObjectType.getName());
                }
                break;
            }
            case 1: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObjectType mIBObjectType;
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBObjectType) || !(mIBObjectType = (MIBObjectType)mIBObject).isTable() || !mIBObjectType.hasIndexPart() || mIBObjectType.getIndexPart().isAugment()) continue;
                    vector.addElement(mIBObjectType.getName());
                }
                break;
            }
            case 2: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBNotifyType)) continue;
                    vector.addElement(mIBObject.getName());
                }
                break;
            }
            case 3: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBObjectType) || SMI.accessType(((MIBObjectType)mIBObject).getAccess()) == 0) continue;
                    vector.addElement(mIBObject.getName());
                }
                break;
            }
            case 4: 
            case 9: {
                if (this.repMan == null) {
                    return vector;
                }
                if (this.mode == 9) {
                    vector.addElement("");
                }
                try {
                    String[] stringArray = this.repMan.getModuleNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        vector.addElement(stringArray[i]);
                    }
                    break;
                }
                catch (IOException iOException) {
                    System.out.println("Error while reading from repository: " + iOException.getMessage());
                    break;
                }
            }
            case 5: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBGroup)) continue;
                    vector.addElement(mIBObject.getName());
                }
                break;
            }
            case 6: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || (!(mIBObject instanceof MIBGroup) || !(object instanceof MIBCondGroup) && !(object instanceof String)) && (!(mIBObject instanceof MIBObjectType) && !(mIBObject instanceof MIBNotifyType) || !(object instanceof MIBException) && !(object instanceof String))) continue;
                    vector.addElement(mIBObject.getName());
                }
                break;
            }
            case 8: {
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBObjectType) && !(mIBObject instanceof MIBNotifyType)) continue;
                    vector.addElement(mIBObject.getName());
                }
                break;
            }
            case 7: {
                vector.addElement("");
                Enumeration<? extends MIBObject> enumeration = this._$2384.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = enumeration.nextElement();
                    if (this.negativeList.get(mIBObject.toString()) != null || !(mIBObject instanceof MIBModule)) continue;
                    vector.addElement(((MIBModule)mIBObject).getModuleName());
                }
                break;
            }
        }
        return vector;
    }

    public void initialize(AWTEvent aWTEvent, JCCellInfo jCCellInfo, Object object) {
        if (!this.isEditFinished() && this.edited != null) {
            this.exclude(this.edited);
        }
        this.edited = object;
        this.setEditFinished(false);
        JCStringValidator jCStringValidator = new JCStringValidator();
        jCStringValidator.setMatchPickList(true);
        jCStringValidator.setAllowNull(false);
        jCStringValidator.setPickList(this.getPickList(object));
        this.setValidator(jCStringValidator);
        this.setSelectOnEnter(true);
        super.initialize(aWTEvent, jCCellInfo, object != null ? object.toString() : null);
        ((JTextField)super.getEditor().getEditorComponent()).selectAll();
    }

    public void setEditFinished(boolean bl) {
        this._$10723 = bl;
    }

    public boolean isEditFinished() {
        return this._$10723;
    }
}

