/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer.editor;

import com.agentpp.common.ShufflePanel;
import com.agentpp.common.table.TableUtils;
import com.agentpp.designer.editor.ImportEditor_source_itemAdapter;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBNotifyType;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBObjectType;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBTextualConvention;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.SMI;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class ImportEditor
extends JPanel
implements JCSelectListener {
    public static final String[] STANDARD_MIBS = new String[]{"SNMPv2-SMI", "SNMPv2-TC", "SNMPv2-CONF", "RFC1155-SMI", "RFC1215"};
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    JComboBox source = new JComboBox();
    ShufflePanel imports = new ShufflePanel();
    Border border1 = BorderFactory.createEtchedBorder(0, Color.white, new Color(148, 145, 140));
    JLabel jLabelSource = new JLabel();
    Border border3 = BorderFactory.createEtchedBorder(Color.white, new Color(148, 145, 140));
    Border border4 = new TitledBorder(this.border3, "Objects and Definitions");
    private Vector _$10127;
    private RepositoryManager _$10128;
    private MIBRepository _$4202;
    private MIBModule _$10129;
    private boolean _$10130 = false;
    JLabel jLabelComment = new JLabel();
    JScrollPane jScrollPaneComment = new JScrollPane();
    JTextArea asn1Comment = new JTextArea();

    public ImportEditor() {
        this(null, null, null, null);
    }

    public ImportEditor(MIBRepository mIBRepository, MIBModule mIBModule, Vector vector, RepositoryManager repositoryManager) {
        this._$10127 = vector;
        this._$10128 = repositoryManager;
        this._$4202 = mIBRepository;
        this._$10129 = mIBModule;
        try {
            this._$4216();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this._$10135();
        }
        catch (IOException iOException) {
            this._$10136(iOException);
        }
        this.imports.getRightTable().addSelectListener(this);
    }

    public void setModuleSelectionEnabled(boolean bl) {
        this.source.setEnabled(bl);
    }

    public void setAllowNewOnly(boolean bl) {
        this._$10130 = bl;
    }

    public void setSelectedModule(String string) {
        this.source.setSelectedItem(string);
        try {
            this._$10143();
        }
        catch (IOException iOException) {
            this._$10136(iOException);
        }
        this._$10144();
    }

    private void _$10135() throws IOException {
        this.source.removeAllItems();
        String[] stringArray = this._$10128.getModuleNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this._$10130 && this._$10145(stringArray[i])) continue;
            this.source.addItem(stringArray[i]);
        }
    }

    public Vector getImports() {
        String string = (String)this.source.getSelectedItem();
        if (string != null) {
            this._$10146(string);
        }
        return this._$10127;
    }

    public MIBImport getSelectedImport() {
        String string = (String)this.source.getSelectedItem();
        if (string == null) {
            return null;
        }
        this._$10146(string);
        MIBImport mIBImport = this._$10148(string);
        return mIBImport;
    }

    private Vector _$10149() {
        Vector vector = this.imports.getRightData().getCells();
        Vector vector2 = new Vector(vector.size() + 1);
        for (int i = 0; i < vector.size(); ++i) {
            vector2.add(((Vector)vector.get(i)).get(0));
        }
        return vector2;
    }

    private void _$10143() throws IOException {
        Serializable serializable;
        MIBObject[] mIBObjectArray;
        String string = (String)this.source.getSelectedItem();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        MIBImport mIBImport = this._$10148(string);
        if (mIBImport != null && mIBImport.hasComment()) {
            this.asn1Comment.setText(mIBImport.getComment());
        } else {
            this.asn1Comment.setText("");
        }
        if (string != null) {
            Vector<String> vector3;
            String string2;
            mIBObjectArray = this._$10128.getObjects(string);
            serializable = new MIBRepository(mIBObjectArray);
            Enumeration<? extends MIBObject> enumeration = ((MIBRepository)serializable).objectsByName();
            int n = 0;
            int n2 = SMI.smiv2MIB(string);
            if (n2 >= 0) {
                int n3 = 0;
                while (n3 < SMI.smiv2Constructs[n2].length) {
                    string2 = SMI.smiv2Constructs[n2][n3];
                    vector3 = new Vector<String>(1);
                    vector3.add(string2);
                    if (mIBImport != null && mIBImport.imports(string2)) {
                        vector2.add(vector3);
                    } else {
                        vector.add(vector3);
                    }
                    ++n3;
                    ++n;
                }
            }
            while (enumeration.hasMoreElements()) {
                MIBObject mIBObject = enumeration.nextElement();
                if (mIBObject instanceof MIBNotifyType || mIBObject instanceof MIBModule && ((MIBModule)mIBObject).getSMIVersion() == 1) continue;
                string2 = mIBObject.getName();
                vector3 = new Vector(1);
                vector3.add(string2);
                if (mIBImport != null && mIBImport.imports(string2)) {
                    vector2.add(vector3);
                } else {
                    vector.add(vector3);
                }
                ++n;
            }
        }
        mIBObjectArray = new JCVectorDataSource();
        mIBObjectArray.setNumRows(vector2.size());
        mIBObjectArray.setNumColumns(1);
        mIBObjectArray.setCells(vector2);
        mIBObjectArray.setColumnLabels(new String[]{"Object"});
        serializable = new JCVectorDataSource();
        ((JCVectorDataSource)serializable).setNumRows(vector.size());
        ((JCVectorDataSource)serializable).setNumColumns(1);
        ((JCVectorDataSource)serializable).setCells(vector);
        ((JCVectorDataSource)serializable).setColumnLabels(new String[]{"Object"});
        this.imports.setRightData((JCVectorDataSource)mIBObjectArray);
        this.imports.setLeftData((JCVectorDataSource)serializable);
    }

    private boolean _$10145(String string) {
        return this._$10148(string) != null;
    }

    private MIBImport _$10148(String string) {
        for (int i = 0; i < this._$10127.size(); ++i) {
            if (!((MIBImport)this._$10127.get(i)).getSource().equals(string)) continue;
            return (MIBImport)this._$10127.get(i);
        }
        return null;
    }

    private void _$4216() throws Exception {
        this.setLayout(this.gridBagLayout1);
        this.imports.setBorder(this.border4);
        this.jLabelSource.setText("Source MIB Module:");
        this.source.addItemListener(new ImportEditor_source_itemAdapter(this));
        this.jLabelComment.setText("ASN.1 Comment:");
        this.asn1Comment.setText("");
        this.add((Component)this.imports, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.jLabelSource, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
        this.add((Component)this.jLabelComment, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.add((Component)this.source, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jScrollPaneComment.getViewport().add(this.asn1Comment);
        this.add((Component)this.jScrollPaneComment, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.imports.setRightTitle("Imported");
        this.imports.setLeftTitle("Not Imported");
    }

    private void _$10136(IOException iOException) {
        JOptionPane.showMessageDialog(this, new String[]{"Error while accessing the MIB repository: ", iOException.getMessage()}, "MIB Repository I/O Error", 0);
    }

    public void source_itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            try {
                this._$10143();
            }
            catch (IOException iOException) {
                this._$10136(iOException);
            }
            this._$10144();
        } else if (itemEvent.getStateChange() == 2) {
            this._$10146((String)itemEvent.getItem());
        }
    }

    private void _$10146(String string) {
        MIBImport mIBImport = this._$10148(string);
        if (mIBImport != null) {
            Vector vector = this._$10149();
            if (vector.size() == 0) {
                this._$10127.remove(mIBImport);
            }
            mIBImport.setImportsVector(vector);
            mIBImport.setComment(MIBObject.makeASN1Comment(this.asn1Comment.getText()));
        } else {
            Vector vector = this._$10149();
            if (vector.size() == 0) {
                return;
            }
            mIBImport = new MIBImport(string, vector, MIBObject.makeASN1Comment(this.asn1Comment.getText()));
            this._$10127.add(mIBImport);
        }
    }

    private boolean _$10182(String string, String string2) {
        if (this._$10129.isUsedSyntax(string2)) {
            return false;
        }
        try {
            MIBObject[] mIBObjectArray = this._$10128.getObjects(string);
            for (int i = 0; i < mIBObjectArray.length; ++i) {
                Vector<? extends MIBObject> vector;
                if (!mIBObjectArray[i].getName().equals(string2) || mIBObjectArray[i] instanceof MIBTextualConvention || (vector = this._$4202.getChildren(mIBObjectArray[i])).size() <= 0) continue;
                boolean bl = true;
                Iterator iterator = vector.iterator();
                while (iterator.hasNext()) {
                    MIBObject mIBObject = (MIBObject)iterator.next();
                    if (!this._$10129.getModuleID().equals(mIBObject.getModuleID())) continue;
                    bl = false;
                    break;
                }
                return bl;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public void beforeSelect(JCSelectEvent jCSelectEvent) {
    }

    public void select(JCSelectEvent jCSelectEvent) {
    }

    public void afterSelect(JCSelectEvent jCSelectEvent) {
        this._$10144();
    }

    private void _$10144() {
        String string = (String)this.source.getSelectedItem();
        if (string != null) {
            JCVectorDataSource jCVectorDataSource = (JCVectorDataSource)this.imports.getRightTable().getDataSource();
            int[] nArray = TableUtils.getSelectedRows(this.imports.getRightTable());
            boolean bl = true;
            boolean bl2 = true;
            for (int i = 1; i < jCVectorDataSource.getNumRows(); ++i) {
                String string2 = (String)jCVectorDataSource.getTableDataItem(i, 0);
                if (this._$10182(string, string2)) continue;
                bl = false;
                for (int j = 0; j < nArray.length; ++j) {
                    if (nArray[j] != i) continue;
                    bl2 = false;
                }
            }
            this.imports.setRemoveAllEnabled(bl);
            this.imports.setRemoveEnabled(bl2);
        } else {
            this.imports.setRemoveEnabled(true);
        }
    }

    public static boolean autoImportSMIMacros(MIBModule mIBModule) {
        int n;
        int n2;
        for (n2 = 0; n2 < STANDARD_MIBS.length; ++n2) {
            if (!mIBModule.getModuleName().equals(STANDARD_MIBS[n2])) continue;
            return false;
        }
        n2 = mIBModule.getSMIVersion();
        Vector<MIBImport> vector = mIBModule.getImportsVector();
        if (vector == null) {
            vector = new Vector();
            mIBModule.setImportsVector(vector);
        }
        Vector<MIBImport> vector2 = new Vector<MIBImport>(vector.size() + 1);
        for (n = 0; n < vector.size(); ++n) {
            MIBImport mIBImport = vector.get(n);
            vector2.add(new MIBImport(mIBImport));
            for (int i = 0; i < mIBImport.getImportsVector().size(); ++i) {
                if (SMI.getKeyWordType(1, mIBImport.getImportsVector().get(i).toString()) >= 0) {
                    mIBImport.getImportsVector().remove(i);
                    --i;
                    continue;
                }
                if (n2 < 2 || SMI.getKeyWordType(2, mIBImport.getImportsVector().get(i).toString()) < 0) continue;
                mIBImport.getImportsVector().remove(i);
                --i;
            }
            if (mIBImport.getImportsVector().size() != 0) continue;
            vector.remove(n--);
        }
        for (n = 0; n < SMI.smiConstructs[n2 - 1].length; ++n) {
            block4: for (int i = 0; i < SMI.smiConstructs[n2 - 1][n].length; ++i) {
                Enumeration enumeration = mIBModule.objects();
                while (enumeration.hasMoreElements()) {
                    MIBObject mIBObject = (MIBObject)enumeration.nextElement();
                    if (!mIBObject.getTypeString().equals(SMI.smiConstructs[n2 - 1][n][i]) && (!(mIBObject instanceof MIBObjectType) || !((MIBObjectType)mIBObject).getSyntax().getSyntax().equals(SMI.smiConstructs[n2 - 1][n][i])) && (!(mIBObject instanceof MIBTextualConvention) || !((MIBTextualConvention)mIBObject).getSyntax().getSyntax().equals(SMI.smiConstructs[n2 - 1][n][i]))) continue;
                    MIBImport mIBImport = mIBModule.getImports(SMI.smiMIBs[n2 - 1][n]);
                    if (mIBImport == null) {
                        Vector<String> vector3 = new Vector<String>(Arrays.asList(SMI.smiConstructs[n2 - 1][n][i]));
                        mIBImport = new MIBImport(SMI.smiMIBs[n2 - 1][n], vector3);
                        mIBModule.getImportsVector().add(mIBImport);
                        continue block4;
                    }
                    mIBImport.getImportsVector().add(SMI.smiConstructs[n2 - 1][n][i]);
                    continue block4;
                }
            }
        }
        return !vector.equals(vector2);
    }
}

