/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.designer;

import com.agentpp.common.SplashWindow;
import com.agentpp.common.lf.MetalTheme;
import com.agentpp.designer.MIBDesignerFrame;
import com.agentpp.util.UserConfigFile;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.io.File;
import java.net.URL;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class MIBDesigner {
    boolean packFrame = false;

    public MIBDesigner(String string) {
        String[] stringArray;
        Frame frame = new Frame();
        MediaTracker mediaTracker = new MediaTracker(frame);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        URL uRL = classLoader.getResource("com/agentpp/designer/mibdesigner_logo.gif");
        Image image = Toolkit.getDefaultToolkit().getImage(uRL);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SplashWindow splashWindow = new SplashWindow(frame, image, 302, 301);
        splashWindow.setCursor(Cursor.getPredefinedCursor(3));
        if (System.getProperty("java.version").compareTo("1.4") < 0) {
            stringArray = new String[]{"MIB Designer 2.x needs Java Runtime Environment 1.4 or later installed!", "Current version is: " + System.getProperty("java.version")};
            JOptionPane.showMessageDialog(frame, stringArray, "Unsupported JRE", 0);
            System.exit(1);
        }
        stringArray = new UserConfigFile(true);
        stringArray.setConfigName("MIBDesigner3.cf");
        if (!stringArray.read(true)) {
            stringArray.setConfigName("MIBDesigner2.cf");
            stringArray.read(true);
            stringArray.setConfigName("MIBDesigner3.cf");
        }
        MetalTheme metalTheme = new MetalTheme((UserConfigFile)stringArray);
        metalTheme.propertiesChanged();
        MetalLookAndFeel.setCurrentTheme(metalTheme);
        String string2 = stringArray.get("LookAndFeel", null);
        if (string2 != null && string2.length() > 0) {
            try {
                UIManager.setLookAndFeel(string2);
            }
            catch (Exception exception) {
                System.out.println("Unable to load look&feel: " + string2);
            }
        } else {
            try {
                UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MIBDesignerFrame mIBDesignerFrame = new MIBDesignerFrame((UserConfigFile)stringArray, string == null);
        if (this.packFrame) {
            mIBDesignerFrame.pack();
        } else {
            mIBDesignerFrame.validate();
        }
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = mIBDesignerFrame.getSize();
        if (dimension2.height > dimension.height) {
            dimension2.height = dimension.height;
        }
        if (dimension2.width > dimension.width) {
            dimension2.width = dimension.width;
        }
        mIBDesignerFrame.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
        splashWindow.setCursor(Cursor.getDefaultCursor());
        splashWindow.setVisible(false);
        mIBDesignerFrame.setVisible(true);
        if (string != null) {
            mIBDesignerFrame.loadMIB(new File(string), false);
        }
    }

    public static void main(String[] stringArray) {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new MIBDesigner(stringArray.length > 0 ? stringArray[0] : null);
    }
}

