/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table.print;

import com.agentpp.common.table.print.DocumentFlow;
import com.agentpp.common.table.print.PageTableView;
import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCFlow;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCPageTemplate;
import com.klg.jclass.page.JCTab;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.TextMacro;
import java.awt.Color;
import java.awt.Font;
import java.io.StringReader;
import java.util.List;

public class TableFlow
implements DocumentFlow {
    static String template = "<?xml version=\"1.0\"?><!DOCTYPE JCPAGETEMPLATE SYSTEM \"JCPageTemplate.dtd\">\n<JCPAGETEMPLATE TITLE=\"8p5x11\">\n    <PAGE NAME=\"8p5x11\" UNIT=\"inches\">        <LOCATION X=\"0\" Y=\"0\"/>        <SIZE WIDTH=\"8.5\"  HEIGHT=\"11\"/>        <FRAME NAME=\"header\" UNIT=\"inches\">            <LOCATION X=\"1\" Y=\"0.25\"/>            <SIZE WIDTH=\"6.5\"  HEIGHT=\"0.75\"/>        </FRAME>        <FRAME NAME=\"body\" UNIT=\"inches\">            <LOCATION X=\"1\" Y=\"1\"/>            <SIZE WIDTH=\"6.5\"  HEIGHT=\"9\"/>        </FRAME>        <FRAME NAME=\"footer\" UNIT=\"inches\">            <LOCATION X=\"1\" Y=\"10.25\"/>            <SIZE WIDTH=\"6.5\"  HEIGHT=\"0.75\"/>        </FRAME>        <FLOWFRAME NAME=\"body\"/>        <FLOWPAGE NAME=\"8p5x11\"/>        <FLOWSECTION NAME=\"8p5x11\"/>    </PAGE></JCPAGETEMPLATE>\n";
    private String _$18005 = null;
    private Font _$25023;
    private boolean _$24964;
    private boolean _$25024;
    private PageTableView _$25025;

    public List getTemplates() {
        List result = null;
        try {
            result = JCPageTemplate.loadTemplates(new StringReader(template));
        }
        catch (Exception e) {
            System.err.println("Error loading template = " + e);
        }
        return result;
    }

    public String getFlowPage() {
        return "8p5x11";
    }

    public void flow(JCDocument doc, JCPage template) {
        JCPageTable headers;
        JCPageTable table = null;
        if (this._$25025 == null) {
            return;
        }
        JCFrame headerFrame = template.stringToFrame("header");
        try {
            Font pf = new Font("TimesRoman", 0, 14);
            if (this.getHeader() != null) {
                JCTextStyle header = new JCTextStyle("Header");
                Font tmpfont = new Font(pf.getName(), 1, pf.getSize() + 4);
                header.setParagraphSpacing(1.5);
                header.setAlignment(4);
                header.setFont(tmpfont);
                header.makeImmutable();
                headerFrame.print(header, this.getHeader());
            }
        }
        catch (EndOfFrameException e) {
            e.printStackTrace(System.out);
        }
        JCFrame footerFrame = template.stringToFrame("footer");
        JCTextStyle style = (JCTextStyle)JCTextStyle.stringToStyle("default text").clone();
        style.setAlignment(4);
        style.makeImmutable();
        try {
            footerFrame.print(style, TextMacro.PAGE_NUMBER);
        }
        catch (EndOfFrameException e) {
            // empty catch block
        }
        JCFlow flow = new JCFlow(doc);
        style = (JCTextStyle)JCTextStyle.stringToStyle("default text").clone();
        style.setAlignment(2);
        style.setFont(this._$25023);
        style.addTab(new JCTab(new JCUnit.Measure(JCUnit.CM, 1.0)));
        style.makeImmutable();
        JCTextStyle headerStyle = (JCTextStyle)JCTextStyle.HEADING5.clone();
        headerStyle.setFont(this._$25023);
        JCTextStyle code = (JCTextStyle)JCTextStyle.stringToStyle("default text").clone();
        code.setFontFamily("Courier");
        code.setPointSize(12.0);
        code.addTab(new JCTab(new JCUnit.Measure(JCUnit.CM, 1.0)));
        code.makeImmutable();
        JCTextStyle codeBold = (JCTextStyle)code.clone();
        codeBold.setFontStyle(1);
        JCTextStyle bold = (JCTextStyle)style.clone();
        bold.setFontStyle(1);
        flow.setCurrentTextStyle(style);
        flow.newLine();
        this._$25025.setHeaderStyle(headerStyle);
        this._$25025.setCellStyle(style);
        table = this._$25025.createPageTable(doc);
        for (int j = 0; j < table.getRowCount(); ++j) {
            for (int i = 0; i < table.getColumnCount(); ++i) {
                table.getCell(j, i).setStyle(style);
            }
        }
        if (!this._$24964) {
            if (this._$25024) {
                table.setOverflowMode(4);
            } else {
                table.setOverflowMode(2);
            }
        }
        if ((headers = table.getHeaders()) != null) {
            headers.setBackgroundColor(Color.lightGray);
        }
        if (this._$24964) {
            table.fitToFrame(flow.getCurrentFrame(), style);
        }
        flow.print(table);
        flow.newLine();
    }

    public void setHeader(String header) {
        this._$18005 = header;
    }

    public String getHeader() {
        return this._$18005;
    }

    public void setDefaultFont(Font defaultFont) {
        this._$25023 = defaultFont;
    }

    public Font getDefaultFont() {
        return this._$25023;
    }

    public void setFitToPage(boolean fitToPage) {
        this._$24964 = fitToPage;
    }

    public boolean isFitToPage() {
        return this._$24964;
    }

    public void setWrapNextPage(boolean wrapNextPage) {
        this._$25024 = wrapNextPage;
    }

    public boolean isWrapNextPage() {
        return this._$25024;
    }

    public void setCurrentTable(PageTableView currentTable) {
        this._$25025 = currentTable;
    }
}

