/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table.print;

import com.agentpp.common.table.PopupTable;
import com.klg.jclass.page.EndOfFrameException;
import com.klg.jclass.page.JCDocument;
import com.klg.jclass.page.JCFrame;
import com.klg.jclass.page.JCPageTable;
import com.klg.jclass.page.JCPageTableFromJCTable;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.TableDataModel;
import java.awt.Image;
import java.util.Vector;

public class JCPageTableFromJCLiveTable {
    public static int defaultColumnWidth = 75;

    private static void _$25157(JCPageTable pageTable, JCTable jcTable, int j, int i, int colOffset, JCTextStyle cellStyle, JCTextStyle numberStyle, JCTextStyle imageStyle) {
        Object value;
        if (i == -1) {
            value = jcTable.getDataView().getTableRowLabel(j);
            i = 0;
        } else {
            value = jcTable instanceof PopupTable ? ((PopupTable)jcTable).getDisplayValue(j, i) : jcTable.getDataView().getTableDataItem(j, i);
        }
        if (value instanceof Number) {
            pageTable.printToCell(j, i + colOffset, numberStyle, value.toString());
        } else if (value instanceof Image) {
            pageTable.getCell(j, i + colOffset).setStyle(imageStyle);
            pageTable.getCell(j, i + colOffset).setCellAlignment(3);
            pageTable.getCell(j, i + colOffset).setCellValue(value);
        } else if (value != null) {
            pageTable.printToCell(j, i + colOffset, cellStyle, value.toString());
        }
    }

    public static JCPageTable createTable(JCDocument doc, JCTable jcTable, JCTextStyle cellStyle, JCTextStyle headerStyle) {
        JCPageTable pageTable = JCPageTableFromJCTable.createTable(doc, jcTable, false);
        JCPageTable headerTable = pageTable.getHeaders();
        if (headerTable != null) {
            headerTable.getRow(0).setDefaultStyle(headerStyle);
        }
        pageTable.setDefaultStyle(cellStyle);
        int i = 0;
        int j = 0;
        TableDataModel model = jcTable.getDataView().getDataSource();
        JCTextStyle imageStyle = (JCTextStyle)cellStyle.clone();
        imageStyle.setAlignment(4);
        JCTextStyle numberStyle = (JCTextStyle)cellStyle.clone();
        numberStyle.setAlignment(3);
        for (int y = 0; y < model.getNumRows(); ++y) {
            if (jcTable.isRowHidden(y)) continue;
            i = 0;
            int colOffset = 0;
            if (jcTable.isRowLabelDisplay()) {
                colOffset = 1;
                JCPageTableFromJCLiveTable._$25157(pageTable, jcTable, j, -1, 0, cellStyle, numberStyle, imageStyle);
            }
            for (int x = 0; x < model.getNumColumns(); ++x) {
                if (jcTable.isColumnHidden(x)) continue;
                JCPageTableFromJCLiveTable._$25157(pageTable, jcTable, j, i, colOffset, cellStyle, numberStyle, imageStyle);
                ++i;
            }
            ++j;
        }
        if (pageTable.getHeaders() != null) {
            JCPageTable header = pageTable.createHeaders();
            try {
                i = 0;
                for (int x = 0; x < model.getNumColumns(); ++x) {
                    if (jcTable.isColumnHidden(x)) continue;
                    JCFrame frame = header.getCellFrame(0, i++);
                    frame.print(headerStyle, model.getTableColumnLabel(x).toString());
                }
            }
            catch (EndOfFrameException e) {
                // empty catch block
            }
        }
        return pageTable;
    }

    public static JCPageTable createTable(JCDocument doc, TableDataModel tableModel) {
        JCPageTable table = null;
        try {
            JCTextStyle style = JCTextStyle.stringToStyle("default text");
            Vector<JCUnit.Measure> columns = new Vector<JCUnit.Measure>(tableModel.getNumColumns());
            JCUnit.Measure width = new JCUnit.Measure(JCUnit.POINTS, defaultColumnWidth);
            for (int i = 0; i < tableModel.getNumColumns(); ++i) {
                columns.add(width);
            }
            table = new JCPageTable(doc, columns);
            table.setAlignment(4);
            JCPageTable header = table.createHeaders();
            for (int i = 0; i < tableModel.getNumColumns(); ++i) {
                JCFrame frame = header.getCellFrame(0, i);
                Object o = tableModel.getTableColumnLabel(i);
                frame.print(style, o.toString());
            }
            boolean row = false;
            for (int rowIdx = 0; rowIdx < tableModel.getNumRows(); ++rowIdx) {
                for (int colIdx = 0; colIdx < tableModel.getNumColumns(); ++colIdx) {
                    JCFrame frame = table.getCellFrame(rowIdx, colIdx);
                    Object object = tableModel.getTableDataItem(rowIdx, colIdx);
                    String string = object != null ? object.toString() : "";
                    frame.print(style, string);
                }
            }
        }
        catch (EndOfFrameException endOfFrameException) {
            // empty catch block
        }
        return table;
    }
}

