/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table;

import com.agentpp.util.UserConfigFile;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCListTable;
import com.klg.jclass.table.TablePopupMenu;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public class PopupListTable
extends JCListTable {
    TablePopupMenu popup = this.createPopupMenu();
    private JCCellPosition _$6638;

    public PopupListTable() {
        this.popup.removeAll();
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> MouseWheelListener2 = cl.loadClass("java.awt.event.MouseWheelListener");
            Class<?> c = cl.loadClass("com.agentpp.common.table.TableMouseWheelListener");
            Constructor<?> constructor = c.getDeclaredConstructors()[0];
            Object[] oargs = new Object[]{this};
            Object tableMouseWheelListener = constructor.newInstance(oargs);
            Class[] params = new Class[]{MouseWheelListener2};
            Method addMouseWheelListener = this.getClass().getMethod("addMouseWheelListener", params);
            oargs[0] = tableMouseWheelListener;
            addMouseWheelListener.invoke((Object)this, oargs);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean isPopupAllowed(int x, int y) {
        return true;
    }

    public void saveColumnWidths(UserConfigFile config, String tableName) {
        int i;
        boolean anyUserPixelWidth = false;
        block3: for (i = 0; !anyUserPixelWidth && i < this.getNumColumns(); ++i) {
            switch (this.getPixelWidth(i)) {
                case 33001: 
                case 33002: {
                    continue block3;
                }
                default: {
                    anyUserPixelWidth = true;
                }
            }
        }
        if (anyUserPixelWidth) {
            for (i = 0; i < this.getNumColumns(); ++i) {
                config.putInteger(tableName + i, this.getPixelWidth(i));
            }
        } else {
            for (i = 0; i < this.getNumColumns(); ++i) {
                config.remove(tableName + i);
            }
        }
    }

    public void restoreColumnWidths(UserConfigFile config, String tableName) {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            this.setPixelWidth(i, config.getInteger(tableName + i, this.getCharWidth(i)));
        }
    }

    public void restoreColumnWidths(UserConfigFile config, String tableName, int defaultValue) {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            this.setPixelWidth(i, config.getInteger(tableName + i, defaultValue));
        }
    }

    public void resetColumnWidths(UserConfigFile config, String tableName) {
        for (int i = 0; i < this.getNumColumns(); ++i) {
            config.remove(tableName + i);
            this.setPixelWidth(i, 33002);
        }
    }

    public void processMouseEvent(MouseEvent event) {
        if (event.getModifiers() == 4 && this.isPopupMenuEnabled()) {
            if (this.isPopupAllowed(event.getX(), event.getY())) {
                this.popup.show(this, event.getX(), event.getY());
                this._$6638 = this.XYToCell(event.getX(), event.getY());
            }
        } else {
            super.processMouseEvent(event);
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() && keyEvent.getKeyCode() == 65 && this.getSelectionPolicy() != 1 && this.getSelectionPolicy() != 0) {
            this.selectAll();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    public TablePopupMenu getPopupMenu() {
        return this.popup;
    }

    public JCCellPosition getPopupCellPosition() {
        return this._$6638;
    }
}

