/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.table;

import com.klg.jclass.table.JCTable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ConcurrentModificationException;

public class FlexTable
extends JCTable {
    public FlexTable() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> MouseWheelListener2 = cl.loadClass("java.awt.event.MouseWheelListener");
            cl = this.getClass().getClassLoader();
            Class<?> c = cl.loadClass("TableMouseWheelListener");
            Constructor<?> constructor = c.getDeclaredConstructors()[0];
            Object[] oargs = new Object[]{this};
            Object tableMouseWheelListener = constructor.newInstance(oargs);
            Class[] params = new Class[]{MouseWheelListener2};
            Method addMouseWheelListener = this.getClass().getMethod("addMouseWheelListener", params);
            oargs[0] = tableMouseWheelListener;
            addMouseWheelListener.invoke((Object)this, oargs);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean repaintEnabled = this.isRepaintEnabled();
        try {
            if (repaintEnabled) {
                this.setRepaintEnabled(false);
            }
            super.setBounds(x, y, width, height);
            int cols = this.getNumColumns();
            if (cols == 0) {
                return;
            }
            int lastcol = -1;
            for (int i = 0; i < this.getNumColumns(); ++i) {
                if (this.isColumnHidden(i)) {
                    --cols;
                    continue;
                }
                lastcol = i;
            }
            if (cols == 0) {
                return;
            }
            int col_width = width / cols;
            for (int i = 0; i < this.getNumColumns(); ++i) {
                if (this.isColumnHidden(i)) continue;
                this.setPixelWidth(i, col_width);
            }
            int pad = width - col_width * cols - this.getPixelWidth(-1);
            if (pad > 0) {
                this.setPixelWidth(lastcol, col_width + pad);
            }
        }
        catch (ConcurrentModificationException ccmex) {
            // empty catch block
        }
        if (repaintEnabled) {
            this.setRepaintEnabled(true);
        }
    }
}

