/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.print;

import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.common.smi.editor.SmiDocument;
import com.agentpp.common.smi.editor.Token;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Segment;
import javax.swing.text.Style;
import javax.swing.text.TabExpander;

public class SmiTextPrintable
implements Printable {
    private Font _$891;
    protected SmiContext styles;
    protected SmiDocument text;
    private String _$46;
    private boolean _$18005;
    private boolean _$18006;
    private boolean _$18007;
    private int _$18008 = 8;
    protected String footerText = "";
    private boolean _$18010;
    protected SmiDocument.Scanner scanner;
    private int _$18012 = -1;
    private LinkedList _$18013;
    private int _$18014;
    private int _$18015;
    private int _$18016;
    private boolean _$9178;
    private LineMetrics _$18017;
    private ArrayList _$18018 = new ArrayList(10);
    private static Color _$18019 = Color.lightGray;
    private static Color _$18020 = Color.black;
    private static Color _$18021 = Color.lightGray;
    private static Color _$18022 = Color.black;
    private static Color _$18023 = Color.gray;
    private static Color _$18024 = Color.black;

    public SmiTextPrintable(SmiDocument text, Font font, String name, String footerText, boolean lineNumbers, boolean colored, SmiContext context, int tablen) {
        this.text = text;
        this._$46 = name;
        this._$18005 = name != null;
        this._$891 = font;
        this._$18007 = colored;
        this._$18005 = this._$18005;
        this._$18006 = footerText != null;
        this.footerText = footerText;
        this.styles = context;
        this._$18008 = tablen;
        this.scanner = text.createScanner();
        this._$18010 = lineNumbers;
    }

    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex > this._$18014 + 1) {
            for (int i = this._$18014; i < pageIndex; ++i) {
                this._$18026(graphics, pageFormat, i, true);
            }
            this._$18014 = pageIndex - 1;
        }
        if (pageIndex == this._$18014 + 1) {
            if (this._$9178) {
                return 1;
            }
            this._$18015 = this._$18016;
            this._$18014 = pageIndex;
        } else if (pageIndex == this._$18014) {
            this._$18016 = this._$18015;
        }
        this._$18026(graphics, pageFormat, pageIndex, true);
        return 0;
    }

    private void _$18026(Graphics graphics, PageFormat pageFormat, int pageIndex, boolean actuallyPaint) {
        double lineNumberWidth;
        Graphics2D gfx = (Graphics2D)graphics;
        gfx.setFont(this._$891);
        double pageX = pageFormat.getImageableX();
        double pageY = pageFormat.getImageableY();
        double pageWidth = pageFormat.getImageableWidth();
        double pageHeight = pageFormat.getImageableHeight();
        if (this._$18005) {
            double headerHeight = this._$18034(gfx, pageX, pageY, pageWidth, actuallyPaint);
            pageY += headerHeight * 2.0;
            pageHeight -= headerHeight * 2.0;
        }
        if (this._$18006) {
            double footerHeight = this._$18036(gfx, pageX, pageY, pageWidth, pageHeight, pageIndex, actuallyPaint);
            pageHeight -= footerHeight * 2.0;
        }
        FontRenderContext frc = gfx.getFontRenderContext();
        if (this._$18010) {
            int lineNumberDigits = (int)Math.ceil(Math.log(this.text.getLineCount() + 1) / Math.log(10.0)) + 1;
            char[] chars = new char[lineNumberDigits];
            for (int i = 0; i < chars.length; ++i) {
                chars[i] = 48;
            }
            lineNumberWidth = this._$891.getStringBounds(chars, 0, lineNumberDigits, frc).getWidth();
        } else {
            lineNumberWidth = 0.0;
        }
        char[] chars = new char[this._$18008];
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = 32;
        }
        double tabWidth = this._$891.getStringBounds(chars, 0, this._$18008, frc).getWidth();
        PrintTabExpander e = new PrintTabExpander(tabWidth);
        Segment seg = new Segment();
        double y = 0.0;
        this._$18017 = this._$891.getLineMetrics("gGyYX", frc);
        while (true) {
            if (this._$18016 == this.text.getLineCount()) {
                this._$9178 = true;
                break;
            }
            this._$18018.clear();
            try {
                this.text.getText(this.text.getLineStartOffset(this._$18016), this.text.getLineLength(this._$18016), seg);
            }
            catch (BadLocationException blex) {
                blex.printStackTrace();
            }
            this.lineToChunkList(this._$18016, seg, this.styles, frc, (float)(pageWidth - lineNumberWidth), e, this._$18018);
            if (this._$18018.size() == 0) {
                this._$18018.add(null);
            }
            if (y + (double)(this._$18017.getHeight() * (float)this._$18018.size()) >= pageHeight) break;
            if (this._$18010 && actuallyPaint) {
                gfx.setFont(this._$891);
                gfx.setColor(_$18023);
                gfx.drawString(String.valueOf(this._$18016 + 1), (float)pageX, (float)(pageY + y));
            }
            for (int i = 0; i < this._$18018.size(); ++i) {
                Chunk chunks = (Chunk)this._$18018.get(i);
                if (chunks != null) {
                    this.paintChunkList(chunks, gfx, (float)(pageX + lineNumberWidth), (float)(pageY + y), false);
                }
                y += (double)this._$18017.getHeight();
            }
            ++this._$18016;
        }
    }

    private double _$18034(Graphics2D gfx, double pageX, double pageY, double pageWidth, boolean actuallyPaint) {
        String headerText = this._$46;
        FontRenderContext frc = gfx.getFontRenderContext();
        this._$18017 = this._$891.getLineMetrics(headerText, frc);
        Rectangle2D bounds = this._$891.getStringBounds(headerText, frc);
        Rectangle2D.Double headerBounds = new Rectangle2D.Double(pageX, pageY, pageWidth, bounds.getHeight());
        if (actuallyPaint) {
            gfx.setColor(_$18019);
            gfx.fill(headerBounds);
            gfx.setColor(_$18020);
            gfx.drawString(headerText, (float)(pageX + (pageWidth - bounds.getWidth()) / 2.0), (float)(pageY + (double)this._$18017.getAscent()));
        }
        return ((RectangularShape)headerBounds).getHeight();
    }

    private double _$18036(Graphics2D gfx, double pageX, double pageY, double pageWidth, double pageHeight, int pageIndex, boolean actuallyPaint) {
        String ft = MessageFormat.format(this.footerText, new Date(), new Integer(pageIndex + 1));
        FontRenderContext frc = gfx.getFontRenderContext();
        this._$18017 = this._$891.getLineMetrics(ft, frc);
        Rectangle2D bounds = this._$891.getStringBounds(ft, frc);
        Rectangle2D.Double footerBounds = new Rectangle2D.Double(pageX, pageY + pageHeight - bounds.getHeight(), pageWidth, bounds.getHeight());
        if (actuallyPaint) {
            gfx.setColor(_$18021);
            gfx.fill(footerBounds);
            gfx.setColor(_$18022);
            gfx.drawString(ft, (float)(pageX + (pageWidth - bounds.getWidth()) / 2.0), (float)(pageY + pageHeight - bounds.getHeight() + (double)this._$18017.getAscent()));
        }
        return ((RectangularShape)footerBounds).getHeight();
    }

    public void lineToChunkList(int line, Segment seg, SmiContext styles, FontRenderContext fontRenderContext, float wrapMargin, TabExpander e, List out) {
        if (wrapMargin != 0.0f) {
            wrapMargin += 2.0f;
        }
        float x = 0.0f;
        float endX = 0.0f;
        boolean seenNonWhiteSpace = false;
        boolean addedNonWhiteSpace = false;
        boolean lastWasSpace = false;
        float firstNonWhiteSpace = 0.0f;
        Chunk first = null;
        Chunk current = null;
        Chunk end = null;
        if (line < 0 || line >= this.text.getDefaultRootElement().getElementCount()) {
            throw new ArrayIndexOutOfBoundsException(line);
        }
        int startOffset = this.text.getLineStartOffset(line);
        int endOffset = this.text.getLineEndOffset(line);
        int start = this.scanner.getScannerStart(startOffset);
        int startLine = this.text.getLineOfOffset(start);
        int tokenListOffset = startOffset;
        try {
            this.scanner.setRange(start, this.text.getLength());
            while (this.scanner.getEndOffset() < startOffset) {
                this.scanner.getNextToken();
            }
            while (this.scanner.getToken().getScanValue() != Token.EOF.getScanValue() && this.scanner.getBeginOffset() < endOffset) {
                int i;
                int flushIndex = Math.max(this.scanner.getBeginOffset(), startOffset);
                Token t = this.scanner.getToken();
                for (i = tokenListOffset; i < flushIndex; ++i) {
                    Chunk newChunk;
                    if (seg.array[i] == '\t') {
                        newChunk = new Chunk(t.getScanValue(), seg, i, i, fontRenderContext);
                        if (first == null) {
                            first = current = newChunk;
                        } else {
                            current.next = newChunk;
                            current = newChunk;
                        }
                        float newX = e.nextTabStop(x, i + tokenListOffset);
                        current.width = newX - x;
                        x = newX;
                        current.length = 1;
                    }
                    if (seg.array[i] == '\r' || seg.array[i] == '\n') continue;
                    newChunk = new Chunk(Token.UNSCANNED.getScanValue(), seg, i, i + 1, fontRenderContext);
                    if (first == null) {
                        first = newChunk;
                    }
                    if (current != null) {
                        current.next = newChunk;
                    }
                    current = newChunk;
                    x += newChunk.width;
                    lastWasSpace = true;
                    seenNonWhiteSpace = false;
                }
                for (i = tokenListOffset = flushIndex; i < endOffset && i < this.scanner.getEndOffset(); ++i) {
                    Chunk newChunk;
                    char ch = seg.array[i];
                    if (ch == '\n' || ch == '\r' || ch == '\t' || ch == ' ' && wrapMargin != 0.0f) {
                        if (i != flushIndex) {
                            newChunk = new Chunk(t.getScanValue(), seg, flushIndex, i, fontRenderContext);
                            if (current != null) {
                                current.next = newChunk;
                            }
                            current = newChunk;
                            x += newChunk.width;
                            lastWasSpace = false;
                            seenNonWhiteSpace = true;
                        }
                        if (end != null && !lastWasSpace && addedNonWhiteSpace && wrapMargin != 0.0f && x > wrapMargin) {
                            if (first != null) {
                                out.add(first);
                            }
                            first = new Chunk(firstNonWhiteSpace, end.offset + 1);
                            first.next = end.next;
                            end.next = null;
                            x = x + firstNonWhiteSpace - endX;
                        }
                        if (first == null) {
                            first = current;
                        }
                        if (ch == ' ') {
                            newChunk = new Chunk(t.getScanValue(), seg, i, i + 1, fontRenderContext);
                            if (first == null) {
                                first = current = newChunk;
                            } else {
                                current.next = newChunk;
                                current = newChunk;
                            }
                            x += current.width;
                        } else if (ch == '\t') {
                            newChunk = new Chunk(t.getScanValue(), seg, i, i, fontRenderContext);
                            if (first == null) {
                                first = current = newChunk;
                            } else {
                                current.next = newChunk;
                                current = newChunk;
                            }
                            float newX = e.nextTabStop(x, i + tokenListOffset);
                            current.width = newX - x;
                            x = newX;
                            current.length = 1;
                        }
                        if (first == null) {
                            first = current;
                        }
                        end = current;
                        endX = x;
                        flushIndex = i + 1;
                        lastWasSpace = true;
                        addedNonWhiteSpace = seenNonWhiteSpace;
                        if (seenNonWhiteSpace) continue;
                        firstNonWhiteSpace = x;
                        continue;
                    }
                    if (i != this.scanner.getEndOffset() - 1) continue;
                    if (flushIndex != i + 1) {
                        newChunk = new Chunk(t.getScanValue(), seg, flushIndex, i + 1, fontRenderContext);
                        if (current != null) {
                            current.next = newChunk;
                        }
                        current = newChunk;
                        x += newChunk.width;
                        seenNonWhiteSpace = true;
                        lastWasSpace = false;
                    }
                    if (i == seg.count - 1 && wrapMargin != 0.0f && x > wrapMargin && addedNonWhiteSpace && end != null) {
                        if (first != null) {
                            out.add(first);
                        }
                        first = new Chunk(firstNonWhiteSpace, end.offset + 1);
                        first.next = end.next;
                        end.next = null;
                        x = x + firstNonWhiteSpace - endX;
                    }
                    if (first == null) {
                        first = current;
                    }
                    addedNonWhiteSpace = seenNonWhiteSpace;
                }
                tokenListOffset = this.scanner.getEndOffset();
                this.scanner.getNextToken();
            }
        }
        catch (IOException iox) {
            iox.printStackTrace();
        }
        if (first != null) {
            out.add(first);
        }
    }

    public float paintChunkList(Chunk chunks, Graphics2D gfx, float x, float y, boolean glyphVector) {
        FontMetrics forBackground = gfx.getFontMetrics();
        float _x = 0.0f;
        Chunk first = chunks;
        Object lastFont = null;
        Object lastColor = null;
        while (chunks != null) {
            if (!chunks.inaccessable && chunks.str != null) {
                gfx.setFont(chunks.font);
                gfx.setColor(chunks.foreground);
                if (glyphVector) {
                    gfx.drawGlyphVector(chunks.text, x + _x, y);
                } else {
                    gfx.drawString(chunks.str, x + _x, y);
                }
            }
            float width = chunks.width;
            _x += width;
            chunks = chunks.next;
        }
        return _x;
    }

    public Font getFont() {
        return this._$891;
    }

    public class Chunk {
        public boolean inaccessable;
        public float width;
        public Style style;
        public Color foreground;
        public Font font;
        public int offset;
        public int length;
        public String str;
        public GlyphVector text;
        public float[] positions;
        public Chunk next;

        Chunk(float width, int offset) {
            this.inaccessable = true;
            this.width = width;
            this.offset = offset;
        }

        Chunk(int tokenType, Segment seg, int offset, int end, FontRenderContext fontRenderContext) {
            if (SmiTextPrintable.this.styles != null) {
                this.style = SmiTextPrintable.this.styles.getStyleForScanValue(tokenType);
                Font f = SmiTextPrintable.this.styles.getFont(tokenType);
                this.font = f.isBold() ? new Font(SmiTextPrintable.this.getFont().getName(), 1, SmiTextPrintable.this.getFont().getSize()) : (f.isItalic() ? new Font(SmiTextPrintable.this.getFont().getName(), 2, SmiTextPrintable.this.getFont().getSize()) : new Font(SmiTextPrintable.this.getFont().getName(), 0, SmiTextPrintable.this.getFont().getSize()));
                this.foreground = SmiTextPrintable.this._$18007 ? SmiTextPrintable.this.styles.getForeground(tokenType) : Color.black;
            } else {
                this.foreground = Color.black;
                this.font = SmiTextPrintable.this.getFont();
            }
            if (offset != end) {
                this.length = end - offset;
                this.str = new String(seg.array, offset, this.length);
                this.text = this.font.createGlyphVector(fontRenderContext, this.str);
                this.width = (float)this.text.getLogicalBounds().getWidth();
                this.positions = this.text.getGlyphPositions(0, this.length, null);
            }
            this.offset = offset;
        }
    }

    static class PrintTabExpander
    implements TabExpander {
        private double _$18041;

        public PrintTabExpander(double tabWidth) {
            this._$18041 = tabWidth;
        }

        public float nextTabStop(float x, int tabOffset) {
            int ntabs = (int)((double)(x + 1.0f) / this._$18041);
            return (float)((double)(ntabs + 1) * this._$18041);
        }
    }
}

