/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.smi.editor;

import com.agentpp.common.smi.editor.Token;
import com.agentpp.smiparser.SMIParserConstants;
import com.agentpp.smiparser.SMIParserTokenManager;
import com.agentpp.smiparser.SimpleCharStream;
import com.agentpp.smiparser.TokenMgrError;
import java.io.IOException;
import java.io.InputStream;
import java.util.TreeSet;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.PlainDocument;
import javax.swing.text.Segment;

public class SmiDocument
extends PlainDocument {
    private boolean _$17943;

    public SmiDocument() {
        super(new GapContent(65535));
    }

    public Scanner createScanner() {
        Scanner s;
        try {
            s = new Scanner();
        }
        catch (IOException e) {
            s = null;
        }
        return s;
    }

    public int getLineOfOffset(int offset) {
        return super.getDefaultRootElement().getElementIndex(offset);
    }

    public int getLineLength(int line) {
        Element l = super.getDefaultRootElement().getElement(line);
        return l.getEndOffset() - l.getStartOffset();
    }

    public int getLineCount() {
        return super.getDefaultRootElement().getElementCount();
    }

    public int getLineStartOffset(int line) {
        return super.getDefaultRootElement().getElement(line).getStartOffset();
    }

    public int getLineEndOffset(int line) {
        return super.getDefaultRootElement().getElement(line).getEndOffset();
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent chng, AttributeSet attr) {
        super.insertUpdate(chng, attr);
        if (chng.getOffset() + chng.getLength() + 1 < chng.getDocument().getEndPosition().getOffset()) {
            this._$17943 = true;
        }
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent chng) {
        super.removeUpdate(chng);
        this._$17943 = true;
    }

    public void setUpdated(boolean updated) {
        this._$17943 = updated;
    }

    public boolean isUpdated() {
        return this._$17943;
    }

    class DocumentInputStream
    extends InputStream {
        Segment segment = new Segment();
        int p0;
        int p1;
        int pos;
        int index;

        public DocumentInputStream(int p0, int p1) {
            this.p0 = p0;
            this.p1 = Math.min(SmiDocument.this.getLength(), p1);
            this.pos = p0;
            try {
                this.loadSegment();
            }
            catch (IOException ioe) {
                throw new Error("unexpected: " + ioe);
            }
        }

        public int read() throws IOException {
            if (this.index >= this.segment.offset + this.segment.count) {
                if (this.pos >= this.p1) {
                    return -1;
                }
                this.loadSegment();
            }
            return this.segment.array[this.index++];
        }

        void loadSegment() throws IOException {
            try {
                int n = Math.min(4096, this.p1 - this.pos);
                SmiDocument.this.getText(this.pos, n, this.segment);
                this.pos += n;
                this.index = this.segment.offset;
            }
            catch (BadLocationException e) {
                throw new IOException("Bad location");
            }
        }
    }

    public class Scanner {
        private SMIParserTokenManager _$17949;
        private SimpleCharStream _$17950;
        private Token[] _$17752;
        private com.agentpp.smiparser.Token _$17951;
        private com.agentpp.smiparser.Token _$17952;
        private TreeSet<Integer> _$17953 = new TreeSet();
        int p0;

        Scanner() throws IOException {
            this._$17954();
            this._$17950 = new SimpleCharStream(new DocumentInputStream(0, SmiDocument.this.getLength()));
            this._$17949 = new SMIParserTokenManager(this._$17950);
        }

        private void _$17954() {
            this._$17752 = new Token[SMIParserConstants.tokenImage.length];
            block0: for (int i = 0; i < this._$17752.length; ++i) {
                for (int j = 0; j < Token.all.length; ++j) {
                    if (Token.all[j].getScanValue() != i) continue;
                    this._$17752[i] = Token.all[j];
                    continue block0;
                }
            }
        }

        public void setRange(int p0, int p1) throws IOException {
            this._$17950 = new SimpleCharStream(new DocumentInputStream(p0, p1), 0, 0, 4096, p0);
            this._$17949.ReInit(this._$17950);
            this._$17951 = null;
            this._$17952 = null;
            this.p0 = p0;
            Integer i0 = new Integer(p0);
            this._$17953.tailSet(i0).clear();
        }

        public final int getEndOffset() {
            if (this._$17951 == null) {
                this.getNextToken();
                if (this._$17951 == null) {
                    return Integer.MAX_VALUE;
                }
            }
            if (this._$17952 != null) {
                return this._$17952.endPos;
            }
            return this._$17951.endPos;
        }

        public int getTokenLength() {
            return this.getEndOffset() - this.getBeginOffset();
        }

        public final int getBeginOffset() {
            if (this._$17951 == null) {
                this.getNextToken();
                if (this._$17951 == null) {
                    return Integer.MAX_VALUE;
                }
            }
            if (this._$17952 != null) {
                return this._$17952.endPos - this._$17952.image.length();
            }
            return this._$17951.endPos - this._$17951.image.length();
        }

        public final Token getToken() {
            if (this._$17951 == null) {
                return this.getNextToken();
            }
            Token t = this._$17952 != null ? this._$17752[this._$17952.kind] : this._$17752[this._$17951.kind];
            if (t == null) {
                return Token.COMMENT;
            }
            return t;
        }

        private void _$17962(int pos) {
            Integer p = new Integer(pos);
            this._$17953.add(p);
        }

        public int getScannerStart(int p) {
            Integer floor = this._$17953.floor(p);
            if (floor == null) {
                return 0;
            }
            return floor;
        }

        public int getScannerEnd(int p) {
            Integer ceiling = this._$17953.ceiling(p);
            if (ceiling == null) {
                return Math.min(SmiDocument.this.getLength(), p + 65535);
            }
            return Math.min(SmiDocument.this.getLength(), ceiling + 65535);
        }

        public final Token getNextToken() {
            Token t = null;
            if (this._$17952 != null) {
                t = this._$17752[this._$17952.kind];
                this._$17952 = this._$17952.next;
                return t;
            }
            try {
                this._$17951 = this._$17949.getNextToken();
                this._$17952 = this._$17951.specialToken;
                if (this._$17952 != null) {
                    while (this._$17952.specialToken != null) {
                        this._$17952 = this._$17952.specialToken;
                    }
                    t = this._$17752[this._$17952.kind];
                } else {
                    t = this._$17752[this._$17951.kind];
                }
                this._$17962(this._$17951.endPos - this._$17951.image.length());
            }
            catch (TokenMgrError error) {
                this._$17951 = null;
                return Token.ERROR;
            }
            if (t == null) {
                return Token.COMMENT;
            }
            return t;
        }
    }
}

