/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common.log;

import com.agentpp.common.PropertiesEditor;
import com.agentpp.common.log.AppenderConfigPanel;
import com.agentpp.common.log.CategoryTreeCellRenderer;
import com.agentpp.common.log.LogAppender;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.field.DataProperties;
import com.klg.jclass.field.JCInvalidInfo;
import com.klg.jclass.field.JCSpinField;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.util.value.MutableValueModel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class LogPreferencesPanel
extends JPanel
implements TreeSelectionListener,
ItemListener {
    public static final String CFG_MAX_LOG_RECORDS = "com.agentpp.log.maxrecords";
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelCenter = new JPanel();
    JPanel jPanelNorth = new JPanel();
    Border border1;
    TitledBorder titledBorder1;
    Border border2;
    Border border3;
    TitledBorder titledBorder2;
    Border border4;
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JLabel jLabelMaxRecords = new JLabel();
    DefaultTreeModel treeModel;
    DefaultMutableTreeNode root;
    private UserConfigFile _$6654;
    private String[] _$22277;
    GridLayout gridLayout1 = new GridLayout();
    JCSpinField maxRecords = new JCSpinField();
    JSplitPane jSplitPane = new JSplitPane();
    JTree tree = new JTree();
    JScrollPane jScrollPane = new JScrollPane();
    JComboBox jComboBoxPriority = new JComboBox();
    JLabel jLabelPriority = new JLabel();
    JLabel jLabelChainedPriority = new JLabel();
    JTextField jTextFieldCategory = new JTextField();
    JLabel jLabelCategory = new JLabel();
    JTextField jTextFieldChainedPriority = new JTextField();
    JPanel jPanelSettings = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    private JPanel _$12175 = new JPanel();
    private AppenderConfigPanel _$32743;
    private BorderLayout _$8133 = new BorderLayout();
    private Border _$27516;
    private TitledBorder _$28131;
    private LogAppender _$32745;
    private boolean _$32746 = true;

    public LogPreferencesPanel() {
        this._$32743 = new AppenderConfigPanel(this);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public LogPreferencesPanel(UserConfigFile config, String[] categories, LogAppender appender) {
        this(config, categories, appender, true);
    }

    public LogPreferencesPanel(UserConfigFile config, String[] categories, LogAppender appender, boolean extendedLogging) {
        this._$6654 = config;
        this._$22277 = categories;
        this._$32745 = appender;
        this._$32746 = extendedLogging;
        this._$32743 = new AppenderConfigPanel(this);
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.jComboBoxPriority.addItem("none");
        this.jComboBoxPriority.addItem(Level.OFF);
        this.jComboBoxPriority.addItem(Level.FATAL);
        this.jComboBoxPriority.addItem(Level.ERROR);
        this.jComboBoxPriority.addItem(Level.WARN);
        this.jComboBoxPriority.addItem(Level.INFO);
        this.jComboBoxPriority.addItem(Level.DEBUG);
        this.load();
        this.tree.addTreeSelectionListener(this);
        this.tree.setCellRenderer(new CategoryTreeCellRenderer());
        this.tree.setShowsRootHandles(true);
        this.tree.setEditable(false);
        this.jComboBoxPriority.addItemListener(this);
    }

    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (n == null) {
                return;
            }
            Logger c = (Logger)n.getUserObject();
            if (e.getItem() instanceof String) {
                if (c.getRootLogger().equals(c)) {
                    c.setLevel(Level.FATAL);
                } else {
                    c.setLevel(null);
                }
            } else {
                c.setLevel((Level)e.getItem());
            }
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        TreePath p = e.getNewLeadSelectionPath();
        if (p == null) {
            this.jTextFieldCategory.setText(null);
            this.jComboBoxPriority.setEnabled(false);
            this.jComboBoxPriority.setSelectedIndex(0);
            return;
        }
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)p.getLastPathComponent();
        Category c = (Category)n.getUserObject();
        this.jTextFieldCategory.setText(c.getName());
        this.jTextFieldChainedPriority.setText(c.getEffectiveLevel().toString());
        if (c.getLevel() != null) {
            this.jComboBoxPriority.setSelectedItem(c.getLevel());
        } else {
            this.jComboBoxPriority.setSelectedItem("none");
        }
        this.jComboBoxPriority.setEnabled(true);
    }

    private void _$32752() {
        if (this.root != null) {
            this.root.removeAllChildren();
        }
        this.root = new DefaultMutableTreeNode(Logger.getRootLogger());
        this.treeModel = new DefaultTreeModel(this.root, false);
        this.tree.setModel(this.treeModel);
        this.tree.treeDidChange();
    }

    private String _$32753(Vector path) {
        StringBuffer buf = new StringBuffer();
        Enumeration en = path.elements();
        while (en.hasMoreElements()) {
            buf.append(en.nextElement());
            if (!en.hasMoreElements()) continue;
            buf.append('.');
        }
        return buf.toString();
    }

    private void _$32754(Vector path, String category, DefaultMutableTreeNode parent) {
        boolean found = false;
        Enumeration<TreeNode> en = parent.children();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)en.nextElement();
            if (!((Category)n.getUserObject()).getName().endsWith(path.firstElement().toString())) continue;
            found = true;
            path.removeElementAt(0);
            if (path.size() <= 0) break;
            this._$32754(path, category, n);
            break;
        }
        if (!found) {
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(Logger.getLogger((String)category));
            this.treeModel.insertNodeInto(child, parent, parent.getChildCount());
        }
    }

    public void load() {
        this._$32752();
        for (int i = 0; i < this._$22277.length; ++i) {
            String s = this._$22277[i];
            StringTokenizer st = new StringTokenizer(s, ".");
            Vector<String> path = new Vector<String>(st.countTokens() + 1);
            while (st.hasMoreTokens()) {
                path.addElement(st.nextToken());
            }
            this._$32754(path, s, this.root);
        }
        Hashtable h = PropertiesEditor.filterProperties(this._$6654.properties);
        PropertyConfigurator.configure((Properties)this._$6654.properties);
        this._$6654.properties.putAll((Map<?, ?>)h);
        if (this._$6654.get("log4j.rootCategory", null) == null && this._$6654.get("log4j.rootLogger", null) == null) {
            Logger.getRootLogger().setLevel(Level.OFF);
        }
        this.maxRecords.setValue(new Integer(this._$6654.get(CFG_MAX_LOG_RECORDS, "100")));
        this._$32743.setConfig(this._$6654);
        this._$32743.load();
    }

    public int getMaxLogRecords() {
        return ((Number)this.maxRecords.getValue()).intValue();
    }

    public void reloadConfiguration() {
        BasicConfigurator.resetConfiguration();
        Hashtable h = PropertiesEditor.filterProperties(this._$6654.properties);
        PropertyConfigurator.configure((Properties)this._$6654.properties);
        this._$6654.properties.putAll((Map<?, ?>)h);
        Logger.getRootLogger().addAppender((Appender)this._$32745);
    }

    public void cancel() {
        this.reloadConfiguration();
    }

    public void save() {
        String oldRoot = this._$6654.get("log4j.rootCategory", null);
        if (oldRoot == null) {
            oldRoot = this._$6654.get("log4j.rootLogger", "");
        }
        oldRoot = oldRoot.indexOf(44) >= 0 ? oldRoot.substring(oldRoot.indexOf(44)) : "";
        if (this._$32743 != null) {
            oldRoot = this._$32743.updateAppenderConfig("root", oldRoot);
        }
        this._$6654.put("log4j.rootLogger", Logger.getRootLogger().getLevel().toString() + oldRoot);
        this._$6654.remove("log4j.rootCategory");
        Enumeration<TreeNode> en = this.root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            String old;
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)en.nextElement();
            Category c = (Category)n.getUserObject();
            if (c.getName().equals("root")) continue;
            if (c.getLevel() == null) {
                old = this._$32743.updateAppenderConfig(c.getName(), "");
                if (old.length() == 0) {
                    this._$6654.put("log4j.logger." + c.getName(), null);
                    continue;
                }
                this._$6654.put("log4j.logger." + c.getName(), "INHERITED" + old);
                continue;
            }
            old = this._$6654.get("log4j.logger." + c.getName(), "");
            old = old.indexOf(44) >= 0 ? old.substring(old.indexOf(44)) : "";
            old = this._$32743.updateAppenderConfig(c.getName(), old);
            this._$6654.put("log4j.logger." + c.getName(), c.getLevel().toString() + old);
        }
        this._$6654.put(CFG_MAX_LOG_RECORDS, "" + this.maxRecords.getValue());
        this._$32743.save();
        this.reloadConfiguration();
    }

    void jbInit() throws Exception {
        this.border1 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder1 = new TitledBorder(this.border1, "Categories");
        this.border2 = BorderFactory.createCompoundBorder(this.titledBorder1, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.border3 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this.titledBorder2 = new TitledBorder(this.border3, "Output Properties");
        this.border4 = BorderFactory.createCompoundBorder(this.titledBorder2, BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._$27516 = new EtchedBorder(0, Color.white, new Color(148, 145, 140));
        this._$28131 = new TitledBorder(new EtchedBorder(0, Color.white, new Color(148, 145, 140)), "External Logging");
        this.setLayout(this.borderLayout1);
        this.jPanelCenter.setLayout(this.gridLayout1);
        this.jPanelCenter.setBorder(this.border2);
        this.jPanelNorth.setBorder(this.border4);
        this.jPanelNorth.setLayout(this.gridBagLayout2);
        this.jLabelMaxRecords.setText("Maximum number of log records:");
        this.gridLayout1.setColumns(2);
        this.gridLayout1.setHgap(5);
        this.maxRecords.setDataProperties(new DataProperties(new JCIntegerValidator(null, new Integer(0), new Integer(Integer.MAX_VALUE), null, false, null, new Integer(10), "#,##0.###;-#,##0.###", false, false, false, null, new Integer(100)), new MutableValueModel(Integer.class, new Integer("100")), new JCInvalidInfo(true, 1, new Color(0, 0, 0, 255), new Color(255, 255, 255, 255))));
        this.jLabelPriority.setText("Assigned Priority:");
        this.jLabelChainedPriority.setText("Inherited Priority:");
        this.jTextFieldCategory.setEnabled(false);
        this.jTextFieldCategory.setEditable(false);
        this.jTextFieldCategory.setColumns(20);
        this.jLabelCategory.setText("Category:");
        this.jTextFieldChainedPriority.setEnabled(false);
        this.jTextFieldChainedPriority.setToolTipText("Shows the priority inherited from parent nodes on the path to the root category");
        this.jPanelSettings.setLayout(this.gridBagLayout1);
        this._$12175.setLayout(this._$8133);
        this._$12175.setBorder(this._$28131);
        this.add((Component)this.jPanelCenter, "Center");
        this.jPanelCenter.add((Component)this.jSplitPane, null);
        this.jSplitPane.add((Component)this.jScrollPane, "left");
        this.jSplitPane.add((Component)this.jPanelSettings, "right");
        this.jPanelSettings.add((Component)this.jLabelCategory, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jTextFieldCategory, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jLabelPriority, new GridBagConstraints(0, 2, 1, 1, 0.0, 1.0, 18, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jComboBoxPriority, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 11, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jLabelChainedPriority, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.jPanelSettings.add((Component)this.jTextFieldChainedPriority, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        this.jScrollPane.getViewport().add((Component)this.tree, null);
        this.add((Component)this.jPanelNorth, "North");
        this.jPanelNorth.add((Component)this.jLabelMaxRecords, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0));
        this.jPanelNorth.add((Component)this.maxRecords, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        if (this.isEnableExtendedLogging()) {
            this.add((Component)this._$12175, "South");
            this._$12175.add((Component)this._$32743, "Center");
        }
        this.jSplitPane.setDividerLocation(150);
    }

    public void setLocalAppender(LogAppender localAppender) {
        this._$32745 = localAppender;
    }

    public LogAppender getLocalAppender() {
        return this._$32745;
    }

    public String[] getCategories() {
        return this._$22277;
    }

    public Integer getCategoryOfAppender(String appender) {
        String c = this._$6654.get("log4j.rootLogger", null);
        for (int i = -1; i < this._$22277.length; ++i) {
            if (i >= 0) {
                c = this._$6654.get("log4j.logger." + this._$22277[i], null);
            }
            if (c == null) continue;
            StringTokenizer st = new StringTokenizer(c, ",", false);
            while (st.hasMoreTokens()) {
                if (!st.nextToken().trim().equals(appender)) continue;
                return new Integer(i);
            }
        }
        return null;
    }

    public boolean isEnableExtendedLogging() {
        return this._$32746;
    }
}

