/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.SortLabel;
import com.agentpp.common.SortLabelRenderer;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCSelectListener;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.Sort;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Comparator;

public class TableSorter
extends MouseAdapter
implements JCSelectListener {
    private Comparator _$8938;
    private JCTable _$6434;
    private JCVectorDataSource _$6454;
    private static SortLabelRenderer _$8939;
    private boolean _$8940 = true;
    private int _$8941 = 0;

    public TableSorter(JCTable table, JCVectorDataSource data) {
        this(table, data, true);
    }

    public TableSorter(JCTable table, JCVectorDataSource data, boolean sortingByUser) {
        this._$6434 = table;
        this._$6454 = data;
        if (_$8939 == null) {
            _$8939 = new SortLabelRenderer();
        }
        this._$8940 = sortingByUser;
        this.makeSortLabels();
    }

    public TableSorter(JCTable table, JCVectorDataSource data, Comparator comparator) {
        this._$6434 = table;
        this._$8938 = comparator;
        this._$6454 = data;
        this.makeSortLabels();
    }

    public SortLabelRenderer getLabelRenderer() {
        return _$8939;
    }

    protected void makeSortLabels() {
        for (int i = 0; i < this._$6454.getNumColumns(); ++i) {
            if (this._$6454.getTableColumnLabel(i) == null) continue;
            if (this._$6454.getTableColumnLabel(i) instanceof SortLabel) {
                this._$6454.setColumnLabel(i, new SortLabel(((SortLabel)this._$6454.getTableColumnLabel(i)).getLabel(), 0));
                continue;
            }
            this._$6454.setColumnLabel(i, new SortLabel(this._$6454.getTableColumnLabel(i).toString(), 0));
        }
        if (this._$8940) {
            this._$6434.setCellRenderer(SortLabel.class, _$8939);
            this._$6434.addMouseListener(this);
        }
    }

    public void unsort() {
        for (int i = 0; i < this._$6434.getDataSource().getNumColumns(); ++i) {
            ((SortLabel)this._$6454.getTableColumnLabel(i)).setDirection(0);
        }
        this._$6434.resetSortedRows();
    }

    public void setData(JCVectorDataSource data) {
        this._$6454 = data;
    }

    public void sort() {
        Comparator comp = this._$8938;
        int j = 0;
        int[] columns = new int[this._$6454.getNumColumns()];
        int[] dirs = new int[columns.length];
        for (int i = 0; i < columns.length; ++i) {
            int dir = ((SortLabel)this._$6454.getTableColumnLabel(i)).getDirection();
            if (dir == 0) continue;
            columns[j] = i;
            dirs[j] = dir;
            ++j;
        }
        if (j == 0) {
            this._$6434.resetSortedRows();
            return;
        }
        int[] cs = new int[j];
        int[] d = new int[j];
        System.arraycopy(columns, 0, cs, 0, j);
        System.arraycopy(dirs, 0, d, 0, j);
        Sort.sortByColumn(this._$6434, cs, d, comp);
    }

    public void beforeSelect(JCSelectEvent e) {
        if (e.getStartRow() == -1) {
            this.addSortColumn(e.getStartColumn());
        }
    }

    public void addSortColumn(int col) {
        Object o = this._$6454.getTableColumnLabel(col);
        if (o == null || !(o instanceof SortLabel)) {
            return;
        }
        SortLabel l = (SortLabel)o;
        switch (l.getDirection()) {
            case -1: {
                l.setDirection(1);
                break;
            }
            case 0: {
                l.setDirection(-1);
                break;
            }
            case 1: {
                l.setDirection(0);
            }
        }
        this.sort();
    }

    public void afterSelect(JCSelectEvent e) {
    }

    public void select(JCSelectEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
        JCCellPosition p = this._$6434.XYToCell((int)e.getPoint().getX(), (int)e.getPoint().getY());
        if (p == null || p.column < this._$8941) {
            return;
        }
        if (p.row == -1) {
            this.addSortColumn(p.column);
        }
    }

    public void setFrozenColumn(int frozenColumn) {
        this._$8941 = frozenColumn;
    }

    public int getFrozenColumn() {
        return this._$8941;
    }
}

