/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.SearchConfig;
import com.agentpp.common.table.ExtendedListTable;
import com.agentpp.common.table.TableUtils;
import com.agentpp.mib.MIBAgentCaps;
import com.agentpp.mib.MIBCompliance;
import com.agentpp.mib.MIBComplianceModule;
import com.agentpp.mib.MIBImport;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.MIBSupportedModule;
import com.agentpp.mib.MIBVariation;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.util.Regex;
import com.agentpp.util.ThreadPool;
import com.klg.jclass.table.JCCellDisplayEvent;
import com.klg.jclass.table.JCCellDisplayListener;
import com.klg.jclass.table.data.JCVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SearchMIBRepository
extends JPanel
implements Runnable,
JCCellDisplayListener {
    private static final String[] _$10889 = new String[]{"MIB Module", "Object Name", "OID", "Type"};
    private static final int _$10890 = 2;
    private static final int _$10891 = 1;
    private static final int _$10892 = 0;
    private SearchConfig _$10893;
    private Regex _$10894;
    private String _$10895 = null;
    private JFrame _$10896;
    private RepositoryManager _$10897;
    private BorderLayout _$7431 = new BorderLayout();
    private JPanel _$10898 = new JPanel();
    private JPanel _$10899 = new JPanel();
    private JProgressBar _$10900 = new JProgressBar();
    private JLabel _$10901 = new JLabel();
    private GridBagLayout _$10902 = new GridBagLayout();
    private ExtendedListTable _$4049 = new ExtendedListTable();
    private BorderLayout _$7433 = new BorderLayout();
    private JCVectorDataSource _$10213 = new JCVectorDataSource();
    public volatile boolean cancel = false;
    private JLabel _$10903 = new JLabel();
    private JLabel _$10904 = new JLabel();
    private int _$5099 = 0;
    private JLabel _$10905 = new JLabel();
    private JLabel _$10906 = new JLabel();
    private Runnable _$10907;

    public SearchMIBRepository(JFrame frame, RepositoryManager repMan, Regex searchExpression, SearchConfig searchPanel) {
        this(frame, repMan, searchExpression, searchPanel, null);
    }

    public SearchMIBRepository(JFrame frame, RepositoryManager repMan, Regex searchExpression, SearchConfig searchPanel, String moduleScope) {
        this._$10896 = frame;
        this._$10897 = repMan;
        this._$10893 = searchPanel;
        this._$10894 = searchExpression;
        this._$10895 = moduleScope;
        this._$10213.setNumColumns(_$10889.length);
        this._$10213.setColumnLabels(_$10889);
        this._$10213.setNumRows(10);
        this._$4049.setDataSource(this._$10213);
        this._$4049.setPopupMenuEnabled(false);
        this._$4049.setCharWidth(-1, 5);
        this._$4049.setTraverseCycle(false);
        this._$4049.addCellDisplayListener(this);
        try {
            this._$7447();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setFinishCallback(Runnable finishCallback) {
        this._$10907 = finishCallback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadPool threadPool = ThreadPool.create("SearchMIBRepository", Runtime.getRuntime().availableProcessors());
        this._$5099 = 0;
        this._$10213.setNumRows(0);
        Object[] modules = null;
        try {
            modules = this._$10897.getModuleNames();
        }
        catch (IOException ex) {
            this._$10904.setText("Failed to access MIB repository: " + ex.getMessage());
            return;
        }
        this._$10900.setMaximum(0);
        this._$10900.setMaximum(modules.length - 1);
        this._$10900.setStringPainted(true);
        Arrays.sort(modules);
        for (int i = 0; i < modules.length && !this.cancel; ++i) {
            this._$10904.setText((String)modules[i]);
            this._$10900.setValue(i);
            Object moduleName = modules[i];
            threadPool.execute(new Runnable((String)moduleName){
                final /* synthetic */ String val$moduleName;
                {
                    this.val$moduleName = string;
                }

                public void run() {
                    try {
                        MIBObject[] objects = SearchMIBRepository.this._$10897.getObjects(this.val$moduleName);
                        MIBRepository rep = new MIBRepository(objects);
                        objects = SearchMIBRepository.this._$10897.getImportedObjects(this.val$moduleName);
                        rep.addAllObjects(objects);
                        SearchMIBRepository.this._$10928(this.val$moduleName, rep);
                    }
                    catch (IOException iox) {
                        iox.printStackTrace();
                    }
                }
            });
        }
        while (!threadPool.isIdle()) {
            try {
                ThreadPool i = threadPool;
                synchronized (i) {
                    threadPool.wait(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        threadPool.stop();
        this._$10904.setText("Search complete!");
        if (this._$10907 != null) {
            SwingUtilities.invokeLater(this._$10907);
        }
    }

    public TreeMap getSelectedObjects() {
        int[] rows = TableUtils.getSelectedRows(this._$4049);
        TreeMap<Object, Object> h = new TreeMap<Object, Object>();
        for (int i = 0; i < rows.length; ++i) {
            h.put(this._$10213.getTableDataItem(rows[i], 1), this._$10213.getTableDataItem(rows[i], 0));
        }
        return h;
    }

    private synchronized boolean _$10937(MIBRepository rep, Regex expression, MIBObject o, boolean[] flags) {
        MIBModule module;
        if (flags[0] && (module = rep.getModule(o.getModuleID())) != null && expression.match(o.toSMI(1, module.getSMIVersion(), rep, "\n"))) {
            return true;
        }
        if ((flags[0] || flags[2]) && o.getName() != null && expression.match(o.getName())) {
            return true;
        }
        if ((flags[0] || flags[1]) && o.getOid() != null && expression.match(o.getOid().toString())) {
            return true;
        }
        if ((flags[0] || flags[3]) && o.getDescription() != null && expression.match(o.getDescription())) {
            return true;
        }
        if (flags[0] || flags.length > 4 && flags[4]) {
            List refs = this._$10941(rep, o);
            for (String ref : refs) {
                if (!expression.match(ref)) continue;
                return true;
            }
        }
        return false;
    }

    private List _$10941(MIBRepository rep, MIBObject o) {
        LinkedList<String> refs;
        block10: {
            MIBAgentCaps ac;
            block11: {
                block9: {
                    refs = new LinkedList<String>();
                    if (!(o instanceof MIBModule)) break block9;
                    MIBModule m = (MIBModule)o;
                    if (!m.hasImports()) break block10;
                    for (int i = 0; i < m.getImportsVector().size(); ++i) {
                        MIBImport imp = m.getImportsVector().get(i);
                        if (this._$10895 != null && !imp.getSource().equals(this._$10895)) continue;
                        refs.addAll(imp.getImportsVector());
                    }
                    break block10;
                }
                if (!(o instanceof MIBCompliance)) break block11;
                MIBCompliance c = (MIBCompliance)o;
                if (c.getModules() == null) break block10;
                for (MIBComplianceModule cm : c.getModules()) {
                    String moduleName = cm.getModuleName();
                    if (!cm.hasModuleName()) {
                        moduleName = rep.getModuleName(o.getModuleID());
                    }
                    if (this._$10895 != null && !moduleName.equals(this._$10895)) continue;
                    if (cm.hasMandatory()) {
                        refs.addAll(cm.getMandatoryVector());
                    }
                    if (!cm.hasVariations()) continue;
                    for (MIBVariation var : cm.getVariationsVector()) {
                        refs.add(var.getVariation());
                        if (!var.hasCreationRequires()) continue;
                        refs.addAll(var.getCreationRequiresVector());
                    }
                }
                break block10;
            }
            if (o instanceof MIBAgentCaps && (ac = (MIBAgentCaps)o).getModules() != null) {
                for (MIBSupportedModule sm : ac.getModules()) {
                    String moduleName = sm.getSupports();
                    if (sm.getSupports() == null) {
                        moduleName = rep.getModuleName(o.getModuleID());
                    }
                    if (this._$10895 != null && !moduleName.equals(this._$10895) || !sm.hasVariations()) continue;
                    for (MIBVariation var : sm.getVariationsVector()) {
                        refs.add(var.getVariation());
                        if (!var.hasCreationRequires()) continue;
                        refs.addAll(var.getCreationRequiresVector());
                    }
                }
            }
        }
        return refs;
    }

    private void _$10928(String moduleName, MIBRepository rep) {
        Integer moduleID = null;
        if (rep.getModule(moduleName) != null) {
            moduleID = rep.getModule(moduleName).getModuleID();
        }
        Enumeration<? extends MIBObject> en = rep.objectsByName();
        while (en.hasMoreElements()) {
            MIBObject o = en.nextElement();
            if (!o.getModuleID().equals(moduleID) || !this._$10937(rep, this._$10894, o, this._$10893.getSearchOptions())) continue;
            ++this._$5099;
            if (this._$5099 == 1) {
                this._$10906.setText("" + this._$5099 + " match.");
            } else {
                this._$10906.setText("" + this._$5099 + " matches.");
            }
            final Vector<Object> row = new Vector<Object>();
            row.add(moduleName);
            row.add(o);
            row.add(o.getOid());
            row.add(o.getTypeString());
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    SearchMIBRepository.this._$10213.addRow(Integer.MAX_VALUE, new Integer(SearchMIBRepository.this._$10213.getNumRows() + 1), row);
                }
            });
        }
    }

    public void setRepositoryManager(RepositoryManager repositoryManager) {
        this._$10897 = repositoryManager;
    }

    public RepositoryManager getRepositoryManager() {
        return this._$10897;
    }

    public SearchMIBRepository() {
        try {
            this._$7447();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void _$7447() throws Exception {
        this.setLayout(this._$7431);
        this._$10901.setText("Progress:");
        this._$10899.setLayout(this._$10902);
        this._$10900.setStringPainted(true);
        this._$10898.setLayout(this._$7433);
        this._$10903.setText("Searching:");
        this._$10905.setText("Found:");
        this._$10906.setText("0 matches.");
        this.add((Component)this._$10898, "Center");
        this._$10898.add((Component)this._$4049, "Center");
        this.add((Component)this._$10899, "North");
        this._$10899.add((Component)this._$10901, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 10), 0, 0));
        this._$10899.add((Component)this._$10900, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 10, 0, 10), 0, 0));
        this._$10899.add((Component)this._$10903, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 10, 5, 10), 0, 0));
        this._$10899.add((Component)this._$10904, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 5, 10), 0, 0));
        this._$10899.add((Component)this._$10905, new GridBagConstraints(0, 2, 1, 2, 0.0, 0.0, 17, 0, new Insets(5, 10, 10, 10), 0, 0));
        this._$10899.add((Component)this._$10906, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 10, 10, 10), 0, 0));
    }

    public void cellDisplay(JCCellDisplayEvent e) {
        if (e.getColumn() == 1 && e.getCellData() instanceof MIBObject) {
            MIBObject o = (MIBObject)e.getDisplayData();
            e.setDisplayData(o.getName());
        }
    }
}

