/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.MIBCompiler;
import com.agentpp.mib.MIBRepository;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smiparser.SMIParseException;
import com.klg.jclass.datasource.BaseColumn;
import com.klg.jclass.datasource.BaseDataTable;
import com.klg.jclass.datasource.BaseMetaData;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.TreeData;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class ParserLogTree
extends TreeData {
    private static final Object[][] _$16674 = new Object[][]{{"Status", String.class}, {"File", String.class}, {"Errors", Integer.class}, {"Path", String.class}, {"MIB Modules", String.class}};
    private static final Object[][] _$16675 = new Object[][]{{"Number", Integer.class}, {"Error Code", Integer.class}, {"Description", String.class}};
    static final int COL_STATUS = 0;
    static final int COL_FILE = 1;
    static final int COL_ERRORS = 2;
    static final int COL_PATH = 3;
    static final int COL_MODULES = 4;
    private BaseMetaData _$16680;
    private BaseMetaData _$16681;
    private FilesTable _$9892;
    private DataModelListener _$6610;
    private HashMap _$16683 = new HashMap();
    private static final String _$16684 = "OK";

    public ParserLogTree() {
        try {
            this.createMetaData();
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public List getFiles() {
        return (List)this._$9892.getUserData("files");
    }

    protected void createMetaData() throws DataModelException {
        BaseColumn column;
        int i;
        this._$16680 = new BaseMetaData(this);
        this._$16680.setDescription("MIB Files");
        this._$16681 = new BaseMetaData(this);
        this._$16681.setDescription("Compilation Errors");
        ((DataSourceTreeModel)this.getMetaDataTree()).setRoot(this._$16680);
        this._$16680.add(this._$16681);
        this._$16680.setCacheChildren(true);
        for (i = 0; i < _$16674.length; ++i) {
            column = new BaseColumn();
            column.setColumnName((String)_$16674[i][0]);
            column.setColumnClassName(((Class)_$16674[i][1]).getName());
            this._$16680.addColumn(column);
        }
        for (i = 0; i < _$16675.length; ++i) {
            column = new BaseColumn();
            column.setColumnName((String)_$16675[i][0]);
            column.setColumnClassName(((Class)_$16675[i][1]).getName());
            this._$16681.addColumn(column);
        }
        this._$9892 = new FilesTable(this._$16680);
        ((DataSourceTreeModel)this.getDataTableTree()).setRoot(this._$9892);
    }

    BaseMetaData getErrorsListMetaData() {
        return this._$16681;
    }

    public void replaceModules(int fileIndex, Vector modules) {
        Object[] row = (Object[])this.getFiles().get(fileIndex);
        row[4] = modules != null ? MIBRepository.buildStringEnumeration(modules.elements()) : "";
        row[0] = _$16684;
        row[2] = new Integer(0);
        try {
            this.replaceErrors(fileIndex, null);
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public void replaceErrors(int fileIndex, SMIParseException pex) throws DataModelException {
        Object[] row = (Object[])this.getFiles().get(fileIndex);
        row[2] = new Integer(this._$16693(pex));
        long bookmark = this._$9892.getRowIdentifier(fileIndex);
        Object old = this._$16683.remove(new Long(bookmark));
        for (int i = 0; i < this._$9892.getChildCount(); ++i) {
            BaseDataTable node = (BaseDataTable)this._$9892.getChildAt(i);
            if (node != old) continue;
            node.removeFromParent();
            break;
        }
        if (pex != null) {
            this._$14928(bookmark, (Object[])this.getFiles().get(fileIndex), pex);
        }
    }

    public long add(Object file, SMIParseException pex, Vector modules) throws DataModelException {
        LinkedList<Object[]> files;
        this.enableDataModelEvents(false);
        Object[] row = new Object[_$16674.length];
        int errors = 0;
        if (pex != null) {
            row[0] = "Failed";
            errors = this._$16693(pex);
        } else {
            row[0] = _$16684;
        }
        row[1] = file instanceof MIBCompiler.ZipReference ? ((MIBCompiler.ZipReference)file).entry.getName() : ((File)file).getName();
        row[2] = new Integer(errors);
        row[3] = file;
        row[4] = modules != null ? MIBRepository.buildStringEnumeration(modules.elements()) : "";
        long id = this._$9892.addInternalRow(row);
        if (pex != null) {
            this._$14928(id, row, pex);
        }
        if ((files = this.getFiles()) == null) {
            files = new LinkedList<Object[]>();
            this._$9892.setUserData("files", files);
        }
        files.add(row);
        this.enableDataModelEvents(true);
        return id;
    }

    private int _$16693(SMIParseException pex) {
        if (pex == null) {
            return 0;
        }
        return pex.getErrorList() != null && pex.getErrorList().size() > 0 ? pex.getErrorList().size() : 1;
    }

    private DataTableModel _$14928(long id, Object[] parentRow, SMIParseException pex) throws DataModelException {
        ErrorsTable errorsTable = (ErrorsTable)this._$9892.createTable(this._$6610, id, this._$16681);
        this._$16683.put(new Long(id), errorsTable);
        List<SMIParseException> errorList = pex.getErrorList();
        if (errorList == null || errorList.size() == 0) {
            errorList = Arrays.asList(pex);
        }
        for (int i = 0; i < errorList.size(); ++i) {
            SMIParseException ex = errorList.get(i);
            Object[] errRow = new Object[_$16675.length];
            int n = 0;
            errRow[n++] = new Integer(i + 1);
            errRow[n++] = new Integer(ex.errorType);
            errRow[n++] = DefaultRepositoryManager.getErrorText(ex, false).replace('\r', ' ').replace('\n', ' ');
            errorsTable.addInternalRow(errRow);
        }
        errorsTable.setUserData("errors", errorList);
        errorsTable.setUserData("file", parentRow);
        return errorsTable;
    }

    public ErrorsTable getErrorTable(long bookmark) {
        return (ErrorsTable)this._$16683.get(new Long(bookmark));
    }

    protected void refreshFinished() {
        this.enableDataModelEvents(true);
        try {
            super.requeryAll(this._$6610);
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public void setDataModelListener(DataModelListener dataModelListener) {
        this._$6610 = dataModelListener;
    }

    public BaseDataTable getRoot() {
        return this._$9892;
    }

    public class ErrorsTable
    extends BaseDataTable {
        public ErrorsTable(MetaDataModel model, long parentRow) {
            super(model, parentRow);
        }
    }

    public class FilesTable
    extends BaseDataTable {
        public FilesTable(MetaDataModel model) {
            super(model);
        }

        public DataTableModel materializeTable(DataModelListener listener, long bookmark, TreeNode node) throws DataModelException {
            ErrorsTable newTable = ParserLogTree.this.getErrorTable(bookmark);
            if (newTable != null) {
                return newTable;
            }
            newTable = new ErrorsTable((BaseMetaData)node, bookmark);
            this.add(newTable);
            return newTable;
        }
    }
}

