/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.MIBCompiler;
import com.agentpp.common.ParserLogTree;
import com.agentpp.common.SortLabelRenderer;
import com.agentpp.mib.MIBModule;
import com.agentpp.notepad.MIBImporter;
import com.agentpp.notepad.Notepad;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.util.UserConfigFile;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.TreeIterator;
import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.CellPosition;
import com.klg.jclass.higrid.CellStyleModel;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.FormatTree;
import com.klg.jclass.higrid.GridScrollbarCallback;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.HiGridErrorListener;
import com.klg.jclass.higrid.HiGridExpansionAdapter;
import com.klg.jclass.higrid.HiGridExpansionEvent;
import com.klg.jclass.higrid.HiGridFormatNodeAdapter;
import com.klg.jclass.higrid.HiGridFormatNodeEvent;
import com.klg.jclass.higrid.HiGridFormatNodeListener;
import com.klg.jclass.higrid.HiGridTraverseAdapter;
import com.klg.jclass.higrid.HiGridTraverseEvent;
import com.klg.jclass.higrid.HiGridTraverseListener;
import com.klg.jclass.higrid.HiGridUpdateAdapter;
import com.klg.jclass.higrid.HiGridUpdateEvent;
import com.klg.jclass.higrid.KeyActionInitiator;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.SortLabelCellRenderer;
import com.klg.jclass.higrid.TableNodeRenderer;
import com.klg.jclass.higrid.Walkable;
import java.awt.Adjustable;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ParserLog
extends JPanel
implements HiGridErrorListener,
GridScrollbarCallback,
HiGridTraverseListener,
MIBImporter {
    BorderLayout borderLayout1 = new BorderLayout();
    BorderLayout borderLayout2 = new BorderLayout();
    private static final Color _$15977 = new Color(200, 215, 250);
    private UserConfigFile _$6654;
    JPanel toolBarPanel = new JPanel();
    JPanel errorPanel = new JPanel();
    JTextArea errorText = new JTextArea();
    HiGrid hiGrid = new HiGrid();
    JScrollPane scrollPane = new JScrollPane();
    JSplitPane splitPane = new JSplitPane(0);
    HiGridFormatNodeListener formatNodeListener = new BaseExampleHiGridFormatNodeListener();
    ParserLogTree data;
    private JFrame _$12186;
    private MIBImporter _$14897;
    private boolean _$15189;

    public ParserLog() {
        this._$6227();
        try {
            this._$6440();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this._$660();
    }

    public ParserLog(UserConfigFile config, JFrame myFrame, MIBImporter importer) {
        this();
        this._$6654 = config;
        this._$12186 = myFrame;
        this._$14897 = importer;
    }

    private void _$6440() throws Exception {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.toolBarPanel, "North");
        this.add((Component)this.splitPane, "Center");
        this.splitPane.setTopComponent(this.hiGrid);
        this.splitPane.setBottomComponent(this.errorPanel);
        this.errorPanel.setLayout(this.borderLayout2);
        this.errorPanel.add((Component)this.scrollPane, "Center");
        this.scrollPane.getViewport().add(this.errorText);
        this.errorText.setEditable(false);
        this.splitPane.setOneTouchExpandable(true);
        this.errorText.setToolTipText("Displays error description of the selected error");
    }

    public void setDividerLocation(double relativeLocation) {
        this.splitPane.setDividerLocation(relativeLocation);
    }

    private void _$6227() {
        this.data = new ParserLogTree();
        TableNodeRenderer nodeRenderer = new TableNodeRenderer();
        this.hiGrid.getLookupTable().setNodeRenderer(nodeRenderer);
        this.hiGrid.getHorizontalScrollbar().setDisplay(0);
        this.hiGrid.addHiGridFormatNodeListener(this.formatNodeListener);
        this.hiGrid.addHiGridUpdateListener(new AutoColumnSizeHiGridUpdateListener());
        this.hiGrid.setBatched(true);
        this.hiGrid.setRowtipVisible(true);
        this.hiGrid.getEditPopupMenu().setDefaultMenuList(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().remove(0);
        this.hiGrid.getEditPopupMenu().add((Component)new JMenuItem(new ExpandAllAction("Expand All")), 0);
        this.hiGrid.getEditPopupMenu().add((Component)new JMenuItem(new CollapseAllAction("Collapse All")), 1);
        this.hiGrid.getEditPopupMenu().add((Component)new JMenuItem(new EditAction("Edit...")), 2);
        this.hiGrid.setDataModel(this.data);
        this.hiGrid.setToolTipText("Double click on file or error to edit it");
        this.data.setDataModelListener(this.hiGrid.getDataModelListener());
        this.hiGrid.setBatched(false);
        KeyActionInitiator copy = new KeyActionInitiator(67, 2);
        this.hiGrid.getController().addAction(copy, 24);
        this.hiGrid.setEditorHidden(true);
        this.hiGrid.addHiGridExpansionListener(new ListModeHiGridExpansionListener());
        this.hiGrid.addHiGridTraverseListener(new ListModeHiGridTraverseListener());
        this.hiGrid.getErrorHandler().setShowErrorDialog(false);
        this.hiGrid.addHiGridErrorListener(this);
        this.hiGrid.setLevelIndented(true);
        this.hiGrid.setEditable(false);
        this.hiGrid.getVerticalScrollbar().setRowtipCallback(this);
        SortLabelCellRenderer.setAscendingImage(SortLabelRenderer.ascendingIcon.getImage());
        SortLabelCellRenderer.setDescendingImage(SortLabelRenderer.descendingIcon.getImage());
        this.createFormats();
        this._$16021(new Integer(0));
        this._$660();
        this.hiGrid.setSortable(new CellValueComparator());
        this.hiGrid.addHiGridTraverseListener(this);
        this.hiGrid.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                CellPosition cp;
                if (e.getClickCount() == 2 && (cp = ParserLog.this.hiGrid.getCellPositionFromPoint(e.getPoint())) != null) {
                    RowNode node = cp.getRowNode();
                    ParserLog.this._$16026(node);
                }
            }
        });
    }

    private void _$16026(RowNode node) {
        List errorList = null;
        DataTableModel model = node.getDataTableModel();
        List files = (List)model.getUserData("files");
        SMIParseException pex = null;
        File f = null;
        if (files != null) {
            Object[] fileRow;
            long bookmark = node.getBookmark();
            int index = model.getRowIndex(bookmark);
            if (index >= 0 && index < files.size() && (fileRow = (Object[])files.get(index)) != null) {
                DataTableModel errorModel = model.getTable(bookmark, this.data.getErrorsListMetaData());
                if (errorModel == null) {
                    errorModel = this.data.getErrorTable(bookmark);
                }
                if (errorModel != null && (errorList = (List)errorModel.getUserData("errors")) != null && errorList.size() > 0) {
                    pex = (SMIParseException)errorList.get(0);
                    Object path = fileRow[3];
                    if (path instanceof MIBCompiler.ZipReference) {
                        f = this._$16035((MIBCompiler.ZipReference)path);
                        fileRow[3] = f;
                    } else {
                        f = (File)path;
                    }
                }
            }
        } else {
            long bookmark;
            int index;
            errorList = (List)model.getUserData("errors");
            Object[] fileRow = (Object[])model.getUserData("file");
            if (fileRow != null && (index = model.getRowIndex(bookmark = node.getBookmark())) >= 0 && index < errorList.size()) {
                pex = (SMIParseException)errorList.get(index);
                Object path = fileRow[3];
                if (path instanceof MIBCompiler.ZipReference) {
                    f = this._$16035((MIBCompiler.ZipReference)path);
                    fileRow[3] = f;
                } else {
                    f = (File)path;
                }
            }
        }
        if (pex != null && f != null) {
            pex.setErrorList(errorList);
            this.showFile(pex, f);
        }
    }

    private File _$16035(MIBCompiler.ZipReference ref) {
        try {
            byte[] b;
            int l;
            File n = new File(ref.entry.getName());
            File f = File.createTempFile("MIB_" + n.getName(), ".txt");
            FileOutputStream fos = new FileOutputStream(f);
            InputStream is = ref.file.getInputStream(ref.entry);
            while (is.available() > 0 && (l = is.read(b = new byte[is.available()])) > 0) {
                fos.write(b, 0, l);
            }
            fos.close();
            is.close();
            return f;
        }
        catch (IOException iox) {
            JOptionPane.showMessageDialog(this, "Could not create temporary file: " + iox.getMessage(), "IO Error", 0);
            return null;
        }
    }

    protected void showFile(SMIParseException pex, File file) {
        StringTokenizer st;
        final Notepad np = pex.fileError != null ? (pex.fileError.getFoundTokenImage() != null ? new Notepad(this._$12186, file, pex.fileError.getLine(), pex.fileError.getColumn(), pex.fileError.getFoundTokenImage().length()) : new Notepad(this._$12186, file, pex.fileError.getLine(), pex.fileError.getColumn())) : (pex.objects != null ? new Notepad(this._$12186, file, pex.objects.firstElement().toString()) : (pex.getMessage() != null ? ((st = new StringTokenizer(pex.getMessage(), ", ")).hasMoreTokens() ? new Notepad(this._$12186, file, st.nextToken()) : new Notepad(this._$12186, file)) : new Notepad(this._$12186, file)));
        np.setConfig(this._$6654);
        np.setImporter(this);
        np.setError(pex);
        np.setTitle(file.getName());
        np.setLocationRelativeTo(this._$12186);
        np.setParserMode(1);
        np.setModal(true);
        np.setLookupEnabled(this._$15189);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                np.setVisible(true);
            }
        });
    }

    public void addResult(File f, SMIParseException pex, Vector modules) {
        try {
            this.data.add(f, pex, modules);
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public void addResult(MIBCompiler.ZipReference f, SMIParseException pex, Vector modules) {
        try {
            this.data.add(f, pex, modules);
        }
        catch (DataModelException ex) {
            ex.printStackTrace();
        }
    }

    public void afterTraverse(HiGridTraverseEvent event) {
    }

    private void _$660() {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Class<?> MouseWheelListener2 = cl.loadClass("java.awt.event.MouseWheelListener");
            cl = this.getClass().getClassLoader();
            Class<?> c = cl.loadClass("grid.GridMouseWheelListener");
            Constructor<?> constructor = c.getDeclaredConstructors()[0];
            Object[] oargs = new Object[]{this.hiGrid};
            Object tableMouseWheelListener = null;
            tableMouseWheelListener = constructor.newInstance(oargs);
            Class[] params = new Class[]{MouseWheelListener2};
            Method addMouseWheelListener = null;
            addMouseWheelListener = this.hiGrid.getClass().getMethod("addMouseWheelListener", params);
            oargs[0] = tableMouseWheelListener;
            addMouseWheelListener.invoke((Object)this, oargs);
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (InvocationTargetException ex) {
        }
        catch (IllegalArgumentException ex) {
        }
        catch (IllegalAccessException ex) {
        }
        catch (InstantiationException ex) {
        }
        catch (SecurityException ex1) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    private void _$16021(Object style) {
        FormatTree formatTree = this.hiGrid.getFormatTree();
        if (formatTree == null || formatTree.getRoot() == null) {
            return;
        }
        this._$16044((FormatNode)formatTree.getRoot(), style);
        this.hiGrid.refresh();
    }

    private void _$16044(FormatNode node, Object style) {
        if (node == null) {
            return;
        }
        this._$16045(node, style);
        TreeIterator ti = node.getIterator();
        while (ti.hasMoreElements()) {
            node = (FormatNode)ti.get();
            this._$16044(node, style);
            ti.nextElement();
        }
    }

    private void _$16045(FormatNode node, Object style) {
        this._$16047(node.getRecordFormat(), style);
        this._$16047(node.getHeaderFormat(), style);
        this._$16047(node.getFooterFormat(), style);
        this._$16047(node.getBeforeDetailsFormat(), style);
        this._$16047(node.getAfterDetailsFormat(), style);
    }

    private void _$16047(RowFormat rowFormat, Object style) {
        CellFormat cellFormat;
        int borderStyle = (Integer)style;
        Enumeration e = rowFormat.getIndicatorFormats().elements();
        while (e.hasMoreElements()) {
            cellFormat = (CellFormat)e.nextElement();
            cellFormat.setBorderStyle(borderStyle);
        }
        e = rowFormat.getDataFormats().elements();
        while (e.hasMoreElements()) {
            cellFormat = (CellFormat)e.nextElement();
            cellFormat.setBorderStyle(borderStyle);
            cellFormat.setVerticalAlignment(1);
        }
    }

    protected void createFormats() {
        FormatTree formatTree = this.hiGrid.getFormatTree();
        FormatNode rootNode = (FormatNode)formatTree.getRoot();
        this._$16059(rootNode);
    }

    private void _$16059(FormatNode node) {
        RecordFormat recordFormat = node.getRecordFormat();
        HeaderFormat headerFormat = node.getHeaderFormat();
        this._$16062(recordFormat);
        for (int i = 0; i < node.getChildCount(); ++i) {
            FormatNode next = (FormatNode)node.getChildAt(i);
            this._$16059(next);
        }
    }

    private void _$16062(RecordFormat recordFormat) {
        Vector v = recordFormat.getDataFormats();
    }

    public void processError(HiGridErrorEvent hiGridErrorEvent) {
        String msg = hiGridErrorEvent.getException().getMessage();
        if (hiGridErrorEvent.getException() instanceof DataModelException) {
            DataModelException ex = (DataModelException)hiGridErrorEvent.getException();
            Exception x = ex.getWrappedException();
            msg = ((DataModelException)x).getWrappedException().getMessage();
        }
        JOptionPane.showMessageDialog(this, msg, "Internal Error", 0);
    }

    public String setRowtipText(RowNode rowNode, int currentValue, Adjustable adjustable) {
        return "Row index: " + Integer.toString(currentValue);
    }

    public void positionRowtip(Container parent, Component rowtip) {
        if (parent != null) {
            rowtip.setSize(200, 24);
            Dimension containerDimension = parent.getSize();
            Dimension tipDimension = rowtip.getSize();
            int x = 0;
            int y = (containerDimension.height - tipDimension.height) / 2;
            rowtip.setLocation(x, y);
        }
    }

    public void refresh() {
        this.data.refreshFinished();
        this.hiGrid.refresh();
        this.setDividerLocation(0.75);
    }

    protected void selectCurrentRow() {
        if (this.hiGrid.getCurrentRowNode() != null) {
            RowNode node;
            SMIParseException pex;
            if (!this.hiGrid.getCurrentRowNode().isSelected()) {
                this.hiGrid.toggleRowSelection(this.hiGrid.getCurrentRowNode(), false);
            }
            if ((pex = this._$15483(node = this.hiGrid.getCurrentRowNode())) != null) {
                String txt = DefaultRepositoryManager.getErrorText(pex);
                this.errorText.setText(txt);
                this.errorText.setCaretPosition(0);
            } else {
                this.errorText.setText("");
                this.errorText.setCaretPosition(0);
            }
        }
    }

    private SMIParseException _$15483(RowNode node) {
        long bookmark;
        int index;
        DataTableModel model = node.getDataTableModel();
        List errorList = (List)model.getUserData("errors");
        if (errorList != null && (index = model.getRowIndex(bookmark = node.getBookmark())) >= 0 && index < errorList.size()) {
            return (SMIParseException)errorList.get(index);
        }
        return null;
    }

    private void _$16092() {
        RowNode top = this.hiGrid.getRowNode(0);
        if (top == null) {
            return;
        }
        this.hiGrid.getRowTree().walk(top, new Walkable(){

            public boolean getDownward() {
                return true;
            }

            public boolean done() {
                return false;
            }

            public void next(RowNode rowNode) {
                ParserLog.this.hiGrid.expandFolder(rowNode);
            }

            public void previous(RowNode rowNode) {
                ParserLog.this.hiGrid.expandFolder(rowNode);
            }

            public boolean find(RowNode rowNode) {
                return false;
            }
        });
    }

    public ModuleInfo[] importMIB(Object caller, File file, int mode) throws SMIParseException, IOException {
        List files = this.data.getFiles();
        LinkedList<Integer> rows = new LinkedList<Integer>();
        int i = 0;
        Iterator it = files.iterator();
        while (it.hasNext()) {
            Object f = ((Object[])it.next())[3];
            if (file.equals(f)) {
                rows.add(new Integer(i));
            }
            ++i;
        }
        try {
            int j;
            ModuleInfo[] info = this._$14897.importMIB(caller, file, mode);
            Vector<String> v = new Vector<String>();
            for (j = 0; j < info.length; ++j) {
                v.add(info[j].moduleName);
            }
            for (j = 0; j < rows.size(); ++j) {
                RowNode row = this.hiGrid.getRowNode((Integer)rows.get(j));
                this.data.replaceModules((Integer)rows.get(j), v);
                if (j != 0) continue;
                this.hiGrid.toggleRowSelection(row, false, true);
            }
            this.data.refreshFinished();
            return info;
        }
        catch (SMIParseException pex) {
            int j;
            for (j = 0; j < rows.size(); ++j) {
                try {
                    this.data.replaceErrors((Integer)rows.get(j), pex);
                    continue;
                }
                catch (DataModelException ex) {
                    ex.printStackTrace();
                }
            }
            this.data.refreshFinished();
            for (j = 0; j < rows.size(); ++j) {
                int rowIndex = (Integer)rows.get(j) + 1;
                RowNode row = this.hiGrid.getRowNode(rowIndex);
                this.hiGrid.expandFolder(row);
                if (j != 0) continue;
                this.hiGrid.toggleRowSelection(row, false, true);
            }
            throw pex;
        }
        catch (IOException iox) {
            throw iox;
        }
    }

    public ModuleInfo[] checkMIB(Object caller, InputStream file, int mode) throws IOException, SMIParseException {
        return this._$14897.checkMIB(caller, file, mode);
    }

    public ModuleInfo[] importMIB(Object caller, InputStream is, String path, int mode) throws IOException, SMIParseException {
        throw new UnsupportedOperationException();
    }

    public MIBModule[] parseMIBs(Object caller, InputStream is, String path, int mode) throws IOException, SMIParseException {
        return this._$14897.parseMIBs(caller, is, path, mode);
    }

    public boolean isLookupEnabled() {
        return this._$15189;
    }

    public void setLookupEnabled(boolean lookupEnabled) {
        this._$15189 = lookupEnabled;
    }

    class ListModeHiGridTraverseListener
    extends HiGridTraverseAdapter {
        ListModeHiGridTraverseListener() {
        }

        public void afterTraverse(HiGridTraverseEvent e) {
            ParserLog.this.selectCurrentRow();
        }
    }

    class ListModeHiGridExpansionListener
    extends HiGridExpansionAdapter {
        ListModeHiGridExpansionListener() {
        }

        public void afterExpandRow(HiGridExpansionEvent e) {
            ParserLog.this.selectCurrentRow();
        }

        public void afterCollapseRow(HiGridExpansionEvent e) {
            ParserLog.this.selectCurrentRow();
        }
    }

    class ExpandAllAction
    extends AbstractAction {
        public ExpandAllAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            ParserLog.this._$16092();
        }
    }

    class EditAction
    extends AbstractAction {
        public EditAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            ParserLog.this._$16026(ParserLog.this.hiGrid.getCurrentRowNode());
        }
    }

    class CollapseAllAction
    extends AbstractAction {
        public CollapseAllAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            try {
                ParserLog.this.data.requeryAll(ParserLog.this.hiGrid.getDataModelListener());
            }
            catch (DataModelException ex) {
                ex.printStackTrace();
            }
        }
    }

    class BaseExampleHiGridFormatNodeListener
    extends HiGridFormatNodeAdapter {
        BaseExampleHiGridFormatNodeListener() {
        }

        public void beforeCreateFormatNodeContents(HiGridFormatNodeEvent event) {
            CellStyleModel cellStyle = ParserLog.this.hiGrid.getRecordCellStyle();
            cellStyle.setBackground(Color.white);
        }
    }

    class AutoColumnSizeHiGridUpdateListener
    extends HiGridUpdateAdapter {
        AutoColumnSizeHiGridUpdateListener() {
        }

        public void afterCreateRow(HiGridUpdateEvent ev) {
            RowNode rowNode = ev.getRowNode();
            DataTableModel dataTable = rowNode.getDataTableModel();
            RowFormat rowFormat = rowNode.getRowFormat();
            boolean repaintNeeded = false;
            if (rowFormat == null || dataTable == null) {
                return;
            }
            Enumeration e = rowFormat.getDataFormats().elements();
            while (e.hasMoreElements()) {
                CellFormat cellFormat = (CellFormat)e.nextElement();
                String name = cellFormat.getName();
                Object o = null;
                if (rowFormat instanceof RecordFormat) {
                    try {
                        o = dataTable.getResultData(rowNode.getBookmark(), name);
                    }
                    catch (Exception x) {}
                } else if (rowFormat instanceof HeaderFormat) {
                    o = cellFormat.getText();
                }
                if (o == null) continue;
                int width = this._$16082(ParserLog.this.hiGrid, cellFormat.getFont(), o.toString());
                if (cellFormat.getWidth() >= width) continue;
                cellFormat.setWidth(width);
                repaintNeeded = true;
            }
            if (repaintNeeded) {
                ParserLog.this.hiGrid.refresh();
            }
        }

        private int _$16082(Component component, Font font, String s) {
            FontMetrics fm = component.getFontMetrics(font);
            return fm.stringWidth(s) + (font.isItalic() ? font.getSize() / 3 + 1 : 0);
        }
    }

    class CellValueComparator
    implements Comparator {
        CellValueComparator() {
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int compare(Object o1, Object o2) {
            if (o1 instanceof File && o2 instanceof MIBCompiler.ZipReference) {
                return this.compare(o2, o1);
            }
            return ((Comparable)o1).compareTo(o2);
        }
    }
}

