/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.StatusBar;
import com.agentpp.common.TableSorter;
import com.agentpp.common.table.TableUtils;
import com.agentpp.common.table.print.JCTableView;
import com.agentpp.common.table.print.PrintActionPanel;
import com.agentpp.common.table.print.TableFlow;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.event.MIBModuleEvent;
import com.agentpp.mib.event.MIBModuleListener;
import com.agentpp.notepad.MIBImporter;
import com.agentpp.notepad.Notepad;
import com.agentpp.repository.DefaultRepositoryManager;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ModuleInfoSorter;
import com.agentpp.smiparser.SMIParseException;
import com.agentpp.util.ExampleFileFilter;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.gui.ShowDialogLater;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCCellStyle;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.data.JCEditableVectorDataSource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class ParseDialog
extends JDialog
implements MIBImporter,
ActionListener,
WindowListener {
    public static final String[] PARSE_TABLE_HEADERS = new String[]{"Status", "File", "MIB Module(s) / Error Text", "Path"};
    private static final int _$16034 = 4;
    private static final String[] _$15436 = new String[]{"ZIP"};
    public static final char NEW_LINE_DELIM = '\n';
    public static final char TAB_DELIM = '\t';
    public static final String EMPTY_STRING = "";
    public static final String NEWLINE = "\n";
    public static final String NULL = "null";
    public static final String TAB = "\t";
    public static final DataFlavor data_flavour = new DataFlavor(String.class, "ExcelTokenizedString");
    private Clipboard _$25196;
    private int _$25197;
    private int _$25198;
    private int _$25199;
    private int _$25200;
    private StringSelection _$25201;
    private Collection _$15206;
    JPanel panel1 = new JPanel();
    BorderLayout borderLayout1 = new BorderLayout();
    JPanel jPanelSouth = new JPanel();
    JPanel jPanelBorder = new JPanel();
    BorderLayout borderLayout2 = new BorderLayout();
    Border border1;
    JPanel jPanelButtons = new JPanel();
    JButton jButtonClose = new JButton();
    FlowLayout flowLayout1 = new FlowLayout();
    JCTable table = new JCTable();
    JCEditableVectorDataSource data;
    JButton jButtonPrint = new JButton();
    JFrame myFrame;
    MIBImporter importer;
    Image stop;
    private TableSorter _$14894;
    private UserConfigFile _$6654 = new UserConfigFile();
    JButton jButtonReport = new JButton();
    static ExampleFileFilter filter = new ExampleFileFilter(_$15436);

    public ParseDialog(Image iStop, MIBImporter importer, JFrame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.myFrame = frame;
        this.stop = iStop;
        this.importer = importer;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.data = new JCEditableVectorDataSource();
        this.data.setNumColumns(PARSE_TABLE_HEADERS.length);
        this.data.setNumRows(0);
        this.data.setColumnLabels(PARSE_TABLE_HEADERS);
        this._$14894 = new TableSorter(this.table, this.data);
        JCCellStyle colors = new JCCellStyle();
        colors.setCellEditor(null);
        colors.setEditable(false);
        this.table.setCellStyle(-997, -997, colors);
        JCCellStyle iconStyle = new JCCellStyle(colors);
        iconStyle.setHorizontalAlignment(0);
        iconStyle.setVerticalAlignment(0);
        this.table.setCellStyle(-997, 0, iconStyle);
        this.table.setPopupMenuEnabled(false);
        this.table.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                JCCellPosition cp = ParseDialog.this.table.XYToCell(e.getX(), e.getY());
                Object data = ParseDialog.this.table.getDataView().getTableRowLabel(cp.row);
                if (data == null) {
                    return;
                }
                if (e.getClickCount() == 2 && data instanceof SMIParseException) {
                    Object path = ParseDialog.this.table.getDataView().getTableDataItem(cp.row, ParseDialog.this.table.getDataView().getNumColumns() - 1);
                    if (path instanceof ZipReference) {
                        try {
                            byte[] b;
                            int l;
                            ZipReference ref = (ZipReference)path;
                            File n = new File(ref.entry.getName());
                            File f = File.createTempFile("MIB_" + n.getName(), ".txt");
                            FileOutputStream fos = new FileOutputStream(f);
                            InputStream is = ref.file.getInputStream(ref.entry);
                            while (is.available() > 0 && (l = is.read(b = new byte[is.available()])) > 0) {
                                fos.write(b, 0, l);
                            }
                            fos.close();
                            is.close();
                            ParseDialog.this.table.getDataView().setTableDataItem(f.getPath(), cp.row, 4);
                            ParseDialog.this.showFile((SMIParseException)data, f);
                        }
                        catch (IOException iox) {
                            JOptionPane.showMessageDialog(ParseDialog.this, "Could not create temporary file: " + iox.getMessage(), "IO Error", 0);
                        }
                    } else {
                        ParseDialog.this.showFile((SMIParseException)data, new File(path.toString()));
                    }
                }
            }
        });
        KeyStroke copy = KeyStroke.getKeyStroke(67, 2, false);
        this.table.registerKeyboardAction(this, "copy", copy, 0);
        this.addWindowListener(this);
    }

    public ParseDialog() {
        this(null, null, null, EMPTY_STRING, false);
    }

    protected void showFile(SMIParseException pex, File file) {
        StringTokenizer st;
        final Notepad np = pex.fileError != null ? (pex.fileError.getFoundTokenImage() != null ? new Notepad(this.myFrame, file, pex.fileError.getLine(), pex.fileError.getColumn(), pex.fileError.getFoundTokenImage().length()) : new Notepad(this.myFrame, file, pex.fileError.getLine(), pex.fileError.getColumn())) : (pex.objects != null ? new Notepad(this.myFrame, file, pex.objects.firstElement().toString()) : ((st = new StringTokenizer(pex.getMessage(), ", ")).hasMoreTokens() ? new Notepad(this.myFrame, file, st.nextToken()) : new Notepad(this.myFrame, file)));
        np.setConfig(this._$6654);
        np.setImporter(this);
        np.setError(pex);
        np.setTitle(file.getName());
        np.setLocationRelativeTo(this.myFrame);
        np.setParserMode(1);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                np.setVisible(true);
            }
        });
    }

    void jbInit() throws Exception {
        this.table.setResizeEven(false);
        this.border1 = new EtchedBorder(0, Color.white, new Color(142, 142, 142));
        this.panel1.setLayout(this.borderLayout1);
        this.jPanelSouth.setLayout(this.borderLayout2);
        this.jPanelBorder.setBorder(this.border1);
        this.jPanelBorder.setPreferredSize(new Dimension(14, 2));
        this.jButtonClose.setText("Close");
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParseDialog.this.jButtonClose_actionPerformed(e);
            }
        });
        this.jPanelButtons.setLayout(this.flowLayout1);
        this.flowLayout1.setAlignment(2);
        this.table.setPopupMenuEnabled(true);
        this.table.setRowLabelDisplay(false);
        this.jButtonPrint.setText("Print");
        this.jButtonPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParseDialog.this.jButtonPrint_actionPerformed(e);
            }
        });
        this.jButtonReport.setToolTipText("Save report on failed MIB files to a text file");
        this.jButtonReport.setText("Save Report...");
        this.jButtonReport.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParseDialog.this.jButtonReport_actionPerformed(e);
            }
        });
        this.getContentPane().add(this.panel1);
        this.panel1.add((Component)this.jPanelSouth, "South");
        this.jPanelSouth.add((Component)this.jPanelBorder, "North");
        this.jPanelSouth.add((Component)this.jPanelButtons, "Center");
        this.jPanelButtons.add((Component)this.jButtonReport, null);
        this.jPanelButtons.add((Component)this.jButtonPrint, null);
        this.jPanelButtons.add((Component)this.jButtonClose, null);
        this.table.setPreferredSize(new Dimension(600, 400));
        this.table.setSelectionPolicy(2);
        this.panel1.add((Component)this.table, "Center");
        this.table.setAutoEdit(false);
        this.getRootPane().setDefaultButton(this.jButtonClose);
    }

    public void create() {
        int i;
        this.table.setDataSource(this.data);
        for (i = 0; i < this.data.getNumRows(); ++i) {
            this.table.setPixelHeight(i, 33001);
        }
        for (i = 0; i < this.data.getNumColumns(); ++i) {
            this.table.setPixelWidth(i, 33001);
        }
        this.table.setVisibleColumns(this.data.getNumColumns() - 1);
        this.table.setVisibleRows(10);
        this.pack();
    }

    public void copySelectionToClipBoard() {
        JCCellRange range2 = null;
        String copy_value = null;
        StringBuffer buffer = new StringBuffer();
        try {
            this._$15206 = this.table.getSelectedCells();
            for (JCCellRange range2 : this._$15206) {
                TableUtils.setRangeAfterCopy(range2);
                for (int row = range2.start_row; row <= this._$25199; ++row) {
                    for (int column = range2.start_column; column <= this._$25200; ++column) {
                        copy_value = this.table.getDataView().getObject(row, column).toString();
                        if (copy_value == null) {
                            copy_value = EMPTY_STRING;
                        } else {
                            copy_value = copy_value.replace('\t', ' ');
                            copy_value = copy_value.replace('\n', ' ');
                        }
                        if (copy_value == NULL) continue;
                        buffer.append(copy_value);
                        if (column < this._$25200) {
                            buffer.append(TAB);
                        }
                        if (column != this._$25200) continue;
                        buffer.append(NEWLINE);
                    }
                }
            }
            this._$25201 = new StringSelection(buffer.toString());
            this._$25196 = Toolkit.getDefaultToolkit().getSystemClipboard();
            this._$25196.setContents(this._$25201, this._$25201);
        }
        catch (NullPointerException e) {
            Toolkit.getDefaultToolkit().beep();
        }
        this._$25201 = null;
    }

    void jButtonClose_actionPerformed(ActionEvent e) {
        for (int i = 0; i < this.table.getNumRows(); ++i) {
            Object o = this.table.getDataSource().getTableDataItem(i, 4);
            if (!(o instanceof ZipReference)) continue;
            try {
                ZipReference ref = (ZipReference)o;
                ref.file.close();
                continue;
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        this.dispose();
    }

    void jButtonPrint_actionPerformed(ActionEvent e) {
        TableFlow flow = new TableFlow();
        JCTableView tableView = new JCTableView();
        tableView.setTable(this.table);
        flow.setCurrentTable(tableView);
        PrintActionPanel action = new PrintActionPanel(this.myFrame, "ParseReport");
        action.setDocumentFlow(flow);
        if (JOptionPane.showConfirmDialog(this, action, "Print Parse Report", 2, -1) == 0) {
            action.getActionPanel().actionPerformed(new ActionEvent(this, 0, "Print"));
        }
    }

    public ModuleInfo[] importMIB(Object caller, File file, int mode) throws SMIParseException, IOException {
        Vector<Integer> rows = new Vector<Integer>();
        for (int i = 0; i < this.table.getDataSource().getNumRows(); ++i) {
            File f = new File(this.table.getDataSource().getTableDataItem(i, this.table.getDataSource().getNumColumns() - 1).toString());
            if (!f.equals(file)) continue;
            rows.add(new Integer(i));
        }
        try {
            int i;
            ModuleInfo[] info = this.importer.importMIB(caller, file, mode);
            Vector<String> v = new Vector<String>();
            for (i = 0; i < info.length; ++i) {
                v.add(info[i].moduleName);
            }
            for (i = 0; i < rows.size(); ++i) {
                this.setRow((int)((Integer)rows.get(i)), file, null, v);
            }
            return info;
        }
        catch (SMIParseException pex) {
            for (int i = 0; i < rows.size(); ++i) {
                this.setRow((int)((Integer)rows.get(i)), file, pex, null);
            }
            throw pex;
        }
        catch (IOException iox) {
            throw iox;
        }
    }

    private Vector _$25216(File f, SMIParseException pex, Vector modules) {
        Vector<Object> r = new Vector<Object>();
        if (pex == null) {
            r.addElement(EMPTY_STRING);
        } else {
            r.addElement(this.stop);
        }
        r.addElement(f.getName());
        if (modules == null && pex != null) {
            r.addElement(DefaultRepositoryManager.getErrorText(pex).replace('\r', ' '));
        } else {
            r.addElement(MIBRepository.buildStringEnumeration(modules.elements()));
        }
        r.addElement(f.getPath());
        return r;
    }

    private Vector _$25216(ZipReference f, SMIParseException pex, Vector modules) {
        Vector<Object> r = new Vector<Object>();
        if (pex == null) {
            r.addElement(EMPTY_STRING);
        } else {
            r.addElement(this.stop);
        }
        if (f.entry != null) {
            r.addElement(f.entry.getName());
        } else {
            r.add(EMPTY_STRING);
        }
        if (modules == null && pex != null) {
            r.addElement(DefaultRepositoryManager.getErrorText(pex).replace('\r', ' '));
        } else {
            r.addElement(MIBRepository.buildStringEnumeration(modules.elements()));
        }
        r.addElement(f);
        return r;
    }

    public void setRow(int row, File f, SMIParseException pex, Vector modules) {
        Vector r = this._$25216(f, pex, modules);
        int col = 0;
        Enumeration en = r.elements();
        while (en.hasMoreElements()) {
            this.data.setTableDataItem(en.nextElement(), row, col);
            ++col;
        }
        this.data.setRowLabel(row, pex);
    }

    public void addRow(File f, SMIParseException pex, Vector modules) {
        Vector r = this._$25216(f, pex, modules);
        this.data.addRow(Integer.MAX_VALUE, pex, r);
    }

    public void setRow(int row, ZipReference f, SMIParseException pex, Vector modules) {
        Vector r = this._$25216(f, pex, modules);
        int col = 0;
        Enumeration en = r.elements();
        while (en.hasMoreElements()) {
            this.data.setTableDataItem(en.nextElement(), row, col);
            ++col;
        }
        this.data.setRowLabel(row, pex);
    }

    public void addRow(ZipReference f, SMIParseException pex, Vector modules) {
        Vector r = this._$25216(f, pex, modules);
        this.data.addRow(Integer.MAX_VALUE, pex, r);
    }

    public void actionPerformed(ActionEvent event) {
        String cmd = event.getActionCommand();
        if (cmd.equals("copy")) {
            this.copySelectionToClipBoard();
        }
    }

    public void setConfig(UserConfigFile newConfig) {
        this._$6654 = newConfig;
    }

    public UserConfigFile getConfig() {
        return this._$6654;
    }

    void jButtonReport_actionPerformed(ActionEvent e) {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        if (fc.showSaveDialog(this) == 0) {
            Object[] options;
            int n;
            if (fc.getSelectedFile().exists() && (n = JOptionPane.showOptionDialog(this, "File already exists! Replace it?", "Confirm Replace", 0, 3, null, options = new Object[]{"Yes", "Cancel"}, options[1])) == 1) {
                return;
            }
            try {
                FileOutputStream fos = new FileOutputStream(fc.getSelectedFile());
                StringBuffer buf = new StringBuffer();
                for (int i = 0; i < this.data.getNumRows(); ++i) {
                    if (this.data.getTableDataItem(i, 0) instanceof String) continue;
                    buf.append(this.data.getTableDataItem(i, 1).toString());
                    buf.append(" (");
                    buf.append(this.data.getTableDataItem(i, 3).toString());
                    buf.append("):\n");
                    SMIParseException pex = (SMIParseException)this.data.getTableRowLabel(i);
                    buf.append(MIBObject.formatLines(TAB, DefaultRepositoryManager.getErrorText(pex) + "."));
                    buf.append("\n\n");
                }
                fos.write(buf.toString().getBytes());
                fos.close();
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Error writing report: " + ex.getMessage(), "File Error", 0);
            }
        }
    }

    private static boolean _$15449(File f) {
        return f.isFile() && filter.accept(f);
    }

    public static void compileMIBs(MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, boolean updateExistant) {
        ParseDialog.compileMIBs(listener, frame, repMan, files, statusBar, openZIPFiles, updateExistant, false);
    }

    public static void compileMIBs(MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, boolean updateExistant, boolean compileLeniently) {
        ParseDialog.compileMIBs(listener, frame, repMan, files, statusBar, openZIPFiles, updateExistant, compileLeniently, false);
    }

    public static void compileMIBs(final MIBModuleListener listener, JFrame frame, RepositoryManager repMan, File[] files, StatusBar statusBar, boolean openZIPFiles, boolean updateExistant, boolean compileLeniently, boolean silent) {
        URL url = Thread.currentThread().getContextClassLoader().getResource("toolbarButtonGraphics/general/Stop16.gif");
        ImageIcon imageStop = new ImageIcon(url);
        ParseDialog pd = new ParseDialog(imageStop.getImage(), (MIBImporter)((Object)frame), frame, "Parser Log", false);
        boolean errorsDetected = false;
        int total = 0;
        int ok = 0;
        try {
            int k;
            ProgressMonitor pm = new ProgressMonitor(frame, "Sorting...", files[0].getPath(), 0, files.length);
            Vector<ModuleInfo> v = new Vector<ModuleInfo>(files.length + 1, 10);
            for (int j = 0; !pm.isCanceled() && j < files.length; ++j) {
                try {
                    ModuleInfo[] info;
                    ParseDialog parseDialog = pd;
                    parseDialog.getClass();
                    SwingUtilities.invokeLater(parseDialog.new ProgressUpdater(pm, j, files[j].getPath()));
                    if (openZIPFiles && ParseDialog._$15449(files[j])) {
                        ZipFile zipFile = new ZipFile(files[j]);
                        info = repMan.getModuleInfo(zipFile);
                    } else {
                        info = repMan.getModuleInfo(files[j]);
                    }
                    for (int k2 = 0; k2 < info.length; ++k2) {
                        v.add(info[k2]);
                    }
                    continue;
                }
                catch (Exception ex) {
                    ModuleInfo inf = new ModuleInfo("invalid ");
                    inf.path = files[j];
                    v.addElement(inf);
                }
            }
            if (pm.isCanceled()) {
                return;
            }
            ModuleInfo[] existant = repMan.getModuleInfos();
            if (!updateExistant) {
                ModuleInfo inf;
                for (int i = 0; i < existant.length; ++i) {
                    for (int j = 0; j < v.size(); ++j) {
                        inf = (ModuleInfo)v.elementAt(j);
                        if (!inf.getModuleName().equals(existant[i].getModuleName())) continue;
                        v.remove(j);
                        --j;
                    }
                }
                Hashtable<String, String> h = new Hashtable<String, String>(v.size() + 10);
                for (int j = 0; j < v.size(); ++j) {
                    inf = (ModuleInfo)v.elementAt(j);
                    if (h.get(inf.getModuleName()) != null) {
                        v.remove(j);
                        --j;
                        continue;
                    }
                    h.put(inf.getModuleName(), inf.getModuleName());
                }
            }
            Object[] list = new ModuleInfo[v.size()];
            v.copyInto(list);
            ModuleInfoSorter s = new ModuleInfoSorter((ModuleInfo[])list);
            s.setPool(existant);
            s.sort();
            ModuleInfo[] sorted = s.getSortedList();
            ModuleInfo[] failed = s.getFailedList();
            files = new File[sorted.length + failed.length];
            Object[][] zipFiles = new Object[sorted.length + failed.length][];
            for (k = 0; k < sorted.length; ++k) {
                files[k] = sorted[k].path;
                zipFiles[k] = sorted[k].userObject instanceof Object[] ? (Object[])sorted[k].userObject : null;
            }
            while (k < files.length) {
                int p = k - sorted.length;
                files[k] = failed[p].path;
                zipFiles[k] = failed[p].userObject instanceof Object[] ? (Object[])failed[p].userObject : null;
                ++k;
            }
            ParseDialog parseDialog = pd;
            parseDialog.getClass();
            SwingUtilities.invokeLater(parseDialog.new EventTrigger(pm));
            pm = new ProgressMonitor(frame, "Compiling...", files[0].getPath(), 0, files.length);
            Hashtable<Object, Object> parsed = new Hashtable<Object, Object>(files.length + 10);
            for (int j = 0; !pm.isCanceled() && j < files.length; ++j) {
                ZipEntry entry = null;
                if (zipFiles[j] != null) {
                    String name = files[j].getPath();
                    entry = (ZipEntry)zipFiles[j][1];
                    if (entry == null) {
                        ParseDialog parseDialog2 = pd;
                        parseDialog2.getClass();
                        pd.addRow(parseDialog2.new ZipReference(entry, (ZipFile)zipFiles[j][0]), new SMIParseException(name, 10), new Vector(1));
                        continue;
                    }
                }
                try {
                    int i;
                    Vector<String> m;
                    ModuleInfo[] info;
                    if (entry != null) {
                        if (parsed.get(entry) != null) continue;
                        parsed.put(entry, entry);
                        ++total;
                        info = compileLeniently ? repMan.addModulesLeniently(((ZipFile)zipFiles[j][0]).getInputStream(entry), files[j].getPath()) : repMan.addModules(((ZipFile)zipFiles[j][0]).getInputStream(entry), files[j].getPath());
                        ++ok;
                        m = new Vector();
                        for (i = 0; i < info.length; ++i) {
                            m.addElement(info[i].moduleName);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                listener.moduleEvent(new MIBModuleEvent(listener, m, 4));
                            }
                        });
                        ParseDialog parseDialog3 = pd;
                        parseDialog3.getClass();
                        pd.addRow(parseDialog3.new ZipReference(entry, (ZipFile)zipFiles[j][0]), null, m);
                    } else {
                        if (parsed.get(files[j]) != null) continue;
                        ++total;
                        parsed.put(files[j], files[j]);
                        info = compileLeniently ? repMan.addModulesLeniently(files[j]) : repMan.addModules(files[j]);
                        ++ok;
                        m = new Vector<String>();
                        for (i = 0; i < info.length; ++i) {
                            m.addElement(info[i].moduleName);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                listener.moduleEvent(new MIBModuleEvent(listener, m, 4));
                            }
                        });
                        pd.addRow(files[j], null, m);
                    }
                    ParseDialog parseDialog4 = pd;
                    parseDialog4.getClass();
                    SwingUtilities.invokeLater(parseDialog4.new ProgressUpdater(pm, j, files[j].getPath()));
                    continue;
                }
                catch (SMIParseException pex) {
                    if (zipFiles[j] != null) {
                        ParseDialog parseDialog5 = pd;
                        parseDialog5.getClass();
                        pd.addRow(parseDialog5.new ZipReference(entry, (ZipFile)zipFiles[j][0]), pex, null);
                        continue;
                    }
                    pd.addRow(files[j], pex, null);
                }
            }
            ParseDialog parseDialog6 = pd;
            parseDialog6.getClass();
            SwingUtilities.invokeLater(parseDialog6.new EventTrigger(pm));
            String message = "Compiled " + ok + " file(s) out of " + total + " successfully.";
            statusBar.setMessage(message);
            errorsDetected = ok < total;
        }
        catch (IOException iox) {
            String s = "Cannot open file: " + iox.getMessage();
            statusBar.setMessage(s);
        }
        if (!silent) {
            Object[] options;
            if (errorsDetected) {
                options = new String[]{"OK", "Details..."};
                if (JOptionPane.showOptionDialog(frame, new String[]{"Compilation failed for " + (total - ok) + " out of " + total + " MIB modules.", "Click on 'Details...' to view the parser log to correct errors."}, "Compilation Errors", 0, 0, null, options, options[1]) == 1) {
                    pd.create();
                    pd.setLocationRelativeTo(frame);
                    SwingUtilities.invokeLater(new ShowDialogLater(pd));
                }
            } else {
                options = new String[]{"OK", "Details..."};
                if (JOptionPane.showOptionDialog(frame, "Successfully compiled all " + total + " MIB modules.", "Compilation Success", 0, 1, null, options, options[0]) == 1) {
                    pd.create();
                    pd.setLocationRelativeTo(frame);
                    SwingUtilities.invokeLater(new ShowDialogLater(pd));
                }
            }
        }
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.jButtonClose_actionPerformed(null);
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public ModuleInfo[] checkMIB(Object caller, InputStream file, int mode) throws IOException, SMIParseException {
        ModuleInfo[] info = this.importer.checkMIB(caller, file, mode);
        return info;
    }

    public ModuleInfo[] importMIB(Object caller, InputStream is, String path, int mode) throws IOException, SMIParseException {
        ModuleInfo[] info = this.importer.importMIB(caller, is, path, mode);
        return info;
    }

    public MIBModule[] parseMIBs(Object caller, InputStream is, String path, int mode) throws IOException, SMIParseException {
        throw new UnsupportedOperationException();
    }

    class ZipReference {
        public ZipFile file;
        public ZipEntry entry;

        public ZipReference(ZipEntry entry, ZipFile file) {
            this.file = file;
            this.entry = entry;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    class EventTrigger
    implements Runnable {
        private ProgressMonitor _$11962;

        public EventTrigger(ProgressMonitor pm) {
            this._$11962 = pm;
        }

        public void run() {
            this._$11962.close();
        }
    }

    class ProgressUpdater
    implements Runnable {
        private int _$8954;
        private String _$11998;
        private ProgressMonitor _$11962;

        public ProgressUpdater(ProgressMonitor pm, int p, String note) {
            this._$11962 = pm;
            this._$11998 = note;
            this._$8954 = p;
        }

        public void run() {
            this._$11962.setNote(this._$11998);
            this._$11962.setProgress(this._$8954);
        }
    }
}

