/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.common;

import com.agentpp.common.ExportPanel;
import com.agentpp.common.StatusBar;
import com.agentpp.common.smi.editor.SmiContext;
import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.mib.pdf.MIBModule2PDF;
import com.agentpp.mib.pdf.PDFPageSetupPanel;
import com.agentpp.mib.xml.MIBModule2XML;
import com.agentpp.mib.xsd.MIBModule2XSD;
import com.agentpp.repository.RepositoryManager;
import com.agentpp.util.UserConfigFile;
import com.agentpp.util.gui.ShowHtmlDialog;
import com.lowagie.text.DocumentException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;

public class ExportThread
extends Thread {
    private JFrame _$9823;
    private MIBRepository _$12421;
    private ExportPanel _$28182;
    private StatusBar _$15439;
    private String _$18005;
    private String _$27800;
    private RepositoryManager _$15438;
    private boolean _$28183 = false;
    private UserConfigFile _$6654;
    private String _$28184 = "http://www.mibexplorer.com/xsd/mibs/";

    public ExportThread(JFrame f, StatusBar statusBar, UserConfigFile config, MIBRepository rep, ExportPanel exportPanel, String header, String dtdURL) {
        this._$9823 = f;
        this._$12421 = rep;
        this._$28182 = exportPanel;
        this._$15439 = statusBar;
        this._$18005 = header;
        this._$27800 = dtdURL;
        this._$6654 = config;
        this._$15438 = null;
    }

    public ExportThread(JFrame f, StatusBar statusBar, UserConfigFile config, RepositoryManager repMan, ExportPanel exportPanel, String header, String dtdURL) {
        this._$9823 = f;
        this._$15438 = repMan;
        this._$6654 = config;
        this._$28182 = exportPanel;
        this._$15439 = statusBar;
        this._$18005 = header;
        this._$27800 = dtdURL;
    }

    public void run() {
        try {
            if (this._$28182.isPDF()) {
                PDFPageSetupPanel p = new PDFPageSetupPanel();
                p.load(this._$6654);
                Object[] options = new String[]{"OK", "Cancel"};
                if (JOptionPane.showOptionDialog(this._$28182.getDialog(), p, "PDF Settings", 2, -1, null, options, options[0]) == 0) {
                    p.save(this._$6654);
                } else {
                    this._$15439.setMessage("Export canceled by user");
                    return;
                }
            }
            Vector modules = this._$28182.getModules();
            ProgressMonitor pm = new ProgressMonitor(this._$9823, "Exporting...", "", 0, modules.size());
            boolean html = this._$28182.isHTML();
            boolean xml = this._$28182.isXML();
            boolean pdf = this._$28182.isPDF();
            boolean xsd = this._$28182.isXSD();
            boolean appendOrigFileName = this._$28182.isAppendOrigFilename();
            String origFileNameSeparator = this._$28182.getOrigFileNameSeparator();
            int tabSize = this._$28182.getTabSize();
            this.exportMIBs(this._$28182.getExportPath(), modules, pm, html, xml, pdf, xsd, tabSize, this._$28182.isUseSpaces(), appendOrigFileName, origFileNameSeparator);
            if (pm.isCanceled()) {
                return;
            }
            SwingUtilities.invokeLater(new EventTrigger(pm));
            this._$15439.setMessage("" + modules.size() + " MIB module" + (modules.size() == 1 ? "" : "s") + " exported to '" + this._$28182.getExportPath() + "'");
        }
        catch (Exception ix) {
            this._$15439.setMessage("Export failed: " + ix.getMessage());
            ix.printStackTrace();
        }
    }

    public String exportMIBs(String path, Vector modules, ProgressMonitor pm, boolean html, boolean xml, boolean pdf, boolean xsd, int tabSize, boolean useSpaces, boolean appendOrigFileName, String origFileNameSeparator) throws FileNotFoundException, IOException, DocumentException {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; !(i >= modules.size() || pm != null && pm.isCanceled()); ++i) {
            FileOutputStream fos;
            File file;
            MIBModule module;
            if (pm != null) {
                if (pm.isCanceled()) {
                    SwingUtilities.invokeLater(new EventTrigger(pm));
                    return null;
                }
                pm.setProgress(i);
            }
            if (this._$15438 == null) {
                module = this._$12421.getModule(modules.get(i).toString());
            } else {
                String m = modules.get(i).toString();
                try {
                    this._$12421 = null;
                    MIBObject[] objs = this._$15438.getObjects(m);
                    MIBObject[] imp = this._$15438.getImportedObjects(m);
                    this._$12421 = new MIBRepository(objs);
                    for (int j = 0; j < imp.length; ++j) {
                        this._$12421.addObject(imp[j]);
                    }
                    this._$12421.structureChanged();
                    module = this._$12421.getModule(m);
                }
                catch (Exception ex) {
                    continue;
                }
            }
            if (module == null) continue;
            if (this._$28183) {
                module.convertToSMIv1(this._$12421);
            }
            if (pm != null) {
                pm.setNote(module.getModuleName());
            }
            if (xml) {
                file = this._$2238(path, module, ".xml", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                MIBModule2XML mxml = new MIBModule2XML(this._$12421);
                mxml.output(fos, mxml.createXML(module, this._$18005, this._$27800), this._$28182.getTabSize());
                fos.close();
            } else if (pdf) {
                PDFPageSetupPanel p = new PDFPageSetupPanel();
                p.load(this._$6654);
                file = this._$2238(path, module, ".pdf", appendOrigFileName, origFileNameSeparator);
                FileOutputStream fos2 = new FileOutputStream(file);
                MIBModule2PDF mpdf = new MIBModule2PDF(this._$12421, SmiContext.getDefaultStyles(), tabSize);
                mpdf.setMode(this._$18642(mpdf.getMode()));
                mpdf.setFontSize(p.getFontSize());
                mpdf.setKeepTogether(p.isKeepTogether());
                mpdf.setOutlineAsTree(p.isOutlineAsTree());
                mpdf.setDisplayPageNumbers(p.isDisplayPageNumbers());
                mpdf.setDisplayCurrentDate(p.isDisplayCurrentDate());
                mpdf.writePDF(module, fos2, this._$18005, p.getPageSizeRectangle());
                fos2.close();
            } else if (html) {
                file = this._$2238(path, module, ".html", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                int mode = 6;
                mode = this._$18642(mode);
                String s = "<body  link=\"#808080\"><pre>" + ShowHtmlDialog.replaceTabs(module.toSMI(mode, this._$12421, MIBObject.getLineSeparator()), tabSize) + "</pre></body>";
                fos.write(s.getBytes());
                fos.close();
            } else if (xsd) {
                file = this._$2238(path, module, ".xsd", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                MIBModule2XSD mxsd = new MIBModule2XSD(this._$12421);
                mxsd.setURLPrefix(this._$28184);
                mxsd.output(fos, mxsd.createXML(module, this._$18005, this._$27800), this._$28182.getTabSize());
                fos.close();
            } else {
                file = this._$2238(path, module, ".txt", appendOrigFileName, origFileNameSeparator);
                fos = new FileOutputStream(file);
                int mode = 1;
                mode = this._$18642(mode);
                if (useSpaces) {
                    String s = module.toSMI(mode, this._$12421, MIBObject.getLineSeparator());
                    s = ShowHtmlDialog.replaceTabs(s, tabSize);
                    fos.write(s.getBytes());
                } else {
                    fos.write(module.toSMI(mode, this._$12421, MIBObject.getLineSeparator()).getBytes());
                }
                fos.close();
            }
            buf.append(file.getPath());
            buf.append(" ");
        }
        return buf.toString();
    }

    private File _$2238(String path, MIBModule module, String suffix, boolean appendOrigFilename, String separator) throws IOException {
        String name = module.getModuleName();
        if (appendOrigFilename && module.getFileName() != null && module.getFileName().trim().length() > 0) {
            int dotpos;
            String fileName = new File(module.getFileName()).getName();
            if (fileName.startsWith(name)) {
                fileName = fileName.substring(name.length());
                if (separator.length() > 0 && fileName.startsWith(separator)) {
                    fileName = fileName.substring(separator.length());
                }
            }
            if ((dotpos = fileName.lastIndexOf(46)) >= 0) {
                fileName = fileName.substring(0, dotpos);
            }
            if (fileName.trim().length() > 0) {
                name = name + separator + fileName;
            }
        }
        if (path == null) {
            return File.createTempFile(name, suffix);
        }
        return new File(path, name + suffix);
    }

    private int _$18642(int mode) {
        mode |= this._$6654.getBoolean("OrderByType", true) ? 256 : 0;
        mode |= this._$6654.getBoolean("PreserveOrder", true) ? 128 : 0;
        mode |= this._$6654.getBoolean("GenerateComments", true) ? 32 : 0;
        return mode |= this._$6654.getBoolean("GenerateCommentsInline", false) ? 1024 : 0;
    }

    public void setConvertV2ToV1(boolean convertV2ToV1) {
        this._$28183 = convertV2ToV1;
    }

    public boolean isConvertV2ToV1() {
        return this._$28183;
    }

    public void setURLPrefixXSD(String urlPrefix) {
        this._$28184 = urlPrefix;
    }

    class EventTrigger
    implements Runnable {
        private ProgressMonitor _$11962;

        public EventTrigger(ProgressMonitor pm) {
            this._$11962 = pm;
        }

        public void run() {
            this._$11962.close();
        }
    }
}

