/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.BidirectionalIterator;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.algorithms.Predicates;

public final class Heap {
    private Heap() {
    }

    public static void pushHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        Heap.pushHeap(bidirectionalIterator, bidirectionalIterator2, new Predicates.HashComparator());
    }

    public static void pushHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, BinaryPredicate binaryPredicate) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        Heap.pushHeap(bidirectionalIterator, bidirectionalIterator.distance(bidirectionalIterator2) - 1, 0, bidirectionalIterator2.get(-1), binaryPredicate);
    }

    static void pushHeap(BidirectionalIterator bidirectionalIterator, int n2, int n3, Object object, BinaryPredicate binaryPredicate) {
        int n4 = (n2 - 1) / 2;
        BidirectionalIterator bidirectionalIterator2 = (BidirectionalIterator)bidirectionalIterator.clone();
        while (n2 > n3 && binaryPredicate.execute(bidirectionalIterator2.get(n4), object)) {
            bidirectionalIterator2.put(n2, bidirectionalIterator2.get(n4));
            n2 = n4;
            n4 = (n2 - 1) / 2;
        }
        bidirectionalIterator2.put(n2, object);
    }

    public static void popHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        Heap.popHeap(bidirectionalIterator, bidirectionalIterator2, new Predicates.HashComparator());
    }

    public static void popHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, BinaryPredicate binaryPredicate) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        Object object = bidirectionalIterator2.get(-1);
        bidirectionalIterator2.put(-1, bidirectionalIterator.get());
        Heap.adjustHeap(bidirectionalIterator, 0, bidirectionalIterator.distance(bidirectionalIterator2) - 1, object, binaryPredicate);
    }

    public static void makeHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        Heap.makeHeap(bidirectionalIterator, bidirectionalIterator2, new Predicates.HashComparator());
    }

    public static void makeHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, BinaryPredicate binaryPredicate) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        int n2 = bidirectionalIterator.distance(bidirectionalIterator2);
        if (n2 < 2) {
            return;
        }
        int n3 = (n2 - 2) / 2;
        while (true) {
            Heap.adjustHeap(bidirectionalIterator, n3, n2, bidirectionalIterator.get(n3), binaryPredicate);
            if (n3 == 0) {
                return;
            }
            --n3;
        }
    }

    public static void sortHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        Heap.sortHeap(bidirectionalIterator, bidirectionalIterator2, new Predicates.HashComparator());
    }

    public static void sortHeap(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, BinaryPredicate binaryPredicate) {
        if (!bidirectionalIterator.isCompatibleWith(bidirectionalIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator2.clone();
        while (bidirectionalIterator.distance(bidirectionalIterator3) > 1) {
            Heap.popHeap(bidirectionalIterator, bidirectionalIterator3, binaryPredicate);
            bidirectionalIterator3.retreat();
        }
    }

    static void adjustHeap(BidirectionalIterator bidirectionalIterator, int n2, int n3, Object object, BinaryPredicate binaryPredicate) {
        int n4 = n2;
        int n5 = 2 * (n2 + 1);
        while (n5 < n3) {
            if (binaryPredicate.execute(bidirectionalIterator.get(n5), bidirectionalIterator.get(n5 - 1))) {
                --n5;
            }
            bidirectionalIterator.put(n2, bidirectionalIterator.get(n5));
            n2 = n5;
            n5 = 2 * (n5 + 1);
        }
        if (n5 == n3) {
            bidirectionalIterator.put(n2, bidirectionalIterator.get(n5 - 1));
            n2 = n5 - 1;
        }
        Heap.pushHeap(bidirectionalIterator, n2, n4, object, binaryPredicate);
    }
}

