/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.algorithms;

import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;

public final class Hashing {
    static final int HASH_SIZE = 16;

    private Hashing() {
    }

    public static int orderedHash(Container container) {
        return Hashing.orderedHash(container.start(), container.finish());
    }

    public static int orderedHash(ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        if (!forwardIterator.isCompatibleWith(forwardIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        int n2 = 0;
        int n3 = forwardIterator.distance(forwardIterator2);
        int n4 = 0;
        int n5 = 1;
        if (n3 >= 16) {
            n5 = n3 / 16;
            forwardIterator.advance(n3 % 16);
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        while (!forwardIterator3.equals(forwardIterator2)) {
            Object object = forwardIterator3.get();
            if (object != null) {
                n2 ^= object.hashCode() / (n4 % 16 + 1);
            }
            ++n4;
            forwardIterator3.advance(n5);
        }
        return n2;
    }

    public static int unorderedHash(Container container) {
        return Hashing.unorderedHash(container.start(), container.finish());
    }

    public static int unorderedHash(ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        if (!forwardIterator.isCompatibleWith(forwardIterator2)) {
            throw new IllegalArgumentException("iterators not compatible");
        }
        int n2 = 0;
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        while (!forwardIterator3.equals(forwardIterator2)) {
            Object object = forwardIterator3.get();
            if (object != null) {
                n2 ^= object.hashCode();
            }
            forwardIterator3.advance();
        }
        return n2;
    }
}

