/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl.adapters;

import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.adapters.Algorithms;
import com.objectspace.jgl.adapters.ArrayAdapter;
import com.objectspace.jgl.adapters.FloatBuffer;
import com.objectspace.jgl.adapters.FloatIterator;
import java.util.Enumeration;

public class FloatArray
extends ArrayAdapter {
    float[] array;
    static final long serialVersionUID = 2024495121036254354L;

    public FloatArray() {
        this(new float[0]);
    }

    public FloatArray(FloatArray floatArray) {
        this(floatArray.array);
    }

    public FloatArray(FloatBuffer floatBuffer) {
        this(floatBuffer.get());
    }

    public FloatArray(float[] fArray) {
        this.array = fArray;
    }

    public synchronized Object clone() {
        return new FloatArray(this);
    }

    public synchronized String toString() {
        return Algorithms.Printing.toString(this, "float[]");
    }

    public boolean equals(Object object) {
        return object instanceof FloatArray && this.equals((FloatArray)object) || object instanceof FloatBuffer && this.equals((FloatBuffer)object);
    }

    public boolean equals(FloatArray floatArray) {
        return this.equals(floatArray.array);
    }

    public boolean equals(FloatBuffer floatBuffer) {
        return this.equals(floatBuffer.storage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean equals(float[] fArray) {
        float[] fArray2 = fArray;
        synchronized (fArray2) {
            if (this.array.length != fArray.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < fArray.length) {
                if (this.array[n2] != fArray[n2]) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public float[] get() {
        return this.array;
    }

    public int size() {
        return this.array.length;
    }

    public int maxSize() {
        return this.array.length;
    }

    public Enumeration elements() {
        return this.begin();
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public synchronized FloatIterator begin() {
        return new FloatIterator(this, 0);
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized FloatIterator end() {
        return new FloatIterator(this, this.array.length);
    }

    public Object at(int n2) {
        return new Float(this.floatAt(n2));
    }

    public synchronized float floatAt(int n2) {
        return this.array[n2];
    }

    public void put(int n2, Object object) {
        this.put(n2, ((Number)object).floatValue());
    }

    public synchronized void put(int n2, float f2) {
        this.array[n2] = f2;
    }
}

