/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.HashSetIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Opaque;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Range;
import com.objectspace.jgl.Set;
import com.objectspace.jgl.xEqualTo;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;

public class HashSet
implements Set {
    static final int DEFAULT_SIZE = 257;
    static final float DEFAULT_RATIO = 0.75f;
    BinaryPredicate comparator;
    boolean allowDups = false;
    boolean expandActive = true;
    transient int size;
    transient HashSetNode[] buckets;
    int length;
    int limit;
    float ratio;
    static final long serialVersionUID = 647750600220545407L;

    public HashSet() {
        this(new xEqualTo(), false, 257, 0.75f);
    }

    public HashSet(boolean bl) {
        this(new xEqualTo(), bl, 257, 0.75f);
    }

    public HashSet(BinaryPredicate binaryPredicate) {
        this(binaryPredicate, false, 257, 0.75f);
    }

    public HashSet(BinaryPredicate binaryPredicate, boolean bl) {
        this(binaryPredicate, bl, 257, 0.75f);
    }

    public HashSet(BinaryPredicate binaryPredicate, int n2, float f2) {
        this(binaryPredicate, false, n2, f2);
    }

    public HashSet(BinaryPredicate binaryPredicate, boolean bl, int n2, float f2) {
        this.comparator = binaryPredicate;
        this.allowDups = bl;
        this.ratio = f2;
        this.length = n2;
        this.limit = (int)((float)this.length * this.ratio);
        this.buckets = new HashSetNode[this.length];
    }

    public HashSet(HashSet hashSet) {
        this.copy(hashSet);
    }

    public boolean allowsDuplicates() {
        return this.allowDups;
    }

    public BinaryPredicate getComparator() {
        return this.comparator;
    }

    public float getLoadRatio() {
        return this.ratio;
    }

    public synchronized Object clone() {
        return new HashSet(this);
    }

    public synchronized void copy(HashSet hashSet) {
        HashSet hashSet2 = hashSet;
        synchronized (hashSet2) {
            this.comparator = hashSet.comparator;
            this.length = hashSet.length;
            this.ratio = hashSet.ratio;
            this.limit = hashSet.limit;
            this.size = hashSet.size;
            this.buckets = new HashSetNode[this.length];
            this.allowDups = hashSet.allowDups;
            int n2 = 0;
            while (n2 < this.length) {
                HashSetNode hashSetNode = null;
                HashSetNode hashSetNode2 = hashSet.buckets[n2];
                while (hashSetNode2 != null) {
                    HashSetNode hashSetNode3 = new HashSetNode();
                    hashSetNode3.object = hashSetNode2.object;
                    hashSetNode3.hash = hashSetNode2.hash;
                    if (this.buckets[n2] == null) {
                        this.buckets[n2] = hashSetNode3;
                    } else {
                        hashSetNode.next = hashSetNode3;
                    }
                    hashSetNode = hashSetNode3;
                    hashSetNode2 = hashSetNode2.next;
                }
                ++n2;
            }
            return;
        }
    }

    public synchronized String toString() {
        return Algos.Printing.toString(this, "HashSet");
    }

    public synchronized Enumeration elements() {
        return new HashSetIterator(this.first(), this);
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized HashSetIterator begin() {
        return new HashSetIterator(this.first(), this);
    }

    public synchronized HashSetIterator end() {
        return new HashSetIterator(null, this);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public boolean equals(Object object) {
        return object instanceof HashSet && this.equals((HashSet)object);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean equals(HashSet hashSet) {
        HashSet hashSet2 = hashSet;
        synchronized (hashSet2) {
            if (this.size != hashSet.size) {
                return false;
            }
            if (this.allowDups) {
                Object object = null;
                HashSetIterator hashSetIterator = this.begin();
                while (hashSetIterator.myNode != null) {
                    Object object2 = hashSetIterator.myNode.object;
                    if (object == null || !object2.equals(object)) {
                        if (this.count(object2) != hashSet.count(object2)) {
                            return false;
                        }
                        object = object2;
                    }
                    hashSetIterator.advance();
                }
            } else {
                HashSetIterator hashSetIterator = this.begin();
                while (hashSetIterator.myNode != null) {
                    if (hashSet.count(hashSetIterator.myNode.object) == 0) {
                        return false;
                    }
                    hashSetIterator.advance();
                }
            }
            return true;
        }
    }

    public synchronized int hashCode() {
        return Algos.Hashing.unorderedHash(this.begin());
    }

    public synchronized void swap(HashSet hashSet) {
        HashSet hashSet2 = hashSet;
        synchronized (hashSet2) {
            int n2 = this.size;
            this.size = hashSet.size;
            hashSet.size = n2;
            HashSetNode[] hashSetNodeArray = this.buckets;
            this.buckets = hashSet.buckets;
            hashSet.buckets = hashSetNodeArray;
            int n3 = this.length;
            this.length = hashSet.length;
            hashSet.length = n3;
            int n4 = this.limit;
            this.limit = hashSet.limit;
            hashSet.limit = n4;
            float f2 = this.ratio;
            this.ratio = hashSet.ratio;
            hashSet.ratio = f2;
            boolean bl = this.allowDups;
            this.allowDups = hashSet.allowDups;
            hashSet.allowDups = bl;
            return;
        }
    }

    public synchronized void clear() {
        this.buckets = new HashSetNode[this.length];
        this.size = 0;
    }

    public int remove(Object object) {
        Pair pair = this.removeAux(object, this.size);
        return ((Number)pair.second).intValue();
    }

    public int remove(Object object, int n2) {
        Pair pair = this.removeAux(object, n2);
        return ((Number)pair.second).intValue();
    }

    synchronized Pair removeAux(Object object, int n2) {
        if (n2 > 0) {
            int n3 = object.hashCode() & Integer.MAX_VALUE;
            int n4 = n3 % this.length;
            HashSetNode hashSetNode = this.buckets[n4];
            HashSetNode hashSetNode2 = null;
            while (hashSetNode != null) {
                if (hashSetNode.hash == n3 && this.comparator.execute(hashSetNode.object, object)) {
                    int n5 = 1;
                    --n2;
                    HashSetNode hashSetNode3 = hashSetNode.next;
                    Object object2 = hashSetNode.object;
                    if (this.allowDups) {
                        while (n2 > 0 && hashSetNode3 != null && hashSetNode3.hash == n3 && this.comparator.execute(hashSetNode3.object, object)) {
                            ++n5;
                            --n2;
                            hashSetNode3 = hashSetNode3.next;
                        }
                    }
                    if (hashSetNode2 == null) {
                        this.buckets[n4] = hashSetNode3;
                    } else {
                        hashSetNode2.next = hashSetNode3;
                    }
                    this.size -= n5;
                    return new Pair(object2, new Integer(n5));
                }
                hashSetNode2 = hashSetNode;
                hashSetNode = hashSetNode.next;
            }
        }
        return new Pair(null, new Integer(0));
    }

    /*
     * Unable to fully structure code
     */
    public synchronized Object remove(Enumeration var1_1) {
        block4: {
            if (!(var1_1 instanceof HashSetIterator)) {
                throw new IllegalArgumentException("Enumeration not a HashSetIterator");
            }
            if (((HashSetIterator)var1_1).myHashSet != this) {
                throw new IllegalArgumentException("Enumeration not for this HashSet");
            }
            var2_2 = (HashSetIterator)var1_1;
            var3_3 = var2_2.myNode;
            var4_4 = var3_3.hash % this.length;
            var5_5 = this.buckets[var4_4];
            if (var3_3 != var5_5) ** GOTO lbl13
            this.buckets[var4_4] = var3_3.next;
            break block4;
lbl-1000:
            // 1 sources

            {
                var5_5 = var5_5.next;
lbl13:
                // 2 sources

                ** while (var5_5.next != var3_3)
            }
lbl14:
            // 1 sources

            var5_5.next = var3_3.next;
        }
        --this.size;
        if (var3_3 == null) {
            return null;
        }
        return var3_3.object;
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2) {
        HashSetIterator hashSetIterator;
        if (!(enumeration instanceof HashSetIterator) || !(enumeration2 instanceof HashSetIterator)) {
            throw new IllegalArgumentException("Enumeration not a HashSetIterator");
        }
        if (((HashSetIterator)enumeration).myHashSet != this || ((HashSetIterator)enumeration2).myHashSet != this) {
            throw new IllegalArgumentException("Enumeration not for this HashSet");
        }
        HashSetIterator hashSetIterator2 = (HashSetIterator)enumeration;
        HashSetIterator hashSetIterator3 = (HashSetIterator)enumeration2;
        int n2 = 0;
        while (!((hashSetIterator = hashSetIterator3) instanceof Opaque) || hashSetIterator2.myNode != ((Opaque)hashSetIterator).opaqueData() && !false) {
            hashSetIterator = new HashSetIterator(hashSetIterator2);
            hashSetIterator.advance();
            this.remove(hashSetIterator2);
            hashSetIterator2 = hashSetIterator;
            ++n2;
        }
        return n2;
    }

    public synchronized HashSetIterator find(Object object) {
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        HashSetNode hashSetNode = this.buckets[n2 % this.length];
        while (hashSetNode != null) {
            if (n2 == hashSetNode.hash && this.comparator.execute(hashSetNode.object, object)) {
                return new HashSetIterator(hashSetNode, this);
            }
            hashSetNode = hashSetNode.next;
        }
        return new HashSetIterator(null, this);
    }

    public synchronized int count(Object object) {
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        HashSetNode hashSetNode = this.buckets[n2 % this.length];
        while (hashSetNode != null) {
            if (n2 == hashSetNode.hash && this.comparator.execute(hashSetNode.object, object)) {
                if (this.allowDups) {
                    int n3 = 1;
                    hashSetNode = hashSetNode.next;
                    while (hashSetNode != null && n2 == hashSetNode.hash && this.comparator.execute(hashSetNode.object, object)) {
                        ++n3;
                        hashSetNode = hashSetNode.next;
                    }
                    return n3;
                }
                return 1;
            }
            hashSetNode = hashSetNode.next;
        }
        return 0;
    }

    public synchronized Object add(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.length;
        HashSetNode hashSetNode = this.buckets[n3];
        while (hashSetNode != null) {
            if (n2 == hashSetNode.hash && this.comparator.execute(hashSetNode.object, object)) {
                if (this.allowDups) {
                    HashSetNode hashSetNode2 = new HashSetNode();
                    hashSetNode2.object = object;
                    hashSetNode2.hash = n2;
                    hashSetNode2.next = hashSetNode.next;
                    hashSetNode.next = hashSetNode2;
                    if (++this.size > this.limit) {
                        this.expand();
                    }
                    return null;
                }
                return hashSetNode.object;
            }
            hashSetNode = hashSetNode.next;
        }
        HashSetNode hashSetNode3 = new HashSetNode();
        hashSetNode3.object = object;
        hashSetNode3.hash = n2;
        hashSetNode3.next = this.buckets[n3];
        this.buckets[n3] = hashSetNode3;
        if (++this.size > this.limit) {
            this.expand();
        }
        return null;
    }

    public synchronized Object get(Object object) {
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        HashSetNode hashSetNode = this.buckets[n2 % this.length];
        while (hashSetNode != null) {
            if (n2 == hashSetNode.hash && this.comparator.execute(hashSetNode.object, object)) {
                return hashSetNode.object;
            }
            hashSetNode = hashSetNode.next;
        }
        return null;
    }

    public synchronized Object put(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        int n3 = n2 % this.length;
        HashSetNode hashSetNode = this.buckets[n3];
        while (hashSetNode != null) {
            if (n2 == hashSetNode.hash && this.comparator.execute(hashSetNode.object, object)) {
                Object object2 = hashSetNode.object;
                hashSetNode.object = object;
                return object2;
            }
            hashSetNode = hashSetNode.next;
        }
        HashSetNode hashSetNode2 = new HashSetNode();
        hashSetNode2.object = object;
        hashSetNode2.hash = n2;
        hashSetNode2.next = this.buckets[n3];
        this.buckets[n3] = hashSetNode2;
        if (++this.size > this.limit) {
            this.expand();
        }
        return null;
    }

    public synchronized HashSet union(HashSet hashSet) {
        HashSet hashSet2 = hashSet;
        synchronized (hashSet2) {
            if (this.allowDups || hashSet.allowDups) {
                throw new InvalidOperationException("union operation invalid on multisets");
            }
            HashSet hashSet3 = new HashSet(this);
            HashSetIterator hashSetIterator = hashSet.begin();
            while (hashSetIterator.myNode != null) {
                hashSet3.add(hashSetIterator.nextElement());
            }
            HashSet hashSet4 = hashSet3;
            Object var4_6 = null;
            return hashSet4;
        }
    }

    public synchronized HashSet intersection(HashSet hashSet) {
        HashSet hashSet2 = hashSet;
        synchronized (hashSet2) {
            HashSetIterator hashSetIterator;
            if (this.allowDups || hashSet.allowDups) {
                throw new InvalidOperationException("intersection operation invalid on multisets");
            }
            HashSet hashSet3 = new HashSet(this.comparator, this.size + hashSet.size, this.ratio);
            if (this.size >= hashSet.size) {
                hashSetIterator = this.begin();
            } else {
                hashSetIterator = hashSet.begin();
                hashSet = this;
            }
            while (hashSetIterator.myNode != null) {
                Object object = hashSetIterator.nextElement();
                if (hashSet.count(object) <= 0) continue;
                hashSet3.add(object);
            }
            HashSet hashSet4 = hashSet3;
            Object var4_7 = null;
            return hashSet4;
        }
    }

    public synchronized HashSet difference(HashSet hashSet) {
        HashSet hashSet2 = hashSet;
        synchronized (hashSet2) {
            if (this.allowDups || hashSet.allowDups) {
                throw new InvalidOperationException("difference operation invalid on multisets");
            }
            HashSet hashSet3 = new HashSet(this.comparator, this.size + hashSet.size, this.ratio);
            HashSetIterator hashSetIterator = this.begin();
            while (hashSetIterator.myNode != null) {
                Object object = hashSetIterator.nextElement();
                if (hashSet.count(object) != 0) continue;
                hashSet3.add(object);
            }
            HashSet hashSet4 = hashSet3;
            Object var4_7 = null;
            return hashSet4;
        }
    }

    public synchronized HashSet symmetricDifference(HashSet hashSet) {
        HashSet hashSet2 = hashSet;
        synchronized (hashSet2) {
            Object object;
            if (this.allowDups || hashSet.allowDups) {
                throw new InvalidOperationException("symmetricDifference operation invalid on multisets");
            }
            HashSet hashSet3 = new HashSet(this.comparator, this.size + hashSet.size, this.ratio);
            HashSetIterator hashSetIterator = this.begin();
            while (hashSetIterator.myNode != null) {
                object = hashSetIterator.nextElement();
                if (hashSet.count(object) != 0) continue;
                hashSet3.add(object);
            }
            hashSetIterator = hashSet.begin();
            while (hashSetIterator.myNode != null) {
                object = hashSetIterator.nextElement();
                if (this.count(object) != 0) continue;
                hashSet3.add(object);
            }
            HashSet hashSet4 = hashSet3;
            Object var4_7 = null;
            return hashSet4;
        }
    }

    public synchronized boolean subsetOf(HashSet hashSet) {
        HashSet hashSet2 = hashSet;
        synchronized (hashSet2) {
            if (this.allowDups || hashSet.allowDups) {
                throw new InvalidOperationException("subsetOf operation invalid on multisets");
            }
            HashSetIterator hashSetIterator = this.begin();
            while (hashSetIterator.myNode != null) {
                if (hashSet.count(hashSetIterator.nextElement()) != 0) continue;
                boolean bl = false;
                Object var4_6 = null;
                return bl;
            }
            boolean bl = true;
            Object var4_7 = null;
            return bl;
        }
    }

    public synchronized boolean properSubsetOf(HashSet hashSet) {
        HashSet hashSet2 = hashSet;
        synchronized (hashSet2) {
            if (this.allowDups || hashSet.allowDups) {
                throw new InvalidOperationException("properSubsetOf operation invalid on multisets");
            }
            boolean bl = this.size < hashSet.size && this.subsetOf(hashSet);
            Object var4_4 = null;
            return bl;
        }
    }

    public synchronized HashSetIterator lowerBound(Object object) {
        return (HashSetIterator)this.equalRange((Object)object).begin;
    }

    public synchronized HashSetIterator upperBound(Object object) {
        return (HashSetIterator)this.equalRange((Object)object).end;
    }

    public synchronized Range equalRange(Object object) {
        int n2 = object.hashCode() & Integer.MAX_VALUE;
        HashSetNode hashSetNode = this.buckets[n2 % this.length];
        while (hashSetNode != null) {
            if (n2 == hashSetNode.hash && this.comparator.execute(hashSetNode.object, object)) {
                HashSetNode hashSetNode2 = hashSetNode;
                hashSetNode = hashSetNode.next;
                while (hashSetNode != null && n2 == hashSetNode.hash && this.comparator.execute(hashSetNode.object, object)) {
                    HashSetNode hashSetNode3 = hashSetNode = hashSetNode.next == null ? this.next(hashSetNode) : hashSetNode.next;
                }
                return new Range(new HashSetIterator(hashSetNode2, this), new HashSetIterator(hashSetNode, this));
            }
            hashSetNode = hashSetNode.next;
        }
        return new Range(this.end(), this.end());
    }

    private HashSetNode first() {
        if (this.size > 0) {
            int n2 = 0;
            while (n2 < this.length) {
                if (this.buckets[n2] != null) {
                    return this.buckets[n2];
                }
                ++n2;
            }
        }
        return null;
    }

    private HashSetNode next(HashSetNode hashSetNode) {
        int n2 = hashSetNode.hash % this.length + 1;
        while (n2 < this.length) {
            if (this.buckets[n2] != null) {
                return this.buckets[n2];
            }
            ++n2;
        }
        return null;
    }

    public boolean expansionAllowed() {
        return this.expandActive;
    }

    public synchronized void allowExpansion(boolean bl) {
        this.expandActive = bl;
    }

    protected int nextBucketSize(int n2) {
        return n2 * 2 + 1;
    }

    private void expand() {
        if (!this.expansionAllowed()) {
            return;
        }
        int n2 = this.nextBucketSize(this.length);
        HashSetNode[] hashSetNodeArray = new HashSetNode[n2];
        int n3 = 0;
        while (n3 < this.length) {
            HashSetNode hashSetNode = this.buckets[n3];
            while (hashSetNode != null) {
                HashSetNode hashSetNode2 = hashSetNode;
                hashSetNode = hashSetNode.next;
                int n4 = hashSetNode2.hash % n2;
                hashSetNode2.next = hashSetNodeArray[n4];
                hashSetNodeArray[n4] = hashSetNode2;
            }
            ++n3;
        }
        this.buckets = hashSetNodeArray;
        this.length = n2;
        this.limit = (int)((float)this.length * this.ratio);
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        HashSetIterator hashSetIterator = this.begin();
        while (hashSetIterator.hasMoreElements()) {
            objectOutputStream.writeObject(hashSetIterator.nextElement());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.buckets = new HashSetNode[this.length];
        int n2 = objectInputStream.readInt();
        while (n2-- > 0) {
            this.add(objectInputStream.readObject());
        }
    }

    static final class HashSetNode {
        Object object;
        int hash;
        HashSetNode next;

        HashSetNode() {
        }
    }
}

