/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.BidirectionalIterator;
import com.objectspace.jgl.DequeIterator;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import java.util.Enumeration;

public class Deque
implements Sequence {
    DequeIterator myStart = new DequeIterator(this, 0, 0);
    DequeIterator myFinish = new DequeIterator(this, 0, 0);
    int myLength;
    Object[][] myMap;
    static final int pageSize = 1024;
    static final int BLOCK_SIZE = 128;
    static final long serialVersionUID = 8175162724553274000L;

    public Deque() {
    }

    public Deque(int n2) {
        this.insert(this.myStart, n2, null);
    }

    public Deque(int n2, Object object) {
        this.insert(this.myStart, n2, object);
    }

    public Deque(Deque deque) {
        Deque deque2 = deque;
        synchronized (deque2) {
            DequeIterator dequeIterator = deque.begin();
            while (!dequeIterator.equals(dequeIterator.myDeque.myFinish)) {
                this.add(dequeIterator.nextElement());
            }
            return;
        }
    }

    public synchronized Object clone() {
        return new Deque(this);
    }

    public boolean equals(Object object) {
        return object instanceof Deque && this.equals((Deque)object);
    }

    public synchronized boolean equals(Deque deque) {
        Deque deque2 = deque;
        synchronized (deque2) {
            boolean bl = Algos.Comparing.equal(this, deque);
            Object var4_4 = null;
            return bl;
        }
    }

    public synchronized int hashCode() {
        return Algos.Hashing.orderedHash(this.start(), this.myLength);
    }

    public synchronized String toString() {
        return Algos.Printing.toString(this, "Deque");
    }

    public synchronized void copy(Deque deque) {
        if (this == deque) {
            return;
        }
        Deque deque2 = deque;
        synchronized (deque2) {
            if (this.myLength >= deque.myLength) {
                DequeIterator dequeIterator = Deque.copy(deque.myStart, deque.myFinish, this.myStart);
                this.remove(dequeIterator, this.myFinish);
            } else {
                DequeIterator dequeIterator = deque.myStart.copy(this.myLength);
                Deque.copy(deque.myStart, dequeIterator, this.myStart);
                DequeIterator dequeIterator2 = dequeIterator;
                while (!dequeIterator2.equals(dequeIterator2.myDeque.myFinish)) {
                    this.add(dequeIterator2.myDeque.myMap[dequeIterator2.myMapIndex][dequeIterator2.myBlockIndex]);
                    if (++dequeIterator2.myBlockIndex != 128) continue;
                    ++dequeIterator2.myMapIndex;
                    dequeIterator2.myBlockIndex = 0;
                }
            }
            return;
        }
    }

    public boolean isEmpty() {
        return this.myLength == 0;
    }

    public int size() {
        return this.myLength;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public synchronized Object add(Object object) {
        if (this.myLength++ == 0) {
            this.createMap();
            this.myMap[this.myFinish.myMapIndex][this.myFinish.myBlockIndex++] = object;
        } else {
            this.myMap[this.myFinish.myMapIndex][this.myFinish.myBlockIndex++] = object;
            if (this.myFinish.myBlockIndex == 128) {
                if (this.myFinish.myMapIndex == this.myMap.length - 1) {
                    this.growMap();
                }
                this.myMap[++this.myFinish.myMapIndex] = new Object[128];
                this.myFinish.myBlockIndex = 0;
            }
        }
        return null;
    }

    public void pushBack(Object object) {
        this.add(object);
    }

    public synchronized void pushFront(Object object) {
        if (this.myLength == 0) {
            this.add(object);
            return;
        }
        ++this.myLength;
        if (--this.myStart.myBlockIndex < 0) {
            if (this.myStart.myMapIndex == 0) {
                this.growMap();
            }
            this.myMap[--this.myStart.myMapIndex] = new Object[128];
            this.myStart.myBlockIndex = 127;
        }
        this.myMap[this.myStart.myMapIndex][this.myStart.myBlockIndex] = object;
    }

    public synchronized Object popFront() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Deque is empty");
        }
        Object object = this.at(0);
        if (--this.myLength == 0) {
            this.clear();
        } else {
            object = this.myMap[this.myStart.myMapIndex][this.myStart.myBlockIndex];
            this.myMap[this.myStart.myMapIndex][this.myStart.myBlockIndex++] = null;
            if (this.myStart.myBlockIndex == 128) {
                this.myMap[this.myStart.myMapIndex++] = null;
                this.myStart.myBlockIndex = 0;
            }
        }
        return object;
    }

    public synchronized Object popBack() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Deque is empty");
        }
        Object object = this.at(0);
        if (--this.myLength == 0) {
            this.clear();
        } else {
            if (this.myFinish.myBlockIndex-- == 0) {
                this.myMap[this.myFinish.myMapIndex--] = null;
                this.myFinish.myBlockIndex = 127;
            }
            object = this.myMap[this.myFinish.myMapIndex][this.myFinish.myBlockIndex];
            this.myMap[this.myFinish.myMapIndex][this.myFinish.myBlockIndex] = null;
        }
        return object;
    }

    public synchronized void clear() {
        this.myMap = null;
        this.myStart.myMapIndex = 0;
        this.myStart.myBlockIndex = 0;
        this.myFinish.myMapIndex = 0;
        this.myFinish.myBlockIndex = 0;
        this.myLength = 0;
    }

    public synchronized Enumeration elements() {
        return new DequeIterator(this.myStart);
    }

    public synchronized DequeIterator begin() {
        return new DequeIterator(this.myStart);
    }

    public synchronized DequeIterator end() {
        return new DequeIterator(this.myFinish);
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized Object front() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Deque is empty");
        }
        return this.myMap[this.myStart.myMapIndex][this.myStart.myBlockIndex];
    }

    public synchronized Object back() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Deque is empty");
        }
        if (this.myFinish.myBlockIndex > 0) {
            return this.myMap[this.myFinish.myMapIndex][this.myFinish.myBlockIndex - 1];
        }
        return this.myMap[this.myFinish.myMapIndex - 1][127];
    }

    public synchronized Object at(int n2) {
        if (n2 < 0 || n2 >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + " when valid range is 0.." + (this.myLength - 1));
        }
        int n3 = this.myStart.myBlockIndex + n2;
        int n4 = this.myStart.myMapIndex;
        if (n3 >= 128) {
            int n5 = n3 / 128;
            n4 += n5;
            n3 %= 128;
        } else if (n3 < 0) {
            int n6 = (127 - n3) / 128;
            n4 -= n6;
            n3 += n6 * 128;
        }
        return this.myMap[n4][n3];
    }

    public synchronized void put(int n2, Object object) {
        if (n2 < 0 || n2 >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + " when valid range is 0.." + (this.myLength - 1));
        }
        int n3 = this.myStart.myBlockIndex + n2;
        int n4 = this.myStart.myMapIndex;
        if (n3 >= 128) {
            int n5 = n3 / 128;
            n4 += n5;
            n3 %= 128;
        } else if (n3 < 0) {
            int n6 = (127 - n3) / 128;
            n4 -= n6;
            n3 += n6 * 128;
        }
        this.myMap[n4][n3] = object;
    }

    public synchronized void swap(Deque deque) {
        Deque deque2 = deque;
        synchronized (deque2) {
            DequeIterator dequeIterator = this.myStart;
            this.myStart = deque.myStart;
            this.myStart.myDeque = this;
            deque.myStart = dequeIterator;
            deque.myStart.myDeque = deque;
            DequeIterator dequeIterator2 = this.myFinish;
            this.myFinish = deque.myFinish;
            this.myFinish.myDeque = this;
            deque.myFinish = dequeIterator2;
            deque.myFinish.myDeque = deque;
            int n2 = this.myLength;
            this.myLength = deque.myLength;
            deque.myLength = n2;
            Object[][] objectArray = this.myMap;
            this.myMap = deque.myMap;
            deque.myMap = objectArray;
            return;
        }
    }

    public synchronized Object remove(int n2) {
        if (n2 < 0 || n2 >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + " when valid range is 0.." + (this.myLength - 1));
        }
        return this.remove(this.myStart.copy(n2));
    }

    public synchronized Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof DequeIterator)) {
            throw new IllegalArgumentException("Enumeration not a DequeIterator");
        }
        if (((DequeIterator)enumeration).myDeque != this) {
            throw new IllegalArgumentException("Enumeration not for this Deque");
        }
        DequeIterator dequeIterator = (DequeIterator)enumeration;
        Object object = dequeIterator.myDeque.myMap[dequeIterator.myMapIndex][dequeIterator.myBlockIndex];
        DequeIterator dequeIterator2 = dequeIterator.copy(1);
        if (this.myStart.distance(dequeIterator) < dequeIterator.distance(this.myFinish)) {
            Deque.copy(dequeIterator2, this.myFinish, dequeIterator);
            this.popBack();
        } else {
            Deque.copyBackward(this.myStart, dequeIterator, dequeIterator2);
            this.popFront();
        }
        return object;
    }

    public synchronized int remove(int n2, int n3) {
        if (n3 < n2) {
            return 0;
        }
        this.checkRange(n2, n3);
        return this.remove(this.myStart.copy(n2), this.myStart.copy(n3 + 1));
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2) {
        int n2;
        if (!(enumeration instanceof DequeIterator) || !(enumeration2 instanceof DequeIterator)) {
            throw new IllegalArgumentException("Enumeration not a DequeIterator");
        }
        if (((DequeIterator)enumeration).myDeque != this || ((DequeIterator)enumeration2).myDeque != this) {
            throw new IllegalArgumentException("Enumeration not for this Deque");
        }
        DequeIterator dequeIterator = (DequeIterator)enumeration;
        DequeIterator dequeIterator2 = (DequeIterator)enumeration2;
        int n3 = n2 = dequeIterator.distance(dequeIterator2);
        if (dequeIterator2.distance(this.myFinish) > this.myStart.distance(dequeIterator)) {
            Deque.copyBackward(this.myStart, dequeIterator, dequeIterator2);
            while (n2-- > 0) {
                this.popFront();
            }
        } else {
            Deque.copy(dequeIterator2, this.myFinish, dequeIterator);
            while (n2-- > 0) {
                this.popBack();
            }
        }
        return n3;
    }

    public synchronized DequeIterator insert(int n2, Object object) {
        if (n2 < 0 || n2 > this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n2 + " when valid range is 0.." + this.myLength);
        }
        return this.insert(this.myStart.copy(n2), object);
    }

    public synchronized DequeIterator insert(DequeIterator dequeIterator, Object object) {
        if (dequeIterator.equals(this.myStart)) {
            this.pushFront(object);
            return new DequeIterator(this.myStart);
        }
        if (dequeIterator.equals(this.myFinish)) {
            this.pushBack(object);
            return this.myFinish.copy(-1);
        }
        int n2 = this.myStart.distance(dequeIterator);
        if (dequeIterator.distance(this.myFinish) > n2) {
            DequeIterator dequeIterator2 = this.myStart;
            this.pushFront(dequeIterator2.myDeque.myMap[dequeIterator2.myMapIndex][dequeIterator2.myBlockIndex]);
            Deque.copy(this.myStart.copy(2), this.myStart.copy(n2 + 1), this.myStart.copy(1));
            dequeIterator2 = this.myStart.copy(n2);
            dequeIterator2.myDeque.myMap[dequeIterator2.myMapIndex][dequeIterator2.myBlockIndex] = object;
            return dequeIterator2;
        }
        DequeIterator dequeIterator3 = this.myFinish.copy(-1);
        this.pushBack(dequeIterator3.myDeque.myMap[dequeIterator3.myMapIndex][dequeIterator3.myBlockIndex]);
        DequeIterator dequeIterator4 = this.myStart.copy(n2);
        Deque.copyBackward(dequeIterator4, this.myFinish.copy(-2), this.myFinish.copy(-1));
        dequeIterator4.myDeque.myMap[dequeIterator4.myMapIndex][dequeIterator4.myBlockIndex] = object;
        return dequeIterator4;
    }

    public synchronized void insert(int n2, int n3, Object object) {
        if (n3 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative n1umber of objects.");
        }
        if (n2 < 0 || n2 > this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n2 + " when valid range is 0.." + this.myLength);
        }
        this.insert(this.myStart.copy(n2), n3, object);
    }

    public synchronized void insert(DequeIterator dequeIterator, int n2, Object object) {
        int n3;
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects");
        }
        if (n2 == 0) {
            return;
        }
        int n4 = this.myStart.distance(dequeIterator);
        int n5 = dequeIterator.distance(this.myFinish);
        if (n5 > n4) {
            if (n2 > n4) {
                int n6 = n2 - n4;
                while (n6-- > 0) {
                    this.pushFront(object);
                }
                int n7 = 1;
                while (n7 <= n4) {
                    this.pushFront(this.at(n2 - 1));
                    ++n7;
                }
                DequeIterator dequeIterator2 = this.myStart.copy(n2);
                DequeIterator dequeIterator3 = this.myStart.copy(n2 + n4);
                while (!dequeIterator2.equals(dequeIterator3)) {
                    dequeIterator2.myDeque.myMap[dequeIterator2.myMapIndex][dequeIterator2.myBlockIndex] = object;
                    if (++dequeIterator2.myBlockIndex != 128) continue;
                    ++dequeIterator2.myMapIndex;
                    dequeIterator2.myBlockIndex = 0;
                }
                return;
            }
            int n8 = 1;
            while (n8 <= n2) {
                this.pushFront(this.at(n2 - 1));
                ++n8;
            }
            DequeIterator dequeIterator4 = this.myStart.copy(n2 + n4);
            Deque.copy(this.myStart.copy(n2 + n2), dequeIterator4, this.myStart.copy(n2));
            DequeIterator dequeIterator5 = this.myStart.copy(n4);
            while (!dequeIterator5.equals(dequeIterator4)) {
                dequeIterator5.myDeque.myMap[dequeIterator5.myMapIndex][dequeIterator5.myBlockIndex] = object;
                if (++dequeIterator5.myBlockIndex != 128) continue;
                ++dequeIterator5.myMapIndex;
                dequeIterator5.myBlockIndex = 0;
            }
            return;
        }
        int n9 = this.size();
        if (n2 > n5) {
            int n10 = n2 - n5;
            while (n10-- > 0) {
                this.pushBack(object);
            }
            int n11 = n4;
            while (n11 < n9) {
                this.pushBack(this.at(n11));
                ++n11;
            }
            DequeIterator dequeIterator6 = this.myStart.copy(n4);
            DequeIterator dequeIterator7 = this.myStart.copy(n9);
            while (!dequeIterator6.equals(dequeIterator7)) {
                dequeIterator6.myDeque.myMap[dequeIterator6.myMapIndex][dequeIterator6.myBlockIndex] = object;
                if (++dequeIterator6.myBlockIndex != 128) continue;
                ++dequeIterator6.myMapIndex;
                dequeIterator6.myBlockIndex = 0;
            }
            return;
        }
        int n12 = n3 = n9 - n2;
        while (n12 < n9) {
            this.pushBack(this.at(n12));
            ++n12;
        }
        DequeIterator dequeIterator8 = this.myStart.copy(n4);
        Deque.copyBackward(dequeIterator8, this.myStart.copy(n3), this.myStart.copy(n9));
        DequeIterator dequeIterator9 = this.myStart.copy(n4 + n2);
        while (!dequeIterator8.equals(dequeIterator9)) {
            dequeIterator8.myDeque.myMap[dequeIterator8.myMapIndex][dequeIterator8.myBlockIndex] = object;
            if (++dequeIterator8.myBlockIndex != 128) continue;
            ++dequeIterator8.myMapIndex;
            dequeIterator8.myBlockIndex = 0;
        }
    }

    public synchronized void insert(int n2, BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        if (n2 < 0 || n2 > this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to insert at index " + n2 + " when valid range is 0.." + this.myLength);
        }
        this.insert(this.myStart.copy(n2), bidirectionalIterator, bidirectionalIterator2);
    }

    public synchronized void insert(DequeIterator dequeIterator, BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2) {
        int n2;
        int n3 = bidirectionalIterator.distance(bidirectionalIterator2);
        int n4 = this.myStart.distance(dequeIterator);
        int n5 = dequeIterator.distance(this.myFinish);
        if (n5 > n4) {
            if (n3 > n4) {
                BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator2.clone();
                bidirectionalIterator3.retreat(n4);
                BidirectionalIterator bidirectionalIterator4 = (BidirectionalIterator)bidirectionalIterator3.clone();
                while (!bidirectionalIterator3.equals(bidirectionalIterator)) {
                    bidirectionalIterator3.retreat();
                    this.pushFront(bidirectionalIterator3.get());
                }
                int n6 = 1;
                while (n6 <= n4) {
                    this.pushFront(this.at(n3 - 1));
                    ++n6;
                }
                Deque.copy(bidirectionalIterator4, bidirectionalIterator2, this.myStart.copy(n3));
                return;
            }
            int n7 = 1;
            while (n7 <= n3) {
                this.pushFront(this.at(n3 - 1));
                ++n7;
            }
            Deque.copy(this.myStart.copy(n3 + n3), this.myStart.copy(n3 + n4), this.myStart.copy(n3));
            Deque.copy(bidirectionalIterator, bidirectionalIterator2, this.myStart.copy(n4));
            return;
        }
        int n8 = this.size();
        if (n3 > n5) {
            BidirectionalIterator bidirectionalIterator5 = (BidirectionalIterator)bidirectionalIterator.clone();
            bidirectionalIterator5.advance(n5);
            BidirectionalIterator bidirectionalIterator6 = (BidirectionalIterator)bidirectionalIterator5.clone();
            while (!bidirectionalIterator5.equals(bidirectionalIterator2)) {
                this.pushBack(bidirectionalIterator5.nextElement());
            }
            int n9 = n4;
            while (n9 < n8) {
                this.pushBack(this.at(n9));
                ++n9;
            }
            Deque.copy(bidirectionalIterator, bidirectionalIterator6, this.myStart.copy(n4));
            return;
        }
        int n10 = n2 = n8 - n3;
        while (n10 < n8) {
            this.pushBack(this.at(n10));
            ++n10;
        }
        DequeIterator dequeIterator2 = this.myStart.copy(n4);
        Deque.copyBackward(dequeIterator2, this.myStart.copy(n2), this.myStart.copy(n8));
        Deque.copy(bidirectionalIterator, bidirectionalIterator2, this.myStart.copy(n4));
    }

    public int remove(Object object) {
        return this.remove(0, this.myLength - 1, object);
    }

    public synchronized int remove(Object object, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.indexOf(object);
            if (n4 < 0) break;
            --n2;
            ++n3;
            this.remove(n4);
        }
        return n3;
    }

    public synchronized int remove(int n2, int n3, Object object) {
        if (n3 < n2) {
            return 0;
        }
        this.checkRange(n2, n3);
        DequeIterator dequeIterator = this.myStart.copy(n2);
        DequeIterator dequeIterator2 = this.myStart.copy(n3 + 1);
        DequeIterator dequeIterator3 = (DequeIterator)Algos.Removing.remove(dequeIterator, dequeIterator2, object);
        int n4 = dequeIterator3.distance(dequeIterator2);
        this.remove(dequeIterator3, dequeIterator2);
        return n4;
    }

    public synchronized int replace(Object object, Object object2) {
        return Algos.Replacing.replace(this.begin(), this.end(), object, object2);
    }

    public synchronized int replace(int n2, int n3, Object object, Object object2) {
        if (n3 < n2) {
            return 0;
        }
        this.checkRange(n2, n3);
        return Algos.Replacing.replace(this.myStart.copy(n2), this.myStart.copy(n3 + 1), object, object2);
    }

    public int count(Object object) {
        if (this.size() == 0) {
            return 0;
        }
        return this.count(0, this.myLength - 1, object);
    }

    public synchronized int count(int n2, int n3, Object object) {
        if (n3 < n2) {
            return 0;
        }
        this.checkRange(n2, n3);
        return Algos.Counting.count(this.myStart.copy(n2), this.myStart.copy(n3 + 1), object);
    }

    public int indexOf(Object object) {
        return this.indexOf(this.myStart, this.myFinish, object);
    }

    public int indexOf(int n2, int n3, Object object) {
        if (n3 < n2) {
            return -1;
        }
        this.checkRange(n2, n3);
        DequeIterator dequeIterator = this.myStart.copy(n3 + 1);
        return this.indexOf(this.myStart.copy(n2), dequeIterator, object);
    }

    synchronized int indexOf(DequeIterator dequeIterator, DequeIterator dequeIterator2, Object object) {
        DequeIterator dequeIterator3 = (DequeIterator)Algos.Finding.find(dequeIterator, dequeIterator2, object);
        if (dequeIterator3.equals(dequeIterator2)) {
            return -1;
        }
        return this.myStart.distance(dequeIterator3);
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    private void growMap() {
        int n2 = this.myMap.length * 2;
        Object[][] objectArray = new Object[n2][];
        int n3 = n2 / 4;
        int n4 = this.myFinish.myMapIndex - this.myStart.myMapIndex + 1;
        System.arraycopy(this.myMap, this.myStart.myMapIndex, objectArray, n3, n4);
        this.myStart.myMapIndex = n3;
        this.myFinish.myMapIndex = n3 + n4 - 1;
        this.myMap = objectArray;
    }

    private void createMap() {
        this.myMap = new Object[1024][];
        int n2 = this.myMap.length / 2;
        this.myMap[n2] = new Object[128];
        this.myStart.myBlockIndex = 64;
        this.myStart.myMapIndex = n2;
        this.myFinish.myBlockIndex = 64;
        this.myFinish.myMapIndex = n2;
    }

    private void checkRange(int n2, int n3) {
        if (n2 < 0 || n2 >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + " when valid range is 0.." + (this.myLength - 1));
        }
        if (n3 < 0 || n3 >= this.myLength) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n3 + " when valid range is 0.." + (this.myLength - 1));
        }
    }

    private static DequeIterator copy(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, DequeIterator dequeIterator) {
        BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator.clone();
        DequeIterator dequeIterator2 = new DequeIterator(dequeIterator);
        while (!bidirectionalIterator3.equals(bidirectionalIterator2)) {
            Object e2 = bidirectionalIterator3.nextElement();
            dequeIterator2.myDeque.myMap[dequeIterator2.myMapIndex][dequeIterator2.myBlockIndex] = e2;
            if (++dequeIterator2.myBlockIndex != 128) continue;
            ++dequeIterator2.myMapIndex;
            dequeIterator2.myBlockIndex = 0;
        }
        return dequeIterator2;
    }

    private static void copyBackward(BidirectionalIterator bidirectionalIterator, BidirectionalIterator bidirectionalIterator2, DequeIterator dequeIterator) {
        BidirectionalIterator bidirectionalIterator3 = (BidirectionalIterator)bidirectionalIterator2.clone();
        DequeIterator dequeIterator2 = new DequeIterator(dequeIterator);
        while (!bidirectionalIterator.equals(bidirectionalIterator3)) {
            Object object;
            if (--dequeIterator2.myBlockIndex == -1) {
                --dequeIterator2.myMapIndex;
                dequeIterator2.myBlockIndex = 127;
            }
            bidirectionalIterator3.retreat();
            dequeIterator2.myDeque.myMap[dequeIterator2.myMapIndex][dequeIterator2.myBlockIndex] = object = bidirectionalIterator3.get();
        }
    }

    private static void fill(DequeIterator dequeIterator, DequeIterator dequeIterator2, Object object) {
        while (!dequeIterator.equals(dequeIterator2)) {
            dequeIterator.myDeque.myMap[dequeIterator.myMapIndex][dequeIterator.myBlockIndex] = object;
            if (++dequeIterator.myBlockIndex != 128) continue;
            ++dequeIterator.myMapIndex;
            dequeIterator.myBlockIndex = 0;
        }
    }
}

