/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.ArrayIterator;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.InvalidOperationException;
import com.objectspace.jgl.Sequence;
import java.util.Enumeration;

public class Array
implements Sequence {
    Object[] myStorage;
    int myLength;
    static final int DEFAULT_SIZE = 10;
    static final int THRESHOLD = 2000;
    static final int MULTIPLIER = 2;
    static final long serialVersionUID = 2600370816661330188L;

    public Array() {
        this.myStorage = new Object[10];
    }

    public Array(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to create an Array with a negative size");
        }
        this.myLength = n2;
        this.myStorage = new Object[this.myLength];
    }

    public Array(int n2, Object object) {
        this(n2);
        int n3 = 0;
        while (n3 < this.myLength) {
            this.myStorage[n3] = object;
            ++n3;
        }
    }

    public Array(Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        synchronized (objectArray2) {
            this.myLength = objectArray.length;
            this.myStorage = new Object[this.myLength];
            System.arraycopy(objectArray, 0, this.myStorage, 0, this.myLength);
            return;
        }
    }

    public Array(Array array) {
        Array array2 = array;
        synchronized (array2) {
            this.myLength = array.myLength;
            this.myStorage = new Object[this.myLength];
            System.arraycopy(array.myStorage, 0, this.myStorage, 0, this.myLength);
            return;
        }
    }

    public synchronized Object clone() {
        return new Array(this);
    }

    public boolean equals(Object object) {
        return object instanceof Array && this.equals((Array)object);
    }

    public synchronized boolean equals(Array array) {
        Array array2 = array;
        synchronized (array2) {
            boolean bl = Algos.Comparing.equal(this, array);
            Object var4_4 = null;
            return bl;
        }
    }

    public synchronized int hashCode() {
        return Algos.Hashing.orderedHash(this.begin(), this.myLength);
    }

    public synchronized String toString() {
        return Algos.Printing.toString(this, "Array");
    }

    public synchronized void copy(Array array) {
        if (this == array) {
            return;
        }
        Array array2 = array;
        synchronized (array2) {
            if (array.myLength > this.myStorage.length) {
                this.myStorage = new Object[array.myLength];
                System.arraycopy(array.myStorage, 0, this.myStorage, 0, array.myLength);
            } else if (this.myLength > array.myLength) {
                System.arraycopy(array.myStorage, 0, this.myStorage, 0, array.myLength);
                int n2 = array.myLength;
                while (n2 < this.myLength) {
                    this.myStorage[n2] = null;
                    ++n2;
                }
            } else {
                System.arraycopy(array.myStorage, 0, this.myStorage, 0, array.myLength);
            }
            this.myLength = array.myLength;
            return;
        }
    }

    public synchronized void copyTo(Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        synchronized (objectArray2) {
            if (this.myLength < objectArray.length) {
                System.arraycopy(this.myStorage, 0, objectArray, 0, this.myLength);
            } else {
                System.arraycopy(this.myStorage, 0, objectArray, 0, objectArray.length);
            }
            return;
        }
    }

    public boolean isEmpty() {
        return this.myLength == 0;
    }

    public int size() {
        return this.myLength;
    }

    public int maxSize() {
        return Integer.MAX_VALUE;
    }

    public int capacity() {
        return this.myStorage.length;
    }

    public synchronized Object back() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Array is empty");
        }
        return this.myStorage[this.myLength - 1];
    }

    public synchronized Object front() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Array is empty");
        }
        return this.myStorage[0];
    }

    public synchronized Object at(int n2) {
        Array.checkIndex(n2, this.myLength);
        return this.myStorage[n2];
    }

    public synchronized void put(int n2, Object object) {
        Array.checkIndex(n2, this.myLength);
        this.myStorage[n2] = object;
    }

    public synchronized void clear() {
        this.myStorage = new Object[10];
        this.myLength = 0;
    }

    public Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof ArrayIterator)) {
            throw new IllegalArgumentException("Enumeration not an ArrayIterator");
        }
        if (((ArrayIterator)enumeration).myArray != this) {
            throw new IllegalArgumentException("Enumeration not for this Array ");
        }
        Object object = (ArrayIterator)enumeration;
        object = ((ArrayIterator)object).myArray.at(((ArrayIterator)object).myIndex);
        this.remove(((ArrayIterator)enumeration).myIndex);
        return object;
    }

    public synchronized Object remove(int n2) {
        Array.checkIndex(n2, this.myLength);
        Object object = this.myStorage[n2];
        System.arraycopy(this.myStorage, n2 + 1, this.myStorage, n2, this.myLength - n2 - 1);
        this.myStorage[--this.myLength] = null;
        return object;
    }

    public int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof ArrayIterator) || !(enumeration2 instanceof ArrayIterator)) {
            throw new IllegalArgumentException("Enumeration not an ArrayIterator");
        }
        if (((ArrayIterator)enumeration).myArray != this || ((ArrayIterator)enumeration2).myArray != this) {
            throw new IllegalArgumentException("Enumeration not for this Array ");
        }
        return this.remove(((ArrayIterator)enumeration).myIndex, ((ArrayIterator)enumeration2).myIndex - 1);
    }

    public synchronized int remove(int n2, int n3) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.myLength;
        Array.checkIndex(n2, n4);
        Array.checkIndex(n3, n4);
        n4 = n3 - n2 + 1;
        System.arraycopy(this.myStorage, n3 + 1, this.myStorage, n2, this.myLength - n3 - 1);
        int n5 = this.myLength - n4;
        while (n5 < this.myLength) {
            this.myStorage[n5] = null;
            ++n5;
        }
        this.myLength -= n4;
        return n4;
    }

    public synchronized Object popBack() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Array is empty");
        }
        Object object = this.myStorage[--this.myLength];
        this.myStorage[this.myLength] = null;
        return object;
    }

    public synchronized Object add(Object object) {
        if (this.myLength == this.myStorage.length) {
            Object[] objectArray = this.getNextStorage(1);
            System.arraycopy(this.myStorage, 0, objectArray, 0, this.myLength);
            this.myStorage = objectArray;
        }
        this.myStorage[this.myLength++] = object;
        return null;
    }

    public void pushBack(Object object) {
        this.add(object);
    }

    public ArrayIterator insert(ArrayIterator arrayIterator, Object object) {
        this.insert(arrayIterator.myIndex, object);
        return new ArrayIterator(this, arrayIterator.myIndex);
    }

    public synchronized void insert(int n2, Object object) {
        Array.checkIndex(n2, this.myLength + 1);
        if (this.myLength != this.myStorage.length) {
            if (n2 != this.myLength) {
                System.arraycopy(this.myStorage, n2, this.myStorage, n2 + 1, this.myLength - n2);
            }
        } else {
            Object[] objectArray = this.getNextStorage(1);
            System.arraycopy(this.myStorage, 0, objectArray, 0, n2);
            System.arraycopy(this.myStorage, n2, objectArray, n2 + 1, this.myLength - n2);
            this.myStorage = objectArray;
        }
        this.myStorage[n2] = object;
        ++this.myLength;
    }

    public void insert(ArrayIterator arrayIterator, int n2, Object object) {
        this.insert(arrayIterator.myIndex, n2, object);
    }

    public synchronized void insert(int n2, int n3, Object object) {
        Array.checkIndex(n2, this.myLength + 1);
        if (n3 < 0) {
            throw new IllegalArgumentException("Attempt to insert a negative number of objects.");
        }
        if (n3 == 0) {
            return;
        }
        if (this.myStorage.length - this.myLength >= n3) {
            System.arraycopy(this.myStorage, n2, this.myStorage, n2 + n3, this.myLength - n2);
        } else {
            Object[] objectArray = this.getNextStorage(n3);
            System.arraycopy(this.myStorage, 0, objectArray, 0, n2);
            System.arraycopy(this.myStorage, n2, objectArray, n2 + n3, this.myLength - n2);
            this.myStorage = objectArray;
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.myStorage[n4] = object;
            ++n4;
        }
        this.myLength += n3;
    }

    public void insert(ArrayIterator arrayIterator, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        this.insert(arrayIterator.myIndex, forwardIterator, forwardIterator2);
    }

    public synchronized void insert(int n2, ForwardIterator forwardIterator, ForwardIterator forwardIterator2) {
        Array.checkIndex(n2, this.myLength + 1);
        int n3 = forwardIterator.distance(forwardIterator2);
        if (n3 == 0) {
            return;
        }
        ForwardIterator forwardIterator3 = (ForwardIterator)forwardIterator.clone();
        if (this.myStorage.length - this.myLength >= n3) {
            System.arraycopy(this.myStorage, n2, this.myStorage, n2 + n3, this.myLength - n2);
        } else {
            Object[] objectArray = this.getNextStorage(n3);
            System.arraycopy(this.myStorage, 0, objectArray, 0, n2);
            System.arraycopy(this.myStorage, n2, objectArray, n2 + n3, this.myLength - n2);
            this.myStorage = objectArray;
        }
        int n4 = n2;
        while (n4 < n2 + n3) {
            this.myStorage[n4] = forwardIterator3.nextElement();
            ++n4;
        }
        this.myLength += n3;
    }

    public synchronized void swap(Array array) {
        Array array2 = array;
        synchronized (array2) {
            int n2 = this.myLength;
            Object[] objectArray = this.myStorage;
            this.myLength = array.myLength;
            this.myStorage = array.myStorage;
            array.myLength = n2;
            array.myStorage = objectArray;
            return;
        }
    }

    public synchronized Enumeration elements() {
        return new ArrayIterator(this, 0);
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized ArrayIterator begin() {
        return new ArrayIterator(this, 0);
    }

    public synchronized ArrayIterator end() {
        return new ArrayIterator(this, this.myLength);
    }

    public synchronized void trimToSize() {
        if (this.myLength < this.myStorage.length) {
            Object[] objectArray = this.myStorage;
            this.myStorage = new Object[this.myLength];
            System.arraycopy(objectArray, 0, this.myStorage, 0, this.myLength);
        }
    }

    public synchronized void ensureCapacity(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to reserve a negative size.");
        }
        if (this.myStorage.length < n2) {
            Object[] objectArray = new Object[n2];
            if (this.myLength > 0) {
                System.arraycopy(this.myStorage, 0, objectArray, 0, this.myLength);
            }
            this.myStorage = objectArray;
        }
    }

    public synchronized Object popFront() {
        if (this.myLength == 0) {
            throw new InvalidOperationException("Array is empty");
        }
        Object object = this.myStorage[0];
        this.remove(0);
        return object;
    }

    public void pushFront(Object object) {
        this.insert(0, object);
    }

    public int remove(Object object) {
        return this.remove(0, this.myLength - 1, object);
    }

    public synchronized int remove(Object object, int n2) {
        int n3 = 0;
        while (n2 > 0) {
            int n4 = this.indexOf(object);
            if (n4 < 0) break;
            --n2;
            ++n3;
            this.remove(n4);
        }
        return n3;
    }

    public synchronized int remove(int n2, int n3, Object object) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.myLength;
        Array.checkIndex(n2, n4);
        Array.checkIndex(n3, n4);
        ArrayIterator arrayIterator = new ArrayIterator(this, n2);
        ArrayIterator arrayIterator2 = new ArrayIterator(this, n3 + 1);
        ArrayIterator arrayIterator3 = (ArrayIterator)Algos.Removing.remove(arrayIterator, arrayIterator2, object);
        return this.remove(arrayIterator3.myIndex, n3);
    }

    public synchronized int replace(Object object, Object object2) {
        return Algos.Replacing.replace(this.begin(), this.end(), object, object2);
    }

    public synchronized int replace(int n2, int n3, Object object, Object object2) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.myLength;
        Array.checkIndex(n2, n4);
        Array.checkIndex(n3, n4);
        return Algos.Replacing.replace(new ArrayIterator(this, n2), new ArrayIterator(this, n3 + 1), object, object2);
    }

    public int count(Object object) {
        if (this.size() == 0) {
            return 0;
        }
        return this.count(0, this.myLength - 1, object);
    }

    public synchronized int count(int n2, int n3, Object object) {
        if (n3 < n2) {
            return 0;
        }
        int n4 = this.myLength;
        Array.checkIndex(n2, n4);
        Array.checkIndex(n3, n4);
        return Algos.Counting.count(new ArrayIterator(this, n2), new ArrayIterator(this, n3 + 1), object);
    }

    public int indexOf(Object object) {
        return this.indexOf(0, this.myLength - 1, object);
    }

    public synchronized int indexOf(int n2, int n3, Object object) {
        if (n3 < n2) {
            return -1;
        }
        int n4 = this.myLength;
        Array.checkIndex(n2, n4);
        Array.checkIndex(n3, n4);
        n4 = ((ArrayIterator)Algos.Finding.find((InputIterator)new ArrayIterator((Array)this, (int)n2), (InputIterator)new ArrayIterator((Array)this, (int)(n3 + 1)), (Object)object)).myIndex;
        if (n4 == n3 + 1) {
            return -1;
        }
        return n4;
    }

    public synchronized void setSize(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Attempt to become a negative size.");
        }
        if (this.myLength > n2) {
            this.remove(n2, this.myLength - 1);
            return;
        }
        if (this.myLength < n2) {
            this.insert(this.myLength, n2 - this.myLength, null);
        }
    }

    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    protected static final void checkIndex(int n2, int n3) {
        if (n2 < 0 || n2 >= n3) {
            throw new IndexOutOfBoundsException("Attempt to access index " + n2 + "; valid range is 0.." + (n3 - 1));
        }
    }

    protected static final void checkRange(int n2, int n3, int n4) {
        Array.checkIndex(n2, n4);
        Array.checkIndex(n3, n4);
    }

    static final int getNextSize(int n2) {
        int n3 = n2 > 2000 ? n2 + 2000 : n2 * 2;
        return Math.max(1, n3);
    }

    private Object[] getNextStorage(int n2) {
        int n3 = Math.max(Array.getNextSize(this.myLength), this.myLength + n2);
        Object[] objectArray = new Object[n3];
        return objectArray;
    }
}

