/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.smi;

import com.agentpp.smi.IModule;
import com.agentpp.smi.IModuleInfo;
import com.agentpp.smiparser.ModuleInfo;
import com.agentpp.smiparser.ModuleInfoSorter;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class IModuleInfoSorter {
    private ModuleInfoSorter sorter = null;

    public IModuleInfoSorter(IModuleInfo[] list) {
        ModuleInfo[] infos = new ModuleInfo[list.length];
        for (int i2 = 0; i2 < list.length; ++i2) {
            infos[i2] = new ModuleInfo(list[i2].getModuleName(), list[i2].getImports());
        }
        this.sorter = new ModuleInfoSorter(infos);
        this.sorter.resetPool();
    }

    public boolean sort() {
        return this.sorter.sort();
    }

    public IModuleInfo[] getSortedList() {
        return this.sorter.getSortedList();
    }

    public IModuleInfo[] getFailedList() {
        return this.sorter.getFailedList();
    }

    public String[] getMissingModules() {
        return this.sorter.getMissingModules();
    }

    public void setPool(IModuleInfo[] poolList) {
        this.sorter.setPool((ModuleInfo[])poolList);
    }

    public void resetPool() {
        this.sorter.resetPool();
    }

    public static Vector sortModulesByImports(List modules) {
        Vector<Object> result = new Vector<Object>(modules.size() + 1);
        ModuleInfo[] list = new ModuleInfo[modules.size()];
        Hashtable<String, IModule> h2 = new Hashtable<String, IModule>(list.length);
        int n2 = 0;
        for (IModule m2 : modules) {
            ModuleInfo info = new ModuleInfo(m2.getModuleName(), m2.getImportSources());
            info.userObject = m2;
            list[n2] = info;
            h2.put(m2.getModuleName(), m2);
            ++n2;
        }
        Vector<ModuleInfo> pool = new Vector<ModuleInfo>();
        for (int i2 = 0; i2 < list.length; ++i2) {
            String[] sources = list[i2].getImports();
            for (int j2 = 0; j2 < sources.length; ++j2) {
                if (h2.get(sources[j2]) != null) continue;
                pool.add(new ModuleInfo(sources[j2], new String[0]));
            }
        }
        ModuleInfoSorter sorter = new ModuleInfoSorter(list);
        ModuleInfo[] poolModules = new ModuleInfo[pool.size()];
        pool.toArray(poolModules);
        sorter.setPool(poolModules);
        sorter.sort();
        ModuleInfo[] sorted = sorter.getSortedList();
        for (int i3 = 0; i3 < sorted.length; ++i3) {
            result.add(sorted[i3].userObject);
        }
        ModuleInfo[] failed = sorter.getFailedList();
        for (int i4 = 0; i4 < failed.length; ++i4) {
            result.add(failed[i4].userObject);
        }
        return result;
    }
}

