/*
 * Decompiled with CFR 0.152.
 */
package com.agentpp.repository;

import com.agentpp.mib.MIBModule;
import com.agentpp.mib.MIBObject;
import com.agentpp.mib.MIBRepository;
import com.agentpp.smi.IObject;
import com.agentpp.smi.event.ImportModuleEvent;
import com.agentpp.smi.event.ImportModuleListener;
import java.util.Enumeration;

public class MIBRepositoryImporter
implements ImportModuleListener {
    private MIBRepository rep;
    private int maxModuleID = -1;
    private boolean cloneObjects = true;

    public MIBRepositoryImporter(MIBRepository rep) {
        this.rep = rep;
    }

    public MIBRepositoryImporter(MIBRepository rep, boolean cloneObjects) {
        this(rep);
        this.cloneObjects = cloneObjects;
    }

    public Integer createModuleID(String moduleName) {
        MIBModule m2 = this.rep.getModule(moduleName);
        if (m2 != null) {
            return m2.getModuleID();
        }
        return new Integer(this.nextModuleID());
    }

    private synchronized int nextModuleID() {
        if (this.maxModuleID < 0) {
            Enumeration<? extends MIBModule> en = this.rep.getModulesSortedByName();
            while (en.hasMoreElements()) {
                MIBModule m2 = en.nextElement();
                Integer mid = m2.getModuleID();
                if (mid == null || mid <= this.maxModuleID) continue;
                this.maxModuleID = mid;
            }
        }
        return ++this.maxModuleID;
    }

    public void freeModuleID(Integer moduleID, String moduleName) {
    }

    public void importModule(ImportModuleEvent e2) {
        String moduleName = e2.getModuleName();
        MIBModule m2 = this.rep.getModule(moduleName);
        if (m2 != null) {
            IObject[] objs = m2.getObjects();
            if (this.cloneObjects) {
                for (int i2 = 0; i2 < objs.length; ++i2) {
                    objs[i2] = ((MIBObject)objs[i2]).getClone();
                }
            }
            e2.setObjects(objs);
        }
    }
}

